/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.Collection;
import java.util.List;
import org.hipparchus.RealFieldElement;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.frames.Frame;
import org.orekit.propagation.FieldAdditionalStateProvider;
import org.orekit.propagation.FieldBoundedPropagator;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;

public interface FieldPropagator<T extends RealFieldElement<T>>
extends FieldPVCoordinatesProvider<T> {
    public static final double DEFAULT_MASS = 1000.0;
    @DefaultDataContext
    public static final AttitudeProvider DEFAULT_LAW = InertialProvider.EME2000_ALIGNED;
    public static final int SLAVE_MODE = 0;
    public static final int MASTER_MODE = 1;
    public static final int EPHEMERIS_GENERATION_MODE = 2;

    public int getMode();

    public void setSlaveMode();

    public void setMasterMode(T var1, FieldOrekitFixedStepHandler<T> var2);

    public void setMasterMode(FieldOrekitStepHandler<T> var1);

    public void setEphemerisMode();

    public FieldBoundedPropagator<T> getGeneratedEphemeris() throws IllegalStateException;

    public FieldSpacecraftState<T> getInitialState();

    public void resetInitialState(FieldSpacecraftState<T> var1);

    public void addAdditionalStateProvider(FieldAdditionalStateProvider<T> var1);

    public List<FieldAdditionalStateProvider<T>> getAdditionalStateProviders();

    public boolean isAdditionalStateManaged(String var1);

    public String[] getManagedAdditionalStates();

    public <D extends FieldEventDetector<T>> void addEventDetector(D var1);

    public Collection<FieldEventDetector<T>> getEventsDetectors();

    public void clearEventsDetectors();

    public AttitudeProvider getAttitudeProvider();

    public void setAttitudeProvider(AttitudeProvider var1);

    public Frame getFrame();

    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> var1);

    public FieldSpacecraftState<T> propagate(FieldAbsoluteDate<T> var1, FieldAbsoluteDate<T> var2);
}

