/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.interpolation.FieldHermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.attitudes.LofOffset;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitIllegalStateException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.LOFType;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldTimeInterpolable;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.time.FieldTimeStamped;
import org.orekit.utils.FieldAbsolutePVCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public class FieldSpacecraftState<T extends RealFieldElement<T>>
implements FieldTimeStamped<T>,
FieldTimeShiftable<FieldSpacecraftState<T>, T>,
FieldTimeInterpolable<FieldSpacecraftState<T>, T> {
    private static final double DEFAULT_MASS = 1000.0;
    private static final double DATE_INCONSISTENCY_THRESHOLD = 1.0E-7;
    private final FieldOrbit<T> orbit;
    private final FieldAbsolutePVCoordinates<T> absPva;
    private final FieldAttitude<T> attitude;
    private final T mass;
    private final Map<String, T[]> additional;

    public FieldSpacecraftState(FieldOrbit<T> orbit) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude) throws IllegalArgumentException {
        this(orbit, attitude, (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass) throws IllegalArgumentException {
        this(orbit, attitude, mass, null);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, Map<String, T[]> additional) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, Map<String, T[]> additional) throws IllegalArgumentException {
        this(orbit, attitude, (RealFieldElement)((RealFieldElement)orbit.getA().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, T mass, Map<String, T[]> additional) {
        this(orbit, new LofOffset(orbit.getFrame(), LOFType.VVLH).getAttitude(orbit, orbit.getDate(), orbit.getFrame()), mass, additional);
    }

    public FieldSpacecraftState(FieldOrbit<T> orbit, FieldAttitude<T> attitude, T mass, Map<String, T[]> additional) throws IllegalArgumentException {
        this.checkConsistency(orbit, attitude);
        this.orbit = orbit;
        this.attitude = attitude;
        this.mass = mass;
        this.absPva = null;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, T[]>(additional.size());
            for (Map.Entry<String, T[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (T[])((RealFieldElement[])entry.getValue()).clone());
            }
        }
    }

    public FieldSpacecraftState(Field<T> field, SpacecraftState state) {
        if (state.isOrbitDefined()) {
            RealFieldElement[] stateDotF;
            double[] stateD = new double[6];
            double[] stateDotD = state.getOrbit().hasDerivatives() ? new double[6] : null;
            state.getOrbit().getType().mapOrbitToArray(state.getOrbit(), PositionAngle.TRUE, stateD, stateDotD);
            RealFieldElement[] stateF = (RealFieldElement[])MathArrays.buildArray(field, 6);
            for (int i = 0; i < stateD.length; ++i) {
                stateF[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(stateD[i]);
            }
            if (stateDotD == null) {
                stateDotF = null;
            } else {
                stateDotF = (RealFieldElement[])MathArrays.buildArray(field, 6);
                for (int i = 0; i < stateDotD.length; ++i) {
                    stateDotF[i] = (RealFieldElement)((RealFieldElement)field.getZero()).add(stateDotD[i]);
                }
            }
            FieldAbsoluteDate<T> dateF = new FieldAbsoluteDate<T>(field, state.getDate());
            this.orbit = state.getOrbit().getType().mapArrayToOrbit(stateF, stateDotF, PositionAngle.TRUE, dateF, (RealFieldElement)((RealFieldElement)field.getZero()).add(state.getMu()), state.getFrame());
            this.attitude = new FieldAttitude<T>(field, state.getAttitude());
            this.mass = (RealFieldElement)((RealFieldElement)field.getZero()).add(state.getMass());
            this.absPva = null;
            Map<String, double[]> additionalD = state.getAdditionalStates();
            if (additionalD.isEmpty()) {
                this.additional = Collections.emptyMap();
            } else {
                this.additional = new HashMap<String, T[]>(additionalD.size());
                for (Map.Entry<String, double[]> entry : additionalD.entrySet()) {
                    RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(field, entry.getValue().length);
                    for (int k = 0; k < array.length; ++k) {
                        array[k] = (RealFieldElement)((RealFieldElement)field.getZero()).add(entry.getValue()[k]);
                    }
                    this.additional.put(entry.getKey(), array);
                }
            }
        } else {
            RealFieldElement zero = (RealFieldElement)field.getZero();
            RealFieldElement x = (RealFieldElement)zero.add(state.getPVCoordinates().getPosition().getX());
            RealFieldElement y = (RealFieldElement)zero.add(state.getPVCoordinates().getPosition().getY());
            RealFieldElement z = (RealFieldElement)zero.add(state.getPVCoordinates().getPosition().getZ());
            RealFieldElement vx = (RealFieldElement)zero.add(state.getPVCoordinates().getVelocity().getX());
            RealFieldElement vy = (RealFieldElement)zero.add(state.getPVCoordinates().getVelocity().getY());
            RealFieldElement vz = (RealFieldElement)zero.add(state.getPVCoordinates().getVelocity().getZ());
            RealFieldElement ax = (RealFieldElement)zero.add(state.getPVCoordinates().getAcceleration().getX());
            RealFieldElement ay = (RealFieldElement)zero.add(state.getPVCoordinates().getAcceleration().getY());
            RealFieldElement az = (RealFieldElement)zero.add(state.getPVCoordinates().getAcceleration().getZ());
            FieldPVCoordinates<RealFieldElement> pva_f = new FieldPVCoordinates<RealFieldElement>(new FieldVector3D<RealFieldElement>(x, y, z), new FieldVector3D<RealFieldElement>(vx, vy, vz), new FieldVector3D<RealFieldElement>(ax, ay, az));
            FieldAbsoluteDate<T> dateF = new FieldAbsoluteDate<T>(field, state.getDate());
            this.orbit = null;
            this.attitude = new FieldAttitude<T>(field, state.getAttitude());
            this.mass = (RealFieldElement)((RealFieldElement)field.getZero()).add(state.getMass());
            this.absPva = new FieldAbsolutePVCoordinates<RealFieldElement>(state.getFrame(), dateF, pva_f);
            Map<String, double[]> additionalD = state.getAdditionalStates();
            if (additionalD.isEmpty()) {
                this.additional = Collections.emptyMap();
            } else {
                this.additional = new HashMap<String, T[]>(additionalD.size());
                for (Map.Entry<String, double[]> entry : additionalD.entrySet()) {
                    RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(field, entry.getValue().length);
                    for (int k = 0; k < array.length; ++k) {
                        array[k] = (RealFieldElement)((RealFieldElement)field.getZero()).add(entry.getValue()[k]);
                    }
                    this.additional.put(entry.getKey(), array);
                }
            }
        }
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), (RealFieldElement)((RealFieldElement)absPva.getDate().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude) throws IllegalArgumentException {
        this(absPva, attitude, (RealFieldElement)((RealFieldElement)absPva.getDate().getField().getZero()).add(1000.0), null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, T mass) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, T mass) throws IllegalArgumentException {
        this(absPva, attitude, mass, null);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, Map<String, T[]> additional) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), (RealFieldElement)((RealFieldElement)absPva.getDate().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, Map<String, T[]> additional) throws IllegalArgumentException {
        this(absPva, attitude, (RealFieldElement)((RealFieldElement)absPva.getDate().getField().getZero()).add(1000.0), additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, T mass, Map<String, T[]> additional) {
        this(absPva, new LofOffset(absPva.getFrame(), LOFType.VVLH).getAttitude(absPva, absPva.getDate(), absPva.getFrame()), mass, additional);
    }

    public FieldSpacecraftState(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude, T mass, Map<String, T[]> additional) throws IllegalArgumentException {
        FieldSpacecraftState.checkConsistency(absPva, attitude);
        this.orbit = null;
        this.absPva = absPva;
        this.attitude = attitude;
        this.mass = mass;
        if (additional == null) {
            this.additional = Collections.emptyMap();
        } else {
            this.additional = new HashMap<String, T[]>(additional.size());
            for (Map.Entry<String, T[]> entry : additional.entrySet()) {
                this.additional.put(entry.getKey(), (T[])((RealFieldElement[])entry.getValue()).clone());
            }
        }
    }

    @SafeVarargs
    public final FieldSpacecraftState<T> addAdditionalState(String name, T ... value) {
        HashMap<String, T[]> newMap = new HashMap<String, T[]>(this.additional.size() + 1);
        newMap.putAll(this.additional);
        newMap.put(name, (T[])value.clone());
        if (this.absPva == null) {
            return new FieldSpacecraftState<T>(this.orbit, this.attitude, this.mass, newMap);
        }
        return new FieldSpacecraftState<T>(this.absPva, this.attitude, this.mass, newMap);
    }

    private void checkConsistency(FieldOrbit<T> orbitN, FieldAttitude<T> attitudeN) throws IllegalArgumentException {
        if (((RealFieldElement)orbitN.getDate().durationFrom(attitudeN.getDate()).abs()).getReal() > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, orbitN.getDate(), attitudeN.getDate());
        }
        if (orbitN.getFrame() != attitudeN.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, orbitN.getFrame().getName(), attitudeN.getReferenceFrame().getName());
        }
    }

    public boolean isOrbitDefined() {
        return this.orbit != null;
    }

    private static <T extends RealFieldElement<T>> void checkConsistency(FieldAbsolutePVCoordinates<T> absPva, FieldAttitude<T> attitude) throws IllegalArgumentException {
        if (FastMath.abs(absPva.getDate().durationFrom(attitude.getDate())).getReal() > 1.0E-7) {
            throw new OrekitIllegalArgumentException(OrekitMessages.ORBIT_AND_ATTITUDE_DATES_MISMATCH, absPva.getDate(), attitude.getDate());
        }
        if (absPva.getFrame() != attitude.getReferenceFrame()) {
            throw new OrekitIllegalArgumentException(OrekitMessages.FRAMES_MISMATCH, absPva.getFrame().getName(), attitude.getReferenceFrame().getName());
        }
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(double dt) {
        if (this.absPva == null) {
            return new FieldSpacecraftState<T>((FieldOrbit)this.orbit.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
        }
        return new FieldSpacecraftState<T>(this.absPva.shiftedBy(dt), this.attitude.shiftedBy(dt), this.mass, this.additional);
    }

    @Override
    public FieldSpacecraftState<T> shiftedBy(T dt) {
        if (this.absPva == null) {
            return new FieldSpacecraftState<T>(this.orbit.shiftedBy((RealFieldElement)dt), this.attitude.shiftedBy((RealFieldElement)dt), this.mass, this.additional);
        }
        return new FieldSpacecraftState<T>(this.absPva.shiftedBy((RealFieldElement)dt), this.attitude.shiftedBy((RealFieldElement)dt), this.mass, this.additional);
    }

    @Override
    public FieldSpacecraftState<T> interpolate(FieldAbsoluteDate<T> date, Stream<FieldSpacecraftState<T>> sample) {
        HashMap<String, T[]> interpolatedAdditional;
        FieldAbsolutePVCoordinates interpolatedAbsPva;
        FieldOrbit interpolatedOrbit;
        ArrayList absPvas;
        ArrayList orbits;
        if (this.isOrbitDefined()) {
            orbits = new ArrayList();
            absPvas = null;
        } else {
            orbits = null;
            absPvas = new ArrayList();
        }
        ArrayList attitudes = new ArrayList();
        FieldHermiteInterpolator massInterpolator = new FieldHermiteInterpolator();
        HashMap additionalInterpolators = new HashMap(this.additional.size());
        for (String name : this.additional.keySet()) {
            additionalInterpolators.put(name, new FieldHermiteInterpolator());
        }
        sample.forEach(state -> {
            T deltaT = state.getDate().durationFrom(date);
            if (this.isOrbitDefined()) {
                orbits.add(state.getOrbit());
            } else {
                absPvas.add(state.getAbsPVA());
            }
            attitudes.add(state.getAttitude());
            RealFieldElement[] mm = (RealFieldElement[])MathArrays.buildArray(this.orbit.getA().getField(), 1);
            mm[0] = state.getMass();
            massInterpolator.addSamplePoint((FieldElement)deltaT, new RealFieldElement[][]{mm});
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                ((FieldHermiteInterpolator)entry.getValue()).addSamplePoint((FieldElement)deltaT, new RealFieldElement[][]{state.getAdditionalState((String)entry.getKey())});
            }
        });
        if (this.isOrbitDefined()) {
            interpolatedOrbit = (FieldOrbit)this.orbit.interpolate(date, orbits);
            interpolatedAbsPva = null;
        } else {
            interpolatedOrbit = null;
            interpolatedAbsPva = (FieldAbsolutePVCoordinates)this.absPva.interpolate(date, absPvas);
        }
        FieldAttitude interpolatedAttitude = (FieldAttitude)this.attitude.interpolate(date, attitudes);
        RealFieldElement interpolatedMass = ((RealFieldElement[])massInterpolator.value((FieldElement)this.orbit.getA().getField().getZero()))[0];
        if (this.additional.isEmpty()) {
            interpolatedAdditional = null;
        } else {
            interpolatedAdditional = new HashMap<String, T[]>(this.additional.size());
            for (Map.Entry entry : additionalInterpolators.entrySet()) {
                interpolatedAdditional.put((String)entry.getKey(), (T[])((FieldHermiteInterpolator)entry.getValue()).value((FieldElement)this.orbit.getA().getField().getZero()));
            }
        }
        if (this.isOrbitDefined()) {
            return new FieldSpacecraftState<RealFieldElement>(interpolatedOrbit, interpolatedAttitude, interpolatedMass, interpolatedAdditional);
        }
        return new FieldSpacecraftState<RealFieldElement>(interpolatedAbsPva, interpolatedAttitude, interpolatedMass, interpolatedAdditional);
    }

    public FieldAbsolutePVCoordinates<T> getAbsPVA() throws OrekitIllegalStateException {
        if (this.absPva == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ABSOLUTE_PVCOORDINATES, new Object[0]);
        }
        return this.absPva;
    }

    public FieldOrbit<T> getOrbit() throws OrekitIllegalStateException {
        if (this.orbit == null) {
            throw new OrekitIllegalStateException(OrekitMessages.UNDEFINED_ORBIT, new Object[0]);
        }
        return this.orbit;
    }

    @Override
    public FieldAbsoluteDate<T> getDate() {
        return this.absPva == null ? this.orbit.getDate() : this.absPva.getDate();
    }

    public Frame getFrame() {
        return this.absPva == null ? this.orbit.getFrame() : this.absPva.getFrame();
    }

    public boolean hasAdditionalState(String name) {
        return this.additional.containsKey(name);
    }

    public void ensureCompatibleAdditionalStates(FieldSpacecraftState<T> state) throws MathIllegalArgumentException {
        for (Map.Entry<String, T[]> entry : this.additional.entrySet()) {
            RealFieldElement[] other = (RealFieldElement[])state.additional.get(entry.getKey());
            if (other == null) {
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, entry.getKey());
            }
            if (other.length == ((RealFieldElement[])entry.getValue()).length) continue;
            throw new MathIllegalStateException(LocalizedCoreFormats.DIMENSIONS_MISMATCH, other.length, ((RealFieldElement[])entry.getValue()).length);
        }
        if (state.additional.size() > this.additional.size()) {
            for (String name : state.additional.keySet()) {
                if (this.additional.containsKey(name)) continue;
                throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
            }
        }
    }

    public T[] getAdditionalState(String name) {
        if (!this.additional.containsKey(name)) {
            throw new OrekitException((Localizable)OrekitMessages.UNKNOWN_ADDITIONAL_STATE, name);
        }
        return (RealFieldElement[])((RealFieldElement[])this.additional.get(name)).clone();
    }

    public Map<String, T[]> getAdditionalStates() {
        return Collections.unmodifiableMap(this.additional);
    }

    public FieldTransform<T> toTransform() {
        TimeStampedFieldPVCoordinates<T> pv = this.getPVCoordinates();
        return new FieldTransform<T>(pv.getDate(), new FieldTransform<T>(pv.getDate(), pv.negate()), new FieldTransform<T>(pv.getDate(), this.attitude.getOrientation()));
    }

    public T getMu() {
        return (T)(this.absPva == null ? this.orbit.getMu() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getKeplerianPeriod() {
        return (T)(this.absPva == null ? this.orbit.getKeplerianPeriod() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getKeplerianMeanMotion() {
        return (T)(this.absPva == null ? this.orbit.getKeplerianMeanMotion() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getA() {
        return (T)(this.absPva == null ? this.orbit.getA() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getEquinoctialEx() {
        return (T)(this.absPva == null ? this.orbit.getEquinoctialEx() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getEquinoctialEy() {
        return (T)(this.absPva == null ? this.orbit.getEquinoctialEy() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getHx() {
        return (T)(this.absPva == null ? this.orbit.getHx() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getHy() {
        return (T)(this.absPva == null ? this.orbit.getHy() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLv() {
        return (T)(this.absPva == null ? this.orbit.getLv() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLE() {
        return (T)(this.absPva == null ? this.orbit.getLE() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getLM() {
        return (T)(this.absPva == null ? this.orbit.getLM() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getE() {
        return (T)(this.absPva == null ? this.orbit.getE() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public T getI() {
        return (T)(this.absPva == null ? this.orbit.getI() : (RealFieldElement)((RealFieldElement)this.absPva.getDate().getField().getZero()).add(Double.NaN));
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates() {
        return this.absPva == null ? this.orbit.getPVCoordinates() : this.absPva.getPVCoordinates();
    }

    public TimeStampedFieldPVCoordinates<T> getPVCoordinates(Frame outputFrame) {
        return this.absPva == null ? this.orbit.getPVCoordinates(outputFrame) : this.absPva.getPVCoordinates(outputFrame);
    }

    public FieldAttitude<T> getAttitude() {
        return this.attitude;
    }

    public T getMass() {
        return this.mass;
    }

    public SpacecraftState toSpacecraftState() {
        Map<String, double[]> map;
        if (this.additional.isEmpty()) {
            map = Collections.emptyMap();
        } else {
            map = new HashMap(this.additional.size());
            for (Map.Entry<String, T[]> entry : this.additional.entrySet()) {
                double[] array = new double[((RealFieldElement[])entry.getValue()).length];
                for (int k = 0; k < array.length; ++k) {
                    array[k] = ((RealFieldElement[])entry.getValue())[k].getReal();
                }
                map.put(entry.getKey(), array);
            }
        }
        if (this.isOrbitDefined()) {
            return new SpacecraftState(this.orbit.toOrbit(), this.attitude.toAttitude(), this.mass.getReal(), map);
        }
        return new SpacecraftState(this.absPva.toAbsolutePVCoordinates(), this.attitude.toAttitude(), this.mass.getReal(), map);
    }

    public String toString() {
        return "FieldSpacecraftState{orbit=" + this.orbit + ", attitude=" + this.attitude + ", mass=" + this.mass + ", additional=" + this.additional + '}';
    }
}

