/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.propagation.AdditionalStateProvider;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.gnss.GPSOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class ClockCorrectionsProvider
implements AdditionalStateProvider {
    public static final String CLOCK_CORRECTIONS = "";
    private static final double GPS_CYCLE_DURATION = 6.193152E8;
    private final GPSOrbitalElements gpsOrbit;
    private final AbsoluteDate clockRef;

    public ClockCorrectionsProvider(GPSOrbitalElements gpsOrbit) {
        this.gpsOrbit = gpsOrbit;
        this.clockRef = gpsOrbit.getDate();
    }

    @Override
    public String getName() {
        return CLOCK_CORRECTIONS;
    }

    private double getDT(AbsoluteDate date) {
        double dt;
        for (dt = date.durationFrom(this.clockRef); dt > 3.096576E8; dt -= 6.193152E8) {
        }
        while (dt < -3.096576E8) {
            dt += 6.193152E8;
        }
        return dt;
    }

    @Override
    public double[] getAdditionalState(SpacecraftState state) {
        double dt = this.getDT(state.getDate());
        double dtSat = this.gpsOrbit.getAf0() + dt * (this.gpsOrbit.getAf1() + dt * this.gpsOrbit.getAf2());
        TimeStampedPVCoordinates pv = state.getPVCoordinates();
        double dtRel = -2.0 * Vector3D.dotProduct(pv.getPosition(), pv.getVelocity()) / 8.987551787368176E16;
        double tg = this.gpsOrbit.getTGD();
        return new double[]{dtSat, dtRel, tg};
    }
}

