/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.analytical.gnss;

import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.InertialProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.frames.Frames;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.analytical.AbstractAnalyticalPropagator;
import org.orekit.propagation.analytical.gnss.SBASOrbitalElements;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;

public class SBASPropagator
extends AbstractAnalyticalPropagator {
    private final SBASOrbitalElements sbasOrbit;
    private final double mass;
    private final double mu;
    private final Frame eci;
    private final Frame ecef;
    private final DSFactory factory;

    private SBASPropagator(Builder builder) {
        super(builder.attitudeProvider);
        this.sbasOrbit = builder.orbit;
        this.setStartDate(this.sbasOrbit.getDate());
        this.mu = builder.mu;
        this.mass = builder.mass;
        this.eci = builder.eci;
        this.ecef = builder.ecef;
        this.factory = new DSFactory(1, 2);
    }

    public PVCoordinates propagateInEcef(AbsoluteDate date) {
        DerivativeStructure dt = this.factory.variable(0, this.getDT(date));
        DerivativeStructure x = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getXDotDot()).add(this.sbasOrbit.getXDot())).add(this.sbasOrbit.getX());
        DerivativeStructure y = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getYDotDot()).add(this.sbasOrbit.getYDot())).add(this.sbasOrbit.getY());
        DerivativeStructure z = dt.multiply(dt.multiply(0.5 * this.sbasOrbit.getZDotDot()).add(this.sbasOrbit.getZDot())).add(this.sbasOrbit.getZ());
        FieldVector3D<DerivativeStructure> positionwithDerivatives = new FieldVector3D<DerivativeStructure>(x, y, z);
        return new PVCoordinates(positionwithDerivatives);
    }

    @Override
    protected Orbit propagateOrbit(AbsoluteDate date) {
        PVCoordinates pvaInECEF = this.propagateInEcef(date);
        PVCoordinates pvaInECI = this.ecef.getTransformTo(this.eci, date).transformPVCoordinates(pvaInECEF);
        return new CartesianOrbit(pvaInECI, this.eci, date, this.mu);
    }

    public double getMU() {
        return this.mu;
    }

    public Frame getECI() {
        return this.eci;
    }

    public Frame getECEF() {
        return this.ecef;
    }

    public SBASOrbitalElements getSBASOrbitalElements() {
        return this.sbasOrbit;
    }

    @Override
    public Frame getFrame() {
        return this.eci;
    }

    @Override
    public void resetInitialState(SpacecraftState state) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    @Override
    protected double getMass(AbsoluteDate date) {
        return this.mass;
    }

    @Override
    protected void resetIntermediateState(SpacecraftState state, boolean forward) {
        throw new OrekitException((Localizable)OrekitMessages.NON_RESETABLE_STATE, new Object[0]);
    }

    private double getDT(AbsoluteDate date) {
        return date.durationFrom(this.sbasOrbit.getDate());
    }

    public static class Builder {
        private final SBASOrbitalElements orbit;
        private double mu;
        private AttitudeProvider attitudeProvider;
        private double mass = 1000.0;
        private Frame eci = null;
        private Frame ecef = null;

        public Builder(SBASOrbitalElements sbasOrbElt, Frames frames) {
            this.orbit = sbasOrbElt;
            this.eci = frames.getEME2000();
            this.ecef = frames.getITRF(IERSConventions.IERS_2010, true);
            this.mu = 3.986005E14;
            this.attitudeProvider = new InertialProvider(this.eci);
        }

        public Builder attitudeProvider(AttitudeProvider userProvider) {
            this.attitudeProvider = userProvider;
            return this;
        }

        public Builder mu(double coefficient) {
            this.mu = coefficient;
            return this;
        }

        public Builder mass(double userMass) {
            this.mass = userMass;
            return this;
        }

        public Builder eci(Frame inertial) {
            this.eci = inertial;
            return this;
        }

        public Builder ecef(Frame bodyFixed) {
            this.ecef = bodyFixed;
            return this;
        }

        public SBASPropagator build() {
            return new SBASPropagator(this);
        }
    }
}

