/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.analysis.MultivariateVectorFunction;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.optim.nonlinear.vector.leastsquares.MultivariateJacobianFunction;
import org.hipparchus.util.Pair;
import org.orekit.errors.OrekitException;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.conversion.AbstractPropagatorConverter;
import org.orekit.propagation.conversion.PropagatorBuilder;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FiniteDifferencePropagatorConverter
extends AbstractPropagatorConverter {
    private final PropagatorBuilder builder;

    public FiniteDifferencePropagatorConverter(PropagatorBuilder factory, double threshold, int maxIterations) {
        super(factory, threshold, maxIterations);
        this.builder = factory;
    }

    @Override
    protected MultivariateVectorFunction getObjectiveFunction() {
        return new ObjectiveFunction();
    }

    @Override
    protected MultivariateJacobianFunction getModel() {
        return new ObjectiveFunctionJacobian();
    }

    private class ObjectiveFunctionJacobian
    implements MultivariateJacobianFunction {
        private ObjectiveFunctionJacobian() {
        }

        @Override
        public Pair<RealVector, RealMatrix> value(RealVector point) throws IllegalArgumentException, OrekitException {
            double[] arg = point.toArray();
            ObjectiveFunction f = new ObjectiveFunction();
            double[][] jacob = new double[FiniteDifferencePropagatorConverter.this.getTargetSize()][arg.length];
            double[] eval = f.value(arg);
            double[] arg1 = new double[arg.length];
            for (int j = 0; j < arg.length; ++j) {
                System.arraycopy(arg, 0, arg1, 0, arg.length);
                int n = j;
                arg1[n] = arg1[n] + 1.0;
                double[] eval1 = f.value(arg1);
                for (int t = 0; t < eval.length; ++t) {
                    jacob[t][j] = eval1[t] - eval[t];
                }
            }
            return new Pair<RealVector, RealMatrix>(MatrixUtils.createRealVector(eval), MatrixUtils.createRealMatrix(jacob));
        }
    }

    private class ObjectiveFunction
    implements MultivariateVectorFunction {
        private ObjectiveFunction() {
        }

        @Override
        public double[] value(double[] arg) throws IllegalArgumentException, OrekitException {
            Propagator propagator = FiniteDifferencePropagatorConverter.this.builder.buildPropagator(arg);
            double[] eval = new double[FiniteDifferencePropagatorConverter.this.getTargetSize()];
            int k = 0;
            for (SpacecraftState state : FiniteDifferencePropagatorConverter.this.getSample()) {
                TimeStampedPVCoordinates pv = propagator.getPVCoordinates(state.getDate(), FiniteDifferencePropagatorConverter.this.getFrame());
                if (Double.isNaN(pv.getMomentum().getNorm())) {
                    propagator.getPVCoordinates(state.getDate(), FiniteDifferencePropagatorConverter.this.getFrame());
                }
                eval[k++] = pv.getPosition().getX();
                eval[k++] = pv.getPosition().getY();
                eval[k++] = pv.getPosition().getZ();
                if (FiniteDifferencePropagatorConverter.this.isOnlyPosition()) continue;
                eval[k++] = pv.getVelocity().getX();
                eval[k++] = pv.getVelocity().getY();
                eval[k++] = pv.getVelocity().getZ();
            }
            return eval;
        }
    }
}

