/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.conversion;

import org.hipparchus.ode.AbstractIntegrator;
import org.hipparchus.ode.nonstiff.HighamHall54Integrator;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.propagation.conversion.ODEIntegratorBuilder;
import org.orekit.propagation.numerical.NumericalPropagator;

public class HighamHall54IntegratorBuilder
implements ODEIntegratorBuilder {
    private final double minStep;
    private final double maxStep;
    private final double dP;

    public HighamHall54IntegratorBuilder(double minStep, double maxStep, double dP) {
        this.minStep = minStep;
        this.maxStep = maxStep;
        this.dP = dP;
    }

    @Override
    public AbstractIntegrator buildIntegrator(Orbit orbit, OrbitType orbitType) {
        double[][] tol = NumericalPropagator.tolerances(this.dP, orbit, orbitType);
        return new HighamHall54Integrator(this.minStep, this.maxStep, tol[0], tol[1]);
    }
}

