/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.enclosing.EnclosingBall;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.util.FastMath;
import org.orekit.errors.OrekitException;
import org.orekit.geometry.fov.PolygonalFieldOfView;

@Deprecated
public class FieldOfView
extends PolygonalFieldOfView {
    public FieldOfView(SphericalPolygonsSet zone, double margin) {
        super(zone, margin);
    }

    public FieldOfView(Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2, double margin) {
        super(FieldOfView.createPolygon(center, axis1, halfAperture1, axis2, halfAperture2), margin);
    }

    public FieldOfView(Vector3D center, Vector3D meridian, double insideRadius, int n, double margin) {
        super(center, PolygonalFieldOfView.DefiningConeType.INSIDE_CONE_TOUCHING_POLYGON_AT_EDGES_MIDDLE, meridian, insideRadius, n, margin);
    }

    @Deprecated
    public double offsetFromBoundary(Vector3D lineOfSight) {
        S2Point los = new S2Point(lineOfSight);
        SphericalPolygonsSet zone = this.getZone();
        EnclosingBall<Sphere2D, S2Point> cap = zone.getEnclosingCap();
        double margin = this.getMargin();
        double crudeDistance = cap.getCenter().distance(los) - cap.getRadius();
        if (crudeDistance - margin > FastMath.max(FastMath.abs(margin), 0.01)) {
            return crudeDistance - margin;
        }
        return zone.projectToBoundary(los).getOffset() - margin;
    }

    private static SphericalPolygonsSet createPolygon(Vector3D center, Vector3D axis1, double halfAperture1, Vector3D axis2, double halfAperture2) {
        RegionFactory<Sphere2D> factory = new RegionFactory<Sphere2D>();
        double tolerance = FastMath.max(FastMath.ulp(Math.PI * 2), 1.0E-12 * FastMath.max(halfAperture1, halfAperture2));
        Region<Sphere2D> dihedra1 = FieldOfView.buildDihedra(factory, tolerance, center, axis1, halfAperture1);
        Region<Sphere2D> dihedra2 = FieldOfView.buildDihedra(factory, tolerance, center, axis2, halfAperture2);
        return (SphericalPolygonsSet)factory.intersection(dihedra1, dihedra2);
    }

    private static Region<Sphere2D> buildDihedra(RegionFactory<Sphere2D> factory, double tolerance, Vector3D center, Vector3D axis, double halfAperture) {
        if (halfAperture > 1.5707963267948966) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, halfAperture, 0.0, 1.5707963267948966);
        }
        Rotation r = new Rotation(axis, halfAperture, RotationConvention.VECTOR_OPERATOR);
        Vector3D normalCenterPlane = Vector3D.crossProduct(axis, center);
        Vector3D normalSidePlus = r.applyInverseTo(normalCenterPlane);
        Vector3D normalSideMinus = r.applyTo(normalCenterPlane.negate());
        return factory.intersection(new SphericalPolygonsSet(normalSidePlus, tolerance), new SphericalPolygonsSet(normalSideMinus, tolerance));
    }
}

