/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.FieldOfView;
import org.orekit.propagation.events.VisibilityTrigger;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;
import org.orekit.utils.PVCoordinatesProvider;

public class FieldOfViewDetector
extends AbstractDetector<FieldOfViewDetector> {
    private final PVCoordinatesProvider targetPVProvider;
    private final double radiusTarget;
    private final VisibilityTrigger trigger;
    private final org.orekit.geometry.fov.FieldOfView fov;

    @Deprecated
    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, FieldOfView fov) {
        this(pvTarget, 0.0, VisibilityTrigger.VISIBLE_AS_SOON_AS_PARTIALLY_IN_FOV, fov);
    }

    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, org.orekit.geometry.fov.FieldOfView fov) {
        this(pvTarget, 0.0, VisibilityTrigger.VISIBLE_AS_SOON_AS_PARTIALLY_IN_FOV, fov);
    }

    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, org.orekit.geometry.fov.FieldOfView fov) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), pvTarget, radiusTarget, trigger, fov);
    }

    @Deprecated
    public FieldOfViewDetector(PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, FieldOfView fov) {
        this(600.0, 1.0E-6, 100, new StopOnIncreasing(), pvTarget, radiusTarget, trigger, fov);
    }

    private FieldOfViewDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super FieldOfViewDetector> handler, PVCoordinatesProvider pvTarget, double radiusTarget, VisibilityTrigger trigger, org.orekit.geometry.fov.FieldOfView fov) {
        super(maxCheck, threshold, maxIter, handler);
        this.targetPVProvider = pvTarget;
        this.radiusTarget = radiusTarget;
        this.trigger = trigger;
        this.fov = fov;
    }

    @Override
    protected FieldOfViewDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super FieldOfViewDetector> newHandler) {
        return new FieldOfViewDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.targetPVProvider, this.radiusTarget, this.trigger, this.fov);
    }

    public PVCoordinatesProvider getPVTarget() {
        return this.targetPVProvider;
    }

    public org.orekit.geometry.fov.FieldOfView getFOV() {
        return this.fov;
    }

    @Deprecated
    public FieldOfView getFieldOfView() {
        return this.fov instanceof FieldOfView ? (FieldOfView)this.fov : null;
    }

    @Override
    public double g(SpacecraftState s) {
        Vector3D targetPosInert = this.targetPVProvider.getPVCoordinates(s.getDate(), s.getFrame()).getPosition();
        Vector3D lineOfSightSC = s.toTransform().transformPosition(targetPosInert);
        double angularRadius = FastMath.asin(this.radiusTarget / lineOfSightSC.getNorm());
        return this.fov.offsetFromBoundary(lineOfSightSC, angularRadius, this.trigger);
    }
}

