/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events;

import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.frames.Frame;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AbstractDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.events.handlers.StopOnIncreasing;

public class NodeDetector
extends AbstractDetector<NodeDetector> {
    private final Frame frame;

    public NodeDetector(Orbit orbit, Frame frame) {
        this(1.0E-13 * orbit.getKeplerianPeriod(), orbit, frame);
    }

    public NodeDetector(double threshold, Orbit orbit, Frame frame) {
        this(2.0 * NodeDetector.estimateNodesTimeSeparation(orbit) / 3.0, threshold, 100, new StopOnIncreasing(), frame);
    }

    private NodeDetector(double maxCheck, double threshold, int maxIter, EventHandler<? super NodeDetector> handler, Frame frame) {
        super(maxCheck, threshold, maxIter, handler);
        this.frame = frame;
    }

    @Override
    protected NodeDetector create(double newMaxCheck, double newThreshold, int newMaxIter, EventHandler<? super NodeDetector> newHandler) {
        return new NodeDetector(newMaxCheck, newThreshold, newMaxIter, newHandler, this.frame);
    }

    private static double estimateNodesTimeSeparation(Orbit orbit) {
        KeplerianOrbit keplerian = (KeplerianOrbit)OrbitType.KEPLERIAN.convertType(orbit);
        double ascendingM = new KeplerianOrbit(keplerian.getA(), keplerian.getE(), keplerian.getI(), keplerian.getPerigeeArgument(), keplerian.getRightAscensionOfAscendingNode(), -keplerian.getPerigeeArgument(), PositionAngle.TRUE, keplerian.getFrame(), keplerian.getDate(), keplerian.getMu()).getMeanAnomaly();
        double descendingM = new KeplerianOrbit(keplerian.getA(), keplerian.getE(), keplerian.getI(), keplerian.getPerigeeArgument(), keplerian.getRightAscensionOfAscendingNode(), Math.PI - keplerian.getPerigeeArgument(), PositionAngle.TRUE, keplerian.getFrame(), keplerian.getDate(), keplerian.getMu()).getMeanAnomaly();
        double delta1 = MathUtils.normalizeAngle(ascendingM, descendingM + Math.PI) - descendingM;
        double delta2 = Math.PI * 2 - delta1;
        return FastMath.min(delta1, delta2) / keplerian.getKeplerianMeanMotion();
    }

    public Frame getFrame() {
        return this.frame;
    }

    @Override
    public double g(SpacecraftState s) {
        return s.getPVCoordinates(this.frame).getPosition().getZ();
    }
}

