/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.events.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.ode.events.Action;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;

public class RecordAndContinue<T extends EventDetector>
implements EventHandler<T> {
    private final List<Event<T>> events;

    public RecordAndContinue() {
        this(new ArrayList<Event<T>>());
    }

    public RecordAndContinue(List<Event<T>> events) {
        this.events = events;
    }

    public List<Event<T>> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    public void clear() {
        this.events.clear();
    }

    @Override
    public Action eventOccurred(SpacecraftState s, T detector, boolean increasing) {
        this.events.add(new Event(detector, s, increasing));
        return Action.CONTINUE;
    }

    @Override
    public SpacecraftState resetState(T detector, SpacecraftState oldState) {
        return null;
    }

    public static class Event<T> {
        private final SpacecraftState state;
        private final T detector;
        private final boolean increasing;

        private Event(T detector, SpacecraftState state, boolean increasing) {
            this.detector = detector;
            this.state = state;
            this.increasing = increasing;
        }

        public T getDetector() {
            return this.detector;
        }

        public boolean isIncreasing() {
            return this.increasing;
        }

        public SpacecraftState getState() {
            return this.state;
        }

        public String toString() {
            return "Event{state=" + this.state + ", increasing=" + this.increasing + ", detector=" + this.detector + '}';
        }
    }
}

