/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.integration;

import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;

public abstract class AbstractDSConverter {
    private final int freeStateParameters;

    protected AbstractDSConverter(int freeStateParameters) {
        this.freeStateParameters = freeStateParameters;
    }

    public int getFreeStateParameters() {
        return this.freeStateParameters;
    }

    protected DerivativeStructure extend(DerivativeStructure original, DSFactory factory) {
        double[] originalDerivatives = original.getAllDerivatives();
        double[] extendedDerivatives = new double[factory.getCompiler().getSize()];
        System.arraycopy(originalDerivatives, 0, extendedDerivatives, 0, originalDerivatives.length);
        return factory.build(extendedDerivatives);
    }

    protected FieldVector3D<DerivativeStructure> extend(FieldVector3D<DerivativeStructure> original, DSFactory factory) {
        return new FieldVector3D<DerivativeStructure>(this.extend(original.getX(), factory), this.extend(original.getY(), factory), this.extend(original.getZ(), factory));
    }

    protected FieldRotation<DerivativeStructure> extend(FieldRotation<DerivativeStructure> original, DSFactory factory) {
        return new FieldRotation<DerivativeStructure>(this.extend(original.getQ0(), factory), this.extend(original.getQ1(), factory), this.extend(original.getQ2(), factory), this.extend(original.getQ3(), factory), false);
    }
}

