/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.sampling;

import org.hipparchus.RealFieldElement;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.sampling.FieldOrekitFixedStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepHandler;
import org.orekit.propagation.sampling.FieldOrekitStepInterpolator;
import org.orekit.time.FieldAbsoluteDate;

public class FieldOrekitStepNormalizer<T extends RealFieldElement<T>>
implements FieldOrekitStepHandler<T> {
    private T h;
    private FieldOrekitFixedStepHandler<T> handler;
    private FieldSpacecraftState<T> lastState;
    private boolean forward;

    public FieldOrekitStepNormalizer(T h, FieldOrekitFixedStepHandler<T> handler) {
        this.h = (RealFieldElement)h.abs();
        this.handler = handler;
        this.lastState = null;
        this.forward = true;
    }

    public boolean requiresDenseOutput() {
        return true;
    }

    @Override
    public void init(FieldSpacecraftState<T> s0, FieldAbsoluteDate<T> t) {
        this.lastState = null;
        this.forward = true;
        this.handler.init(s0, t, this.h);
    }

    @Override
    public void handleStep(FieldOrekitStepInterpolator<T> interpolator, boolean isLast) {
        FieldAbsoluteDate<T> nextTime;
        if (this.lastState == null) {
            this.lastState = interpolator.getPreviousState();
        }
        Object step = this.h;
        this.forward = interpolator.isForward();
        if (!this.forward) {
            step = (RealFieldElement)this.h.multiply((int)-1);
        }
        boolean nextInStep = this.forward ^ (nextTime = this.lastState.getDate().shiftedBy(step)).compareTo(interpolator.getCurrentState().getDate()) > 0;
        while (nextInStep) {
            this.handler.handleStep(this.lastState, false);
            this.lastState = interpolator.getInterpolatedState(nextTime);
            nextTime = nextTime.shiftedBy(step);
            nextInStep = this.forward ^ nextTime.compareTo(interpolator.getCurrentState().getDate()) > 0;
        }
        if (isLast) {
            this.handler.handleStep(this.lastState, true);
        }
    }
}

