/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.exception.Localizable;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.sampling.FieldODEStateInterpolator;
import org.hipparchus.ode.sampling.FieldODEStepHandler;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.attitudes.FieldAttitude;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.frames.Frame;
import org.orekit.orbits.FieldEquinoctialOrbit;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.integration.FieldAbstractIntegratedPropagator;
import org.orekit.propagation.integration.FieldStateMapper;
import org.orekit.propagation.numerical.FieldNumericalPropagator;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTNewtonianAttraction;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldFixedNumberInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldInterpolationGrid;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldMaxGapInterpolationGrid;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterObserver;

public class FieldDSSTPropagator<T extends RealFieldElement<T>>
extends FieldAbstractIntegratedPropagator<T> {
    private static final int I = 1;
    private static final int INTERPOLATION_POINTS_PER_STEP = 3;
    private static final double EPSILON_DEFAULT = 1.0E-13;
    private static final int MAX_ITERATIONS_DEFAULT = 200;
    private boolean initialIsOsculating;
    private final Field<T> field;
    private final transient List<DSSTForceModel> forceModels;
    private FieldMeanPlusShortPeriodicMapper mapper;
    private FieldInterpolationGrid<T> interpolationgrid;

    @DefaultDataContext
    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, PropagationType propagationType) {
        this(field, integrator, propagationType, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, PropagationType propagationType, AttitudeProvider attitudeProvider) {
        super(field, integrator, propagationType);
        this.field = field;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.initMapper(field);
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(attitudeProvider);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    @DefaultDataContext
    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator) {
        this(field, integrator, Propagator.getDefaultLaw(DataContext.getDefault().getFrames()));
    }

    public FieldDSSTPropagator(Field<T> field, FieldODEIntegrator<T> integrator, AttitudeProvider attitudeProvider) {
        super(field, integrator, PropagationType.MEAN);
        this.field = field;
        this.forceModels = new ArrayList<DSSTForceModel>();
        this.initMapper(field);
        this.setOrbitType(OrbitType.EQUINOCTIAL);
        this.setPositionAngleType(PositionAngle.MEAN);
        this.setAttitudeProvider(attitudeProvider);
        this.setInterpolationGridToFixedNumberOfPoints(3);
    }

    @Override
    public void setMu(T mu) {
        this.addForceModel(new DSSTNewtonianAttraction(mu.getReal()));
    }

    private void superSetMu(T mu) {
        super.setMu(mu);
    }

    private boolean hasNewtonianAttraction() {
        int last = this.forceModels.size() - 1;
        return last >= 0 && this.forceModels.get(last) instanceof DSSTNewtonianAttraction;
    }

    public void setInitialState(FieldSpacecraftState<T> initialState) {
        this.setInitialState(initialState, PropagationType.OSCULATING);
    }

    public void setInitialState(FieldSpacecraftState<T> initialState, PropagationType stateType) {
        switch (stateType) {
            case MEAN: {
                this.initialIsOsculating = false;
                break;
            }
            case OSCULATING: {
                this.initialIsOsculating = true;
                break;
            }
            default: {
                throw new OrekitInternalError(null);
            }
        }
        this.resetInitialState(initialState);
    }

    @Override
    public void resetInitialState(FieldSpacecraftState<T> state) {
        super.resetInitialState(state);
        if (!this.hasNewtonianAttraction()) {
            this.setMu(state.getMu());
        }
        super.setStartDate(state.getDate());
    }

    public void setSelectedCoefficients(Set<String> selectedCoefficients) {
        this.mapper.setSelectedCoefficients((Set<String>)(selectedCoefficients == null ? null : new HashSet<String>(selectedCoefficients)));
    }

    public Set<String> getSelectedCoefficients() {
        Set<String> set = this.mapper.getSelectedCoefficients();
        return set == null ? null : Collections.unmodifiableSet(set);
    }

    public boolean initialIsOsculating() {
        return this.initialIsOsculating;
    }

    public void setInterpolationGridToFixedNumberOfPoints(int interpolationPoints) {
        this.interpolationgrid = new FieldFixedNumberInterpolationGrid<T>(this.field, interpolationPoints);
    }

    public void setInterpolationGridToMaxTimeGap(T maxGap) {
        this.interpolationgrid = new FieldMaxGapInterpolationGrid<T>(this.field, maxGap);
    }

    public void addForceModel(DSSTForceModel force) {
        if (force instanceof DSSTNewtonianAttraction) {
            try {
                force.getParametersDrivers()[0].addObserver(new ParameterObserver(){

                    @Override
                    public void valueChanged(double previousValue, ParameterDriver driver) {
                        FieldDSSTPropagator.this.superSetMu((RealFieldElement)((RealFieldElement)FieldDSSTPropagator.this.field.getZero()).add(driver.getValue()));
                    }
                });
            }
            catch (OrekitException oe) {
                throw new OrekitInternalError(oe);
            }
            if (this.hasNewtonianAttraction()) {
                this.forceModels.set(this.forceModels.size() - 1, force);
            } else {
                this.forceModels.add(force);
            }
        } else if (this.hasNewtonianAttraction()) {
            this.forceModels.add(this.forceModels.size() - 1, force);
        } else {
            this.forceModels.add(force);
        }
        force.registerAttitudeProvider(this.getAttitudeProvider());
    }

    public void removeForceModels() {
        int last = this.forceModels.size() - 1;
        if (this.hasNewtonianAttraction()) {
            DSSTForceModel newton = this.forceModels.get(last);
            this.forceModels.clear();
            this.forceModels.add(newton);
        } else {
            this.forceModels.clear();
        }
    }

    public List<DSSTForceModel> getAllForceModels() {
        return Collections.unmodifiableList(this.forceModels);
    }

    @Override
    public OrbitType getOrbitType() {
        return super.getOrbitType();
    }

    @Override
    public PositionAngle getPositionAngleType() {
        return super.getPositionAngleType();
    }

    public FieldSpacecraftState<T> computeOsculatingState(FieldSpacecraftState<T> mean, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forces) {
        FieldAuxiliaryElements<T> aux = new FieldAuxiliaryElements<T>(mean.getOrbit(), 1);
        ArrayList<FieldShortPeriodTerms<T>> shortPeriodTerms = new ArrayList<FieldShortPeriodTerms<T>>();
        for (DSSTForceModel force : forces) {
            force.registerAttitudeProvider(attitudeProvider);
            shortPeriodTerms.addAll(force.initialize(aux, PropagationType.OSCULATING, force.getParameters(this.field)));
            force.updateShortPeriodTerms(force.getParameters(this.field), new FieldSpacecraftState[]{mean});
        }
        FieldEquinoctialOrbit<T> osculatingOrbit = this.computeOsculatingOrbit(mean, shortPeriodTerms);
        return new FieldSpacecraftState<T>(osculatingOrbit, mean.getAttitude(), mean.getMass(), mean.getAdditionalStates());
    }

    public FieldSpacecraftState<T> computeMeanState(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel) {
        return this.computeMeanState(osculating, attitudeProvider, forceModel, 1.0E-13, 200);
    }

    public FieldSpacecraftState<T> computeMeanState(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel, double epsilon, int maxIterations) {
        FieldOrbit<T> meanOrbit = this.computeMeanOrbit(osculating, attitudeProvider, forceModel, epsilon, maxIterations);
        return new FieldSpacecraftState<T>(meanOrbit, osculating.getAttitude(), osculating.getMass(), osculating.getAdditionalStates());
    }

    public void setSatelliteRevolution(int satelliteRevolution) {
        this.mapper.setSatelliteRevolution(satelliteRevolution);
    }

    public int getSatelliteRevolution() {
        return this.mapper.getSatelliteRevolution();
    }

    @Override
    public void setAttitudeProvider(AttitudeProvider attitudeProvider) {
        super.setAttitudeProvider(attitudeProvider);
        for (DSSTForceModel force : this.forceModels) {
            force.registerAttitudeProvider(attitudeProvider);
        }
    }

    @Override
    protected void beforeIntegration(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> tEnd) {
        PropagationType type = this.isMeanOrbit();
        FieldAuxiliaryElements<T> aux = new FieldAuxiliaryElements<T>(initialState.getOrbit(), 1);
        ArrayList shortPeriodTerms = new ArrayList();
        for (DSSTForceModel force : this.forceModels) {
            shortPeriodTerms.addAll(force.initialize(aux, type, force.getParameters(this.field)));
        }
        this.mapper.setShortPeriodTerms(shortPeriodTerms);
        if (type == PropagationType.OSCULATING) {
            FieldShortPeriodicsHandler spHandler = new FieldShortPeriodicsHandler(this.forceModels);
            ArrayList stepHandlers = new ArrayList();
            stepHandlers.add(spHandler);
            FieldODEIntegrator integrator = this.getIntegrator();
            Collection existing = integrator.getStepHandlers();
            stepHandlers.addAll(existing);
            integrator.clearStepHandlers();
            for (FieldODEStepHandler fieldODEStepHandler : stepHandlers) {
                integrator.addStepHandler(fieldODEStepHandler);
            }
        }
    }

    @Override
    protected void afterIntegration() {
        if (this.isMeanOrbit() == PropagationType.OSCULATING) {
            ArrayList preserved = new ArrayList();
            FieldODEIntegrator integrator = this.getIntegrator();
            integrator.clearStepHandlers();
            for (FieldODEStepHandler sp : preserved) {
                integrator.addStepHandler(sp);
            }
        }
    }

    private FieldOrbit<T> computeMeanOrbit(FieldSpacecraftState<T> osculating, AttitudeProvider attitudeProvider, Collection<DSSTForceModel> forceModel, double epsilon, int maxIterations) {
        RealFieldElement zero = (RealFieldElement)this.field.getZero();
        FieldEquinoctialOrbit<RealFieldElement> meanOrbit = (FieldEquinoctialOrbit<RealFieldElement>)OrbitType.EQUINOCTIAL.convertType(osculating.getOrbit());
        RealFieldElement epsilonT = (RealFieldElement)zero.add(epsilon);
        RealFieldElement thresholdA = (RealFieldElement)epsilonT.multiply(FastMath.abs(meanOrbit.getA()).add(1.0));
        RealFieldElement thresholdE = (RealFieldElement)epsilonT.multiply(meanOrbit.getE().add(1.0));
        RealFieldElement thresholdI = (RealFieldElement)epsilonT.multiply(meanOrbit.getI().add(1.0));
        RealFieldElement thresholdL = (RealFieldElement)epsilonT.multiply(Math.PI);
        for (DSSTForceModel force : forceModel) {
            force.registerAttitudeProvider(attitudeProvider);
        }
        int i = 0;
        while (i++ < maxIterations) {
            FieldSpacecraftState<T> meanState = new FieldSpacecraftState<T>(meanOrbit, osculating.getAttitude(), osculating.getMass());
            FieldAuxiliaryElements aux = new FieldAuxiliaryElements(meanOrbit, 1);
            ArrayList<FieldShortPeriodTerms<T>> shortPeriodTerms = new ArrayList<FieldShortPeriodTerms<T>>();
            for (DSSTForceModel force : forceModel) {
                shortPeriodTerms.addAll(force.initialize(aux, PropagationType.OSCULATING, force.getParameters(this.field)));
                force.updateShortPeriodTerms(force.getParameters(this.field), new FieldSpacecraftState[]{meanState});
            }
            FieldEquinoctialOrbit<T> rebuilt = this.computeOsculatingOrbit(meanState, shortPeriodTerms);
            RealFieldElement deltaA = (RealFieldElement)osculating.getA().subtract(rebuilt.getA());
            RealFieldElement deltaEx = (RealFieldElement)osculating.getEquinoctialEx().subtract(rebuilt.getEquinoctialEx());
            RealFieldElement deltaEy = (RealFieldElement)osculating.getEquinoctialEy().subtract(rebuilt.getEquinoctialEy());
            RealFieldElement deltaHx = (RealFieldElement)osculating.getHx().subtract(rebuilt.getHx());
            RealFieldElement deltaHy = (RealFieldElement)osculating.getHy().subtract(rebuilt.getHy());
            RealFieldElement deltaLv = MathUtils.normalizeAngle((RealFieldElement)osculating.getLv().subtract(rebuilt.getLv()), zero);
            if (FastMath.abs(deltaA).getReal() < thresholdA.getReal() && FastMath.abs(deltaEx).getReal() < thresholdE.getReal() && FastMath.abs(deltaEy).getReal() < thresholdE.getReal() && FastMath.abs(deltaHx).getReal() < thresholdI.getReal() && FastMath.abs(deltaHy).getReal() < thresholdI.getReal() && FastMath.abs(deltaLv).getReal() < thresholdL.getReal()) {
                return meanOrbit;
            }
            meanOrbit = new FieldEquinoctialOrbit<RealFieldElement>(meanOrbit.getA().add((RealFieldElement)deltaA), meanOrbit.getEquinoctialEx().add((RealFieldElement)deltaEx), meanOrbit.getEquinoctialEy().add((RealFieldElement)deltaEy), meanOrbit.getHx().add((RealFieldElement)deltaHx), meanOrbit.getHy().add((RealFieldElement)deltaHy), meanOrbit.getLv().add((RealFieldElement)deltaLv), PositionAngle.TRUE, meanOrbit.getFrame(), meanOrbit.getDate(), (RealFieldElement)meanOrbit.getMu());
        }
        throw new OrekitException((Localizable)OrekitMessages.UNABLE_TO_COMPUTE_DSST_MEAN_PARAMETERS, i);
    }

    private FieldEquinoctialOrbit<T> computeOsculatingOrbit(FieldSpacecraftState<T> meanState, List<FieldShortPeriodTerms<T>> shortPeriodTerms) {
        RealFieldElement[] mean = (RealFieldElement[])MathArrays.buildArray(this.field, 6);
        RealFieldElement[] meanDot = (RealFieldElement[])MathArrays.buildArray(this.field, 6);
        OrbitType.EQUINOCTIAL.mapOrbitToArray(meanState.getOrbit(), PositionAngle.MEAN, mean, meanDot);
        RealFieldElement[] y = (RealFieldElement[])mean.clone();
        for (FieldShortPeriodTerms<T> spt : shortPeriodTerms) {
            RealFieldElement[] shortPeriodic = spt.value(meanState.getOrbit());
            for (int i = 0; i < shortPeriodic.length; ++i) {
                y[i] = y[i].add(shortPeriodic[i]);
            }
        }
        return (FieldEquinoctialOrbit)OrbitType.EQUINOCTIAL.mapArrayToOrbit(y, meanDot, PositionAngle.MEAN, meanState.getDate(), (RealFieldElement)meanState.getMu(), meanState.getFrame());
    }

    @Override
    protected FieldSpacecraftState<T> getInitialIntegrationState() {
        if (this.initialIsOsculating) {
            return this.computeMeanState(this.getInitialState(), this.getAttitudeProvider(), this.forceModels);
        }
        return this.getInitialState();
    }

    @Override
    protected FieldStateMapper<T> createMapper(FieldAbsoluteDate<T> referenceDate, T mu, OrbitType ignoredOrbitType, PositionAngle ignoredPositionAngleType, AttitudeProvider attitudeProvider, Frame frame) {
        FieldMeanPlusShortPeriodicMapper newMapper = new FieldMeanPlusShortPeriodicMapper(this, referenceDate, mu, attitudeProvider, frame);
        if (this.mapper != null) {
            newMapper.setSatelliteRevolution(this.mapper.getSatelliteRevolution());
            newMapper.setSelectedCoefficients(this.mapper.getSelectedCoefficients());
            newMapper.setShortPeriodTerms(this.mapper.getShortPeriodTerms());
        }
        this.mapper = newMapper;
        return this.mapper;
    }

    @Override
    protected FieldAbstractIntegratedPropagator.MainStateEquations<T> getMainStateEquations(FieldODEIntegrator<T> integrator) {
        return new Main(integrator);
    }

    public static <T extends RealFieldElement<T>> double[][] tolerances(T dP, FieldOrbit<T> orbit) {
        return FieldNumericalPropagator.tolerances(dP, orbit, OrbitType.EQUINOCTIAL);
    }

    private class FieldShortPeriodicsHandler
    implements FieldODEStepHandler<T> {
        private final List<DSSTForceModel> forceModels;

        FieldShortPeriodicsHandler(List<DSSTForceModel> forceModels) {
            this.forceModels = forceModels;
        }

        @Override
        public void init(FieldODEStateAndDerivative<T> initialState, T finalTime) {
            RealFieldElement zero = (RealFieldElement)FieldDSSTPropagator.this.field.getZero();
            FieldSpacecraftState meanStates = FieldDSSTPropagator.this.mapper.mapArrayToState(zero, initialState.getPrimaryState(), initialState.getPrimaryDerivative(), PropagationType.MEAN);
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParameters(FieldDSSTPropagator.this.field), new FieldSpacecraftState[]{meanStates});
            }
        }

        @Override
        public void handleStep(FieldODEStateInterpolator<T> interpolator, boolean isLast) {
            RealFieldElement[] interpolationPoints = FieldDSSTPropagator.this.interpolationgrid.getGridPoints((RealFieldElement)interpolator.getPreviousState().getTime(), (RealFieldElement)interpolator.getCurrentState().getTime());
            FieldSpacecraftState[] meanStates = new FieldSpacecraftState[interpolationPoints.length];
            for (int i = 0; i < interpolationPoints.length; ++i) {
                RealFieldElement time = interpolationPoints[i];
                FieldODEStateAndDerivative<RealFieldElement> sd = interpolator.getInterpolatedState(time);
                meanStates[i] = FieldDSSTPropagator.this.mapper.mapArrayToState(time, sd.getPrimaryState(), sd.getPrimaryDerivative(), PropagationType.MEAN);
            }
            for (DSSTForceModel forceModel : this.forceModels) {
                forceModel.updateShortPeriodTerms(forceModel.getParameters(FieldDSSTPropagator.this.field), meanStates);
            }
        }
    }

    private class Main
    implements FieldAbstractIntegratedPropagator.MainStateEquations<T> {
        private final T[] yDot;

        Main(FieldODEIntegrator<T> integrator) {
            this.yDot = (RealFieldElement[])MathArrays.buildArray(FieldDSSTPropagator.this.field, 7);
            for (DSSTForceModel forceModel : FieldDSSTPropagator.this.forceModels) {
                FieldEventDetector<T>[] modelDetectors = forceModel.getFieldEventsDetectors(FieldDSSTPropagator.this.field);
                if (modelDetectors == null) continue;
                for (FieldEventDetector detector : modelDetectors) {
                    FieldDSSTPropagator.this.setUpEventDetector(integrator, detector);
                }
            }
        }

        @Override
        public void init(FieldSpacecraftState<T> initialState, FieldAbsoluteDate<T> target) {
        }

        @Override
        public T[] computeDerivatives(FieldSpacecraftState<T> state) {
            RealFieldElement zero = (RealFieldElement)state.getDate().getField().getZero();
            Arrays.fill(this.yDot, zero);
            FieldAuxiliaryElements auxiliaryElements = new FieldAuxiliaryElements(state.getOrbit(), 1);
            for (DSSTForceModel forceModel : FieldDSSTPropagator.this.forceModels) {
                RealFieldElement[] daidt = this.elementRates(forceModel, state, auxiliaryElements, forceModel.getParameters(FieldDSSTPropagator.this.field));
                for (int i = 0; i < daidt.length; ++i) {
                    this.yDot[i] = this.yDot[i].add((RealFieldElement)daidt[i]);
                }
            }
            return (RealFieldElement[])this.yDot.clone();
        }

        private T[] elementRates(DSSTForceModel forceModel, FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
            return forceModel.getMeanElementRate(state, auxiliaryElements, (RealFieldElement[])parameters);
        }
    }

    private static class FieldMeanPlusShortPeriodicMapper
    extends FieldStateMapper<T> {
        private Set<String> selectedCoefficients;
        private int satelliteRevolution;
        private List<FieldShortPeriodTerms<T>> shortPeriodTerms;
        final /* synthetic */ FieldDSSTPropagator this$0;

        FieldMeanPlusShortPeriodicMapper(FieldAbsoluteDate<T> referenceDate, T mu, AttitudeProvider attitudeProvider, Frame frame) {
            this.this$0 = var1_1;
            super(referenceDate, mu, OrbitType.EQUINOCTIAL, PositionAngle.MEAN, attitudeProvider, frame);
            this.selectedCoefficients = null;
            this.satelliteRevolution = 2;
            this.shortPeriodTerms = Collections.emptyList();
        }

        @Override
        public FieldSpacecraftState<T> mapArrayToState(FieldAbsoluteDate<T> date, T[] y, T[] yDot, PropagationType type) {
            HashMap<String, T[]> coefficients;
            RealFieldElement[] elements = (RealFieldElement[])y.clone();
            switch (type) {
                case MEAN: {
                    coefficients = null;
                    break;
                }
                case OSCULATING: {
                    FieldOrbit meanOrbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, (RealFieldElement[])yDot, PositionAngle.MEAN, date, (RealFieldElement)this.getMu(), this.getFrame());
                    coefficients = this.selectedCoefficients == null ? null : new HashMap<String, T[]>();
                    for (FieldShortPeriodTerms spt : this.shortPeriodTerms) {
                        RealFieldElement[] shortPeriodic = spt.value(meanOrbit);
                        for (int i = 0; i < shortPeriodic.length; ++i) {
                            elements[i] = elements[i].add(shortPeriodic[i]);
                        }
                        if (this.selectedCoefficients == null) continue;
                        coefficients.putAll(spt.getCoefficients(date, this.selectedCoefficients));
                    }
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
            RealFieldElement mass = elements[6];
            if (mass.getReal() <= 0.0) {
                throw new OrekitException((Localizable)OrekitMessages.SPACECRAFT_MASS_BECOMES_NEGATIVE, mass);
            }
            FieldOrbit orbit = OrbitType.EQUINOCTIAL.mapArrayToOrbit(elements, (RealFieldElement[])yDot, PositionAngle.MEAN, date, (RealFieldElement)this.getMu(), this.getFrame());
            FieldAttitude attitude = this.getAttitudeProvider().getAttitude(orbit, date, this.getFrame());
            if (coefficients == null) {
                return new FieldSpacecraftState<RealFieldElement>(orbit, attitude, mass);
            }
            return new FieldSpacecraftState<RealFieldElement>(orbit, attitude, mass, coefficients);
        }

        @Override
        public void mapStateToArray(FieldSpacecraftState<T> state, T[] y, T[] yDot) {
            OrbitType.EQUINOCTIAL.mapOrbitToArray(state.getOrbit(), PositionAngle.MEAN, (RealFieldElement[])y, (RealFieldElement[])yDot);
            y[6] = state.getMass();
        }

        public void setSatelliteRevolution(int satelliteRevolution) {
            this.satelliteRevolution = satelliteRevolution;
        }

        public int getSatelliteRevolution() {
            return this.satelliteRevolution;
        }

        public void setSelectedCoefficients(Set<String> selectedCoefficients) {
            this.selectedCoefficients = selectedCoefficients;
        }

        public Set<String> getSelectedCoefficients() {
            return this.selectedCoefficients;
        }

        public void setShortPeriodTerms(List<FieldShortPeriodTerms<T>> shortPeriodTerms) {
            this.shortPeriodTerms = shortPeriodTerms;
        }

        public List<FieldShortPeriodTerms<T>> getShortPeriodTerms() {
            return this.shortPeriodTerms;
        }
    }
}

