/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.orekit.forces.drag.DragForce;
import org.orekit.forces.drag.DragSensitive;
import org.orekit.forces.drag.IsotropicDrag;
import org.orekit.models.earth.atmosphere.Atmosphere;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ParameterDriver;

public class DSSTAtmosphericDrag
extends AbstractGaussianContribution {
    private static final double GAUSS_THRESHOLD = 6.0E-10;
    private static final double ATMOSPHERE_ALTITUDE_MAX = 1000000.0;
    private final DragForce drag;
    private final double rbar;

    public DSSTAtmosphericDrag(DragForce force, double mu) {
        super("DSST-drag-", 6.0E-10, force, mu);
        this.drag = force;
        this.rbar = 7378137.0;
    }

    public DSSTAtmosphericDrag(Atmosphere atmosphere, double cd, double area, double mu) {
        this(atmosphere, new IsotropicDrag(area, cd), mu);
    }

    public DSSTAtmosphericDrag(Atmosphere atmosphere, DragSensitive spacecraft, double mu) {
        this(new DragForce(atmosphere, spacecraft), mu);
    }

    public Atmosphere getAtmosphere() {
        return this.drag.getAtmosphere();
    }

    public double getRbar() {
        return this.rbar;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    protected double[] getLLimits(SpacecraftState state, AuxiliaryElements auxiliaryElements) {
        double perigee = auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc());
        if (perigee > this.rbar) {
            return new double[2];
        }
        double apogee = auxiliaryElements.getSma() * (1.0 + auxiliaryElements.getEcc());
        if (apogee < this.rbar) {
            return new double[]{-Math.PI + MathUtils.normalizeAngle(state.getLv(), 0.0), Math.PI + MathUtils.normalizeAngle(state.getLv(), 0.0)};
        }
        double fb = FastMath.acos((auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc() * auxiliaryElements.getEcc()) / this.rbar - 1.0) / auxiliaryElements.getEcc());
        double wW = FastMath.atan2(auxiliaryElements.getH(), auxiliaryElements.getK());
        return new double[]{wW - fb, wW + fb};
    }

    @Override
    protected <T extends RealFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements) {
        Field<T> field = state.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement[] tab = (RealFieldElement[])MathArrays.buildArray(field, 2);
        RealFieldElement perigee = (RealFieldElement)auxiliaryElements.getSma().multiply(((RealFieldElement)auxiliaryElements.getEcc().negate()).add(1.0));
        if (perigee.getReal() > this.rbar) {
            return tab;
        }
        RealFieldElement apogee = (RealFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getEcc().add(1.0));
        if (apogee.getReal() < this.rbar) {
            tab[0] = (RealFieldElement)MathUtils.normalizeAngle(state.getLv(), zero).subtract(Math.PI);
            tab[1] = (RealFieldElement)MathUtils.normalizeAngle(state.getLv(), zero).add(Math.PI);
            return tab;
        }
        RealFieldElement fb = FastMath.acos((RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(((RealFieldElement)((RealFieldElement)auxiliaryElements.getEcc().multiply(auxiliaryElements.getEcc())).negate()).add(1.0))).divide(this.rbar)).subtract(1.0)).divide(auxiliaryElements.getEcc()));
        RealFieldElement wW = FastMath.atan2(auxiliaryElements.getH(), auxiliaryElements.getK());
        tab[0] = wW.subtract((RealFieldElement)fb);
        tab[1] = wW.add((RealFieldElement)fb);
        return tab;
    }

    @Override
    protected ParameterDriver[] getParametersDriversWithoutMu() {
        return this.drag.getParametersDrivers();
    }

    public DragSensitive getSpacecraft() {
        return this.drag.getSpacecraft();
    }

    public DragForce getDrag() {
        return this.drag;
    }
}

