/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;
import org.hipparchus.util.Precision;
import org.orekit.forces.radiation.IsotropicRadiationSingleCoefficient;
import org.orekit.forces.radiation.RadiationSensitive;
import org.orekit.forces.radiation.SolarRadiationPressure;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.AbstractGaussianContribution;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.utils.ExtendedPVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class DSSTSolarRadiationPressure
extends AbstractGaussianContribution {
    private static final double D_REF = 1.4959787E11;
    private static final double P_REF = 4.56E-6;
    private static final double GAUSS_THRESHOLD = 1.0E-15;
    private static final double S_ZERO = 1.0E-6;
    private static final String PREFIX = "DSST-SRP-";
    private final ExtendedPVCoordinatesProvider sun;
    private final double ae;
    private final RadiationSensitive spacecraft;

    public DSSTSolarRadiationPressure(double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(1.4959787E11, 4.56E-6, cr, area, sun, equatorialRadius, mu);
    }

    public DSSTSolarRadiationPressure(ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        this(1.4959787E11, 4.56E-6, sun, equatorialRadius, spacecraft, mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, double cr, double area, ExtendedPVCoordinatesProvider sun, double equatorialRadius, double mu) {
        this(dRef, pRef, sun, equatorialRadius, new IsotropicRadiationSingleCoefficient(area, cr), mu);
    }

    public DSSTSolarRadiationPressure(double dRef, double pRef, ExtendedPVCoordinatesProvider sun, double equatorialRadius, RadiationSensitive spacecraft, double mu) {
        super(PREFIX, 1.0E-15, new SolarRadiationPressure(dRef, pRef, sun, equatorialRadius, spacecraft), mu);
        this.sun = sun;
        this.ae = equatorialRadius;
        this.spacecraft = spacecraft;
    }

    public RadiationSensitive getSpacecraft() {
        return this.spacecraft;
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    @Override
    protected ParameterDriver[] getParametersDriversWithoutMu() {
        return this.spacecraft.getRadiationParametersDrivers();
    }

    @Override
    protected double[] getLLimits(SpacecraftState state, AuxiliaryElements auxiliaryElements) {
        double[] ll = new double[]{-Math.PI + MathUtils.normalizeAngle(state.getLv(), 0.0), Math.PI + MathUtils.normalizeAngle(state.getLv(), 0.0)};
        Vector3D sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        double alpha = sunDir.dotProduct(auxiliaryElements.getVectorF());
        double beta = sunDir.dotProduct(auxiliaryElements.getVectorG());
        double gamma = sunDir.dotProduct(auxiliaryElements.getVectorW());
        if (FastMath.abs(gamma * auxiliaryElements.getSma() * (1.0 - auxiliaryElements.getEcc())) < this.ae) {
            double[] roots;
            double bet2 = beta * beta;
            double h2 = auxiliaryElements.getH() * auxiliaryElements.getH();
            double k2 = auxiliaryElements.getK() * auxiliaryElements.getK();
            double m = this.ae / (auxiliaryElements.getSma() * auxiliaryElements.getB());
            double m2 = m * m;
            double m4 = m2 * m2;
            double bb = alpha * beta + m2 * auxiliaryElements.getH() * auxiliaryElements.getK();
            double b2 = bb * bb;
            double cc = alpha * alpha - bet2 + m2 * (k2 - h2);
            double dd = 1.0 - bet2 - m2 * (1.0 + h2);
            double[] a = new double[]{4.0 * b2 + cc * cc, 8.0 * bb * m2 * auxiliaryElements.getH() + 4.0 * cc * m2 * auxiliaryElements.getK(), -4.0 * b2 + 4.0 * m4 * h2 - 2.0 * cc * dd + 4.0 * m4 * k2, -8.0 * bb * m2 * auxiliaryElements.getH() - 4.0 * dd * m2 * auxiliaryElements.getK(), -4.0 * m4 * h2 + dd * dd};
            int nbRoots = this.realQuarticRoots(a, roots = new double[4]);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    double cosL = roots[i];
                    double sL = FastMath.sqrt((1.0 - cosL) * (1.0 + cosL));
                    for (int j = -1; j <= 1; j += 2) {
                        double range;
                        double S;
                        double sinL = (double)j * sL;
                        double cPhi = alpha * cosL + beta * sinL;
                        if (!(cPhi < 0.0) || !(FastMath.abs(S = 1.0 - m2 * (range = 1.0 + auxiliaryElements.getK() * cosL + auxiliaryElements.getH() * sinL) * range - cPhi * cPhi) < 1.0E-6)) continue;
                        double dSdL = m2 * range * (auxiliaryElements.getK() * sinL - auxiliaryElements.getH() * cosL) + cPhi * (alpha * sinL - beta * cosL);
                        if (dSdL > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2(sinL, cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2(sinL, cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = -Math.PI;
                    ll[1] = Math.PI;
                }
                if (ll[0] > ll[1]) {
                    if (ll[1] < 0.0) {
                        ll[1] = ll[1] + Math.PI * 2;
                    } else {
                        ll[0] = ll[0] - Math.PI * 2;
                    }
                }
            }
        }
        return ll;
    }

    @Override
    protected <T extends RealFieldElement<T>> T[] getLLimits(FieldSpacecraftState<T> state, FieldAuxiliaryElements<T> auxiliaryElements) {
        Field<T> field = state.getDate().getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement one = (RealFieldElement)field.getOne();
        RealFieldElement[] ll = (RealFieldElement[])MathArrays.buildArray(field, 2);
        ll[0] = (RealFieldElement)MathUtils.normalizeAngle(state.getLv(), zero).subtract(Math.PI);
        ll[1] = (RealFieldElement)MathUtils.normalizeAngle(state.getLv(), zero).add(Math.PI);
        FieldVector3D<T> sunDir = this.sun.getPVCoordinates(state.getDate(), state.getFrame()).getPosition().normalize();
        Object alpha = sunDir.dotProduct(auxiliaryElements.getVectorF());
        Object beta = sunDir.dotProduct(auxiliaryElements.getVectorG());
        T gamma = sunDir.dotProduct(auxiliaryElements.getVectorW());
        if (FastMath.abs(((RealFieldElement)gamma.multiply(auxiliaryElements.getSma())).multiply(((RealFieldElement)auxiliaryElements.getEcc().negate()).add(one))).getReal() < this.ae) {
            RealFieldElement bet2 = (RealFieldElement)beta.multiply(beta);
            RealFieldElement h2 = (RealFieldElement)auxiliaryElements.getH().multiply(auxiliaryElements.getH());
            RealFieldElement k2 = (RealFieldElement)auxiliaryElements.getK().multiply(auxiliaryElements.getK());
            RealFieldElement m = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getSma().multiply(auxiliaryElements.getB())).divide(this.ae)).reciprocal();
            RealFieldElement m2 = m.multiply(m);
            RealFieldElement m4 = m2.multiply(m2);
            RealFieldElement bb = (RealFieldElement)((RealFieldElement)alpha.multiply(beta)).add(((RealFieldElement)m2.multiply(auxiliaryElements.getH())).multiply(auxiliaryElements.getK()));
            RealFieldElement b2 = bb.multiply(bb);
            RealFieldElement cc = ((RealFieldElement)alpha.multiply(alpha)).subtract(bet2).add(m2.multiply(k2.subtract(h2)));
            RealFieldElement dd = ((RealFieldElement)((RealFieldElement)bet2.add(m2.multiply(h2.add(1.0)))).negate()).add(one);
            RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(field, 5);
            a[0] = ((RealFieldElement)b2.multiply(4.0)).add(cc.multiply(cc));
            a[1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)bb.multiply(8.0)).multiply(m2).multiply(auxiliaryElements.getH())).add(((RealFieldElement)cc.multiply(4.0)).multiply(m2).multiply(auxiliaryElements.getK()));
            a[2] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)m4.multiply(h2).multiply(4.0)).subtract(cc.multiply(dd).multiply(2.0))).add(m4.multiply(k2).multiply(4.0))).subtract(b2.multiply(4.0));
            a[3] = (RealFieldElement)((RealFieldElement)((RealFieldElement)auxiliaryElements.getH().multiply((RealFieldElement)m2).multiply(bb).multiply(8.0)).add(auxiliaryElements.getK().multiply((RealFieldElement)m2).multiply(dd).multiply(4.0))).negate();
            a[4] = (RealFieldElement)dd.multiply(dd).subtract(m4.multiply(h2).multiply(4.0));
            RealFieldElement[] roots = (RealFieldElement[])MathArrays.buildArray(field, 4);
            int nbRoots = this.realQuarticRoots(a, roots, field);
            if (nbRoots > 0) {
                boolean entryFound = false;
                boolean exitFound = false;
                for (int i = 0; i < nbRoots; ++i) {
                    RealFieldElement cosL = roots[i];
                    RealFieldElement sL = FastMath.sqrt(((RealFieldElement)cosL.negate()).add(one).multiply(cosL.add(one)));
                    for (int j = -1; j <= 1; j += 2) {
                        RealFieldElement range;
                        RealFieldElement S;
                        RealFieldElement sinL = (RealFieldElement)sL.multiply(j);
                        RealFieldElement cPhi = (RealFieldElement)((RealFieldElement)cosL.multiply(alpha)).add(sinL.multiply(beta));
                        if (!(cPhi.getReal() < 0.0) || !(FastMath.abs(S = (RealFieldElement)((RealFieldElement)(range = ((RealFieldElement)((RealFieldElement)cosL.multiply(auxiliaryElements.getK())).add(sinL.multiply(auxiliaryElements.getH()))).add(one)).multiply(range).multiply(m2).add(cPhi.multiply(cPhi)).negate()).add(1.0)).getReal() < 1.0E-6)) continue;
                        RealFieldElement dSdL = m2.multiply(range).multiply(auxiliaryElements.getK().multiply((RealFieldElement)sinL).subtract(auxiliaryElements.getH().multiply((RealFieldElement)cosL))).add(cPhi.multiply(alpha.multiply((RealFieldElement)sinL).subtract(beta.multiply((RealFieldElement)cosL))));
                        if (dSdL.getReal() > 0.0) {
                            exitFound = true;
                            ll[0] = FastMath.atan2(sinL, cosL);
                            continue;
                        }
                        entryFound = true;
                        ll[1] = FastMath.atan2(sinL, cosL);
                    }
                }
                if (entryFound != exitFound) {
                    ll[0] = (RealFieldElement)zero.add(-Math.PI);
                    ll[1] = (RealFieldElement)zero.add(Math.PI);
                }
                if (ll[0].getReal() > ll[1].getReal()) {
                    if (ll[1].getReal() < 0.0) {
                        ll[1] = (RealFieldElement)ll[1].add(zero.add(Math.PI * 2));
                    } else {
                        ll[0] = (RealFieldElement)ll[0].subtract(zero.add(Math.PI * 2));
                    }
                }
            }
        }
        return ll;
    }

    public double getEquatorialRadius() {
        return this.ae;
    }

    private int realQuarticRoots(double[] a, double[] y) {
        if (Precision.equals(a[0], 0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, y);
        }
        double b = a[1] / a[0];
        double c = a[2] / a[0];
        double d = a[3] / a[0];
        double e = a[4] / a[0];
        double bh = b * 0.5;
        double[] z3 = new double[3];
        int i3 = this.realCubicRoots(new double[]{1.0, -c, b * d - 4.0 * e, e * (4.0 * c - b * b) - d * d}, z3);
        if (i3 == 0) {
            return 0;
        }
        double z = z3[0];
        double zh = z * 0.5;
        double p = FastMath.max(z + bh * bh - c, 0.0);
        double q = FastMath.max(zh * zh - e, 0.0);
        double r = bh * z - d;
        double pp = FastMath.sqrt(p);
        double qq = FastMath.copySign(FastMath.sqrt(q), r);
        double[] y1 = new double[2];
        int n1 = this.realQuadraticRoots(new double[]{1.0, bh - pp, zh - qq}, y1);
        double[] y2 = new double[2];
        int n2 = this.realQuadraticRoots(new double[]{1.0, bh + pp, zh + qq}, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private <T extends RealFieldElement<T>> int realQuarticRoots(T[] a, T[] y, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        if (Precision.equals(a[0].getReal(), 0.0)) {
            RealFieldElement[] aa = (RealFieldElement[])MathArrays.buildArray(field, a.length - 1);
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realCubicRoots(aa, (RealFieldElement[])y, field);
        }
        RealFieldElement b = (RealFieldElement)a[1].divide(a[0]);
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = (RealFieldElement)a[3].divide(a[0]);
        RealFieldElement e = (RealFieldElement)a[4].divide(a[0]);
        RealFieldElement bh = (RealFieldElement)b.multiply(0.5);
        RealFieldElement[] z3 = (RealFieldElement[])MathArrays.buildArray(field, 3);
        RealFieldElement[] i = (RealFieldElement[])MathArrays.buildArray(field, 4);
        i[0] = (RealFieldElement)zero.add(1.0);
        i[1] = (RealFieldElement)c.negate();
        i[2] = (RealFieldElement)b.multiply(d).subtract(e.multiply(4.0));
        i[3] = e.multiply(((RealFieldElement)c.multiply(4.0)).subtract(b.multiply(b))).subtract(d.multiply(d));
        int i3 = this.realCubicRoots(i, z3, field);
        if (i3 == 0) {
            return 0;
        }
        RealFieldElement z = z3[0];
        RealFieldElement zh = (RealFieldElement)z.multiply(0.5);
        RealFieldElement p = FastMath.max(z.add(bh.multiply(bh)).subtract(c), zero);
        RealFieldElement q = FastMath.max(zh.multiply(zh).subtract(e), zero);
        RealFieldElement r = bh.multiply(z).subtract(d);
        RealFieldElement pp = FastMath.sqrt(p);
        RealFieldElement qq = FastMath.copySign(FastMath.sqrt(q), r);
        RealFieldElement[] y1 = (RealFieldElement[])MathArrays.buildArray(field, 2);
        RealFieldElement[] n = (RealFieldElement[])MathArrays.buildArray(field, 3);
        n[0] = (RealFieldElement)zero.add(1.0);
        n[1] = bh.subtract(pp);
        n[2] = zh.subtract(qq);
        int n1 = this.realQuadraticRoots(n, y1);
        RealFieldElement[] y2 = (RealFieldElement[])MathArrays.buildArray(field, 2);
        RealFieldElement[] nn = (RealFieldElement[])MathArrays.buildArray(field, 3);
        nn[0] = (RealFieldElement)zero.add(1.0);
        nn[1] = bh.add(pp);
        nn[2] = zh.add(qq);
        int n2 = this.realQuadraticRoots(nn, y2);
        if (n1 == 2) {
            if (n2 == 2) {
                y[0] = y1[0];
                y[1] = y1[1];
                y[2] = y2[0];
                y[3] = y2[1];
                return 4;
            }
            y[0] = y1[0];
            y[1] = y1[1];
            return 2;
        }
        if (n2 == 2) {
            y[0] = y2[0];
            y[1] = y2[1];
            return 2;
        }
        return 0;
    }

    private int realCubicRoots(double[] a, double[] y) {
        if (Precision.equals(a[0], 0.0)) {
            double[] aa = new double[a.length - 1];
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, y);
        }
        double b = -a[1] / (3.0 * a[0]);
        double b2 = b * b;
        double c = a[2] / a[0];
        double p = b2 - c / 3.0;
        double d = a[3] / a[0];
        double q = b * (b2 - c * 0.5) - d * 0.5;
        double disc = p * p * p - q * q;
        if (disc < 0.0) {
            double alpha = q + FastMath.copySign(FastMath.sqrt(-disc), q);
            double cbrtAl = FastMath.cbrt(alpha);
            double cbrtBe = p / cbrtAl;
            y[0] = p < 0.0 ? b + 2.0 * q / (cbrtAl * cbrtAl + cbrtBe * cbrtBe - p) : (p > 0.0 ? b + cbrtAl + cbrtBe : b + cbrtAl);
            return 1;
        }
        if (disc > 0.0) {
            double phi = FastMath.atan2(FastMath.sqrt(disc), q) / 3.0;
            double sqP = 2.0 * FastMath.sqrt(p);
            y[0] = b + sqP * FastMath.cos(phi);
            y[1] = b - sqP * FastMath.cos(1.0471975511965976 + phi);
            y[2] = b - sqP * FastMath.cos(1.0471975511965976 - phi);
            return 3;
        }
        double cbrtQ = FastMath.cbrt(q);
        double root1 = b + 2.0 * cbrtQ;
        double root2 = b - cbrtQ;
        if (q < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private <T extends RealFieldElement<T>> int realCubicRoots(T[] a, T[] y, Field<T> field) {
        if (Precision.equals(a[0].getReal(), 0.0)) {
            RealFieldElement[] aa = (RealFieldElement[])MathArrays.buildArray(field, a.length - 1);
            System.arraycopy(a, 1, aa, 0, aa.length);
            return this.realQuadraticRoots(aa, (RealFieldElement[])y);
        }
        RealFieldElement b = (RealFieldElement)((RealFieldElement)a[1].divide(a[0].multiply(3.0))).negate();
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = (RealFieldElement)a[3].divide(a[0]);
        RealFieldElement b2 = b.multiply(b);
        RealFieldElement p = (RealFieldElement)b2.subtract(c.divide(3.0));
        RealFieldElement q = (RealFieldElement)((RealFieldElement)b.multiply(b2.subtract(c.multiply(0.5)))).subtract(d.multiply(0.5));
        RealFieldElement disc = p.multiply(p).multiply(p).subtract(q.multiply(q));
        if (disc.getReal() < 0.0) {
            RealFieldElement alpha = FastMath.copySign(FastMath.sqrt((RealFieldElement)disc.negate()), q).add(q);
            RealFieldElement cbrtAl = FastMath.cbrt(alpha);
            RealFieldElement cbrtBe = p.divide(cbrtAl);
            y[0] = p.getReal() < 0.0 ? ((RealFieldElement)q.divide(cbrtAl.multiply(cbrtAl).add(cbrtBe.multiply(cbrtBe)).subtract(p)).multiply(2.0)).add(b) : (p.getReal() > 0.0 ? b.add(cbrtAl).add(cbrtBe) : b.add(cbrtAl));
            return 1;
        }
        if (disc.getReal() > 0.0) {
            RealFieldElement phi = (RealFieldElement)FastMath.atan2(FastMath.sqrt(disc), q).divide(3.0);
            RealFieldElement sqP = (RealFieldElement)FastMath.sqrt(p).multiply(2.0);
            y[0] = b.add(sqP.multiply(FastMath.cos(phi)));
            y[1] = b.subtract(sqP.multiply(FastMath.cos((RealFieldElement)phi.add(1.0471975511965976))));
            y[2] = b.subtract(sqP.multiply(FastMath.cos((RealFieldElement)((RealFieldElement)phi.negate()).add(1.0471975511965976))));
            return 3;
        }
        RealFieldElement cbrtQ = FastMath.cbrt(q);
        RealFieldElement root1 = (RealFieldElement)b.add(cbrtQ.multiply(2.0));
        RealFieldElement root2 = b.subtract(cbrtQ);
        if (q.getReal() < 0.0) {
            y[0] = root2;
            y[1] = root2;
            y[2] = root1;
        } else {
            y[0] = root1;
            y[1] = root2;
            y[2] = root2;
        }
        return 3;
    }

    private int realQuadraticRoots(double[] a, double[] y) {
        if (Precision.equals(a[0], 0.0)) {
            if (Precision.equals(a[1], 0.0)) {
                return 0;
            }
            y[0] = -a[2] / a[1];
            return 1;
        }
        double b = -0.5 * a[1] / a[0];
        double c = a[2] / a[0];
        double d = b * b - c;
        if (d < 0.0) {
            return 0;
        }
        if (d > 0.0) {
            double y0 = b + FastMath.copySign(FastMath.sqrt(d), b);
            double y1 = c / y0;
            y[0] = FastMath.max(y0, y1);
            y[1] = FastMath.min(y0, y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }

    private <T extends RealFieldElement<T>> int realQuadraticRoots(T[] a, T[] y) {
        if (Precision.equals(a[0].getReal(), 0.0)) {
            if (Precision.equals(a[1].getReal(), 0.0)) {
                return 0;
            }
            y[0] = (RealFieldElement)((RealFieldElement)a[2].divide(a[1])).negate();
            return 1;
        }
        RealFieldElement b = (RealFieldElement)((RealFieldElement)((RealFieldElement)a[1].divide(a[0])).multiply(0.5)).negate();
        RealFieldElement c = (RealFieldElement)a[2].divide(a[0]);
        RealFieldElement d = b.multiply(b).subtract(c);
        if (d.getReal() < 0.0) {
            return 0;
        }
        if (d.getReal() > 0.0) {
            RealFieldElement y0 = b.add(FastMath.copySign(FastMath.sqrt(d), b));
            RealFieldElement y1 = c.divide(y0);
            y[0] = FastMath.max(y0, y1);
            y[1] = FastMath.min(y0, y1);
            return 2;
        }
        y[0] = b;
        y[1] = b;
        return 2;
    }
}

