/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.forces;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.forces.gravity.potential.UnnormalizedSphericalHarmonicsProvider;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.orbits.FieldOrbit;
import org.orekit.orbits.Orbit;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.PropagationType;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.FieldEventDetector;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTForceModel;
import org.orekit.propagation.semianalytical.dsst.forces.DSSTTesseralContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldDSSTTesseralContext;
import org.orekit.propagation.semianalytical.dsst.forces.FieldShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.forces.ShortPeriodTerms;
import org.orekit.propagation.semianalytical.dsst.utilities.AuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldAuxiliaryElements;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldGHmsjPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldGammaMnsFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.FieldShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.GHmsjPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.GammaMnsFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.JacobiPolynomials;
import org.orekit.propagation.semianalytical.dsst.utilities.ShortPeriodicsInterpolatedCoefficient;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.FieldHansenTesseralLinear;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenTesseralLinear;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.FieldTimeSpanMap;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class DSSTTesseral
implements DSSTForceModel {
    public static final String SHORT_PERIOD_PREFIX = "DSST-central-body-tesseral-";
    public static final String CM_COEFFICIENTS = "cM";
    public static final String SM_COEFFICIENTS = "sM";
    private static final int I = 1;
    private static final double MU_SCALE = FastMath.scalb(1.0, 32);
    private static final double MIN_PERIOD_IN_SECONDS = 864000.0;
    private static final double MIN_PERIOD_IN_SAT_REV = 10.0;
    private static final int INTERPOLATION_POINTS = 3;
    private final UnnormalizedSphericalHarmonicsProvider provider;
    private final Frame bodyFrame;
    private final double centralBodyRotationRate;
    private final double bodyPeriod;
    private final int maxDegree;
    private final int maxDegreeTesseralSP;
    private final int maxDegreeMdailyTesseralSP;
    private final int maxOrder;
    private final int maxOrderTesseralSP;
    private final int maxOrderMdailyTesseralSP;
    private final int maxEccPowTesseralSP;
    private final int maxEccPowMdailyTesseralSP;
    private final int maxFrequencyShortPeriodics;
    private int mMax;
    private final SortedMap<Integer, List<Integer>> nonResOrders;
    private TesseralShortPeriodicCoefficients shortPeriodTerms;
    private Map<Field<?>, FieldTesseralShortPeriodicCoefficients<?>> fieldShortPeriodTerms;
    private final ParameterDriver gmParameterDriver;
    private HansenObjects hansen;
    private Map<Field<?>, FieldHansenObjects<?>> fieldHansen;
    private DSFactory factory;
    private Map<Field<?>, FDSFactory<?>> fieldFactory;
    private boolean pendingInitialization;

    public DSSTTesseral(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider) {
        this(centralBodyFrame, centralBodyRotationRate, provider, provider.getMaxDegree(), provider.getMaxOrder(), 4, FastMath.min(12, provider.getMaxDegree() + 4), provider.getMaxDegree(), provider.getMaxOrder(), FastMath.min(4, provider.getMaxDegree() - 2));
    }

    public DSSTTesseral(Frame centralBodyFrame, double centralBodyRotationRate, UnnormalizedSphericalHarmonicsProvider provider, int maxDegreeTesseralSP, int maxOrderTesseralSP, int maxEccPowTesseralSP, int maxFrequencyShortPeriodics, int maxDegreeMdailyTesseralSP, int maxOrderMdailyTesseralSP, int maxEccPowMdailyTesseralSP) {
        this.gmParameterDriver = new ParameterDriver("central attraction coefficient", provider.getMu(), MU_SCALE, 0.0, Double.POSITIVE_INFINITY);
        this.bodyFrame = centralBodyFrame;
        this.centralBodyRotationRate = centralBodyRotationRate;
        this.bodyPeriod = Math.PI * 2 / centralBodyRotationRate;
        this.provider = provider;
        this.maxDegree = provider.getMaxDegree();
        this.maxOrder = provider.getMaxOrder();
        this.checkIndexRange(maxDegreeTesseralSP, 2, this.maxDegree);
        this.maxDegreeTesseralSP = maxDegreeTesseralSP;
        this.checkIndexRange(maxDegreeMdailyTesseralSP, 2, this.maxDegree);
        this.maxDegreeMdailyTesseralSP = maxDegreeMdailyTesseralSP;
        this.checkIndexRange(maxOrderTesseralSP, 0, this.maxOrder);
        this.maxOrderTesseralSP = maxOrderTesseralSP;
        this.checkIndexRange(maxOrderMdailyTesseralSP, 0, this.maxOrder);
        this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
        this.maxEccPowTesseralSP = maxEccPowTesseralSP;
        this.checkIndexRange(maxEccPowMdailyTesseralSP, 0, maxDegreeMdailyTesseralSP - 2);
        this.maxEccPowMdailyTesseralSP = maxEccPowMdailyTesseralSP;
        this.maxFrequencyShortPeriodics = maxFrequencyShortPeriodics;
        this.nonResOrders = new TreeMap<Integer, List<Integer>>();
        this.pendingInitialization = true;
        this.fieldShortPeriodTerms = new HashMap();
        this.fieldHansen = new HashMap();
        this.fieldFactory = new HashMap();
    }

    private void checkIndexRange(int index, int min, int max) {
        if (index < min || index > max) {
            throw new OrekitException((Localizable)LocalizedCoreFormats.OUT_OF_RANGE_SIMPLE, index, min, max);
        }
    }

    @Override
    public List<ShortPeriodTerms> initialize(AuxiliaryElements auxiliaryElements, PropagationType type, double[] parameters) {
        DSSTTesseralContext context = this.initializeStep(auxiliaryElements, parameters);
        double ratio = context.getRatio();
        int maxEccPow = context.getMaxEccPow();
        List<Integer> resOrders = context.getResOrders();
        this.getNonResonantTerms(type, context);
        this.hansen = new HansenObjects(ratio, maxEccPow, resOrders, type);
        this.factory = new DSFactory(1, 1);
        this.mMax = FastMath.max(this.maxOrderTesseralSP, this.maxOrderMdailyTesseralSP);
        this.shortPeriodTerms = new TesseralShortPeriodicCoefficients(this.bodyFrame, this.maxOrderMdailyTesseralSP, this.maxDegreeTesseralSP < 0, this.nonResOrders, this.mMax, this.maxFrequencyShortPeriodics, 3, new TimeSpanMap<Slot>(new Slot(this.mMax, this.maxFrequencyShortPeriodics, 3)));
        ArrayList<ShortPeriodTerms> list = new ArrayList<ShortPeriodTerms>();
        list.add(this.shortPeriodTerms);
        return list;
    }

    @Override
    public <T extends RealFieldElement<T>> List<FieldShortPeriodTerms<T>> initialize(FieldAuxiliaryElements<T> auxiliaryElements, PropagationType type, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        if (this.pendingInitialization) {
            FieldDSSTTesseralContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
            this.getNonResonantTerms(type, context, field);
            Object ratio = context.getRatio();
            int maxEccPow = context.getMaxEccPow();
            List<Integer> resOrders = context.getResOrders();
            this.mMax = FastMath.max(this.maxOrderTesseralSP, this.maxOrderMdailyTesseralSP);
            this.fieldFactory.put(field, new FDSFactory<T>(field, 1, 1));
            this.fieldHansen.put(field, new FieldHansenObjects(this, ratio, maxEccPow, resOrders, type, field));
            this.pendingInitialization = false;
        }
        FieldTesseralShortPeriodicCoefficients ftspc = new FieldTesseralShortPeriodicCoefficients(this.bodyFrame, this.maxOrderMdailyTesseralSP, this.maxDegreeTesseralSP < 0, this.nonResOrders, this.mMax, this.maxFrequencyShortPeriodics, 3, new FieldTimeSpanMap(new FieldSlot(this.mMax, this.maxFrequencyShortPeriodics, 3), field));
        this.fieldShortPeriodTerms.put(field, ftspc);
        return Collections.singletonList(ftspc);
    }

    private DSSTTesseralContext initializeStep(AuxiliaryElements auxiliaryElements, double[] parameters) {
        return new DSSTTesseralContext(auxiliaryElements, this.bodyFrame, this.provider, this.maxFrequencyShortPeriodics, this.bodyPeriod, parameters);
    }

    private <T extends RealFieldElement<T>> FieldDSSTTesseralContext<T> initializeStep(FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        return new FieldDSSTTesseralContext(auxiliaryElements, this.bodyFrame, this.provider, this.maxFrequencyShortPeriodics, this.bodyPeriod, parameters);
    }

    @Override
    public double[] getMeanElementRate(SpacecraftState spacecraftState, AuxiliaryElements auxiliaryElements, double[] parameters) {
        DSSTTesseralContext context = this.initializeStep(auxiliaryElements, parameters);
        UAnddU udu = new UAnddU(spacecraftState.getDate(), context, this.hansen);
        double UAlphaGamma = auxiliaryElements.getAlpha() * udu.getdUdGa() - auxiliaryElements.getGamma() * udu.getdUdAl();
        double UAlphaBeta = auxiliaryElements.getAlpha() * udu.getdUdBe() - auxiliaryElements.getBeta() * udu.getdUdAl();
        double UBetaGamma = auxiliaryElements.getBeta() * udu.getdUdGa() - auxiliaryElements.getGamma() * udu.getdUdBe();
        double Uhk = auxiliaryElements.getH() * udu.getdUdk() - auxiliaryElements.getK() * udu.getdUdh();
        double pUagmIqUbgoAB = (auxiliaryElements.getP() * UAlphaGamma - 1.0 * auxiliaryElements.getQ() * UBetaGamma) * context.getOoAB();
        double UhkmUabmdUdl = Uhk - UAlphaBeta - udu.getdUdl();
        double da = context.getAx2oA() * udu.getdUdl();
        double dh = context.getBoA() * udu.getdUdk() + auxiliaryElements.getK() * pUagmIqUbgoAB - auxiliaryElements.getH() * context.getBoABpo() * udu.getdUdl();
        double dk = -(context.getBoA() * udu.getdUdh() + auxiliaryElements.getH() * pUagmIqUbgoAB + auxiliaryElements.getK() * context.getBoABpo() * udu.getdUdl());
        double dp = context.getCo2AB() * (auxiliaryElements.getP() * UhkmUabmdUdl - UBetaGamma);
        double dq = context.getCo2AB() * (auxiliaryElements.getQ() * UhkmUabmdUdl - 1.0 * UAlphaGamma);
        double dM = -context.getAx2oA() * udu.getdUda() + context.getBoABpo() * (auxiliaryElements.getH() * udu.getdUdh() + auxiliaryElements.getK() * udu.getdUdk()) + pUagmIqUbgoAB;
        return new double[]{da, dk, dh, dq, dp, dM};
    }

    @Override
    public <T extends RealFieldElement<T>> T[] getMeanElementRate(FieldSpacecraftState<T> spacecraftState, FieldAuxiliaryElements<T> auxiliaryElements, T[] parameters) {
        Field<T> field = auxiliaryElements.getDate().getField();
        FieldDSSTTesseralContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
        FieldHansenObjects<?> fho = this.fieldHansen.get(field);
        FieldUAnddU<T> udu = new FieldUAnddU<T>(spacecraftState.getDate(), context, fho);
        RealFieldElement UAlphaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(auxiliaryElements.getAlpha())).subtract(udu.getdUdAl().multiply(auxiliaryElements.getGamma()));
        RealFieldElement UAlphaBeta = (RealFieldElement)((RealFieldElement)udu.getdUdBe().multiply(auxiliaryElements.getAlpha())).subtract(udu.getdUdAl().multiply(auxiliaryElements.getBeta()));
        RealFieldElement UBetaGamma = (RealFieldElement)((RealFieldElement)udu.getdUdGa().multiply(auxiliaryElements.getBeta())).subtract(udu.getdUdBe().multiply(auxiliaryElements.getGamma()));
        RealFieldElement Uhk = (RealFieldElement)((RealFieldElement)udu.getdUdk().multiply(auxiliaryElements.getH())).subtract(udu.getdUdh().multiply(auxiliaryElements.getK()));
        RealFieldElement pUagmIqUbgoAB = (RealFieldElement)((RealFieldElement)((RealFieldElement)UAlphaGamma.multiply(auxiliaryElements.getP())).subtract(((RealFieldElement)UBetaGamma.multiply(auxiliaryElements.getQ())).multiply(true))).multiply(context.getOoAB());
        RealFieldElement UhkmUabmdUdl = (RealFieldElement)Uhk.subtract(UAlphaBeta).subtract(udu.getdUdl());
        RealFieldElement da = (RealFieldElement)udu.getdUdl().multiply(context.getAx2oA());
        RealFieldElement dh = (RealFieldElement)((RealFieldElement)((RealFieldElement)udu.getdUdk().multiply(context.getBoA())).add(pUagmIqUbgoAB.multiply(auxiliaryElements.getK()))).subtract(((RealFieldElement)udu.getdUdl().multiply(auxiliaryElements.getH())).multiply(context.getBoABpo()));
        RealFieldElement dk = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(context.getBoA())).add(pUagmIqUbgoAB.multiply(auxiliaryElements.getH()))).add(((RealFieldElement)udu.getdUdl().multiply(context.getBoABpo())).multiply(auxiliaryElements.getK()))).negate();
        RealFieldElement dp = context.getCo2AB().multiply((RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)UhkmUabmdUdl).subtract(UBetaGamma));
        RealFieldElement dq = (RealFieldElement)context.getCo2AB().multiply(auxiliaryElements.getQ().multiply((RealFieldElement)UhkmUabmdUdl).subtract(UAlphaGamma.multiply(true)));
        RealFieldElement dM = (RealFieldElement)((RealFieldElement)pUagmIqUbgoAB.add(((RealFieldElement)udu.getdUda().multiply(context.getAx2oA())).negate())).add(((RealFieldElement)((RealFieldElement)udu.getdUdh().multiply(auxiliaryElements.getH())).add(udu.getdUdk().multiply(auxiliaryElements.getK()))).multiply(context.getBoABpo()));
        RealFieldElement[] elements = (RealFieldElement[])MathArrays.buildArray(field, 6);
        elements[0] = da;
        elements[1] = dk;
        elements[2] = dh;
        elements[3] = dq;
        elements[4] = dp;
        elements[5] = dM;
        return elements;
    }

    @Override
    public void updateShortPeriodTerms(double[] parameters, SpacecraftState ... meanStates) {
        Slot slot = this.shortPeriodTerms.createSlot(meanStates);
        for (SpacecraftState meanState : meanStates) {
            AuxiliaryElements auxiliaryElements = new AuxiliaryElements(meanState.getOrbit(), 1);
            DSSTTesseralContext context = this.initializeStep(auxiliaryElements, parameters);
            for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
                this.hansen.computeHansenObjectsInitValues(context, s + this.maxDegree, 0);
                if (this.maxDegreeTesseralSP < 0) continue;
                for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                    this.hansen.computeHansenObjectsInitValues(context, s + this.maxDegree, j);
                }
            }
            FourierCjSjCoefficients cjsjFourier = new FourierCjSjCoefficients(this.maxFrequencyShortPeriodics, this.mMax);
            if (this.nonResOrders.isEmpty() && this.maxDegreeTesseralSP >= 0) continue;
            cjsjFourier.generateCoefficients(meanState.getDate(), context, this.hansen);
            double tnota = 1.5 * context.getMeanMotion() / auxiliaryElements.getSma();
            for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                this.buildCoefficients(cjsjFourier, meanState.getDate(), slot, m, 0, tnota, context);
            }
            if (this.maxDegreeTesseralSP < 0) continue;
            for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                for (int j : entry.getValue()) {
                    this.buildCoefficients(cjsjFourier, meanState.getDate(), slot, entry.getKey(), j, tnota, context);
                }
            }
        }
    }

    @Override
    public <T extends RealFieldElement<T>> void updateShortPeriodTerms(T[] parameters, FieldSpacecraftState<T> ... meanStates) {
        Field<T> field = meanStates[0].getDate().getField();
        FieldTesseralShortPeriodicCoefficients<?> ftspc = this.fieldShortPeriodTerms.get(field);
        FieldSlot<?> slot = ftspc.createSlot(meanStates);
        for (FieldSpacecraftState<T> meanState : meanStates) {
            FieldAuxiliaryElements<T> auxiliaryElements = new FieldAuxiliaryElements<T>(meanState.getOrbit(), 1);
            FieldDSSTTesseralContext context = this.initializeStep(auxiliaryElements, (RealFieldElement[])parameters);
            FieldHansenObjects<?> fho = this.fieldHansen.get(field);
            for (int s = -this.maxDegree; s <= this.maxDegree; ++s) {
                fho.computeHansenObjectsInitValues(context, s + this.maxDegree, 0);
                if (this.maxDegreeTesseralSP < 0) continue;
                for (int j = 1; j <= this.maxFrequencyShortPeriodics; ++j) {
                    fho.computeHansenObjectsInitValues(context, s + this.maxDegree, j);
                }
            }
            FieldFourierCjSjCoefficients<T> cjsjFourier = new FieldFourierCjSjCoefficients<T>(this.maxFrequencyShortPeriodics, this.mMax, field);
            if (this.nonResOrders.isEmpty() && this.maxDegreeTesseralSP >= 0) continue;
            cjsjFourier.generateCoefficients(meanState.getDate(), context, fho, field);
            RealFieldElement tnota = (RealFieldElement)((RealFieldElement)context.getMeanMotion().multiply(1.5)).divide(auxiliaryElements.getSma());
            for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                this.buildCoefficients(cjsjFourier, meanState.getDate(), slot, m, 0, tnota, context, field);
            }
            if (this.maxDegreeTesseralSP < 0) continue;
            for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                for (int j : entry.getValue()) {
                    this.buildCoefficients(cjsjFourier, meanState.getDate(), slot, entry.getKey(), j, tnota, context, field);
                }
            }
        }
    }

    @Override
    public ParameterDriver[] getParametersDrivers() {
        return new ParameterDriver[]{this.gmParameterDriver};
    }

    private void buildCoefficients(FourierCjSjCoefficients cjsjFourier, AbsoluteDate date, Slot slot, int m, int j, double tnota, DSSTTesseralContext context) {
        int i;
        double[] currentCijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] currentSijm = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double oojnmt = 1.0 / ((double)j * context.getMeanMotion() - (double)m * this.centralBodyRotationRate);
        for (i = 0; i < 6; ++i) {
            currentCijm[i] = -cjsjFourier.getSijm(i, j, m);
            currentSijm[i] = cjsjFourier.getCijm(i, j, m);
        }
        currentCijm[5] = currentCijm[5] + tnota * oojnmt * cjsjFourier.getCijm(0, j, m);
        currentSijm[5] = currentSijm[5] + tnota * oojnmt * cjsjFourier.getSijm(0, j, m);
        i = 0;
        while (i < 6) {
            int n = i;
            currentCijm[n] = currentCijm[n] * oojnmt;
            int n2 = i++;
            currentSijm[n2] = currentSijm[n2] * oojnmt;
        }
        slot.cijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, currentCijm);
        slot.sijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, currentSijm);
    }

    private <T extends RealFieldElement<T>> void buildCoefficients(FieldFourierCjSjCoefficients<T> cjsjFourier, FieldAbsoluteDate<T> date, FieldSlot<T> slot, int m, int j, T tnota, FieldDSSTTesseralContext<T> context, Field<T> field) {
        int i;
        RealFieldElement zero = (RealFieldElement)field.getZero();
        Object[] currentCijm = (RealFieldElement[])MathArrays.buildArray(field, 6);
        Object[] currentSijm = (RealFieldElement[])MathArrays.buildArray(field, 6);
        Arrays.fill(currentCijm, zero);
        Arrays.fill(currentSijm, zero);
        RealFieldElement oojnmt = (RealFieldElement)((RealFieldElement)((RealFieldElement)context.getMeanMotion().multiply((int)j)).subtract((double)m * this.centralBodyRotationRate)).reciprocal();
        for (i = 0; i < 6; ++i) {
            currentCijm[i] = (RealFieldElement)cjsjFourier.getSijm(i, j, m).negate();
            currentSijm[i] = cjsjFourier.getCijm(i, j, m);
        }
        currentCijm[5] = (RealFieldElement)currentCijm[5].add(tnota.multiply((RealFieldElement)oojnmt).multiply(cjsjFourier.getCijm(0, j, m)));
        currentSijm[5] = (RealFieldElement)currentSijm[5].add(tnota.multiply((RealFieldElement)oojnmt).multiply(cjsjFourier.getSijm(0, j, m)));
        for (i = 0; i < 6; ++i) {
            currentCijm[i] = currentCijm[i].multiply(oojnmt);
            currentSijm[i] = currentSijm[i].multiply(oojnmt);
        }
        ((FieldSlot)slot).cijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, (RealFieldElement[])currentCijm);
        ((FieldSlot)slot).sijm[m][j + this.maxFrequencyShortPeriodics].addGridPoint(date, (RealFieldElement[])currentSijm);
    }

    @Override
    public EventDetector[] getEventsDetectors() {
        return null;
    }

    @Override
    public <T extends RealFieldElement<T>> FieldEventDetector<T>[] getFieldEventsDetectors(Field<T> field) {
        return null;
    }

    private void getNonResonantTerms(PropagationType type, DSSTTesseralContext context) {
        double tolerance = 1.0 / FastMath.max(10.0, 864000.0 / context.getOrbitPeriod());
        this.nonResOrders.clear();
        for (int m = 1; m <= this.maxOrder; ++m) {
            double resonance = context.getRatio() * (double)m;
            int jRes = 0;
            int jComputedRes = (int)FastMath.round(resonance);
            if (jComputedRes > 0 && jComputedRes <= this.maxFrequencyShortPeriodics && FastMath.abs(resonance - (double)jComputedRes) <= tolerance) {
                jRes = jComputedRes;
            }
            if (type != PropagationType.OSCULATING || this.maxDegreeTesseralSP < 0 || m > this.maxOrderTesseralSP) continue;
            ArrayList<Integer> listJofM = new ArrayList<Integer>();
            for (int j = -this.maxFrequencyShortPeriodics; j <= this.maxFrequencyShortPeriodics; ++j) {
                if (j == 0 || j == jRes) continue;
                listJofM.add(j);
            }
            this.nonResOrders.put(m, listJofM);
        }
    }

    private <T extends RealFieldElement<T>> void getNonResonantTerms(PropagationType type, FieldDSSTTesseralContext<T> context, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        RealFieldElement tolerance = (RealFieldElement)FastMath.max((RealFieldElement)zero.add(10.0), (RealFieldElement)((RealFieldElement)context.getOrbitPeriod().divide(864000.0)).reciprocal()).reciprocal();
        this.nonResOrders.clear();
        for (int m = 1; m <= this.maxOrder; ++m) {
            RealFieldElement resonance = (RealFieldElement)context.getRatio().multiply((int)m);
            int jRes = 0;
            int jComputedRes = (int)FastMath.round(resonance);
            if (jComputedRes > 0 && jComputedRes <= this.maxFrequencyShortPeriodics && FastMath.abs((RealFieldElement)resonance.subtract(jComputedRes)).getReal() <= tolerance.getReal()) {
                jRes = jComputedRes;
            }
            if (type != PropagationType.OSCULATING || this.maxDegreeTesseralSP < 0 || m > this.maxOrderTesseralSP) continue;
            ArrayList<Integer> listJofM = new ArrayList<Integer>();
            for (int j = -this.maxFrequencyShortPeriodics; j <= this.maxFrequencyShortPeriodics; ++j) {
                if (j == 0 || j == jRes) continue;
                listJofM.add(j);
            }
            this.nonResOrders.put(m, listJofM);
        }
    }

    private double[][] computeNSum(AbsoluteDate date, int j, int m, int s, int maxN, double[] roaPow, GHmsjPolynomials ghMSJ, GammaMnsFunction gammaMNS, DSSTTesseralContext context, HansenObjects hansenObjects) {
        AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date);
        double dUdaCos = 0.0;
        double dUdaSin = 0.0;
        double dUdhCos = 0.0;
        double dUdhSin = 0.0;
        double dUdkCos = 0.0;
        double dUdkSin = 0.0;
        double dUdlCos = 0.0;
        double dUdlSin = 0.0;
        double dUdAlCos = 0.0;
        double dUdAlSin = 0.0;
        double dUdBeCos = 0.0;
        double dUdBeSin = 0.0;
        double dUdGaCos = 0.0;
        double dUdGaSin = 0.0;
        boolean Im = true;
        int v = FastMath.abs(m - s);
        int w = FastMath.abs(m + s);
        int nmin = FastMath.max(FastMath.max(2, m), FastMath.abs(s));
        int sIndex = this.maxDegree + (j < 0 ? -s : s);
        int jIndex = FastMath.abs(j);
        HansenTesseralLinear hans = hansenObjects.getHansenObjects()[sIndex][jIndex];
        for (int n = nmin; n <= maxN; ++n) {
            if ((n - s) % 2 != 0) continue;
            double vMNS = CoefficientsFactory.getVmns(m, n, s);
            double gaMNS = gammaMNS.getValue(m, n, s);
            double dGaMNS = gammaMNS.getDerivative(m, n, s);
            double kJNS = hans.getValue(-n - 1, context.getChi());
            double dkJNS = hans.getDerivative(-n - 1, context.getChi());
            double gMSJ = ghMSJ.getGmsj(m, s, j);
            double hMSJ = ghMSJ.getHmsj(m, s, j);
            double dGdh = ghMSJ.getdGmsdh(m, s, j);
            double dGdk = ghMSJ.getdGmsdk(m, s, j);
            double dGdA = ghMSJ.getdGmsdAlpha(m, s, j);
            double dGdB = ghMSJ.getdGmsdBeta(m, s, j);
            double dHdh = ghMSJ.getdHmsdh(m, s, j);
            double dHdk = ghMSJ.getdHmsdk(m, s, j);
            double dHdA = ghMSJ.getdHmsdAlpha(m, s, j);
            double dHdB = ghMSJ.getdHmsdBeta(m, s, j);
            int l = FastMath.min(n - m, n - FastMath.abs(s));
            DerivativeStructure jacobi = JacobiPolynomials.getValue(l, v, w, this.factory.variable(0, auxiliaryElements.getGamma()));
            double cnm = harmonics.getUnnormalizedCnm(n, m);
            double snm = harmonics.getUnnormalizedSnm(n, m);
            double cf_0 = roaPow[n] * (double)Im * vMNS;
            double cf_1 = cf_0 * gaMNS * jacobi.getValue();
            double cf_2 = cf_1 * kJNS;
            double gcPhs = gMSJ * cnm + hMSJ * snm;
            double gsMhc = gMSJ * snm - hMSJ * cnm;
            double dKgcPhsx2 = 2.0 * dkJNS * gcPhs;
            double dKgsMhcx2 = 2.0 * dkJNS * gsMhc;
            double dUdaCoef = (double)(n + 1) * cf_2;
            double dUdlCoef = (double)j * cf_2;
            double dUdGaCoef = cf_0 * kJNS * (jacobi.getValue() * dGaMNS + gaMNS * jacobi.getPartialDerivative(1));
            dUdaCos += dUdaCoef * gcPhs;
            dUdaSin += dUdaCoef * gsMhc;
            dUdhCos += cf_1 * (kJNS * (cnm * dGdh + snm * dHdh) + auxiliaryElements.getH() * dKgcPhsx2);
            dUdhSin += cf_1 * (kJNS * (snm * dGdh - cnm * dHdh) + auxiliaryElements.getH() * dKgsMhcx2);
            dUdkCos += cf_1 * (kJNS * (cnm * dGdk + snm * dHdk) + auxiliaryElements.getK() * dKgcPhsx2);
            dUdkSin += cf_1 * (kJNS * (snm * dGdk - cnm * dHdk) + auxiliaryElements.getK() * dKgsMhcx2);
            dUdlCos += dUdlCoef * gsMhc;
            dUdlSin += -dUdlCoef * gcPhs;
            dUdAlCos += cf_2 * (dGdA * cnm + dHdA * snm);
            dUdAlSin += cf_2 * (dGdA * snm - dHdA * cnm);
            dUdBeCos += cf_2 * (dGdB * cnm + dHdB * snm);
            dUdBeSin += cf_2 * (dGdB * snm - dHdB * cnm);
            dUdGaCos += dUdGaCoef * gcPhs;
            dUdGaSin += dUdGaCoef * gsMhc;
        }
        return new double[][]{{dUdaCos, dUdaSin}, {dUdhCos, dUdhSin}, {dUdkCos, dUdkSin}, {dUdlCos, dUdlSin}, {dUdAlCos, dUdAlSin}, {dUdBeCos, dUdBeSin}, {dUdGaCos, dUdGaSin}};
    }

    private <T extends RealFieldElement<T>> T[][] computeNSum(FieldAbsoluteDate<T> date, int j, int m, int s, int maxN, T[] roaPow, FieldGHmsjPolynomials<T> ghMSJ, FieldGammaMnsFunction<T> gammaMNS, FieldDSSTTesseralContext<T> context, FieldHansenObjects<T> hansenObjects) {
        FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
        Field<T> field = date.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        UnnormalizedSphericalHarmonicsProvider.UnnormalizedSphericalHarmonics harmonics = this.provider.onDate(date.toAbsoluteDate());
        RealFieldElement dUdaCos = zero;
        RealFieldElement dUdaSin = zero;
        RealFieldElement dUdhCos = zero;
        RealFieldElement dUdhSin = zero;
        RealFieldElement dUdkCos = zero;
        RealFieldElement dUdkSin = zero;
        RealFieldElement dUdlCos = zero;
        RealFieldElement dUdlSin = zero;
        RealFieldElement dUdAlCos = zero;
        RealFieldElement dUdAlSin = zero;
        RealFieldElement dUdBeCos = zero;
        RealFieldElement dUdBeSin = zero;
        RealFieldElement dUdGaCos = zero;
        RealFieldElement dUdGaSin = zero;
        boolean Im = true;
        int v = FastMath.abs(m - s);
        int w = FastMath.abs(m + s);
        int nmin = FastMath.max(FastMath.max(2, m), FastMath.abs(s));
        int sIndex = this.maxDegree + (j < 0 ? -s : s);
        int jIndex = FastMath.abs(j);
        FieldHansenTesseralLinear<T> hans = hansenObjects.getHansenObjects()[sIndex][jIndex];
        for (int n = nmin; n <= maxN; ++n) {
            if ((n - s) % 2 != 0) continue;
            RealFieldElement vMNS = (RealFieldElement)zero.add(CoefficientsFactory.getVmns(m, n, s));
            Object gaMNS = gammaMNS.getValue(m, n, s);
            Object dGaMNS = gammaMNS.getDerivative(m, n, s);
            T kJNS = hans.getValue(-n - 1, context.getChi());
            RealFieldElement dkJNS = hans.getDerivative(-n - 1, context.getChi());
            RealFieldElement gMSJ = ghMSJ.getGmsj(m, s, j);
            RealFieldElement hMSJ = ghMSJ.getHmsj(m, s, j);
            T dGdh = ghMSJ.getdGmsdh(m, s, j);
            T dGdk = ghMSJ.getdGmsdk(m, s, j);
            RealFieldElement dGdA = ghMSJ.getdGmsdAlpha(m, s, j);
            RealFieldElement dGdB = ghMSJ.getdGmsdBeta(m, s, j);
            T dHdh = ghMSJ.getdHmsdh(m, s, j);
            T dHdk = ghMSJ.getdHmsdk(m, s, j);
            RealFieldElement dHdA = ghMSJ.getdHmsdAlpha(m, s, j);
            RealFieldElement dHdB = ghMSJ.getdHmsdBeta(m, s, j);
            int l = FastMath.min(n - m, n - FastMath.abs(s));
            FDSFactory<?> fdsf = this.fieldFactory.get(field);
            FieldDerivativeStructure<?> jacobi = JacobiPolynomials.getValue(l, v, w, fdsf.variable(0, auxiliaryElements.getGamma()));
            RealFieldElement cnm = (RealFieldElement)zero.add(harmonics.getUnnormalizedCnm(n, m));
            RealFieldElement snm = (RealFieldElement)zero.add(harmonics.getUnnormalizedSnm(n, m));
            RealFieldElement cf_0 = ((RealFieldElement)roaPow[n].multiply(Im)).multiply(vMNS);
            RealFieldElement cf_1 = (RealFieldElement)((RealFieldElement)cf_0.multiply(gaMNS)).multiply(jacobi.getValue());
            RealFieldElement cf_2 = (RealFieldElement)cf_1.multiply(kJNS);
            RealFieldElement gcPhs = gMSJ.multiply((RealFieldElement)cnm).add(hMSJ.multiply((RealFieldElement)snm));
            RealFieldElement gsMhc = gMSJ.multiply((RealFieldElement)snm).subtract(hMSJ.multiply((RealFieldElement)cnm));
            RealFieldElement dKgcPhsx2 = (RealFieldElement)dkJNS.multiply((RealFieldElement)gcPhs).multiply(2.0);
            RealFieldElement dKgsMhcx2 = (RealFieldElement)dkJNS.multiply((RealFieldElement)gsMhc).multiply(2.0);
            RealFieldElement dUdaCoef = (RealFieldElement)cf_2.multiply(n + 1);
            RealFieldElement dUdlCoef = (RealFieldElement)cf_2.multiply(j);
            RealFieldElement dUdGaCoef = (RealFieldElement)((RealFieldElement)cf_0.multiply(kJNS)).multiply(((RealFieldElement)dGaMNS.multiply(jacobi.getValue())).add(gaMNS.multiply(jacobi.getPartialDerivative(1))));
            dUdaCos = dUdaCos.add(dUdaCoef.multiply(gcPhs));
            dUdaSin = dUdaSin.add(dUdaCoef.multiply(gsMhc));
            dUdhCos = (RealFieldElement)dUdhCos.add(cf_1.multiply(((RealFieldElement)kJNS.multiply(((RealFieldElement)cnm.multiply(dGdh)).add(snm.multiply(dHdh)))).add(dKgcPhsx2.multiply(auxiliaryElements.getH()))));
            dUdhSin = (RealFieldElement)dUdhSin.add(cf_1.multiply(((RealFieldElement)kJNS.multiply(((RealFieldElement)snm.multiply(dGdh)).subtract(cnm.multiply(dHdh)))).add(dKgsMhcx2.multiply(auxiliaryElements.getH()))));
            dUdkCos = (RealFieldElement)dUdkCos.add(cf_1.multiply(((RealFieldElement)kJNS.multiply(((RealFieldElement)cnm.multiply(dGdk)).add(snm.multiply(dHdk)))).add(dKgcPhsx2.multiply(auxiliaryElements.getK()))));
            dUdkSin = (RealFieldElement)dUdkSin.add(cf_1.multiply(((RealFieldElement)kJNS.multiply(((RealFieldElement)snm.multiply(dGdk)).subtract(cnm.multiply(dHdk)))).add(dKgsMhcx2.multiply(auxiliaryElements.getK()))));
            dUdlCos = dUdlCos.add(dUdlCoef.multiply(gsMhc));
            dUdlSin = (RealFieldElement)dUdlSin.add(dUdlCoef.multiply(gcPhs).negate());
            dUdAlCos = dUdAlCos.add(cf_2.multiply(dGdA.multiply((RealFieldElement)cnm).add(dHdA.multiply((RealFieldElement)snm))));
            dUdAlSin = dUdAlSin.add(cf_2.multiply(dGdA.multiply((RealFieldElement)snm).subtract(dHdA.multiply((RealFieldElement)cnm))));
            dUdBeCos = dUdBeCos.add(cf_2.multiply(dGdB.multiply((RealFieldElement)cnm).add(dHdB.multiply((RealFieldElement)snm))));
            dUdBeSin = dUdBeSin.add(cf_2.multiply(dGdB.multiply((RealFieldElement)snm).subtract(dHdB.multiply((RealFieldElement)cnm))));
            dUdGaCos = dUdGaCos.add(dUdGaCoef.multiply(gcPhs));
            dUdGaSin = dUdGaSin.add(dUdGaCoef.multiply(gsMhc));
        }
        RealFieldElement[][] derivatives = (RealFieldElement[][])MathArrays.buildArray(field, 7, 2);
        derivatives[0][0] = dUdaCos;
        derivatives[0][1] = dUdaSin;
        derivatives[1][0] = dUdhCos;
        derivatives[1][1] = dUdhSin;
        derivatives[2][0] = dUdkCos;
        derivatives[2][1] = dUdkSin;
        derivatives[3][0] = dUdlCos;
        derivatives[3][1] = dUdlSin;
        derivatives[4][0] = dUdAlCos;
        derivatives[4][1] = dUdAlSin;
        derivatives[5][0] = dUdBeCos;
        derivatives[5][1] = dUdBeSin;
        derivatives[6][0] = dUdGaCos;
        derivatives[6][1] = dUdGaSin;
        return derivatives;
    }

    @Override
    public void registerAttitudeProvider(AttitudeProvider attitudeProvider) {
    }

    private static class FieldHansenObjects<T extends RealFieldElement<T>> {
        private int maxHansen;
        private FieldHansenTesseralLinear<T>[][] hansenObjects;
        final /* synthetic */ DSSTTesseral this$0;

        FieldHansenObjects(T ratio, int maxEccPow, List<Integer> resOrders, PropagationType type, Field<T> field) {
            this.this$0 = var1_1;
            this.maxHansen = maxEccPow / 2;
            int rows = 2 * ((DSSTTesseral)var1_1).maxDegree + 1;
            int columns = ((DSSTTesseral)var1_1).maxFrequencyShortPeriodics + 1;
            this.hansenObjects = (FieldHansenTesseralLinear[][])Array.newInstance(FieldHansenTesseralLinear.class, rows, columns);
            switch (type) {
                case MEAN: {
                    for (int m : resOrders) {
                        int j = FastMath.max(1, (int)FastMath.round((RealFieldElement)ratio.multiply(m)));
                        int sMin = FastMath.min(maxEccPow - j, ((DSSTTesseral)var1_1).maxDegree);
                        int sMax = FastMath.min(maxEccPow + j, ((DSSTTesseral)var1_1).maxDegree);
                        for (int s = 0; s <= sMax; ++s) {
                            int n0 = FastMath.max(FastMath.max(2, m), s);
                            this.hansenObjects[s + ((DSSTTesseral)var1_1).maxDegree][j] = new FieldHansenTesseralLinear<T>(((DSSTTesseral)var1_1).maxDegree, s, j, n0, this.maxHansen, field);
                            if (s <= 0 || s > sMin) continue;
                            this.hansenObjects[((DSSTTesseral)var1_1).maxDegree - s][j] = new FieldHansenTesseralLinear<T>(((DSSTTesseral)var1_1).maxDegree, -s, j, n0, this.maxHansen, field);
                        }
                    }
                    break;
                }
                case OSCULATING: {
                    for (int j = 0; j <= ((DSSTTesseral)var1_1).maxFrequencyShortPeriodics; ++j) {
                        for (int s = -((DSSTTesseral)var1_1).maxDegree; s <= ((DSSTTesseral)var1_1).maxDegree; ++s) {
                            int n0 = FastMath.max(2, FastMath.abs(s));
                            this.hansenObjects[s + ((DSSTTesseral)var1_1).maxDegree][j] = new FieldHansenTesseralLinear<T>(((DSSTTesseral)var1_1).maxDegree, s, j, n0, this.maxHansen, field);
                        }
                    }
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }

        public void computeHansenObjectsInitValues(FieldDSSTTesseralContext<T> context, int rows, int columns) {
            this.hansenObjects[rows][columns].computeInitValues(context.getE2(), context.getChi(), context.getChi2());
        }

        public FieldHansenTesseralLinear<T>[][] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private class HansenObjects {
        private int maxHansen;
        private HansenTesseralLinear[][] hansenObjects;

        HansenObjects(double ratio, int maxEccPow, List<Integer> resOrders, PropagationType type) {
            this.maxHansen = maxEccPow / 2;
            int rows = 2 * DSSTTesseral.this.maxDegree + 1;
            int columns = DSSTTesseral.this.maxFrequencyShortPeriodics + 1;
            this.hansenObjects = new HansenTesseralLinear[rows][columns];
            switch (type) {
                case MEAN: {
                    for (int m : resOrders) {
                        int j = FastMath.max(1, (int)FastMath.round(ratio * (double)m));
                        int sMin = FastMath.min(maxEccPow - j, DSSTTesseral.this.maxDegree);
                        int sMax = FastMath.min(maxEccPow + j, DSSTTesseral.this.maxDegree);
                        for (int s = 0; s <= sMax; ++s) {
                            int n0 = FastMath.max(FastMath.max(2, m), s);
                            this.hansenObjects[s + ((DSSTTesseral)DSSTTesseral.this).maxDegree][j] = new HansenTesseralLinear(DSSTTesseral.this.maxDegree, s, j, n0, this.maxHansen);
                            if (s <= 0 || s > sMin) continue;
                            this.hansenObjects[((DSSTTesseral)DSSTTesseral.this).maxDegree - s][j] = new HansenTesseralLinear(DSSTTesseral.this.maxDegree, -s, j, n0, this.maxHansen);
                        }
                    }
                    break;
                }
                case OSCULATING: {
                    for (int j = 0; j <= DSSTTesseral.this.maxFrequencyShortPeriodics; ++j) {
                        for (int s = -DSSTTesseral.this.maxDegree; s <= DSSTTesseral.this.maxDegree; ++s) {
                            int n0 = FastMath.max(2, FastMath.abs(s));
                            this.hansenObjects[s + ((DSSTTesseral)DSSTTesseral.this).maxDegree][j] = new HansenTesseralLinear(DSSTTesseral.this.maxDegree, s, j, n0, this.maxHansen);
                        }
                    }
                    break;
                }
                default: {
                    throw new OrekitInternalError(null);
                }
            }
        }

        public void computeHansenObjectsInitValues(DSSTTesseralContext context, int rows, int columns) {
            this.hansenObjects[rows][columns].computeInitValues(context.getE2(), context.getChi(), context.getChi2());
        }

        public HansenTesseralLinear[][] getHansenObjects() {
            return this.hansenObjects;
        }
    }

    private class FieldUAnddU<T extends RealFieldElement<T>> {
        private T dUda;
        private T dUdk;
        private T dUdh;
        private T dUdl;
        private T dUdAl;
        private T dUdBe;
        private T dUdGa;

        FieldUAnddU(FieldAbsoluteDate<T> date, FieldDSSTTesseralContext<T> context, FieldHansenObjects<T> hansen) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            Field<T> field = date.getField();
            RealFieldElement zero = (RealFieldElement)field.getZero();
            this.dUda = zero;
            this.dUdh = zero;
            this.dUdk = zero;
            this.dUdl = zero;
            this.dUdAl = zero;
            this.dUdBe = zero;
            this.dUdGa = zero;
            if (!context.getResOrders().isEmpty()) {
                FieldGHmsjPolynomials ghMSJ = new FieldGHmsjPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), 1, field);
                FieldGammaMnsFunction gammaMNS = new FieldGammaMnsFunction(DSSTTesseral.this.maxDegree, auxiliaryElements.getGamma(), 1, field);
                RealFieldElement[] roaPow = (RealFieldElement[])MathArrays.buildArray(field, DSSTTesseral.this.maxDegree + 1);
                roaPow[0] = (RealFieldElement)zero.add(1.0);
                for (int i = 1; i <= DSSTTesseral.this.maxDegree; ++i) {
                    roaPow[i] = (RealFieldElement)roaPow[i - 1].multiply(context.getRoa());
                }
                for (int m : context.getResOrders()) {
                    int j = FastMath.max(1, (int)FastMath.round((RealFieldElement)context.getRatio().multiply((int)m)));
                    RealFieldElement jlMmt = (RealFieldElement)((RealFieldElement)auxiliaryElements.getLM().multiply((int)j)).subtract(context.getTheta().multiply((int)m));
                    RealFieldElement sinPhi = FastMath.sin(jlMmt);
                    RealFieldElement cosPhi = FastMath.cos(jlMmt);
                    RealFieldElement dUdaCos = zero;
                    RealFieldElement dUdaSin = zero;
                    RealFieldElement dUdhCos = zero;
                    RealFieldElement dUdhSin = zero;
                    RealFieldElement dUdkCos = zero;
                    RealFieldElement dUdkSin = zero;
                    RealFieldElement dUdlCos = zero;
                    RealFieldElement dUdlSin = zero;
                    RealFieldElement dUdAlCos = zero;
                    RealFieldElement dUdAlSin = zero;
                    RealFieldElement dUdBeCos = zero;
                    RealFieldElement dUdBeSin = zero;
                    RealFieldElement dUdGaCos = zero;
                    RealFieldElement dUdGaSin = zero;
                    int sMin = FastMath.min(context.getMaxEccPow() - j, DSSTTesseral.this.maxDegree);
                    int sMax = FastMath.min(context.getMaxEccPow() + j, DSSTTesseral.this.maxDegree);
                    for (int s = 0; s <= sMax; ++s) {
                        hansen.computeHansenObjectsInitValues(context, s + DSSTTesseral.this.maxDegree, j);
                        RealFieldElement[][] nSumSpos = DSSTTesseral.this.computeNSum(date, j, m, s, DSSTTesseral.this.maxDegree, roaPow, ghMSJ, gammaMNS, context, hansen);
                        dUdaCos = dUdaCos.add(nSumSpos[0][0]);
                        dUdaSin = dUdaSin.add(nSumSpos[0][1]);
                        dUdhCos = dUdhCos.add(nSumSpos[1][0]);
                        dUdhSin = dUdhSin.add(nSumSpos[1][1]);
                        dUdkCos = dUdkCos.add(nSumSpos[2][0]);
                        dUdkSin = dUdkSin.add(nSumSpos[2][1]);
                        dUdlCos = dUdlCos.add(nSumSpos[3][0]);
                        dUdlSin = dUdlSin.add(nSumSpos[3][1]);
                        dUdAlCos = dUdAlCos.add(nSumSpos[4][0]);
                        dUdAlSin = dUdAlSin.add(nSumSpos[4][1]);
                        dUdBeCos = dUdBeCos.add(nSumSpos[5][0]);
                        dUdBeSin = dUdBeSin.add(nSumSpos[5][1]);
                        dUdGaCos = dUdGaCos.add(nSumSpos[6][0]);
                        dUdGaSin = dUdGaSin.add(nSumSpos[6][1]);
                        if (s <= 0 || s > sMin) continue;
                        hansen.computeHansenObjectsInitValues(context, DSSTTesseral.this.maxDegree - s, j);
                        RealFieldElement[][] nSumSneg = DSSTTesseral.this.computeNSum(date, j, m, -s, DSSTTesseral.this.maxDegree, roaPow, ghMSJ, gammaMNS, context, hansen);
                        dUdaCos = dUdaCos.add(nSumSneg[0][0]);
                        dUdaSin = dUdaSin.add(nSumSneg[0][1]);
                        dUdhCos = dUdhCos.add(nSumSneg[1][0]);
                        dUdhSin = dUdhSin.add(nSumSneg[1][1]);
                        dUdkCos = dUdkCos.add(nSumSneg[2][0]);
                        dUdkSin = dUdkSin.add(nSumSneg[2][1]);
                        dUdlCos = dUdlCos.add(nSumSneg[3][0]);
                        dUdlSin = dUdlSin.add(nSumSneg[3][1]);
                        dUdAlCos = dUdAlCos.add(nSumSneg[4][0]);
                        dUdAlSin = dUdAlSin.add(nSumSneg[4][1]);
                        dUdBeCos = dUdBeCos.add(nSumSneg[5][0]);
                        dUdBeSin = dUdBeSin.add(nSumSneg[5][1]);
                        dUdGaCos = dUdGaCos.add(nSumSneg[6][0]);
                        dUdGaSin = dUdGaSin.add(nSumSneg[6][1]);
                    }
                    this.dUda = this.dUda.add((RealFieldElement)dUdaCos.multiply(cosPhi).add(dUdaSin.multiply(sinPhi)));
                    this.dUdh = this.dUdh.add((RealFieldElement)dUdhCos.multiply(cosPhi).add(dUdhSin.multiply(sinPhi)));
                    this.dUdk = this.dUdk.add((RealFieldElement)dUdkCos.multiply(cosPhi).add(dUdkSin.multiply(sinPhi)));
                    this.dUdl = this.dUdl.add((RealFieldElement)dUdlCos.multiply(cosPhi).add(dUdlSin.multiply(sinPhi)));
                    this.dUdAl = this.dUdAl.add((RealFieldElement)dUdAlCos.multiply(cosPhi).add(dUdAlSin.multiply(sinPhi)));
                    this.dUdBe = this.dUdBe.add((RealFieldElement)dUdBeCos.multiply(cosPhi).add(dUdBeSin.multiply(sinPhi)));
                    this.dUdGa = this.dUdGa.add((RealFieldElement)dUdGaCos.multiply(cosPhi).add(dUdGaSin.multiply(sinPhi)));
                }
                this.dUda = (RealFieldElement)((RealFieldElement)this.dUda.multiply(context.getMoa().divide(auxiliaryElements.getSma()))).negate();
                this.dUdh = (RealFieldElement)this.dUdh.multiply(context.getMoa());
                this.dUdk = (RealFieldElement)this.dUdk.multiply(context.getMoa());
                this.dUdl = (RealFieldElement)this.dUdl.multiply(context.getMoa());
                this.dUdAl = (RealFieldElement)this.dUdAl.multiply(context.getMoa());
                this.dUdBe = (RealFieldElement)this.dUdBe.multiply(context.getMoa());
                this.dUdGa = (RealFieldElement)this.dUdGa.multiply(context.getMoa());
            }
        }

        public T getdUda() {
            return this.dUda;
        }

        public T getdUdk() {
            return this.dUdk;
        }

        public T getdUdh() {
            return this.dUdh;
        }

        public T getdUdl() {
            return this.dUdl;
        }

        public T getdUdAl() {
            return this.dUdAl;
        }

        public T getdUdBe() {
            return this.dUdBe;
        }

        public T getdUdGa() {
            return this.dUdGa;
        }
    }

    private class UAnddU {
        private double dUda;
        private double dUdk;
        private double dUdh;
        private double dUdl;
        private double dUdAl;
        private double dUdBe;
        private double dUdGa;

        UAnddU(AbsoluteDate date, DSSTTesseralContext context, HansenObjects hansen) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            this.dUda = 0.0;
            this.dUdh = 0.0;
            this.dUdk = 0.0;
            this.dUdl = 0.0;
            this.dUdAl = 0.0;
            this.dUdBe = 0.0;
            this.dUdGa = 0.0;
            if (!context.getResOrders().isEmpty()) {
                GHmsjPolynomials ghMSJ = new GHmsjPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), 1);
                GammaMnsFunction gammaMNS = new GammaMnsFunction(DSSTTesseral.this.maxDegree, auxiliaryElements.getGamma(), 1);
                double[] roaPow = new double[DSSTTesseral.this.maxDegree + 1];
                roaPow[0] = 1.0;
                for (int i = 1; i <= DSSTTesseral.this.maxDegree; ++i) {
                    roaPow[i] = context.getRoa() * roaPow[i - 1];
                }
                for (int m : context.getResOrders()) {
                    int j = FastMath.max(1, (int)FastMath.round(context.getRatio() * (double)m));
                    double jlMmt = (double)j * auxiliaryElements.getLM() - (double)m * context.getTheta();
                    double sinPhi = FastMath.sin(jlMmt);
                    double cosPhi = FastMath.cos(jlMmt);
                    double dUdaCos = 0.0;
                    double dUdaSin = 0.0;
                    double dUdhCos = 0.0;
                    double dUdhSin = 0.0;
                    double dUdkCos = 0.0;
                    double dUdkSin = 0.0;
                    double dUdlCos = 0.0;
                    double dUdlSin = 0.0;
                    double dUdAlCos = 0.0;
                    double dUdAlSin = 0.0;
                    double dUdBeCos = 0.0;
                    double dUdBeSin = 0.0;
                    double dUdGaCos = 0.0;
                    double dUdGaSin = 0.0;
                    int sMin = FastMath.min(context.getMaxEccPow() - j, DSSTTesseral.this.maxDegree);
                    int sMax = FastMath.min(context.getMaxEccPow() + j, DSSTTesseral.this.maxDegree);
                    for (int s = 0; s <= sMax; ++s) {
                        hansen.computeHansenObjectsInitValues(context, s + DSSTTesseral.this.maxDegree, j);
                        double[][] nSumSpos = DSSTTesseral.this.computeNSum(date, j, m, s, DSSTTesseral.this.maxDegree, roaPow, ghMSJ, gammaMNS, context, hansen);
                        dUdaCos += nSumSpos[0][0];
                        dUdaSin += nSumSpos[0][1];
                        dUdhCos += nSumSpos[1][0];
                        dUdhSin += nSumSpos[1][1];
                        dUdkCos += nSumSpos[2][0];
                        dUdkSin += nSumSpos[2][1];
                        dUdlCos += nSumSpos[3][0];
                        dUdlSin += nSumSpos[3][1];
                        dUdAlCos += nSumSpos[4][0];
                        dUdAlSin += nSumSpos[4][1];
                        dUdBeCos += nSumSpos[5][0];
                        dUdBeSin += nSumSpos[5][1];
                        dUdGaCos += nSumSpos[6][0];
                        dUdGaSin += nSumSpos[6][1];
                        if (s <= 0 || s > sMin) continue;
                        hansen.computeHansenObjectsInitValues(context, DSSTTesseral.this.maxDegree - s, j);
                        double[][] nSumSneg = DSSTTesseral.this.computeNSum(date, j, m, -s, DSSTTesseral.this.maxDegree, roaPow, ghMSJ, gammaMNS, context, hansen);
                        dUdaCos += nSumSneg[0][0];
                        dUdaSin += nSumSneg[0][1];
                        dUdhCos += nSumSneg[1][0];
                        dUdhSin += nSumSneg[1][1];
                        dUdkCos += nSumSneg[2][0];
                        dUdkSin += nSumSneg[2][1];
                        dUdlCos += nSumSneg[3][0];
                        dUdlSin += nSumSneg[3][1];
                        dUdAlCos += nSumSneg[4][0];
                        dUdAlSin += nSumSneg[4][1];
                        dUdBeCos += nSumSneg[5][0];
                        dUdBeSin += nSumSneg[5][1];
                        dUdGaCos += nSumSneg[6][0];
                        dUdGaSin += nSumSneg[6][1];
                    }
                    this.dUda += cosPhi * dUdaCos + sinPhi * dUdaSin;
                    this.dUdh += cosPhi * dUdhCos + sinPhi * dUdhSin;
                    this.dUdk += cosPhi * dUdkCos + sinPhi * dUdkSin;
                    this.dUdl += cosPhi * dUdlCos + sinPhi * dUdlSin;
                    this.dUdAl += cosPhi * dUdAlCos + sinPhi * dUdAlSin;
                    this.dUdBe += cosPhi * dUdBeCos + sinPhi * dUdBeSin;
                    this.dUdGa += cosPhi * dUdGaCos + sinPhi * dUdGaSin;
                }
                this.dUda *= -context.getMoa() / auxiliaryElements.getSma();
                this.dUdh *= context.getMoa();
                this.dUdk *= context.getMoa();
                this.dUdl *= context.getMoa();
                this.dUdAl *= context.getMoa();
                this.dUdBe *= context.getMoa();
                this.dUdGa *= context.getMoa();
            }
        }

        public double getdUda() {
            return this.dUda;
        }

        public double getdUdk() {
            return this.dUdk;
        }

        public double getdUdh() {
            return this.dUdh;
        }

        public double getdUdl() {
            return this.dUdl;
        }

        public double getdUdAl() {
            return this.dUdAl;
        }

        public double getdUdBe() {
            return this.dUdBe;
        }

        public double getdUdGa() {
            return this.dUdGa;
        }
    }

    private static class FieldSlot<T extends RealFieldElement<T>> {
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[][] cijm;
        private final FieldShortPeriodicsInterpolatedCoefficient<T>[][] sijm;

        FieldSlot(int mMax, int jMax, int interpolationPoints) {
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.cijm = (FieldShortPeriodicsInterpolatedCoefficient[][])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, rows, columns);
            this.sijm = (FieldShortPeriodicsInterpolatedCoefficient[][])Array.newInstance(FieldShortPeriodicsInterpolatedCoefficient.class, rows, columns);
            for (int m = 1; m <= mMax; ++m) {
                for (int j = -jMax; j <= jMax; ++j) {
                    this.cijm[m][j + jMax] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    this.sijm[m][j + jMax] = new FieldShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
            }
        }

        T[] getCijm(int j, int m, FieldAbsoluteDate<T> date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.cijm[m][j + jMax].value(date);
        }

        T[] getSijm(int j, int m, FieldAbsoluteDate<T> date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.sijm[m][j + jMax].value(date);
        }
    }

    private static class Slot {
        private final ShortPeriodicsInterpolatedCoefficient[][] cijm;
        private final ShortPeriodicsInterpolatedCoefficient[][] sijm;

        Slot(int mMax, int jMax, int interpolationPoints) {
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.cijm = new ShortPeriodicsInterpolatedCoefficient[rows][columns];
            this.sijm = new ShortPeriodicsInterpolatedCoefficient[rows][columns];
            for (int m = 1; m <= mMax; ++m) {
                for (int j = -jMax; j <= jMax; ++j) {
                    this.cijm[m][j + jMax] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                    this.sijm[m][j + jMax] = new ShortPeriodicsInterpolatedCoefficient(interpolationPoints);
                }
            }
        }

        double[] getCijm(int j, int m, AbsoluteDate date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.cijm[m][j + jMax].value(date);
        }

        double[] getSijm(int j, int m, AbsoluteDate date) {
            int jMax = (this.cijm[m].length - 1) / 2;
            return this.sijm[m][j + jMax].value(date);
        }
    }

    private static class FieldTesseralShortPeriodicCoefficients<T extends RealFieldElement<T>>
    implements FieldShortPeriodTerms<T> {
        private static final int I = 1;
        private final Frame bodyFrame;
        private final int maxOrderMdailyTesseralSP;
        private final boolean mDailiesOnly;
        private final SortedMap<Integer, List<Integer>> nonResOrders;
        private final int mMax;
        private final int jMax;
        private final int interpolationPoints;
        private final transient FieldTimeSpanMap<FieldSlot<T>, T> slots;

        FieldTesseralShortPeriodicCoefficients(Frame bodyFrame, int maxOrderMdailyTesseralSP, boolean mDailiesOnly, SortedMap<Integer, List<Integer>> nonResOrders, int mMax, int jMax, int interpolationPoints, FieldTimeSpanMap<FieldSlot<T>, T> slots) {
            this.bodyFrame = bodyFrame;
            this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
            this.mDailiesOnly = mDailiesOnly;
            this.nonResOrders = nonResOrders;
            this.mMax = mMax;
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public FieldSlot<T> createSlot(FieldSpacecraftState<T> ... meanStates) {
            FieldAbsoluteDate<T> last;
            FieldSlot slot = new FieldSlot(this.mMax, this.jMax, this.interpolationPoints);
            FieldAbsoluteDate<T> first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public T[] value(FieldOrbit<T> meanOrbit) {
            FieldSlot<T> slot = this.slots.get(meanOrbit.getDate());
            RealFieldElement[] shortPeriodicVariation = (RealFieldElement[])MathArrays.buildArray(meanOrbit.getDate().getField(), 6);
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                FieldAuxiliaryElements<T> auxiliaryElements = new FieldAuxiliaryElements<T>(meanOrbit, 1);
                FieldTransform<T> t = this.bodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
                FieldVector3D<T> xB = t.transformVector(Vector3D.PLUS_I);
                FieldVector3D<T> yB = t.transformVector(Vector3D.PLUS_J);
                FieldVector3D<T> f = auxiliaryElements.getVectorF();
                FieldVector3D<T> g = auxiliaryElements.getVectorG();
                RealFieldElement currentTheta = FastMath.atan2((RealFieldElement)((RealFieldElement)f.dotProduct(yB).negate()).add(g.dotProduct(xB).multiply(true)), (RealFieldElement)f.dotProduct(xB).add(g.dotProduct(yB).multiply(true)));
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    RealFieldElement jlMmt = (RealFieldElement)currentTheta.multiply(-m);
                    RealFieldElement sinPhi = FastMath.sin(jlMmt);
                    RealFieldElement cosPhi = FastMath.cos(jlMmt);
                    RealFieldElement[] c = slot.getCijm(0, m, meanOrbit.getDate());
                    RealFieldElement[] s = slot.getSijm(0, m, meanOrbit.getDate());
                    for (int i = 0; i < 6; ++i) {
                        shortPeriodicVariation[i] = shortPeriodicVariation[i].add(c[i].multiply(cosPhi).add(s[i].multiply(sinPhi)));
                    }
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        RealFieldElement jlMmt = (RealFieldElement)((RealFieldElement)meanOrbit.getLM().multiply((int)j)).subtract(currentTheta.multiply(m));
                        RealFieldElement sinPhi = FastMath.sin(jlMmt);
                        RealFieldElement cosPhi = FastMath.cos(jlMmt);
                        RealFieldElement[] c = slot.getCijm(j, m, meanOrbit.getDate());
                        RealFieldElement[] s = slot.getSijm(j, m, meanOrbit.getDate());
                        for (int i = 0; i < 6; ++i) {
                            shortPeriodicVariation[i] = shortPeriodicVariation[i].add(c[i].multiply(cosPhi).add(s[i].multiply(sinPhi)));
                        }
                    }
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return DSSTTesseral.SHORT_PERIOD_PREFIX;
        }

        @Override
        public Map<String, T[]> getCoefficients(FieldAbsoluteDate<T> date, Set<String> selected) {
            FieldSlot<T> slot = this.slots.get(date);
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                HashMap<String, T[]> coefficients = new HashMap<String, T[]>(12 * this.maxOrderMdailyTesseralSP + 12 * this.nonResOrders.size());
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    this.storeIfSelected(coefficients, selected, slot.getCijm(0, m, date), DSSTTesseral.CM_COEFFICIENTS, new int[]{m});
                    this.storeIfSelected(coefficients, selected, slot.getSijm(0, m, date), DSSTTesseral.SM_COEFFICIENTS, new int[]{m});
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        for (int i = 0; i < 6; ++i) {
                            this.storeIfSelected(coefficients, selected, slot.getCijm(j, m, date), "c", new int[]{j, m});
                            this.storeIfSelected(coefficients, selected, slot.getSijm(j, m, date), "s", new int[]{j, m});
                        }
                    }
                }
                return coefficients;
            }
            return Collections.emptyMap();
        }

        private void storeIfSelected(Map<String, T[]> map, Set<String> selected, T[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    private static class TesseralShortPeriodicCoefficients
    implements ShortPeriodTerms {
        private static final int I = 1;
        private final Frame bodyFrame;
        private final int maxOrderMdailyTesseralSP;
        private final boolean mDailiesOnly;
        private final SortedMap<Integer, List<Integer>> nonResOrders;
        private final int mMax;
        private final int jMax;
        private final int interpolationPoints;
        private final transient TimeSpanMap<Slot> slots;

        TesseralShortPeriodicCoefficients(Frame bodyFrame, int maxOrderMdailyTesseralSP, boolean mDailiesOnly, SortedMap<Integer, List<Integer>> nonResOrders, int mMax, int jMax, int interpolationPoints, TimeSpanMap<Slot> slots) {
            this.bodyFrame = bodyFrame;
            this.maxOrderMdailyTesseralSP = maxOrderMdailyTesseralSP;
            this.mDailiesOnly = mDailiesOnly;
            this.nonResOrders = nonResOrders;
            this.mMax = mMax;
            this.jMax = jMax;
            this.interpolationPoints = interpolationPoints;
            this.slots = slots;
        }

        public Slot createSlot(SpacecraftState ... meanStates) {
            AbsoluteDate last;
            Slot slot = new Slot(this.mMax, this.jMax, this.interpolationPoints);
            AbsoluteDate first = meanStates[0].getDate();
            if (first.compareTo(last = meanStates[meanStates.length - 1].getDate()) <= 0) {
                this.slots.addValidAfter(slot, first);
            } else {
                this.slots.addValidBefore(slot, first);
            }
            return slot;
        }

        @Override
        public double[] value(Orbit meanOrbit) {
            Slot slot = this.slots.get(meanOrbit.getDate());
            double[] shortPeriodicVariation = new double[6];
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                AuxiliaryElements auxiliaryElements = new AuxiliaryElements(meanOrbit, 1);
                Transform t = this.bodyFrame.getTransformTo(auxiliaryElements.getFrame(), auxiliaryElements.getDate());
                Vector3D xB = t.transformVector(Vector3D.PLUS_I);
                Vector3D yB = t.transformVector(Vector3D.PLUS_J);
                Vector3D f = auxiliaryElements.getVectorF();
                Vector3D g = auxiliaryElements.getVectorG();
                double currentTheta = FastMath.atan2(-f.dotProduct(yB) + 1.0 * g.dotProduct(xB), f.dotProduct(xB) + 1.0 * g.dotProduct(yB));
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    double jlMmt = (double)(-m) * currentTheta;
                    double sinPhi = FastMath.sin(jlMmt);
                    double cosPhi = FastMath.cos(jlMmt);
                    double[] c = slot.getCijm(0, m, meanOrbit.getDate());
                    double[] s = slot.getSijm(0, m, meanOrbit.getDate());
                    for (int i = 0; i < 6; ++i) {
                        int n = i;
                        shortPeriodicVariation[n] = shortPeriodicVariation[n] + (c[i] * cosPhi + s[i] * sinPhi);
                    }
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        double jlMmt = (double)j * meanOrbit.getLM() - (double)m * currentTheta;
                        double sinPhi = FastMath.sin(jlMmt);
                        double cosPhi = FastMath.cos(jlMmt);
                        double[] c = slot.getCijm(j, m, meanOrbit.getDate());
                        double[] s = slot.getSijm(j, m, meanOrbit.getDate());
                        for (int i = 0; i < 6; ++i) {
                            int n = i;
                            shortPeriodicVariation[n] = shortPeriodicVariation[n] + (c[i] * cosPhi + s[i] * sinPhi);
                        }
                    }
                }
            }
            return shortPeriodicVariation;
        }

        @Override
        public String getCoefficientsKeyPrefix() {
            return DSSTTesseral.SHORT_PERIOD_PREFIX;
        }

        @Override
        public Map<String, double[]> getCoefficients(AbsoluteDate date, Set<String> selected) {
            Slot slot = this.slots.get(date);
            if (!this.nonResOrders.isEmpty() || this.mDailiesOnly) {
                HashMap<String, double[]> coefficients = new HashMap<String, double[]>(12 * this.maxOrderMdailyTesseralSP + 12 * this.nonResOrders.size());
                for (int m = 1; m <= this.maxOrderMdailyTesseralSP; ++m) {
                    this.storeIfSelected(coefficients, selected, slot.getCijm(0, m, date), DSSTTesseral.CM_COEFFICIENTS, m);
                    this.storeIfSelected(coefficients, selected, slot.getSijm(0, m, date), DSSTTesseral.SM_COEFFICIENTS, m);
                }
                for (Map.Entry<Integer, List<Integer>> entry : this.nonResOrders.entrySet()) {
                    int m = entry.getKey();
                    List<Integer> listJ = entry.getValue();
                    for (int j : listJ) {
                        for (int i = 0; i < 6; ++i) {
                            this.storeIfSelected(coefficients, selected, slot.getCijm(j, m, date), "c", j, m);
                            this.storeIfSelected(coefficients, selected, slot.getSijm(j, m, date), "s", j, m);
                        }
                    }
                }
                return coefficients;
            }
            return Collections.emptyMap();
        }

        private void storeIfSelected(Map<String, double[]> map, Set<String> selected, double[] value, String id, int ... indices) {
            StringBuilder keyBuilder = new StringBuilder(this.getCoefficientsKeyPrefix());
            keyBuilder.append(id);
            for (int index : indices) {
                keyBuilder.append('[').append(index).append(']');
            }
            String key = keyBuilder.toString();
            if (selected.isEmpty() || selected.contains(key)) {
                map.put(key, value);
            }
        }
    }

    private class FieldFourierCjSjCoefficients<T extends RealFieldElement<T>> {
        private final int jMax;
        private final T[][][] cCoef;
        private final T[][][] sCoef;
        private FieldGHmsjPolynomials<T> ghMSJ;
        private FieldGammaMnsFunction<T> gammaMNS;
        private final T[] roaPow;

        FieldFourierCjSjCoefficients(int jMax, int mMax, Field<T> field) {
            RealFieldElement zero = (RealFieldElement)field.getZero();
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.jMax = jMax;
            this.cCoef = (RealFieldElement[][][])MathArrays.buildArray(field, rows, columns, 6);
            this.sCoef = (RealFieldElement[][][])MathArrays.buildArray(field, rows, columns, 6);
            this.roaPow = (RealFieldElement[])MathArrays.buildArray(field, DSSTTesseral.this.maxDegree + 1);
            this.roaPow[0] = (RealFieldElement)zero.add(1.0);
        }

        public void generateCoefficients(FieldAbsoluteDate<T> date, FieldDSSTTesseralContext<T> context, FieldHansenObjects<T> hansenObjects, Field<T> field) {
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            if (!DSSTTesseral.this.nonResOrders.isEmpty() || DSSTTesseral.this.maxDegreeTesseralSP < 0) {
                this.ghMSJ = new FieldGHmsjPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), 1, field);
                this.gammaMNS = new FieldGammaMnsFunction(DSSTTesseral.this.maxDegree, auxiliaryElements.getGamma(), 1, field);
                int maxRoaPower = FastMath.max(DSSTTesseral.this.maxDegreeTesseralSP, DSSTTesseral.this.maxDegreeMdailyTesseralSP);
                for (int i = 1; i <= maxRoaPower; ++i) {
                    this.roaPow[i] = (RealFieldElement)context.getRoa().multiply(this.roaPow[i - 1]);
                }
                for (int m = 1; m <= DSSTTesseral.this.maxOrderMdailyTesseralSP; ++m) {
                    this.buildFourierCoefficients(date, m, 0, DSSTTesseral.this.maxDegreeMdailyTesseralSP, context, hansenObjects, field);
                }
                if (DSSTTesseral.this.maxDegreeTesseralSP >= 0) {
                    Iterator iterator = DSSTTesseral.this.nonResOrders.keySet().iterator();
                    while (iterator.hasNext()) {
                        int m = (Integer)iterator.next();
                        List listJ = (List)DSSTTesseral.this.nonResOrders.get(m);
                        Iterator iterator2 = listJ.iterator();
                        while (iterator2.hasNext()) {
                            int j = (Integer)iterator2.next();
                            this.buildFourierCoefficients(date, m, j, DSSTTesseral.this.maxDegreeTesseralSP, context, hansenObjects, field);
                        }
                    }
                }
            }
        }

        private void buildFourierCoefficients(FieldAbsoluteDate<T> date, int m, int j, int maxN, FieldDSSTTesseralContext<T> context, FieldHansenObjects<T> hansenObjects, Field<T> field) {
            RealFieldElement zero = (RealFieldElement)field.getZero();
            FieldAuxiliaryElements auxiliaryElements = context.getFieldAuxiliaryElements();
            RealFieldElement dRdaCos = zero;
            RealFieldElement dRdaSin = zero;
            RealFieldElement dRdhCos = zero;
            RealFieldElement dRdhSin = zero;
            RealFieldElement dRdkCos = zero;
            RealFieldElement dRdkSin = zero;
            RealFieldElement dRdlCos = zero;
            RealFieldElement dRdlSin = zero;
            RealFieldElement dRdAlCos = zero;
            RealFieldElement dRdAlSin = zero;
            RealFieldElement dRdBeCos = zero;
            RealFieldElement dRdBeSin = zero;
            RealFieldElement dRdGaCos = zero;
            RealFieldElement dRdGaSin = zero;
            int sMin = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            int sMax = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            for (int s = 0; s <= sMax; ++s) {
                RealFieldElement[][] nSumSpos = DSSTTesseral.this.computeNSum(date, j, m, s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS, context, hansenObjects);
                dRdaCos = dRdaCos.add(nSumSpos[0][0]);
                dRdaSin = dRdaSin.add(nSumSpos[0][1]);
                dRdhCos = dRdhCos.add(nSumSpos[1][0]);
                dRdhSin = dRdhSin.add(nSumSpos[1][1]);
                dRdkCos = dRdkCos.add(nSumSpos[2][0]);
                dRdkSin = dRdkSin.add(nSumSpos[2][1]);
                dRdlCos = dRdlCos.add(nSumSpos[3][0]);
                dRdlSin = dRdlSin.add(nSumSpos[3][1]);
                dRdAlCos = dRdAlCos.add(nSumSpos[4][0]);
                dRdAlSin = dRdAlSin.add(nSumSpos[4][1]);
                dRdBeCos = dRdBeCos.add(nSumSpos[5][0]);
                dRdBeSin = dRdBeSin.add(nSumSpos[5][1]);
                dRdGaCos = dRdGaCos.add(nSumSpos[6][0]);
                dRdGaSin = dRdGaSin.add(nSumSpos[6][1]);
                if (s <= 0 || s > sMin) continue;
                RealFieldElement[][] nSumSneg = DSSTTesseral.this.computeNSum(date, j, m, -s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS, context, hansenObjects);
                dRdaCos = dRdaCos.add(nSumSneg[0][0]);
                dRdaSin = dRdaSin.add(nSumSneg[0][1]);
                dRdhCos = dRdhCos.add(nSumSneg[1][0]);
                dRdhSin = dRdhSin.add(nSumSneg[1][1]);
                dRdkCos = dRdkCos.add(nSumSneg[2][0]);
                dRdkSin = dRdkSin.add(nSumSneg[2][1]);
                dRdlCos = dRdlCos.add(nSumSneg[3][0]);
                dRdlSin = dRdlSin.add(nSumSneg[3][1]);
                dRdAlCos = dRdAlCos.add(nSumSneg[4][0]);
                dRdAlSin = dRdAlSin.add(nSumSneg[4][1]);
                dRdBeCos = dRdBeCos.add(nSumSneg[5][0]);
                dRdBeSin = dRdBeSin.add(nSumSneg[5][1]);
                dRdGaCos = dRdGaCos.add(nSumSneg[6][0]);
                dRdGaSin = dRdGaSin.add(nSumSneg[6][1]);
            }
            dRdaCos = (RealFieldElement)dRdaCos.multiply(((RealFieldElement)context.getMoa().negate()).divide(auxiliaryElements.getSma()));
            dRdaSin = (RealFieldElement)dRdaSin.multiply(((RealFieldElement)context.getMoa().negate()).divide(auxiliaryElements.getSma()));
            dRdhCos = (RealFieldElement)dRdhCos.multiply(context.getMoa());
            dRdhSin = (RealFieldElement)dRdhSin.multiply(context.getMoa());
            dRdkCos = (RealFieldElement)dRdkCos.multiply(context.getMoa());
            dRdkSin = (RealFieldElement)dRdkSin.multiply(context.getMoa());
            dRdlCos = (RealFieldElement)dRdlCos.multiply(context.getMoa());
            dRdlSin = (RealFieldElement)dRdlSin.multiply(context.getMoa());
            dRdAlCos = (RealFieldElement)dRdAlCos.multiply(context.getMoa());
            dRdAlSin = (RealFieldElement)dRdAlSin.multiply(context.getMoa());
            dRdBeCos = (RealFieldElement)dRdBeCos.multiply(context.getMoa());
            dRdBeSin = (RealFieldElement)dRdBeSin.multiply(context.getMoa());
            dRdGaCos = (RealFieldElement)dRdGaCos.multiply(context.getMoa());
            dRdGaSin = (RealFieldElement)dRdGaSin.multiply(context.getMoa());
            RealFieldElement RAlphaGammaCos = auxiliaryElements.getAlpha().multiply((RealFieldElement)dRdGaCos).subtract(auxiliaryElements.getGamma().multiply((RealFieldElement)dRdAlCos));
            RealFieldElement RAlphaGammaSin = auxiliaryElements.getAlpha().multiply((RealFieldElement)dRdGaSin).subtract(auxiliaryElements.getGamma().multiply((RealFieldElement)dRdAlSin));
            RealFieldElement RAlphaBetaCos = auxiliaryElements.getAlpha().multiply((RealFieldElement)dRdBeCos).subtract(auxiliaryElements.getBeta().multiply((RealFieldElement)dRdAlCos));
            RealFieldElement RAlphaBetaSin = auxiliaryElements.getAlpha().multiply((RealFieldElement)dRdBeSin).subtract(auxiliaryElements.getBeta().multiply((RealFieldElement)dRdAlSin));
            RealFieldElement RBetaGammaCos = auxiliaryElements.getBeta().multiply((RealFieldElement)dRdGaCos).subtract(auxiliaryElements.getGamma().multiply((RealFieldElement)dRdBeCos));
            RealFieldElement RBetaGammaSin = auxiliaryElements.getBeta().multiply((RealFieldElement)dRdGaSin).subtract(auxiliaryElements.getGamma().multiply((RealFieldElement)dRdBeSin));
            RealFieldElement RhkCos = auxiliaryElements.getH().multiply((RealFieldElement)dRdkCos).subtract(auxiliaryElements.getK().multiply((RealFieldElement)dRdhCos));
            RealFieldElement RhkSin = auxiliaryElements.getH().multiply((RealFieldElement)dRdkSin).subtract(auxiliaryElements.getK().multiply((RealFieldElement)dRdhSin));
            RealFieldElement pRagmIqRbgoABCos = (RealFieldElement)((RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)RAlphaGammaCos).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)RBetaGammaCos).multiply(true))).multiply(context.getOoAB());
            RealFieldElement pRagmIqRbgoABSin = (RealFieldElement)((RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)RAlphaGammaSin).subtract(auxiliaryElements.getQ().multiply((RealFieldElement)RBetaGammaSin).multiply(true))).multiply(context.getOoAB());
            RealFieldElement RhkmRabmdRdlCos = RhkCos.subtract(RAlphaBetaCos).subtract(dRdlCos);
            RealFieldElement RhkmRabmdRdlSin = RhkSin.subtract(RAlphaBetaSin).subtract(dRdlSin);
            this.cCoef[m][j + this.jMax][0] = context.getAx2oA().multiply((RealFieldElement)dRdlCos);
            this.sCoef[m][j + this.jMax][0] = context.getAx2oA().multiply((RealFieldElement)dRdlSin);
            this.cCoef[m][j + this.jMax][1] = (RealFieldElement)context.getBoA().multiply((RealFieldElement)dRdhCos).add(auxiliaryElements.getH().multiply((RealFieldElement)pRagmIqRbgoABCos)).add(((RealFieldElement)auxiliaryElements.getK().multiply(context.getBoABpo())).multiply(dRdlCos)).negate();
            this.sCoef[m][j + this.jMax][1] = (RealFieldElement)context.getBoA().multiply((RealFieldElement)dRdhSin).add(auxiliaryElements.getH().multiply((RealFieldElement)pRagmIqRbgoABSin)).add(((RealFieldElement)auxiliaryElements.getK().multiply(context.getBoABpo())).multiply(dRdlSin)).negate();
            this.cCoef[m][j + this.jMax][2] = context.getBoA().multiply((RealFieldElement)dRdkCos).add(auxiliaryElements.getK().multiply((RealFieldElement)pRagmIqRbgoABCos)).subtract(((RealFieldElement)auxiliaryElements.getH().multiply(context.getBoABpo())).multiply(dRdlCos));
            this.sCoef[m][j + this.jMax][2] = context.getBoA().multiply((RealFieldElement)dRdkSin).add(auxiliaryElements.getK().multiply((RealFieldElement)pRagmIqRbgoABSin)).subtract(((RealFieldElement)auxiliaryElements.getH().multiply(context.getBoABpo())).multiply(dRdlSin));
            this.cCoef[m][j + this.jMax][3] = (RealFieldElement)context.getCo2AB().multiply(auxiliaryElements.getQ().multiply((RealFieldElement)RhkmRabmdRdlCos).subtract(RAlphaGammaCos.multiply(true)));
            this.sCoef[m][j + this.jMax][3] = (RealFieldElement)context.getCo2AB().multiply(auxiliaryElements.getQ().multiply((RealFieldElement)RhkmRabmdRdlSin).subtract(RAlphaGammaSin.multiply(true)));
            this.cCoef[m][j + this.jMax][4] = context.getCo2AB().multiply((RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)RhkmRabmdRdlCos).subtract(RBetaGammaCos));
            this.sCoef[m][j + this.jMax][4] = context.getCo2AB().multiply((RealFieldElement)auxiliaryElements.getP().multiply((RealFieldElement)RhkmRabmdRdlSin).subtract(RBetaGammaSin));
            this.cCoef[m][j + this.jMax][5] = ((RealFieldElement)context.getAx2oA().negate()).multiply(dRdaCos).add(context.getBoABpo().multiply((RealFieldElement)auxiliaryElements.getH().multiply((RealFieldElement)dRdhCos).add(auxiliaryElements.getK().multiply((RealFieldElement)dRdkCos)))).add(pRagmIqRbgoABCos);
            this.sCoef[m][j + this.jMax][5] = ((RealFieldElement)context.getAx2oA().negate()).multiply(dRdaSin).add(context.getBoABpo().multiply((RealFieldElement)auxiliaryElements.getH().multiply((RealFieldElement)dRdhSin).add(auxiliaryElements.getK().multiply((RealFieldElement)dRdkSin)))).add(pRagmIqRbgoABSin);
        }

        public T getCijm(int i, int j, int m) {
            return this.cCoef[m][j + this.jMax][i];
        }

        public T getSijm(int i, int j, int m) {
            return this.sCoef[m][j + this.jMax][i];
        }
    }

    private class FourierCjSjCoefficients {
        private final int jMax;
        private final double[][][] cCoef;
        private final double[][][] sCoef;
        private GHmsjPolynomials ghMSJ;
        private GammaMnsFunction gammaMNS;
        private final double[] roaPow;

        FourierCjSjCoefficients(int jMax, int mMax) {
            int rows = mMax + 1;
            int columns = 2 * jMax + 1;
            this.jMax = jMax;
            this.cCoef = new double[rows][columns][6];
            this.sCoef = new double[rows][columns][6];
            this.roaPow = new double[DSSTTesseral.this.maxDegree + 1];
            this.roaPow[0] = 1.0;
        }

        public void generateCoefficients(AbsoluteDate date, DSSTTesseralContext context, HansenObjects hansenObjects) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            if (!DSSTTesseral.this.nonResOrders.isEmpty() || DSSTTesseral.this.maxDegreeTesseralSP < 0) {
                this.ghMSJ = new GHmsjPolynomials(auxiliaryElements.getK(), auxiliaryElements.getH(), auxiliaryElements.getAlpha(), auxiliaryElements.getBeta(), 1);
                this.gammaMNS = new GammaMnsFunction(DSSTTesseral.this.maxDegree, auxiliaryElements.getGamma(), 1);
                int maxRoaPower = FastMath.max(DSSTTesseral.this.maxDegreeTesseralSP, DSSTTesseral.this.maxDegreeMdailyTesseralSP);
                for (int i = 1; i <= maxRoaPower; ++i) {
                    this.roaPow[i] = context.getRoa() * this.roaPow[i - 1];
                }
                for (int m = 1; m <= DSSTTesseral.this.maxOrderMdailyTesseralSP; ++m) {
                    this.buildFourierCoefficients(date, m, 0, DSSTTesseral.this.maxDegreeMdailyTesseralSP, context, hansenObjects);
                }
                if (DSSTTesseral.this.maxDegreeTesseralSP >= 0) {
                    Iterator iterator = DSSTTesseral.this.nonResOrders.keySet().iterator();
                    while (iterator.hasNext()) {
                        int m = (Integer)iterator.next();
                        List listJ = (List)DSSTTesseral.this.nonResOrders.get(m);
                        Iterator iterator2 = listJ.iterator();
                        while (iterator2.hasNext()) {
                            int j = (Integer)iterator2.next();
                            this.buildFourierCoefficients(date, m, j, DSSTTesseral.this.maxDegreeTesseralSP, context, hansenObjects);
                        }
                    }
                }
            }
        }

        private void buildFourierCoefficients(AbsoluteDate date, int m, int j, int maxN, DSSTTesseralContext context, HansenObjects hansenObjects) {
            AuxiliaryElements auxiliaryElements = context.getAuxiliaryElements();
            double dRdaCos = 0.0;
            double dRdaSin = 0.0;
            double dRdhCos = 0.0;
            double dRdhSin = 0.0;
            double dRdkCos = 0.0;
            double dRdkSin = 0.0;
            double dRdlCos = 0.0;
            double dRdlSin = 0.0;
            double dRdAlCos = 0.0;
            double dRdAlSin = 0.0;
            double dRdBeCos = 0.0;
            double dRdBeSin = 0.0;
            double dRdGaCos = 0.0;
            double dRdGaSin = 0.0;
            int sMin = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            int sMax = j == 0 ? DSSTTesseral.this.maxEccPowMdailyTesseralSP : DSSTTesseral.this.maxEccPowTesseralSP;
            for (int s = 0; s <= sMax; ++s) {
                double[][] nSumSpos = DSSTTesseral.this.computeNSum(date, j, m, s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS, context, hansenObjects);
                dRdaCos += nSumSpos[0][0];
                dRdaSin += nSumSpos[0][1];
                dRdhCos += nSumSpos[1][0];
                dRdhSin += nSumSpos[1][1];
                dRdkCos += nSumSpos[2][0];
                dRdkSin += nSumSpos[2][1];
                dRdlCos += nSumSpos[3][0];
                dRdlSin += nSumSpos[3][1];
                dRdAlCos += nSumSpos[4][0];
                dRdAlSin += nSumSpos[4][1];
                dRdBeCos += nSumSpos[5][0];
                dRdBeSin += nSumSpos[5][1];
                dRdGaCos += nSumSpos[6][0];
                dRdGaSin += nSumSpos[6][1];
                if (s <= 0 || s > sMin) continue;
                double[][] nSumSneg = DSSTTesseral.this.computeNSum(date, j, m, -s, maxN, this.roaPow, this.ghMSJ, this.gammaMNS, context, hansenObjects);
                dRdaCos += nSumSneg[0][0];
                dRdaSin += nSumSneg[0][1];
                dRdhCos += nSumSneg[1][0];
                dRdhSin += nSumSneg[1][1];
                dRdkCos += nSumSneg[2][0];
                dRdkSin += nSumSneg[2][1];
                dRdlCos += nSumSneg[3][0];
                dRdlSin += nSumSneg[3][1];
                dRdAlCos += nSumSneg[4][0];
                dRdAlSin += nSumSneg[4][1];
                dRdBeCos += nSumSneg[5][0];
                dRdBeSin += nSumSneg[5][1];
                dRdGaCos += nSumSneg[6][0];
                dRdGaSin += nSumSneg[6][1];
            }
            dRdaCos *= -context.getMoa() / auxiliaryElements.getSma();
            dRdaSin *= -context.getMoa() / auxiliaryElements.getSma();
            dRdhCos *= context.getMoa();
            dRdhSin *= context.getMoa();
            dRdkCos *= context.getMoa();
            dRdkSin *= context.getMoa();
            dRdlCos *= context.getMoa();
            dRdlSin *= context.getMoa();
            double RAlphaGammaCos = auxiliaryElements.getAlpha() * (dRdGaCos *= context.getMoa()) - auxiliaryElements.getGamma() * (dRdAlCos *= context.getMoa());
            double RAlphaGammaSin = auxiliaryElements.getAlpha() * (dRdGaSin *= context.getMoa()) - auxiliaryElements.getGamma() * (dRdAlSin *= context.getMoa());
            double RAlphaBetaCos = auxiliaryElements.getAlpha() * (dRdBeCos *= context.getMoa()) - auxiliaryElements.getBeta() * dRdAlCos;
            double RAlphaBetaSin = auxiliaryElements.getAlpha() * (dRdBeSin *= context.getMoa()) - auxiliaryElements.getBeta() * dRdAlSin;
            double RBetaGammaCos = auxiliaryElements.getBeta() * dRdGaCos - auxiliaryElements.getGamma() * dRdBeCos;
            double RBetaGammaSin = auxiliaryElements.getBeta() * dRdGaSin - auxiliaryElements.getGamma() * dRdBeSin;
            double RhkCos = auxiliaryElements.getH() * dRdkCos - auxiliaryElements.getK() * dRdhCos;
            double RhkSin = auxiliaryElements.getH() * dRdkSin - auxiliaryElements.getK() * dRdhSin;
            double pRagmIqRbgoABCos = (auxiliaryElements.getP() * RAlphaGammaCos - 1.0 * auxiliaryElements.getQ() * RBetaGammaCos) * context.getOoAB();
            double pRagmIqRbgoABSin = (auxiliaryElements.getP() * RAlphaGammaSin - 1.0 * auxiliaryElements.getQ() * RBetaGammaSin) * context.getOoAB();
            double RhkmRabmdRdlCos = RhkCos - RAlphaBetaCos - dRdlCos;
            double RhkmRabmdRdlSin = RhkSin - RAlphaBetaSin - dRdlSin;
            this.cCoef[m][j + this.jMax][0] = context.getAx2oA() * dRdlCos;
            this.sCoef[m][j + this.jMax][0] = context.getAx2oA() * dRdlSin;
            this.cCoef[m][j + this.jMax][1] = -(context.getBoA() * dRdhCos + auxiliaryElements.getH() * pRagmIqRbgoABCos + auxiliaryElements.getK() * context.getBoABpo() * dRdlCos);
            this.sCoef[m][j + this.jMax][1] = -(context.getBoA() * dRdhSin + auxiliaryElements.getH() * pRagmIqRbgoABSin + auxiliaryElements.getK() * context.getBoABpo() * dRdlSin);
            this.cCoef[m][j + this.jMax][2] = context.getBoA() * dRdkCos + auxiliaryElements.getK() * pRagmIqRbgoABCos - auxiliaryElements.getH() * context.getBoABpo() * dRdlCos;
            this.sCoef[m][j + this.jMax][2] = context.getBoA() * dRdkSin + auxiliaryElements.getK() * pRagmIqRbgoABSin - auxiliaryElements.getH() * context.getBoABpo() * dRdlSin;
            this.cCoef[m][j + this.jMax][3] = context.getCo2AB() * (auxiliaryElements.getQ() * RhkmRabmdRdlCos - 1.0 * RAlphaGammaCos);
            this.sCoef[m][j + this.jMax][3] = context.getCo2AB() * (auxiliaryElements.getQ() * RhkmRabmdRdlSin - 1.0 * RAlphaGammaSin);
            this.cCoef[m][j + this.jMax][4] = context.getCo2AB() * (auxiliaryElements.getP() * RhkmRabmdRdlCos - RBetaGammaCos);
            this.sCoef[m][j + this.jMax][4] = context.getCo2AB() * (auxiliaryElements.getP() * RhkmRabmdRdlSin - RBetaGammaSin);
            this.cCoef[m][j + this.jMax][5] = -context.getAx2oA() * dRdaCos + context.getBoABpo() * (auxiliaryElements.getH() * dRdhCos + auxiliaryElements.getK() * dRdkCos) + pRagmIqRbgoABCos;
            this.sCoef[m][j + this.jMax][5] = -context.getAx2oA() * dRdaSin + context.getBoABpo() * (auxiliaryElements.getH() * dRdhSin + auxiliaryElements.getK() * dRdkSin) + pRagmIqRbgoABSin;
        }

        public double getCijm(int i, int j, int m) {
            return this.cCoef[m][j + this.jMax][i];
        }

        public double getSijm(int i, int j, int m) {
            return this.sCoef[m][j + this.jMax][i];
        }
    }
}

