/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.TreeMap;
import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.CoefficientsFactory;

public class FieldLnsCoefficients<T extends RealFieldElement<T>> {
    private final T[][] lns;
    private final T[][] dlns;

    public FieldLnsCoefficients(int nMax, int sMax, T[][] Qns, TreeMap<CoefficientsFactory.NSKey, Double> Vns, T roa, Field<T> field) {
        RealFieldElement zero = (RealFieldElement)field.getZero();
        int rows = nMax + 1;
        int columns = sMax + 1;
        this.lns = (RealFieldElement[][])MathArrays.buildArray(field, rows, columns);
        this.dlns = (RealFieldElement[][])MathArrays.buildArray(field, rows, columns);
        RealFieldElement[] roaPow = (RealFieldElement[])MathArrays.buildArray(field, rows);
        roaPow[0] = (RealFieldElement)zero.add(1.0);
        for (int i = 1; i <= nMax; ++i) {
            roaPow[i] = roa.multiply((RealFieldElement)roaPow[i - 1]);
        }
        for (int s = 0; s <= sMax; ++s) {
            for (int n = s; n <= nMax; ++n) {
                if ((n - s) % 2 == 0) {
                    RealFieldElement coef = (RealFieldElement)roaPow[n].multiply(Vns.get(new CoefficientsFactory.NSKey(n, s)));
                    this.lns[n][s] = (RealFieldElement)coef.multiply(Qns[n][s]);
                    if (n == s) {
                        this.dlns[n][s] = zero;
                        continue;
                    }
                    this.dlns[n][s] = (RealFieldElement)coef.multiply(Qns[n][s + 1]);
                    continue;
                }
                this.lns[n][s] = zero;
                this.dlns[n][s] = zero;
            }
        }
    }

    public T getLns(int n, int s) {
        return this.lns[n][s];
    }

    public T getdLnsdGamma(int n, int s) {
        return this.dlns[n][s];
    }
}

