/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import org.orekit.propagation.semianalytical.dsst.utilities.CjSjCoefficient;

public class GHIJjsPolynomials {
    private final CjSjCoefficient cjsjKH;
    private final CjSjCoefficient cjsjAB;

    public GHIJjsPolynomials(double k, double h, double alpha, double beta) {
        this.cjsjKH = new CjSjCoefficient(k, h);
        this.cjsjAB = new CjSjCoefficient(alpha, beta);
    }

    public double getGjs(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getCj(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getSj(s);
    }

    public double getdGjsdk(int j, int s) {
        return this.cjsjKH.getDcjDk(j) * this.cjsjAB.getCj(s) + this.cjsjKH.getDsjDk(j) * this.cjsjAB.getSj(s);
    }

    public double getdGjsdh(int j, int s) {
        return this.cjsjKH.getDcjDh(j) * this.cjsjAB.getCj(s) + this.cjsjKH.getDsjDh(j) * this.cjsjAB.getSj(s);
    }

    public double getdGjsdAlpha(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDcjDk(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getDsjDk(s);
    }

    public double getdGjsdBeta(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDcjDh(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getDsjDh(s);
    }

    public double getHjs(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getSj(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getCj(s);
    }

    public double getdHjsdk(int j, int s) {
        return this.cjsjKH.getDcjDk(j) * this.cjsjAB.getSj(s) - this.cjsjKH.getDsjDk(j) * this.cjsjAB.getCj(s);
    }

    public double getdHjsdh(int j, int s) {
        return this.cjsjKH.getDcjDh(j) * this.cjsjAB.getSj(s) - this.cjsjKH.getDsjDh(j) * this.cjsjAB.getCj(s);
    }

    public double getdHjsdAlpha(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDsjDk(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getDcjDk(s);
    }

    public double getdHjsdBeta(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDsjDh(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getDcjDh(s);
    }

    public double getIjs(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getSj(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getCj(s);
    }

    public double getdIjsdk(int j, int s) {
        return this.cjsjKH.getDcjDk(j) * this.cjsjAB.getSj(s) + this.cjsjKH.getDsjDk(j) * this.cjsjAB.getCj(s);
    }

    public double getdIjsdh(int j, int s) {
        return this.cjsjKH.getDcjDh(j) * this.cjsjAB.getSj(s) + this.cjsjKH.getDsjDh(j) * this.cjsjAB.getCj(s);
    }

    public double getdIjsdAlpha(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDsjDk(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getDcjDk(s);
    }

    public double getdIjsdBeta(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDsjDh(s) + this.cjsjKH.getSj(j) * this.cjsjAB.getDcjDh(s);
    }

    public double getJjs(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getCj(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getSj(s);
    }

    public double getdJjsdk(int j, int s) {
        return this.cjsjKH.getDcjDk(j) * this.cjsjAB.getCj(s) - this.cjsjKH.getDsjDk(j) * this.cjsjAB.getSj(s);
    }

    public double getdJjsdh(int j, int s) {
        return this.cjsjKH.getDcjDh(j) * this.cjsjAB.getCj(s) - this.cjsjKH.getDsjDh(j) * this.cjsjAB.getSj(s);
    }

    public double getdJjsdAlpha(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDcjDk(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getDsjDk(s);
    }

    public double getdJjsdBeta(int j, int s) {
        return this.cjsjKH.getCj(j) * this.cjsjAB.getDcjDh(s) - this.cjsjKH.getSj(j) * this.cjsjAB.getDsjDh(s);
    }
}

