/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.analysis.polynomials.PolynomialsUtils;

public class JacobiPolynomials {
    private static final Map<JacobiKey, List<PolynomialFunction>> MAP = new HashMap<JacobiKey, List<PolynomialFunction>>();

    private JacobiPolynomials() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DerivativeStructure getValue(int l, int v, int w, DerivativeStructure gamma) {
        PolynomialFunction polynomial;
        List<PolynomialFunction> polyList;
        Map<JacobiKey, List<PolynomialFunction>> map = MAP;
        synchronized (map) {
            JacobiKey key = new JacobiKey(v, w);
            if (!MAP.containsKey(key)) {
                MAP.put(key, new ArrayList());
            }
            polyList = MAP.get(key);
        }
        List<PolynomialFunction> list = polyList;
        synchronized (list) {
            for (int degree = polyList.size(); degree <= l; ++degree) {
                polyList.add(degree, PolynomialsUtils.createJacobiPolynomial(degree, v, w));
            }
            polynomial = polyList.get(l);
        }
        return polynomial.value(gamma);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends RealFieldElement<T>> FieldDerivativeStructure<T> getValue(int l, int v, int w, FieldDerivativeStructure<T> gamma) {
        PolynomialFunction polynomial;
        List<PolynomialFunction> polyList;
        Map<JacobiKey, List<PolynomialFunction>> map = MAP;
        synchronized (map) {
            JacobiKey key = new JacobiKey(v, w);
            if (!MAP.containsKey(key)) {
                MAP.put(key, new ArrayList());
            }
            polyList = MAP.get(key);
        }
        List<PolynomialFunction> list = polyList;
        synchronized (list) {
            for (int degree = polyList.size(); degree <= l; ++degree) {
                polyList.add(degree, PolynomialsUtils.createJacobiPolynomial(degree, v, w));
            }
            polynomial = polyList.get(l);
        }
        return polynomial.value(gamma);
    }

    private static class JacobiKey {
        private final int v;
        private final int w;

        JacobiKey(int v, int w) {
            this.v = v;
            this.w = w;
        }

        public int hashCode() {
            return this.v << 16 ^ this.w;
        }

        public boolean equals(Object key) {
            if (key == null || !(key instanceof JacobiKey)) {
                return false;
            }
            JacobiKey otherK = (JacobiKey)key;
            return this.v == otherK.v && this.w == otherK.w;
        }
    }
}

