/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.Field;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.PolynomialFunctionMatrix;

public class FieldHansenThirdBodyLinear<T extends RealFieldElement<T>> {
    private static final int SLICE = 10;
    private PolynomialFunction[][] mpvec;
    private PolynomialFunction[][] mpvecDeriv;
    private T[][] hansenRoot;
    private T[][] hansenDerivRoot;
    private int numSlices;
    private int nMax;
    private int N0;
    private int s;
    private double twosp1dfosp1f;
    private double twosp1dfosp2f;
    private double two2sp1dfosp2f;
    private double twosp3;

    public FieldHansenThirdBodyLinear(int nMax, int s, Field<T> field) {
        this.nMax = nMax;
        this.N0 = s;
        this.s = s;
        this.mpvec = new PolynomialFunction[this.nMax + 1][];
        this.mpvecDeriv = new PolynomialFunction[this.nMax + 1][];
        this.twosp1dfosp1f = s % 2 == 0 ? 1.0 : -1.0;
        for (int i = s; i >= 1; --i) {
            this.twosp1dfosp1f *= (2.0 * (double)i + 1.0) / ((double)i + 1.0);
        }
        this.twosp1dfosp2f = this.twosp1dfosp1f / ((double)s + 2.0);
        this.twosp3 = 2 * s + 3;
        this.two2sp1dfosp2f = 2.0 * this.twosp1dfosp2f;
        this.mpvec = new PolynomialFunction[this.nMax + 1][];
        this.mpvecDeriv = new PolynomialFunction[this.nMax + 1][];
        this.numSlices = FastMath.max(1, (nMax - s + 10 - 2) / 10);
        this.hansenRoot = (RealFieldElement[][])MathArrays.buildArray(field, this.numSlices, 2);
        this.hansenDerivRoot = (RealFieldElement[][])MathArrays.buildArray(field, this.numSlices, 2);
        this.generatePolynomials();
    }

    private PolynomialFunction a(int n) {
        double r1 = 2 * n + 1;
        double r2 = n + 1;
        return new PolynomialFunction(new double[]{r1 / r2});
    }

    private PolynomialFunction b(int n) {
        double r1 = (n + this.s) * (n - this.s);
        double r2 = n * (n + 1);
        return new PolynomialFunction(new double[]{0.0, 0.0, -r1 / r2});
    }

    private PolynomialFunction d(int n) {
        double r1 = 2 * (n + this.s) * (n - this.s);
        double r2 = n * (n + 1);
        return new PolynomialFunction(new double[]{0.0, 0.0, 0.0, r1 / r2});
    }

    private void generatePolynomials() {
        int sliceCounter = 0;
        PolynomialFunctionMatrix A = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix B = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix D = HansenUtilities.buildZeroMatrix2();
        PolynomialFunctionMatrix E = HansenUtilities.buildIdentityMatrix2();
        PolynomialFunctionMatrix a = HansenUtilities.buildZeroMatrix2();
        a.setElem(0, 1, HansenUtilities.ONE);
        for (int i = this.N0 + 2; i <= this.nMax; ++i) {
            a.setMatrixLine(1, new PolynomialFunction[]{this.b(i), this.a(i)});
            A = A.multiply(a);
            this.mpvec[i] = A.getMatrixLine(1);
            D = D.multiply(a);
            if (sliceCounter % 10 != 0) {
                a.setMatrixLine(1, new PolynomialFunction[]{this.b(i - 1), this.a(i - 1)});
                E = E.multiply(a);
            }
            B.setElem(1, 0, this.d(i));
            D = D.add(E.multiply(B));
            this.mpvecDeriv[i] = D.getMatrixLine(1);
            if (++sliceCounter % 10 != 0) continue;
            A = HansenUtilities.buildIdentityMatrix2();
            D = HansenUtilities.buildZeroMatrix2();
            E = HansenUtilities.buildIdentityMatrix2();
        }
    }

    public void computeInitValues(T chitm1, T chitm2, T chitm3) {
        Field field = chitm2.getField();
        RealFieldElement zero = (RealFieldElement)field.getZero();
        this.hansenRoot[0][0] = (RealFieldElement)zero.add(this.twosp1dfosp1f);
        this.hansenRoot[0][1] = (RealFieldElement)((RealFieldElement)((RealFieldElement)chitm2.negate()).add(this.twosp3)).multiply(this.twosp1dfosp2f);
        this.hansenDerivRoot[0][0] = zero;
        this.hansenDerivRoot[0][1] = (RealFieldElement)chitm3.multiply(this.two2sp1dfosp2f);
        for (int i = 1; i < this.numSlices; ++i) {
            for (int j = 0; j < 2; ++j) {
                PolynomialFunction[] mv = this.mpvec[this.s + i * 10 + j];
                PolynomialFunction[] sv = this.mpvecDeriv[this.s + i * 10 + j];
                this.hansenDerivRoot[i][j] = (RealFieldElement)((RealFieldElement)((RealFieldElement)((RealFieldElement)mv[1].value(chitm1).multiply(this.hansenDerivRoot[i - 1][1])).add(mv[0].value(chitm1).multiply(this.hansenDerivRoot[i - 1][0]))).add(sv[1].value(chitm1).multiply(this.hansenRoot[i - 1][1]))).add(sv[0].value(chitm1).multiply(this.hansenRoot[i - 1][0]));
                this.hansenRoot[i][j] = (RealFieldElement)((RealFieldElement)mv[1].value(chitm1).multiply(this.hansenRoot[i - 1][1])).add(mv[0].value(chitm1).multiply(this.hansenRoot[i - 1][0]));
            }
        }
    }

    public T getValue(int n, T chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        RealFieldElement ret = (RealFieldElement)v[1].value(chitm1).multiply(this.hansenRoot[sliceNo][1]);
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            ret = (RealFieldElement)ret.add(v[0].value(chitm1).multiply(this.hansenRoot[sliceNo][0]));
        }
        return (T)ret;
    }

    public T getDerivative(int n, T chitm1) {
        int sliceNo = (n - this.s) / 10;
        if (sliceNo < this.numSlices) {
            int indexInSlice = (n - this.s) % 10;
            if (indexInSlice <= 1) {
                return this.hansenDerivRoot[sliceNo][indexInSlice];
            }
        } else {
            --sliceNo;
        }
        PolynomialFunction[] v = this.mpvec[n];
        RealFieldElement ret = (RealFieldElement)v[1].value(chitm1).multiply(this.hansenDerivRoot[sliceNo][1]);
        if (this.hansenDerivRoot[sliceNo][0].getReal() != 0.0) {
            ret = (RealFieldElement)ret.add(v[0].value(chitm1).multiply(this.hansenDerivRoot[sliceNo][0]));
        }
        PolynomialFunction[] v1 = this.mpvecDeriv[n];
        ret = (RealFieldElement)ret.add(v1[1].value(chitm1).multiply(this.hansenRoot[sliceNo][1]));
        if (this.hansenRoot[sliceNo][0].getReal() != 0.0) {
            ret = (RealFieldElement)ret.add(v1[0].value(chitm1).multiply(this.hansenRoot[sliceNo][0]));
        }
        return (T)ret;
    }
}

