/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.propagation.semianalytical.dsst.utilities.hansen;

import org.hipparchus.analysis.polynomials.PolynomialFunction;
import org.orekit.propagation.semianalytical.dsst.utilities.hansen.HansenUtilities;

public class PolynomialFunctionMatrix {
    private int order;
    private PolynomialFunction[][] elements;

    PolynomialFunctionMatrix(int order) {
        this.order = order;
        this.elements = new PolynomialFunction[order][order];
    }

    public void setElem(int line, int column, PolynomialFunction value) {
        this.elements[line][column] = value;
    }

    public PolynomialFunction getElem(int line, int column) {
        return this.elements[line][column];
    }

    public PolynomialFunctionMatrix multiply(PolynomialFunctionMatrix matrix) {
        PolynomialFunctionMatrix result = new PolynomialFunctionMatrix(this.order);
        for (int i = 0; i < this.order; ++i) {
            for (int j = 0; j < this.order; ++j) {
                PolynomialFunction cc = HansenUtilities.ZERO;
                for (int k = 0; k < this.order; ++k) {
                    cc = cc.add(matrix.getElem(i, k).multiply(this.elements[k][j]));
                }
                result.setElem(i, j, cc);
            }
        }
        return result;
    }

    public void setMatrix(PolynomialFunction[][] polynomials) {
        this.elements = (PolynomialFunction[][])polynomials.clone();
    }

    public void setMatrixLine(int line, PolynomialFunction[] polynomials) {
        this.elements[line] = polynomials;
    }

    public PolynomialFunction[] getMatrixLine(int line) {
        return (PolynomialFunction[])this.elements[line].clone();
    }

    public PolynomialFunctionMatrix add(PolynomialFunctionMatrix matrix) {
        PolynomialFunctionMatrix c = new PolynomialFunctionMatrix(this.order);
        for (int i = 0; i < this.order; ++i) {
            for (int j = 0; j < this.order; ++j) {
                c.setElem(i, j, this.elements[i][j].add(matrix.getElem(i, j)));
            }
        }
        return c;
    }
}

