/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.ArrayList;
import java.util.List;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DatesSelector;
import org.orekit.time.TimeScale;

public class FixedStepSelector
implements DatesSelector {
    private final double step;
    private final TimeScale alignmentTimeScale;
    private AbsoluteDate last;

    public FixedStepSelector(double step, TimeScale alignmentTimeScale) {
        this.step = step;
        this.alignmentTimeScale = alignmentTimeScale;
        this.last = null;
    }

    @Override
    public List<AbsoluteDate> selectDates(AbsoluteDate start, AbsoluteDate end) {
        AbsoluteDate next;
        double sign = FastMath.copySign(1.0, end.durationFrom(start));
        ArrayList<AbsoluteDate> selected = new ArrayList<AbsoluteDate>();
        boolean reset = this.last == null || sign * start.durationFrom(this.last) > this.step;
        AbsoluteDate absoluteDate = next = reset ? start : this.last.shiftedBy(sign * this.step);
        while (sign * next.durationFrom(end) <= 0.0) {
            if (this.alignmentTimeScale != null) {
                double t = next.getComponents(this.alignmentTimeScale).getTime().getSecondsInLocalDay();
                double dt = this.step * (double)FastMath.round(t / this.step) - t;
                next = next.shiftedBy(dt);
            }
            if (sign * next.durationFrom(start) >= 0.0) {
                if (!(sign * next.durationFrom(end) <= 0.0)) break;
                selected.add(next);
            }
            this.last = next;
            next = this.last.shiftedBy(sign * this.step);
        }
        return selected;
    }
}

