/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.util.HashMap;
import java.util.Map;
import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum Month {
    JANUARY(1),
    FEBRUARY(2),
    MARCH(3),
    APRIL(4),
    MAY(5),
    JUNE(6),
    JULY(7),
    AUGUST(8),
    SEPTEMBER(9),
    OCTOBER(10),
    NOVEMBER(11),
    DECEMBER(12);

    private static final Map<String, Month> STRINGS_MAP;
    private static final Map<Integer, Month> NUMBERS_MAP;
    private final int number;
    private final String lowerCaseName;
    private final String capitalizedName;
    private final String upperCaseAbbreviation;
    private final String lowerCaseAbbreviation;
    private final String capitalizedAbbreviation;

    private Month(int number) {
        this.number = number;
        this.lowerCaseName = this.toString().toLowerCase();
        this.capitalizedName = this.toString().charAt(0) + this.lowerCaseName.substring(1);
        this.upperCaseAbbreviation = this.toString().substring(0, 3);
        this.lowerCaseAbbreviation = this.lowerCaseName.substring(0, 3);
        this.capitalizedAbbreviation = this.capitalizedName.substring(0, 3);
    }

    public int getNumber() {
        return this.number;
    }

    public String getUpperCaseName() {
        return this.toString();
    }

    public String getLowerCaseName() {
        return this.lowerCaseName;
    }

    public String getCapitalizedName() {
        return this.capitalizedName;
    }

    public String getUpperCaseAbbreviation() {
        return this.upperCaseAbbreviation;
    }

    public String getLowerCaseAbbreviation() {
        return this.lowerCaseAbbreviation;
    }

    public String getCapitalizedAbbreviation() {
        return this.capitalizedAbbreviation;
    }

    public static Month parseMonth(String s) {
        String normalizedString = s.trim().toLowerCase();
        Month month = STRINGS_MAP.get(normalizedString);
        if (month == null) {
            try {
                return Month.getMonth(Integer.parseInt(normalizedString));
            }
            catch (NumberFormatException nfe) {
                throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_MONTH, s);
            }
        }
        return month;
    }

    public static Month getMonth(int number) {
        Month month = NUMBERS_MAP.get(number);
        if (month == null) {
            throw new OrekitIllegalArgumentException(OrekitMessages.UNKNOWN_MONTH, number);
        }
        return month;
    }

    static {
        STRINGS_MAP = new HashMap<String, Month>();
        for (Month month : Month.values()) {
            STRINGS_MAP.put(month.getLowerCaseName(), month);
            STRINGS_MAP.put(month.getLowerCaseAbbreviation(), month);
        }
        NUMBERS_MAP = new HashMap<Integer, Month>();
        for (Month month : Month.values()) {
            NUMBERS_MAP.put(month.getNumber(), month);
        }
    }
}

