/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import org.hipparchus.RealFieldElement;
import org.hipparchus.util.FastMath;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.TimeScale;

public class TDBScale
implements TimeScale {
    private static final long serialVersionUID = 20131209L;
    private static final double G0 = 357.53;
    private static final double G1 = 0.9856003;
    private static final double SIN_G_FACTOR = 0.001658;
    private static final double SIN_2G_FACTOR = 1.4E-5;
    private final TimeScale tt;
    private final AbsoluteDate j2000Epoch;

    TDBScale(TimeScale tt, AbsoluteDate j2000Epoch) {
        this.tt = tt;
        this.j2000Epoch = j2000Epoch;
    }

    @Override
    public double offsetFromTAI(AbsoluteDate date) {
        double dtDays = date.durationFrom(this.j2000Epoch) / 86400.0;
        double g = FastMath.toRadians(357.53 + 0.9856003 * dtDays);
        return this.tt.offsetFromTAI(date) + (0.001658 * FastMath.sin(g) + 1.4E-5 * FastMath.sin(2.0 * g));
    }

    @Override
    public <T extends RealFieldElement<T>> T offsetFromTAI(FieldAbsoluteDate<T> date) {
        RealFieldElement dtDays = (RealFieldElement)date.durationFrom(this.j2000Epoch).divide(86400.0);
        RealFieldElement g = (RealFieldElement)((RealFieldElement)((RealFieldElement)dtDays.multiply(0.9856003)).add(357.53)).multiply(Math.PI / 180);
        return (T)((RealFieldElement)this.tt.offsetFromTAI(date).add(((RealFieldElement)((RealFieldElement)g.sin()).multiply(0.001658)).add(((RealFieldElement)((RealFieldElement)g.multiply(2)).sin()).multiply(1.4E-5))));
    }

    @Override
    public String getName() {
        return "TDB";
    }

    public String toString() {
        return this.getName();
    }
}

