/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.time;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hipparchus.exception.Localizable;
import org.hipparchus.util.FastMath;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.AbstractSelfFeedingLoader;
import org.orekit.data.DataContext;
import org.orekit.data.DataLoader;
import org.orekit.data.DataProvidersManager;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.DateComponents;
import org.orekit.time.OffsetModel;
import org.orekit.time.UTCTAIOffsetsLoader;

public class UTCTAIBulletinAFilesLoader
extends AbstractSelfFeedingLoader
implements UTCTAIOffsetsLoader {
    @DefaultDataContext
    public UTCTAIBulletinAFilesLoader(String supportedNames) {
        this(supportedNames, DataContext.getDefault().getDataProvidersManager());
    }

    public UTCTAIBulletinAFilesLoader(String supportedNames, DataProvidersManager manager) {
        super(supportedNames, manager);
    }

    @Override
    public List<OffsetModel> loadOffsets() {
        Parser parser = new Parser();
        this.feed(parser);
        SortedMap<Integer, Integer> taiUtc = parser.getTaiUtc();
        SortedMap<Integer, Double> ut1Utc = parser.getUt1Utc();
        ArrayList<Integer> leapDays = new ArrayList<Integer>();
        Map.Entry<Integer, Double> previous = null;
        for (Map.Entry<Integer, Double> entry : ut1Utc.entrySet()) {
            double delta;
            if (previous != null && FastMath.abs(delta = entry.getValue() - previous.getValue()) > 0.5) {
                leapDays.add(entry.getKey());
            }
            previous = entry;
        }
        ArrayList<OffsetModel> offsets = new ArrayList<OffsetModel>();
        if (!taiUtc.isEmpty()) {
            int n;
            Map.Entry<Integer, Integer> firstTaiMUtc = taiUtc.entrySet().iterator().next();
            int offset = firstTaiMUtc.getValue();
            int refMJD = firstTaiMUtc.getKey();
            Iterator<Object> iterator = leapDays.iterator();
            while (iterator.hasNext() && (n = ((Integer)iterator.next()).intValue()) <= refMJD) {
                --offset;
            }
            iterator = leapDays.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                offsets.add(new OffsetModel(new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, n2), ++offset));
            }
            for (Map.Entry entry : taiUtc.entrySet()) {
                DateComponents refDC = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, (Integer)entry.getKey() + 1);
                OffsetModel before = null;
                for (OffsetModel o : offsets) {
                    if (o.getStart().compareTo(refDC) >= 0) continue;
                    before = o;
                }
                if (before == null || (Integer)entry.getValue() == (int)FastMath.rint(before.getOffset())) continue;
                throw new OrekitException((Localizable)OrekitMessages.MISSING_EARTH_ORIENTATION_PARAMETERS_BETWEEN_DATES, before.getStart(), refDC);
            }
            if (offsets.isEmpty()) {
                offsets.add(0, new OffsetModel(new DateComponents(1972, 1, 1), (Integer)taiUtc.get(taiUtc.firstKey())));
            } else if (((OffsetModel)offsets.get(0)).getStart().getYear() > 1972) {
                offsets.add(0, new OffsetModel(new DateComponents(1972, 1, 1), (int)FastMath.rint(((OffsetModel)offsets.get(0)).getOffset()) - 1));
            }
        }
        return offsets;
    }

    private static class Parser
    implements DataLoader {
        private static final String LINE_START_REGEXP = "^\\p{Blank}+";
        private static final String LINE_END_REGEXP = "\\p{Blank}*$";
        private static final String INTEGER_REGEXP = "[-+]?\\p{Digit}+";
        private static final String REAL_REGEXP = "[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        private static final String STORED_INTEGER_FIELD = "\\p{Blank}*([-+]?\\p{Digit}+)";
        private static final String STORED_MJD_FIELD = "\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})";
        private static final String STORED_REAL_FIELD = "\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)";
        private static final String IGNORED_REAL_FIELD = "\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?";
        private final SortedMap<Integer, Integer> taiUtc = new TreeMap<Integer, Integer>();
        private final SortedMap<Integer, Double> ut1Utc = new TreeMap<Integer, Double>();
        private int lineNumber = 0;
        private String line;

        Parser() {
        }

        public SortedMap<Integer, Integer> getTaiUtc() {
            return this.taiUtc;
        }

        public SortedMap<Integer, Double> getUt1Utc() {
            return this.ut1Utc;
        }

        @Override
        public boolean stillAcceptsData() {
            return true;
        }

        @Override
        public void loadData(InputStream input, String name) throws IOException {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
            this.lineNumber = 0;
            ArrayList<Section> remaining = new ArrayList<Section>(Arrays.asList(Section.values()));
            Section section = this.nextSection(remaining, reader);
            while (section != null) {
                if (section == Section.TAI_UTC) {
                    this.loadTaiUtc(section, reader, name);
                } else {
                    this.loadTimeSteps(section, reader, name);
                }
                remaining.remove((Object)section);
                section = this.nextSection(remaining, reader);
            }
            if (remaining.contains((Object)Section.EOP_RAPID_SERVICE) || remaining.contains((Object)Section.EOP_PREDICTION)) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_A_SUPPORTED_IERS_DATA_FILE, name);
            }
        }

        private Section nextSection(List<Section> sections, BufferedReader reader) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                for (Section section : sections) {
                    if (!section.matchesHeader(this.line)) continue;
                    return section;
                }
                this.line = reader.readLine();
            }
            return null;
        }

        private void loadTaiUtc(Section section, BufferedReader reader, String name) throws IOException {
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                String[] fields = section.getFields(this.line);
                if (fields != null) {
                    int mjd = Integer.parseInt(fields[0]);
                    int offset = Integer.parseInt(fields[1]);
                    this.taiUtc.put(mjd, offset);
                    return;
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }

        private void loadTimeSteps(Section section, BufferedReader reader, String name) throws IOException {
            boolean inValuesPart = false;
            this.line = reader.readLine();
            while (this.line != null) {
                ++this.lineNumber;
                String[] fields = section.getFields(this.line);
                if (fields != null) {
                    inValuesPart = true;
                    int year = Integer.parseInt(fields[0]);
                    int month = Integer.parseInt(fields[1]);
                    int day = Integer.parseInt(fields[2]);
                    int mjd = Integer.parseInt(fields[3]);
                    DateComponents dc = new DateComponents(DateComponents.MODIFIED_JULIAN_EPOCH, mjd);
                    if (dc.getYear() % 100 != year % 100 || dc.getMonth() != month || dc.getDay() != day) {
                        throw new OrekitException((Localizable)OrekitMessages.INCONSISTENT_DATES_IN_IERS_FILE, name, year, month, day, mjd);
                    }
                    double offset = Double.parseDouble(fields[4]);
                    this.ut1Utc.put(mjd, offset);
                } else if (inValuesPart) {
                    return;
                }
                this.line = reader.readLine();
            }
            throw new OrekitException((Localizable)OrekitMessages.UNEXPECTED_END_OF_FILE_AFTER_LINE, name, this.lineNumber);
        }

        private static enum Section {
            EOP_RAPID_SERVICE("^ *COMBINED EARTH ORIENTATION PARAMETERS: *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}*$"),
            EOP_FINAL_VALUES("^ *IERS Final Values *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$"),
            TAI_UTC("^ *PREDICTIONS: *$", "^\\p{Blank}+TAI-UTC\\(MJD *\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\) *= *\\p{Blank}*([-+]?\\p{Digit}+)(?:\\.0*)?\\p{Blank}*$"),
            EOP_PREDICTION("^ *MJD *x\\(arcsec\\) *y\\(arcsec\\) *UT1-UTC\\(sec\\) *$", "^\\p{Blank}+\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}*([-+]?\\p{Digit}+)\\p{Blank}+(\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit}\\p{Digit})\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+[-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?\\p{Blank}+([-+]?(?:(?:\\p{Digit}+(?:\\.\\p{Digit}*)?)|(?:\\.\\p{Digit}+))(?:[eE][-+]?\\p{Digit}+)?)\\p{Blank}*$");

            private final Pattern header;
            private final Pattern data;

            private Section(String headerRegExp, String dataRegExp) {
                this.header = Pattern.compile(headerRegExp);
                this.data = Pattern.compile(dataRegExp);
            }

            public boolean matchesHeader(String l) {
                return this.header.matcher(l).matches();
            }

            public String[] getFields(String l) {
                Matcher matcher = this.data.matcher(l);
                if (matcher.matches()) {
                    String[] fields = new String[matcher.groupCount()];
                    for (int i = 0; i < fields.length; ++i) {
                        fields[i] = matcher.group(i + 1);
                    }
                    return fields;
                }
                return null;
            }
        }
    }
}

