/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.io.Serializable;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.linear.DecompositionSolver;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposition;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AngularCoordinates
implements TimeShiftable<AngularCoordinates>,
Serializable {
    public static final AngularCoordinates IDENTITY = new AngularCoordinates(Rotation.IDENTITY, Vector3D.ZERO, Vector3D.ZERO);
    private static final long serialVersionUID = 20140414L;
    private final Rotation rotation;
    private final Vector3D rotationRate;
    private final Vector3D rotationAcceleration;

    public AngularCoordinates() {
        this(Rotation.IDENTITY, Vector3D.ZERO, Vector3D.ZERO);
    }

    public AngularCoordinates(Rotation rotation, Vector3D rotationRate) {
        this(rotation, rotationRate, Vector3D.ZERO);
    }

    public AngularCoordinates(Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public AngularCoordinates(PVCoordinates u1, PVCoordinates u2, PVCoordinates v1, PVCoordinates v2, double tolerance) {
        try {
            this.rotation = new Rotation(u1.getPosition(), u2.getPosition(), v1.getPosition(), v2.getPosition());
            Vector3D ru1Dot = this.rotation.applyTo(u1.getVelocity());
            Vector3D ru2Dot = this.rotation.applyTo(u2.getVelocity());
            this.rotationRate = AngularCoordinates.inverseCrossProducts(v1.getPosition(), (Vector3D)ru1Dot.subtract((Vector)v1.getVelocity()), v2.getPosition(), (Vector3D)ru2Dot.subtract((Vector)v2.getVelocity()), tolerance);
            Vector3D ru1DotDot = this.rotation.applyTo(u1.getAcceleration());
            Vector3D oDotv1 = Vector3D.crossProduct(this.rotationRate, v1.getVelocity());
            Vector3D oov1 = Vector3D.crossProduct(this.rotationRate, Vector3D.crossProduct(this.rotationRate, v1.getPosition()));
            Vector3D c1 = new Vector3D(1.0, ru1DotDot, -2.0, oDotv1, -1.0, oov1, -1.0, v1.getAcceleration());
            Vector3D ru2DotDot = this.rotation.applyTo(u2.getAcceleration());
            Vector3D oDotv2 = Vector3D.crossProduct(this.rotationRate, v2.getVelocity());
            Vector3D oov2 = Vector3D.crossProduct(this.rotationRate, Vector3D.crossProduct(this.rotationRate, v2.getPosition()));
            Vector3D c2 = new Vector3D(1.0, ru2DotDot, -2.0, oDotv2, -1.0, oov2, -1.0, v2.getAcceleration());
            this.rotationAcceleration = AngularCoordinates.inverseCrossProducts(v1.getPosition(), c1, v2.getPosition(), c2, tolerance);
        }
        catch (MathRuntimeException mrte) {
            throw new OrekitException(mrte);
        }
    }

    public AngularCoordinates(PVCoordinates u, PVCoordinates v) {
        this(new FieldRotation<DerivativeStructure>(u.toDerivativeStructureVector(2), v.toDerivativeStructureVector(2)));
    }

    public AngularCoordinates(FieldRotation<DerivativeStructure> r) {
        double q0 = r.getQ0().getReal();
        double q1 = r.getQ1().getReal();
        double q2 = r.getQ2().getReal();
        double q3 = r.getQ3().getReal();
        this.rotation = new Rotation(q0, q1, q2, q3, false);
        if (r.getQ0().getOrder() >= 1) {
            double q0Dot = r.getQ0().getPartialDerivative(1);
            double q1Dot = r.getQ1().getPartialDerivative(1);
            double q2Dot = r.getQ2().getPartialDerivative(1);
            double q3Dot = r.getQ3().getPartialDerivative(1);
            this.rotationRate = new Vector3D(2.0 * MathArrays.linearCombination(-q1, q0Dot, q0, q1Dot, q3, q2Dot, -q2, q3Dot), 2.0 * MathArrays.linearCombination(-q2, q0Dot, -q3, q1Dot, q0, q2Dot, q1, q3Dot), 2.0 * MathArrays.linearCombination(-q3, q0Dot, q2, q1Dot, -q1, q2Dot, q0, q3Dot));
            if (r.getQ0().getOrder() >= 2) {
                double q0DotDot = r.getQ0().getPartialDerivative(2);
                double q1DotDot = r.getQ1().getPartialDerivative(2);
                double q2DotDot = r.getQ2().getPartialDerivative(2);
                double q3DotDot = r.getQ3().getPartialDerivative(2);
                this.rotationAcceleration = new Vector3D(2.0 * MathArrays.linearCombination(-q1, q0DotDot, q0, q1DotDot, q3, q2DotDot, -q2, q3DotDot), 2.0 * MathArrays.linearCombination(-q2, q0DotDot, -q3, q1DotDot, q0, q2DotDot, q1, q3DotDot), 2.0 * MathArrays.linearCombination(-q3, q0DotDot, q2, q1DotDot, -q1, q2DotDot, q0, q3DotDot));
            } else {
                this.rotationAcceleration = Vector3D.ZERO;
            }
        } else {
            this.rotationRate = Vector3D.ZERO;
            this.rotationAcceleration = Vector3D.ZERO;
        }
    }

    private static Vector3D inverseCrossProducts(Vector3D v1, Vector3D c1, Vector3D v2, Vector3D c2, double tolerance) throws MathIllegalArgumentException {
        Vector3D omega;
        double v12 = v1.getNormSq();
        double v1n = FastMath.sqrt(v12);
        double v22 = v2.getNormSq();
        double v2n = FastMath.sqrt(v22);
        double threshold = tolerance * FastMath.max(v1n, v2n);
        try {
            RealMatrix m = MatrixUtils.createRealMatrix(6, 3);
            m.setEntry(0, 1, v1.getZ());
            m.setEntry(0, 2, -v1.getY());
            m.setEntry(1, 0, -v1.getZ());
            m.setEntry(1, 2, v1.getX());
            m.setEntry(2, 0, v1.getY());
            m.setEntry(2, 1, -v1.getX());
            m.setEntry(3, 1, v2.getZ());
            m.setEntry(3, 2, -v2.getY());
            m.setEntry(4, 0, -v2.getZ());
            m.setEntry(4, 2, v2.getX());
            m.setEntry(5, 0, v2.getY());
            m.setEntry(5, 1, -v2.getX());
            RealVector rhs = MatrixUtils.createRealVector(new double[]{c1.getX(), c1.getY(), c1.getZ(), c2.getX(), c2.getY(), c2.getZ()});
            DecompositionSolver solver = new QRDecomposition(m, threshold).getSolver();
            RealVector v = solver.solve(rhs);
            omega = new Vector3D(v.getEntry(0), v.getEntry(1), v.getEntry(2));
        }
        catch (MathIllegalArgumentException miae) {
            if (miae.getSpecifier() == LocalizedCoreFormats.SINGULAR_MATRIX) {
                double c12 = c1.getNormSq();
                double c1n = FastMath.sqrt(c12);
                double c22 = c2.getNormSq();
                double c2n = FastMath.sqrt(c22);
                if (c1n <= threshold && c2n <= threshold) {
                    return Vector3D.ZERO;
                }
                if (v1n <= threshold && c1n >= threshold) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, c1n, 0, true);
                }
                if (v2n <= threshold && c2n >= threshold) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, c2n, 0, true);
                }
                if (Vector3D.crossProduct(v1, v2).getNorm() <= threshold && v12 > threshold) {
                    omega = new Vector3D(1.0 / v12, Vector3D.crossProduct(v1, c1));
                }
                throw miae;
            }
            throw miae;
        }
        double d1 = Vector3D.distance(Vector3D.crossProduct(omega, v1), c1);
        if (d1 > threshold) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, d1, 0, true);
        }
        double d2 = Vector3D.distance(Vector3D.crossProduct(omega, v2), c2);
        if (d2 > threshold) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, d2, 0, true);
        }
        return omega;
    }

    public FieldRotation<DerivativeStructure> toDerivativeStructureRotation(int order) {
        DerivativeStructure q3DS;
        DerivativeStructure q2DS;
        DerivativeStructure q1DS;
        DerivativeStructure q0DS;
        double q0 = this.rotation.getQ0();
        double q1 = this.rotation.getQ1();
        double q2 = this.rotation.getQ2();
        double q3 = this.rotation.getQ3();
        double oX = this.rotationRate.getX();
        double oY = this.rotationRate.getY();
        double oZ = this.rotationRate.getZ();
        double q0Dot = 0.5 * MathArrays.linearCombination(-q1, oX, -q2, oY, -q3, oZ);
        double q1Dot = 0.5 * MathArrays.linearCombination(q0, oX, -q3, oY, q2, oZ);
        double q2Dot = 0.5 * MathArrays.linearCombination(q3, oX, q0, oY, -q1, oZ);
        double q3Dot = 0.5 * MathArrays.linearCombination(-q2, oX, q1, oY, q0, oZ);
        double oXDot = this.rotationAcceleration.getX();
        double oYDot = this.rotationAcceleration.getY();
        double oZDot = this.rotationAcceleration.getZ();
        double q0DotDot = -0.5 * MathArrays.linearCombination(new double[]{q1, q2, q3, q1Dot, q2Dot, q3Dot}, new double[]{oXDot, oYDot, oZDot, oX, oY, oZ});
        double q1DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q2, -q3, q0Dot, q2Dot, -q3Dot}, new double[]{oXDot, oZDot, oYDot, oX, oZ, oY});
        double q2DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q3, -q1, q0Dot, q3Dot, -q1Dot}, new double[]{oYDot, oXDot, oZDot, oY, oX, oZ});
        double q3DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q1, -q2, q0Dot, q1Dot, -q2Dot}, new double[]{oZDot, oYDot, oXDot, oZ, oY, oX});
        switch (order) {
            case 0: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(q0);
                q1DS = factory.build(q1);
                q2DS = factory.build(q2);
                q3DS = factory.build(q3);
                break;
            }
            case 1: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(q0, q0Dot);
                q1DS = factory.build(q1, q1Dot);
                q2DS = factory.build(q2, q2Dot);
                q3DS = factory.build(q3, q3Dot);
                break;
            }
            case 2: {
                DSFactory factory = new DSFactory(1, order);
                q0DS = factory.build(q0, q0Dot, q0DotDot);
                q1DS = factory.build(q1, q1Dot, q1DotDot);
                q2DS = factory.build(q2, q2Dot, q2DotDot);
                q3DS = factory.build(q3, q3Dot, q3DotDot);
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldRotation<DerivativeStructure>(q0DS, q1DS, q2DS, q3DS, false);
    }

    public static Vector3D estimateRate(Rotation start, Rotation end, double dt) {
        Rotation evolution = start.compose(end.revert(), RotationConvention.VECTOR_OPERATOR);
        return new Vector3D(evolution.getAngle() / dt, evolution.getAxis(RotationConvention.VECTOR_OPERATOR));
    }

    public AngularCoordinates revert() {
        return new AngularCoordinates(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate).negate(), this.rotation.applyInverseTo(this.rotationAcceleration).negate());
    }

    @Override
    public AngularCoordinates shiftedBy(double dt) {
        double rate = this.rotationRate.getNorm();
        Rotation rateContribution = rate == 0.0 ? Rotation.IDENTITY : new Rotation(this.rotationRate, rate * dt, RotationConvention.FRAME_TRANSFORM);
        AngularCoordinates linearPart = new AngularCoordinates(rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        double acc = this.rotationAcceleration.getNorm();
        if (acc == 0.0) {
            return linearPart;
        }
        AngularCoordinates quadraticContribution = new AngularCoordinates(new Rotation(this.rotationAcceleration, 0.5 * acc * dt * dt, RotationConvention.FRAME_TRANSFORM), new Vector3D(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Vector3D getRotationRate() {
        return this.rotationRate;
    }

    public Vector3D getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public AngularCoordinates addOffset(AngularCoordinates offset) {
        Vector3D rOmega = this.rotation.applyTo(offset.rotationRate);
        Vector3D rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new AngularCoordinates(this.rotation.compose(offset.rotation, RotationConvention.VECTOR_OPERATOR), (Vector3D)this.rotationRate.add((Vector)rOmega), new Vector3D(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, Vector3D.crossProduct(this.rotationRate, rOmega)));
    }

    public AngularCoordinates subtractOffset(AngularCoordinates offset) {
        return this.addOffset(offset.revert());
    }

    public PVCoordinates applyTo(PVCoordinates pv) {
        Vector3D transformedP = this.rotation.applyTo(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct(this.rotationRate, transformedP);
        Vector transformedV = this.rotation.applyTo(pv.getVelocity()).subtract((Vector)crossP);
        Vector3D crossV = Vector3D.crossProduct(this.rotationRate, (Vector3D)transformedV);
        Vector3D crossCrossP = Vector3D.crossProduct(this.rotationRate, crossP);
        Vector3D crossDotP = Vector3D.crossProduct(this.rotationAcceleration, transformedP);
        Vector3D transformedA = new Vector3D(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new PVCoordinates(transformedP, (Vector3D)transformedV, transformedA);
    }

    public TimeStampedPVCoordinates applyTo(TimeStampedPVCoordinates pv) {
        Vector3D transformedP = this.getRotation().applyTo(pv.getPosition());
        Vector3D crossP = Vector3D.crossProduct(this.getRotationRate(), transformedP);
        Vector transformedV = this.getRotation().applyTo(pv.getVelocity()).subtract((Vector)crossP);
        Vector3D crossV = Vector3D.crossProduct(this.getRotationRate(), (Vector3D)transformedV);
        Vector3D crossCrossP = Vector3D.crossProduct(this.getRotationRate(), crossP);
        Vector3D crossDotP = Vector3D.crossProduct(this.getRotationAcceleration(), transformedP);
        Vector3D transformedA = new Vector3D(1.0, this.getRotation().applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedPVCoordinates(pv.getDate(), transformedP, (Vector3D)transformedV, transformedA);
    }

    public <T extends RealFieldElement<T>> FieldPVCoordinates<T> applyTo(FieldPVCoordinates<T> pv) {
        FieldVector3D<T> transformedP = FieldRotation.applyTo(this.rotation, pv.getPosition());
        FieldVector3D<T> crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D<T> transformedV = FieldRotation.applyTo(this.rotation, pv.getVelocity()).subtract(crossP);
        FieldVector3D<T> crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D<T> crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D<T> crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D<T> transformedA = new FieldVector3D<T>(1.0, FieldRotation.applyTo(this.rotation, pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates<T>(transformedP, transformedV, transformedA);
    }

    public <T extends RealFieldElement<T>> TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D transformedP = FieldRotation.applyTo(this.rotation, pv.getPosition());
        FieldVector3D crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D transformedV = FieldRotation.applyTo(this.rotation, pv.getVelocity()).subtract(crossP);
        FieldVector3D crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D transformedA = new FieldVector3D(1.0, FieldRotation.applyTo(this.rotation, pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public double[][] getModifiedRodrigues(double sign) {
        double q0 = sign * this.getRotation().getQ0();
        double q1 = sign * this.getRotation().getQ1();
        double q2 = sign * this.getRotation().getQ2();
        double q3 = sign * this.getRotation().getQ3();
        double oX = this.getRotationRate().getX();
        double oY = this.getRotationRate().getY();
        double oZ = this.getRotationRate().getZ();
        double oXDot = this.getRotationAcceleration().getX();
        double oYDot = this.getRotationAcceleration().getY();
        double oZDot = this.getRotationAcceleration().getZ();
        double q0Dot = 0.5 * MathArrays.linearCombination(-q1, oX, -q2, oY, -q3, oZ);
        double q1Dot = 0.5 * MathArrays.linearCombination(q0, oX, -q3, oY, q2, oZ);
        double q2Dot = 0.5 * MathArrays.linearCombination(q3, oX, q0, oY, -q1, oZ);
        double q3Dot = 0.5 * MathArrays.linearCombination(-q2, oX, q1, oY, q0, oZ);
        double q0DotDot = -0.5 * MathArrays.linearCombination(new double[]{q1, q2, q3, q1Dot, q2Dot, q3Dot}, new double[]{oXDot, oYDot, oZDot, oX, oY, oZ});
        double q1DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q2, -q3, q0Dot, q2Dot, -q3Dot}, new double[]{oXDot, oZDot, oYDot, oX, oZ, oY});
        double q2DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q3, -q1, q0Dot, q3Dot, -q1Dot}, new double[]{oYDot, oXDot, oZDot, oY, oX, oZ});
        double q3DotDot = 0.5 * MathArrays.linearCombination(new double[]{q0, q1, -q2, q0Dot, q1Dot, -q2Dot}, new double[]{oZDot, oYDot, oXDot, oZ, oY, oX});
        double inv = 1.0 / (1.0 + q0);
        double mTwoInvQ0Dot = -2.0 * inv * q0Dot;
        double r1 = inv * q1;
        double r2 = inv * q2;
        double r3 = inv * q3;
        double mInvR1 = -inv * r1;
        double mInvR2 = -inv * r2;
        double mInvR3 = -inv * r3;
        double r1Dot = MathArrays.linearCombination(inv, q1Dot, mInvR1, q0Dot);
        double r2Dot = MathArrays.linearCombination(inv, q2Dot, mInvR2, q0Dot);
        double r3Dot = MathArrays.linearCombination(inv, q3Dot, mInvR3, q0Dot);
        double r1DotDot = MathArrays.linearCombination(inv, q1DotDot, mTwoInvQ0Dot, r1Dot, mInvR1, q0DotDot);
        double r2DotDot = MathArrays.linearCombination(inv, q2DotDot, mTwoInvQ0Dot, r2Dot, mInvR2, q0DotDot);
        double r3DotDot = MathArrays.linearCombination(inv, q3DotDot, mTwoInvQ0Dot, r3Dot, mInvR3, q0DotDot);
        return new double[][]{{r1, r2, r3}, {r1Dot, r2Dot, r3Dot}, {r1DotDot, r2DotDot, r3DotDot}};
    }

    public static AngularCoordinates createFromModifiedRodrigues(double[][] r) {
        double rSquared = r[0][0] * r[0][0] + r[0][1] * r[0][1] + r[0][2] * r[0][2];
        double oPQ0 = 2.0 / (1.0 + rSquared);
        double q0 = oPQ0 - 1.0;
        double q1 = oPQ0 * r[0][0];
        double q2 = oPQ0 * r[0][1];
        double q3 = oPQ0 * r[0][2];
        double oPQ02 = oPQ0 * oPQ0;
        double q0Dot = -oPQ02 * MathArrays.linearCombination(r[0][0], r[1][0], r[0][1], r[1][1], r[0][2], r[1][2]);
        double q1Dot = oPQ0 * r[1][0] + r[0][0] * q0Dot;
        double q2Dot = oPQ0 * r[1][1] + r[0][1] * q0Dot;
        double q3Dot = oPQ0 * r[1][2] + r[0][2] * q0Dot;
        double oX = 2.0 * MathArrays.linearCombination(-q1, q0Dot, q0, q1Dot, q3, q2Dot, -q2, q3Dot);
        double oY = 2.0 * MathArrays.linearCombination(-q2, q0Dot, -q3, q1Dot, q0, q2Dot, q1, q3Dot);
        double oZ = 2.0 * MathArrays.linearCombination(-q3, q0Dot, q2, q1Dot, -q1, q2Dot, q0, q3Dot);
        double q0DotDot = (1.0 - q0) / oPQ0 * q0Dot * q0Dot - oPQ02 * MathArrays.linearCombination(r[0][0], r[2][0], r[0][1], r[2][1], r[0][2], r[2][2]) - (q1Dot * q1Dot + q2Dot * q2Dot + q3Dot * q3Dot);
        double q1DotDot = MathArrays.linearCombination(oPQ0, r[2][0], 2.0 * r[1][0], q0Dot, r[0][0], q0DotDot);
        double q2DotDot = MathArrays.linearCombination(oPQ0, r[2][1], 2.0 * r[1][1], q0Dot, r[0][1], q0DotDot);
        double q3DotDot = MathArrays.linearCombination(oPQ0, r[2][2], 2.0 * r[1][2], q0Dot, r[0][2], q0DotDot);
        double oXDot = 2.0 * MathArrays.linearCombination(-q1, q0DotDot, q0, q1DotDot, q3, q2DotDot, -q2, q3DotDot);
        double oYDot = 2.0 * MathArrays.linearCombination(-q2, q0DotDot, -q3, q1DotDot, q0, q2DotDot, q1, q3DotDot);
        double oZDot = 2.0 * MathArrays.linearCombination(-q3, q0DotDot, q2, q1DotDot, -q1, q2DotDot, q0, q3DotDot);
        return new AngularCoordinates(new Rotation(q0, q1, q2, q3, false), new Vector3D(oX, oY, oZ), new Vector3D(oXDot, oYDot, oZDot));
    }
}

