/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.orekit.errors.OrekitIllegalArgumentException;
import org.orekit.errors.OrekitMessages;

public enum CartesianDerivativesFilter {
    USE_P(0),
    USE_PV(1),
    USE_PVA(2);

    private final int maxOrder;

    private CartesianDerivativesFilter(int maxOrder) {
        this.maxOrder = maxOrder;
    }

    public int getMaxOrder() {
        return this.maxOrder;
    }

    public static CartesianDerivativesFilter getFilter(int order) throws IllegalArgumentException {
        for (CartesianDerivativesFilter filter : CartesianDerivativesFilter.values()) {
            if (filter.getMaxOrder() != order) continue;
            return filter;
        }
        throw new OrekitIllegalArgumentException(OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
    }
}

