/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.UnivariateVectorFunction;
import org.hipparchus.analysis.differentiation.DSFactory;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.hipparchus.analysis.differentiation.UnivariateDifferentiableVectorFunction;
import org.orekit.attitudes.AttitudeProvider;
import org.orekit.orbits.Orbit;
import org.orekit.orbits.OrbitType;
import org.orekit.orbits.PositionAngle;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.numerical.NumericalPropagator;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.ParameterFunction;
import org.orekit.utils.StateFunction;
import org.orekit.utils.StateJacobian;

public class Differentiation {
    private static final DSFactory FACTORY = new DSFactory(1, 1);

    private Differentiation() {
    }

    public static ParameterFunction differentiate(final ParameterFunction function, final int nbPoints, final double step) {
        return new ParameterFunction(){
            private final FiniteDifferencesDifferentiator differentiator;
            {
                this.differentiator = new FiniteDifferencesDifferentiator(nbPoints, step);
            }

            @Override
            public double value(final ParameterDriver driver) {
                UnivariateFunction uf = new UnivariateFunction(){

                    @Override
                    public double value(double value) {
                        double saved = driver.getValue();
                        driver.setValue(value);
                        double functionValue = function.value(driver);
                        driver.setValue(saved);
                        return functionValue;
                    }
                };
                DerivativeStructure dsParam = FACTORY.variable(0, driver.getValue());
                DerivativeStructure dsValue = this.differentiator.differentiate(uf).value(dsParam);
                return dsValue.getPartialDerivative(1);
            }
        };
    }

    public static StateJacobian differentiate(final StateFunction function, final int dimension, final AttitudeProvider provider, final OrbitType orbitType, final PositionAngle positionAngle, final double dP, final int nbPoints) {
        return new StateJacobian(){

            @Override
            public double[][] value(SpacecraftState state) {
                double[] tolerances = NumericalPropagator.tolerances(dP, state.getOrbit(), orbitType)[0];
                double[][] jacobian = new double[dimension][6];
                for (int j = 0; j < 6; ++j) {
                    StateComponentFunction componentJ = new StateComponentFunction(j, function, provider, state, orbitType, positionAngle);
                    FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, tolerances[j]);
                    UnivariateDifferentiableVectorFunction differentiatedJ = differentiator.differentiate(componentJ);
                    DerivativeStructure[] c = differentiatedJ.value(FACTORY.variable(0, 0.0));
                    for (int i = 0; i < dimension; ++i) {
                        jacobian[i][j] = c[i].getPartialDerivative(1);
                    }
                }
                return jacobian;
            }
        };
    }

    private static class StateComponentFunction
    implements UnivariateVectorFunction {
        private final int index;
        private final StateFunction f;
        private final OrbitType orbitType;
        private final PositionAngle positionAngle;
        private final SpacecraftState baseState;
        private final AttitudeProvider provider;

        StateComponentFunction(int index, StateFunction f, AttitudeProvider provider, SpacecraftState baseState, OrbitType orbitType, PositionAngle positionAngle) {
            this.index = index;
            this.f = f;
            this.provider = provider;
            this.orbitType = orbitType;
            this.positionAngle = positionAngle;
            this.baseState = baseState;
        }

        @Override
        public double[] value(double x) {
            double[] array = new double[6];
            double[] arrayDot = new double[6];
            this.orbitType.mapOrbitToArray(this.baseState.getOrbit(), this.positionAngle, array, arrayDot);
            int n = this.index;
            array[n] = array[n] + x;
            Orbit orbit = this.orbitType.mapArrayToOrbit(array, arrayDot, this.positionAngle, this.baseState.getDate(), this.baseState.getMu(), this.baseState.getFrame());
            SpacecraftState state = new SpacecraftState(orbit, this.provider.getAttitude(orbit, orbit.getDate(), orbit.getFrame()), this.baseState.getMass());
            return this.f.value(state);
        }
    }
}

