/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.RealFieldElement;
import org.hipparchus.analysis.differentiation.FDSFactory;
import org.hipparchus.analysis.differentiation.FieldDerivativeStructure;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.linear.FieldDecompositionSolver;
import org.hipparchus.linear.FieldMatrix;
import org.hipparchus.linear.FieldQRDecomposition;
import org.hipparchus.linear.FieldVector;
import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class FieldAngularCoordinates<T extends RealFieldElement<T>> {
    private final FieldRotation<T> rotation;
    private final FieldVector3D<T> rotationRate;
    private final FieldVector3D<T> rotationAcceleration;

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate) {
        this(rotation, rotationRate, new FieldVector3D<RealFieldElement>((RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero(), (RealFieldElement)rotation.getQ0().getField().getZero()));
    }

    public FieldAngularCoordinates(FieldRotation<T> rotation, FieldVector3D<T> rotationRate, FieldVector3D<T> rotationAcceleration) {
        this.rotation = rotation;
        this.rotationRate = rotationRate;
        this.rotationAcceleration = rotationAcceleration;
    }

    public FieldAngularCoordinates(FieldPVCoordinates<T> u1, FieldPVCoordinates<T> u2, FieldPVCoordinates<T> v1, FieldPVCoordinates<T> v2, double tolerance) {
        try {
            this.rotation = new FieldRotation<T>(u1.getPosition(), u2.getPosition(), v1.getPosition(), v2.getPosition());
            FieldVector3D<T> ru1Dot = this.rotation.applyTo(u1.getVelocity());
            FieldVector3D<T> ru2Dot = this.rotation.applyTo(u2.getVelocity());
            this.rotationRate = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), ru1Dot.subtract(v1.getVelocity()), v2.getPosition(), ru2Dot.subtract(v2.getVelocity()), tolerance);
            FieldVector3D<T> ru1DotDot = this.rotation.applyTo(u1.getAcceleration());
            FieldVector3D<T> oDotv1 = FieldVector3D.crossProduct(this.rotationRate, v1.getVelocity());
            FieldVector3D<T> oov1 = FieldVector3D.crossProduct(this.rotationRate, this.rotationRate.crossProduct(v1.getPosition()));
            FieldVector3D<T> c1 = new FieldVector3D<T>(1.0, ru1DotDot, -2.0, oDotv1, -1.0, oov1, -1.0, v1.getAcceleration());
            FieldVector3D<T> ru2DotDot = this.rotation.applyTo(u2.getAcceleration());
            FieldVector3D<T> oDotv2 = FieldVector3D.crossProduct(this.rotationRate, v2.getVelocity());
            FieldVector3D<T> oov2 = FieldVector3D.crossProduct(this.rotationRate, this.rotationRate.crossProduct(v2.getPosition()));
            FieldVector3D<T> c2 = new FieldVector3D<T>(1.0, ru2DotDot, -2.0, oDotv2, -1.0, oov2, -1.0, v2.getAcceleration());
            this.rotationAcceleration = FieldAngularCoordinates.inverseCrossProducts(v1.getPosition(), c1, v2.getPosition(), c2, tolerance);
        }
        catch (MathIllegalArgumentException miae) {
            throw new OrekitException(miae);
        }
    }

    public FieldAngularCoordinates(Field<T> field, AngularCoordinates ang) {
        this.rotation = new FieldRotation<T>(field, ang.getRotation());
        this.rotationRate = new FieldVector3D<T>(field, ang.getRotationRate());
        this.rotationAcceleration = new FieldVector3D<T>(field, ang.getRotationAcceleration());
    }

    public FieldAngularCoordinates(FieldRotation<FieldDerivativeStructure<T>> r) {
        Object q0 = r.getQ0().getValue();
        T q1 = r.getQ1().getValue();
        T q2 = r.getQ2().getValue();
        T q3 = r.getQ3().getValue();
        this.rotation = new FieldRotation<T>(q0, q1, q2, q3, false);
        if (r.getQ0().getOrder() >= 1) {
            T q0Dot = r.getQ0().getPartialDerivative(1);
            T q1Dot = r.getQ1().getPartialDerivative(1);
            T q2Dot = r.getQ2().getPartialDerivative(1);
            T q3Dot = r.getQ3().getPartialDerivative(1);
            this.rotationRate = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), q0Dot, q0, q1Dot, q3, q2Dot, q2.negate(), q3Dot)).multiply(2), (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), q0Dot, q3.negate(), q1Dot, q0, q2Dot, q1, q3Dot)).multiply(2), (RealFieldElement)((RealFieldElement)q0.linearCombination(q3.negate(), q0Dot, q2, q1Dot, q1.negate(), q2Dot, q0, q3Dot)).multiply(2));
            if (r.getQ0().getOrder() >= 2) {
                T q0DotDot = r.getQ0().getPartialDerivative(2);
                T q1DotDot = r.getQ1().getPartialDerivative(2);
                T q2DotDot = r.getQ2().getPartialDerivative(2);
                T q3DotDot = r.getQ3().getPartialDerivative(2);
                this.rotationAcceleration = new FieldVector3D<RealFieldElement>((RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), q0DotDot, q0, q1DotDot, q3, q2DotDot, q2.negate(), q3DotDot)).multiply(2), (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), q0DotDot, q3.negate(), q1DotDot, q0, q2DotDot, q1, q3DotDot)).multiply(2), (RealFieldElement)((RealFieldElement)q0.linearCombination(q3.negate(), q0DotDot, q2, q1DotDot, q1.negate(), q2DotDot, q0, q3DotDot)).multiply(2));
            } else {
                this.rotationAcceleration = FieldVector3D.getZero(q0.getField());
            }
        } else {
            this.rotationRate = FieldVector3D.getZero(q0.getField());
            this.rotationAcceleration = FieldVector3D.getZero(q0.getField());
        }
    }

    public static <T extends RealFieldElement<T>> FieldAngularCoordinates<T> getIdentity(Field<T> field) {
        return new FieldAngularCoordinates<T>(field, AngularCoordinates.IDENTITY);
    }

    private static <T extends RealFieldElement<T>> FieldVector3D<T> inverseCrossProducts(FieldVector3D<T> v1, FieldVector3D<T> c1, FieldVector3D<T> v2, FieldVector3D<T> c2, double tolerance) throws MathIllegalArgumentException {
        T v12 = v1.getNormSq();
        RealFieldElement v1n = (RealFieldElement)v12.sqrt();
        T v22 = v2.getNormSq();
        RealFieldElement v2n = (RealFieldElement)v22.sqrt();
        RealFieldElement threshold = v1n.getReal() >= v2n.getReal() ? (RealFieldElement)v1n.multiply(tolerance) : (RealFieldElement)v2n.multiply(tolerance);
        FieldVector3D<RealFieldElement> omega = null;
        try {
            FieldMatrix<T> m = MatrixUtils.createFieldMatrix(v12.getField(), 6, 3);
            m.setEntry(0, 1, v1.getZ());
            m.setEntry(0, 2, (FieldElement)v1.getY().negate());
            m.setEntry(1, 0, (FieldElement)v1.getZ().negate());
            m.setEntry(1, 2, v1.getX());
            m.setEntry(2, 0, v1.getY());
            m.setEntry(2, 1, (FieldElement)v1.getX().negate());
            m.setEntry(3, 1, v2.getZ());
            m.setEntry(3, 2, (FieldElement)v2.getY().negate());
            m.setEntry(4, 0, (FieldElement)v2.getZ().negate());
            m.setEntry(4, 2, v2.getX());
            m.setEntry(5, 0, v2.getY());
            m.setEntry(5, 1, (FieldElement)v2.getX().negate());
            FieldElement[] kk = (RealFieldElement[])MathArrays.buildArray(v2n.getField(), 6);
            kk[0] = c1.getX();
            kk[1] = c1.getY();
            kk[2] = c1.getZ();
            kk[3] = c2.getX();
            kk[4] = c2.getY();
            kk[5] = c2.getZ();
            FieldVector rhs = MatrixUtils.createFieldVector((FieldElement[])kk);
            FieldDecompositionSolver solver = new FieldQRDecomposition(m).getSolver();
            FieldVector v = solver.solve(rhs);
            omega = new FieldVector3D<RealFieldElement>((RealFieldElement)v.getEntry(0), (RealFieldElement)v.getEntry(1), (RealFieldElement)v.getEntry(2));
        }
        catch (MathIllegalArgumentException miae) {
            if (miae.getSpecifier() == LocalizedCoreFormats.SINGULAR_MATRIX) {
                T c12 = c1.getNormSq();
                RealFieldElement c1n = (RealFieldElement)c12.sqrt();
                T c22 = c2.getNormSq();
                RealFieldElement c2n = (RealFieldElement)c22.sqrt();
                if (c1n.getReal() <= threshold.getReal() && c2n.getReal() <= threshold.getReal()) {
                    return new FieldVector3D<RealFieldElement>((RealFieldElement)v12.getField().getZero(), (RealFieldElement)v12.getField().getZero(), (RealFieldElement)v12.getField().getZero());
                }
                if (v1n.getReal() <= threshold.getReal() && c1n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, c1n.getReal(), 0, true);
                }
                if (v2n.getReal() <= threshold.getReal() && c2n.getReal() >= threshold.getReal()) {
                    throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, c2n.getReal(), 0, true);
                }
                if (v1.crossProduct(v1).getNorm().getReal() <= threshold.getReal() && v12.getReal() > threshold.getReal()) {
                    omega = new FieldVector3D<RealFieldElement>((RealFieldElement)v12.reciprocal(), v1.crossProduct(c1));
                }
                throw miae;
            }
            throw miae;
        }
        RealFieldElement d1 = FieldVector3D.distance(omega.crossProduct(v1), c1);
        if (d1.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, 0, true);
        }
        RealFieldElement d2 = FieldVector3D.distance(omega.crossProduct(v2), c2);
        if (d2.getReal() > threshold.getReal()) {
            throw new MathIllegalArgumentException(LocalizedCoreFormats.NUMBER_TOO_LARGE, 0, true);
        }
        return omega;
    }

    public FieldRotation<FieldDerivativeStructure<T>> toDerivativeStructureRotation(int order) {
        FieldDerivativeStructure q3DS;
        FieldDerivativeStructure q2DS;
        FieldDerivativeStructure q1DS;
        FieldDerivativeStructure q0DS;
        Object q0 = this.rotation.getQ0();
        T q1 = this.rotation.getQ1();
        T q2 = this.rotation.getQ2();
        T q3 = this.rotation.getQ3();
        T oX = this.rotationRate.getX();
        T oY = this.rotationRate.getY();
        T oZ = this.rotationRate.getZ();
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), oX, q2.negate(), oY, q3.negate(), oZ)).multiply(0.5);
        RealFieldElement q1Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q0, oX, q3.negate(), oY, q2, oZ)).multiply(0.5);
        RealFieldElement q2Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q3, oX, q0, oY, q1.negate(), oZ)).multiply(0.5);
        RealFieldElement q3Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q2.negate(), oX, q1, oY, q0, oZ)).multiply(0.5);
        T oXDot = this.rotationAcceleration.getX();
        T oYDot = this.rotationAcceleration.getY();
        T oZDot = this.rotationAcceleration.getZ();
        RealFieldElement q0DotDot = (RealFieldElement)q0.linearCombination((RealFieldElement[])this.array6((RealFieldElement)q1, (RealFieldElement)q2, (RealFieldElement)q3, q1Dot, q2Dot, q3Dot), (RealFieldElement[])this.array6((RealFieldElement)oXDot, (RealFieldElement)oYDot, (RealFieldElement)oZDot, (RealFieldElement)oX, (RealFieldElement)oY, (RealFieldElement)oZ)).multiply(-0.5);
        RealFieldElement q1DotDot = (RealFieldElement)q0.linearCombination((RealFieldElement[])this.array6((RealFieldElement)q0, (RealFieldElement)q2, (RealFieldElement)q3.negate(), q0Dot, q2Dot, (RealFieldElement)q3Dot.negate()), (RealFieldElement[])this.array6((RealFieldElement)oXDot, (RealFieldElement)oZDot, (RealFieldElement)oYDot, (RealFieldElement)oX, (RealFieldElement)oZ, (RealFieldElement)oY)).multiply(0.5);
        RealFieldElement q2DotDot = (RealFieldElement)q0.linearCombination((RealFieldElement[])this.array6((RealFieldElement)q0, (RealFieldElement)q3, (RealFieldElement)q1.negate(), q0Dot, q3Dot, (RealFieldElement)q1Dot.negate()), (RealFieldElement[])this.array6((RealFieldElement)oYDot, (RealFieldElement)oXDot, (RealFieldElement)oZDot, (RealFieldElement)oY, (RealFieldElement)oX, (RealFieldElement)oZ)).multiply(0.5);
        RealFieldElement q3DotDot = (RealFieldElement)q0.linearCombination((RealFieldElement[])this.array6((RealFieldElement)q0, (RealFieldElement)q1, (RealFieldElement)q2.negate(), q0Dot, q1Dot, (RealFieldElement)q2Dot.negate()), (RealFieldElement[])this.array6((RealFieldElement)oZDot, (RealFieldElement)oYDot, (RealFieldElement)oXDot, (RealFieldElement)oZ, (RealFieldElement)oY, (RealFieldElement)oX)).multiply(0.5);
        switch (order) {
            case 0: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new RealFieldElement[]{q0});
                q1DS = factory.build(new RealFieldElement[]{q1});
                q2DS = factory.build(new RealFieldElement[]{q2});
                q3DS = factory.build(new RealFieldElement[]{q3});
                break;
            }
            case 1: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new RealFieldElement[]{q0, q0Dot});
                q1DS = factory.build(new RealFieldElement[]{q1, q1Dot});
                q2DS = factory.build(new RealFieldElement[]{q2, q2Dot});
                q3DS = factory.build(new RealFieldElement[]{q3, q3Dot});
                break;
            }
            case 2: {
                FDSFactory factory = new FDSFactory(q0.getField(), 1, order);
                q0DS = factory.build(new RealFieldElement[]{q0, q0Dot, q0DotDot});
                q1DS = factory.build(new RealFieldElement[]{q1, q1Dot, q1DotDot});
                q2DS = factory.build(new RealFieldElement[]{q2, q2Dot, q2DotDot});
                q3DS = factory.build(new RealFieldElement[]{q3, q3Dot, q3DotDot});
                break;
            }
            default: {
                throw new OrekitException((Localizable)OrekitMessages.OUT_OF_RANGE_DERIVATION_ORDER, order);
            }
        }
        return new FieldRotation<FieldDerivativeStructure<T>>(q0DS, q1DS, q2DS, q3DS, false);
    }

    private T[] array6(T e1, T e2, T e3, T e4, T e5, T e6) {
        RealFieldElement[] array = (RealFieldElement[])MathArrays.buildArray(e1.getField(), 6);
        array[0] = e1;
        array[1] = e2;
        array[2] = e3;
        array[3] = e4;
        array[4] = e5;
        array[5] = e6;
        return array;
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, double dt) {
        return FieldAngularCoordinates.estimateRate(start, end, (RealFieldElement)((RealFieldElement)start.getQ0().getField().getZero()).add(dt));
    }

    public static <T extends RealFieldElement<T>> FieldVector3D<T> estimateRate(FieldRotation<T> start, FieldRotation<T> end, T dt) {
        FieldRotation<T> evolution = start.compose(end.revert(), RotationConvention.VECTOR_OPERATOR);
        return new FieldVector3D<T>(evolution.getAngle().divide(dt), evolution.getAxis(RotationConvention.VECTOR_OPERATOR));
    }

    public FieldAngularCoordinates<T> revert() {
        return new FieldAngularCoordinates<T>(this.rotation.revert(), this.rotation.applyInverseTo(this.rotationRate.negate()), this.rotation.applyInverseTo(this.rotationAcceleration.negate()));
    }

    public FieldAngularCoordinates<T> shiftedBy(double dt) {
        return this.shiftedBy((RealFieldElement)((RealFieldElement)this.rotation.getQ0().getField().getZero()).add(dt));
    }

    public FieldAngularCoordinates<T> shiftedBy(T dt) {
        T rate = this.rotationRate.getNorm();
        RealFieldElement zero = (RealFieldElement)rate.getField().getZero();
        RealFieldElement one = (RealFieldElement)rate.getField().getOne();
        FieldRotation<RealFieldElement> rateContribution = rate.getReal() == 0.0 ? new FieldRotation<RealFieldElement>(one, zero, zero, zero, false) : new FieldRotation<RealFieldElement>(this.rotationRate, (RealFieldElement)rate.multiply(dt), RotationConvention.FRAME_TRANSFORM);
        FieldAngularCoordinates<RealFieldElement> linearPart = new FieldAngularCoordinates<RealFieldElement>(rateContribution.compose(this.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate);
        T acc = this.rotationAcceleration.getNorm();
        if (acc.getReal() == 0.0) {
            return linearPart;
        }
        FieldAngularCoordinates<RealFieldElement> quadraticContribution = new FieldAngularCoordinates<RealFieldElement>(new FieldRotation<RealFieldElement>(this.rotationAcceleration, (RealFieldElement)acc.multiply(((RealFieldElement)dt.multiply(0.5)).multiply(dt)), RotationConvention.FRAME_TRANSFORM), new FieldVector3D<T>(dt, this.rotationAcceleration), this.rotationAcceleration);
        return quadraticContribution.addOffset(linearPart);
    }

    public FieldRotation<T> getRotation() {
        return this.rotation;
    }

    public FieldVector3D<T> getRotationRate() {
        return this.rotationRate;
    }

    public FieldVector3D<T> getRotationAcceleration() {
        return this.rotationAcceleration;
    }

    public FieldAngularCoordinates<T> addOffset(FieldAngularCoordinates<T> offset) {
        FieldVector3D<T> rOmega = this.rotation.applyTo(offset.rotationRate);
        FieldVector3D<T> rOmegaDot = this.rotation.applyTo(offset.rotationAcceleration);
        return new FieldAngularCoordinates<T>(this.rotation.compose(offset.rotation, RotationConvention.VECTOR_OPERATOR), this.rotationRate.add(rOmega), new FieldVector3D<T>(1.0, this.rotationAcceleration, 1.0, rOmegaDot, -1.0, FieldVector3D.crossProduct(this.rotationRate, rOmega)));
    }

    public FieldAngularCoordinates<T> subtractOffset(FieldAngularCoordinates<T> offset) {
        return this.addOffset(offset.revert());
    }

    public AngularCoordinates toAngularCoordinates() {
        return new AngularCoordinates(this.rotation.toRotation(), this.rotationRate.toVector3D(), this.rotationAcceleration.toVector3D());
    }

    public FieldPVCoordinates<T> applyTo(PVCoordinates pv) {
        FieldVector3D<T> transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D<T> crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D<T> transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D<T> crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D<T> crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D<T> crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D<T> transformedA = new FieldVector3D<T>(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates<T>(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedPVCoordinates pv) {
        FieldVector3D<T> transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D<T> crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D<T> transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D<T> crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D<T> crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D<T> crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D<T> transformedA = new FieldVector3D<T>(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public FieldPVCoordinates<T> applyTo(FieldPVCoordinates<T> pv) {
        FieldVector3D<T> transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D<T> crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D<T> transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D<T> crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D<T> crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D<T> crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D<T> transformedA = new FieldVector3D<T>(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new FieldPVCoordinates<T>(transformedP, transformedV, transformedA);
    }

    public TimeStampedFieldPVCoordinates<T> applyTo(TimeStampedFieldPVCoordinates<T> pv) {
        FieldVector3D<T> transformedP = this.rotation.applyTo(pv.getPosition());
        FieldVector3D<T> crossP = FieldVector3D.crossProduct(this.rotationRate, transformedP);
        FieldVector3D<T> transformedV = this.rotation.applyTo(pv.getVelocity()).subtract(crossP);
        FieldVector3D<T> crossV = FieldVector3D.crossProduct(this.rotationRate, transformedV);
        FieldVector3D<T> crossCrossP = FieldVector3D.crossProduct(this.rotationRate, crossP);
        FieldVector3D<T> crossDotP = FieldVector3D.crossProduct(this.rotationAcceleration, transformedP);
        FieldVector3D<T> transformedA = new FieldVector3D<T>(1.0, this.rotation.applyTo(pv.getAcceleration()), -2.0, crossV, -1.0, crossCrossP, -1.0, crossDotP);
        return new TimeStampedFieldPVCoordinates<T>(pv.getDate(), transformedP, transformedV, transformedA);
    }

    public T[][] getModifiedRodrigues(double sign) {
        RealFieldElement q0 = (RealFieldElement)this.getRotation().getQ0().multiply(sign);
        RealFieldElement q1 = (RealFieldElement)this.getRotation().getQ1().multiply(sign);
        RealFieldElement q2 = (RealFieldElement)this.getRotation().getQ2().multiply(sign);
        RealFieldElement q3 = (RealFieldElement)this.getRotation().getQ3().multiply(sign);
        T oX = this.getRotationRate().getX();
        T oY = this.getRotationRate().getY();
        T oZ = this.getRotationRate().getZ();
        T oXDot = this.getRotationAcceleration().getX();
        T oYDot = this.getRotationAcceleration().getY();
        T oZDot = this.getRotationAcceleration().getZ();
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)q0.linearCombination(q1.negate(), oX, q2.negate(), oY, q3.negate(), oZ)).multiply(0.5);
        RealFieldElement q1Dot = (RealFieldElement)q0.linearCombination(q0, oX, q3.negate(), oY, q2, oZ).multiply(0.5);
        RealFieldElement q2Dot = (RealFieldElement)q0.linearCombination(q3, oX, q0, oY, q1.negate(), oZ).multiply(0.5);
        RealFieldElement q3Dot = (RealFieldElement)q0.linearCombination(q2.negate(), oX, q1, oY, q0, oZ).multiply(0.5);
        RealFieldElement q0DotDot = (RealFieldElement)this.linearCombination(q1, oXDot, q2, oYDot, q3, oZDot, q1Dot, oX, q2Dot, oY, q3Dot, oZ).multiply(-0.5);
        RealFieldElement q1DotDot = (RealFieldElement)this.linearCombination(q0, oXDot, q2, oZDot, (RealFieldElement)q3.negate(), oYDot, q0Dot, oX, q2Dot, oZ, (RealFieldElement)q3Dot.negate(), oY).multiply(0.5);
        RealFieldElement q2DotDot = (RealFieldElement)this.linearCombination(q0, oYDot, q3, oXDot, (RealFieldElement)q1.negate(), oZDot, q0Dot, oY, q3Dot, oX, (RealFieldElement)q1Dot.negate(), oZ).multiply(0.5);
        RealFieldElement q3DotDot = (RealFieldElement)this.linearCombination(q0, oZDot, q1, oYDot, (RealFieldElement)q2.negate(), oXDot, q0Dot, oZ, q1Dot, oY, (RealFieldElement)q2Dot.negate(), oX).multiply(0.5);
        RealFieldElement inv = (RealFieldElement)((RealFieldElement)q0.add(1.0)).reciprocal();
        RealFieldElement mTwoInvQ0Dot = (RealFieldElement)inv.multiply(q0Dot).multiply(-2);
        RealFieldElement r1 = inv.multiply(q1);
        RealFieldElement r2 = inv.multiply(q2);
        RealFieldElement r3 = inv.multiply(q3);
        RealFieldElement mInvR1 = (RealFieldElement)inv.multiply(r1).negate();
        RealFieldElement mInvR2 = (RealFieldElement)inv.multiply(r2).negate();
        RealFieldElement mInvR3 = (RealFieldElement)inv.multiply(r3).negate();
        RealFieldElement r1Dot = q0.linearCombination(inv, q1Dot, mInvR1, q0Dot);
        RealFieldElement r2Dot = q0.linearCombination(inv, q2Dot, mInvR2, q0Dot);
        RealFieldElement r3Dot = q0.linearCombination(inv, q3Dot, mInvR3, q0Dot);
        RealFieldElement r1DotDot = q0.linearCombination(inv, q1DotDot, mTwoInvQ0Dot, r1Dot, mInvR1, q0DotDot);
        RealFieldElement r2DotDot = q0.linearCombination(inv, q2DotDot, mTwoInvQ0Dot, r2Dot, mInvR2, q0DotDot);
        RealFieldElement r3DotDot = q0.linearCombination(inv, q3DotDot, mTwoInvQ0Dot, r3Dot, mInvR3, q0DotDot);
        RealFieldElement[][] rodrigues = (RealFieldElement[][])MathArrays.buildArray(q0.getField(), 3, 3);
        rodrigues[0][0] = r1;
        rodrigues[0][1] = r2;
        rodrigues[0][2] = r3;
        rodrigues[1][0] = r1Dot;
        rodrigues[1][1] = r2Dot;
        rodrigues[1][2] = r3Dot;
        rodrigues[2][0] = r1DotDot;
        rodrigues[2][1] = r2DotDot;
        rodrigues[2][2] = r3DotDot;
        return rodrigues;
    }

    private T linearCombination(T a1, T b1, T a2, T b2, T a3, T b3, T a4, T b4, T a5, T b5, T a6, T b6) {
        RealFieldElement[] a = (RealFieldElement[])MathArrays.buildArray(a1.getField(), 6);
        a[0] = a1;
        a[1] = a2;
        a[2] = a3;
        a[3] = a4;
        a[4] = a5;
        a[5] = a6;
        RealFieldElement[] b = (RealFieldElement[])MathArrays.buildArray(b1.getField(), 6);
        b[0] = b1;
        b[1] = b2;
        b[2] = b3;
        b[3] = b4;
        b[4] = b5;
        b[5] = b6;
        return (T)a1.linearCombination((RealFieldElement[])a, (RealFieldElement[])b);
    }

    public static <T extends RealFieldElement<T>> FieldAngularCoordinates<T> createFromModifiedRodrigues(T[][] r) {
        RealFieldElement rSquared = (RealFieldElement)((RealFieldElement)((RealFieldElement)r[0][0].multiply(r[0][0])).add(r[0][1].multiply(r[0][1]))).add(r[0][2].multiply(r[0][2]));
        RealFieldElement oPQ0 = (RealFieldElement)((RealFieldElement)((RealFieldElement)rSquared.add(1.0)).reciprocal()).multiply(2);
        RealFieldElement q0 = (RealFieldElement)oPQ0.subtract(1.0);
        RealFieldElement q1 = (RealFieldElement)oPQ0.multiply(r[0][0]);
        RealFieldElement q2 = (RealFieldElement)oPQ0.multiply(r[0][1]);
        RealFieldElement q3 = (RealFieldElement)oPQ0.multiply(r[0][2]);
        RealFieldElement oPQ02 = oPQ0.multiply(oPQ0);
        RealFieldElement q0Dot = (RealFieldElement)((RealFieldElement)oPQ02.multiply(q0.linearCombination(r[0][0], r[1][0], r[0][1], r[1][1], r[0][2], r[1][2]))).negate();
        RealFieldElement q1Dot = ((RealFieldElement)oPQ0.multiply(r[1][0])).add(r[0][0].multiply((RealFieldElement)q0Dot));
        RealFieldElement q2Dot = ((RealFieldElement)oPQ0.multiply(r[1][1])).add(r[0][1].multiply((RealFieldElement)q0Dot));
        RealFieldElement q3Dot = ((RealFieldElement)oPQ0.multiply(r[1][2])).add(r[0][2].multiply((RealFieldElement)q0Dot));
        RealFieldElement oX = (RealFieldElement)q0.linearCombination(q1.negate(), q0Dot, q0, q1Dot, q3, q2Dot, q2.negate(), q3Dot).multiply(2);
        RealFieldElement oY = (RealFieldElement)q0.linearCombination(q2.negate(), q0Dot, q3.negate(), q1Dot, q0, q2Dot, q1, q3Dot).multiply(2);
        RealFieldElement oZ = (RealFieldElement)q0.linearCombination(q3.negate(), q0Dot, q2, q1Dot, q1.negate(), q2Dot, q0, q3Dot).multiply(2);
        RealFieldElement q0DotDot = ((RealFieldElement)((RealFieldElement)((RealFieldElement)q0.subtract(1.0)).negate()).divide(oPQ0).multiply(q0Dot).multiply(q0Dot).subtract(oPQ02.multiply(q0.linearCombination(r[0][0], r[2][0], r[0][1], r[2][1], r[0][2], r[2][2])))).subtract(q1Dot.multiply(q1Dot).add(q2Dot.multiply(q2Dot)).add(q3Dot.multiply(q3Dot)));
        RealFieldElement q1DotDot = q0.linearCombination(oPQ0, r[2][0], r[1][0].add(r[1][0]), q0Dot, r[0][0], q0DotDot);
        RealFieldElement q2DotDot = q0.linearCombination(oPQ0, r[2][1], r[1][1].add(r[1][1]), q0Dot, r[0][1], q0DotDot);
        RealFieldElement q3DotDot = q0.linearCombination(oPQ0, r[2][2], r[1][2].add(r[1][2]), q0Dot, r[0][2], q0DotDot);
        RealFieldElement oXDot = (RealFieldElement)q0.linearCombination(q1.negate(), q0DotDot, q0, q1DotDot, q3, q2DotDot, q2.negate(), q3DotDot).multiply(2);
        RealFieldElement oYDot = (RealFieldElement)q0.linearCombination(q2.negate(), q0DotDot, q3.negate(), q1DotDot, q0, q2DotDot, q1, q3DotDot).multiply(2);
        RealFieldElement oZDot = (RealFieldElement)q0.linearCombination(q3.negate(), q0DotDot, q2, q1DotDot, q1.negate(), q2DotDot, q0, q3DotDot).multiply(2);
        return new FieldAngularCoordinates<RealFieldElement>(new FieldRotation<RealFieldElement>(q0, q1, q2, q3, false), new FieldVector3D<RealFieldElement>(oX, oY, oZ), new FieldVector3D<RealFieldElement>(oXDot, oYDot, oZDot));
    }
}

