/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collections;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ChronologicalComparator;
import org.orekit.time.TimeStamped;

public class TimeSpanMap<T> {
    private final NavigableSet<Transition<T>> data = new TreeSet<TimeStamped>(new ChronologicalComparator());

    public TimeSpanMap(T entry) {
        this.data.add(new Transition(AbsoluteDate.ARBITRARY_EPOCH, entry, entry));
    }

    public void addValidBefore(T entry, AbsoluteDate latestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(latestValidityDate, entry, single.getAfter()));
            return;
        }
        Transition previous = this.data.floor(new Transition(latestValidityDate, entry, null));
        if (previous == null) {
            this.data.add(new Transition(latestValidityDate, entry, ((Transition)this.data.first()).getBefore()));
        } else {
            this.data.remove(previous);
            this.data.add(new Transition(previous.date, previous.getBefore(), entry));
            this.data.add(new Transition(latestValidityDate, entry, previous.getAfter()));
        }
    }

    public void addValidAfter(T entry, AbsoluteDate earliestValidityDate) {
        Transition single;
        if (this.data.size() == 1 && (single = (Transition)this.data.first()).getBefore() == single.getAfter()) {
            this.data.clear();
            this.data.add(new Transition(earliestValidityDate, single.getBefore(), entry));
            return;
        }
        Transition next = this.data.ceiling(new Transition(earliestValidityDate, entry, null));
        if (next == null) {
            this.data.add(new Transition(earliestValidityDate, ((Transition)this.data.last()).getAfter(), entry));
        } else {
            this.data.remove(next);
            this.data.add(new Transition(earliestValidityDate, next.getBefore(), entry));
            this.data.add(new Transition(next.date, entry, next.getAfter()));
        }
    }

    public T get(AbsoluteDate date) {
        Transition previous = this.data.floor(new Transition(date, null, null));
        if (previous == null) {
            return (T)((Transition)this.data.first()).getBefore();
        }
        return (T)previous.getAfter();
    }

    public Span<T> getSpan(AbsoluteDate date) {
        Transition previous = this.data.floor(new Transition(date, null, null));
        if (previous == null) {
            return new Span(((Transition)this.data.first()).getBefore(), AbsoluteDate.PAST_INFINITY, ((Transition)this.data.first()).getDate());
        }
        Transition next = this.data.higher(previous);
        return new Span(previous.getAfter(), previous.getDate(), next == null ? AbsoluteDate.FUTURE_INFINITY : next.getDate());
    }

    public TimeSpanMap<T> extractRange(AbsoluteDate start, AbsoluteDate end) {
        NavigableSet inRange = this.data.subSet(new Transition(start, null, null), true, new Transition(end, null, null), true);
        if (inRange.isEmpty()) {
            return new TimeSpanMap<T>(this.get(start));
        }
        TimeSpanMap<Object> range = new TimeSpanMap<Object>(((Transition)inRange.first()).before);
        for (Transition transition : inRange) {
            range.addValidAfter(transition.after, transition.getDate());
        }
        return range;
    }

    public NavigableSet<Transition<T>> getTransitions() {
        return Collections.unmodifiableNavigableSet(this.data);
    }

    public static class Span<S> {
        private final S data;
        private final AbsoluteDate start;
        private final AbsoluteDate end;

        private Span(S data, AbsoluteDate start, AbsoluteDate end) {
            this.data = data;
            this.start = start;
            this.end = end;
        }

        public S getData() {
            return this.data;
        }

        public AbsoluteDate getStart() {
            return this.start;
        }

        public AbsoluteDate getEnd() {
            return this.end;
        }
    }

    public static class Transition<S>
    implements TimeStamped {
        private final AbsoluteDate date;
        private final S before;
        private final S after;

        private Transition(AbsoluteDate date, S before, S after) {
            this.date = date;
            this.before = before;
            this.after = after;
        }

        @Override
        public AbsoluteDate getDate() {
            return this.date;
        }

        public S getBefore() {
            return this.before;
        }

        public S getAfter() {
            return this.after;
        }
    }
}

