/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.utils;

import java.util.Collection;
import org.hipparchus.analysis.differentiation.DerivativeStructure;
import org.hipparchus.analysis.interpolation.HermiteInterpolator;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.FieldRotation;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.RotationConvention;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathArrays;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitInternalError;
import org.orekit.errors.OrekitMessages;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;
import org.orekit.utils.AngularCoordinates;
import org.orekit.utils.AngularDerivativesFilter;
import org.orekit.utils.PVCoordinates;

public class TimeStampedAngularCoordinates
extends AngularCoordinates
implements TimeStamped {
    private static final long serialVersionUID = 20140723L;
    private final AbsoluteDate date;

    public TimeStampedAngularCoordinates(AbsoluteDate date, Rotation rotation, Vector3D rotationRate, Vector3D rotationAcceleration) {
        super(rotation, rotationRate, rotationAcceleration);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u1, PVCoordinates u2, PVCoordinates v1, PVCoordinates v2, double tolerance) {
        super(u1, u2, v1, v2, tolerance);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, PVCoordinates u, PVCoordinates v) {
        super(u, v);
        this.date = date;
    }

    public TimeStampedAngularCoordinates(AbsoluteDate date, FieldRotation<DerivativeStructure> r) {
        super(r);
        this.date = date;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.date;
    }

    @Override
    public TimeStampedAngularCoordinates revert() {
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().revert(), this.getRotation().applyInverseTo(this.getRotationRate().negate()), this.getRotation().applyInverseTo(this.getRotationAcceleration().negate()));
    }

    @Override
    public TimeStampedAngularCoordinates shiftedBy(double dt) {
        AngularCoordinates sac = super.shiftedBy(dt);
        return new TimeStampedAngularCoordinates(this.date.shiftedBy(dt), sac.getRotation(), sac.getRotationRate(), sac.getRotationAcceleration());
    }

    @Override
    public TimeStampedAngularCoordinates addOffset(AngularCoordinates offset) {
        Vector3D rOmega = this.getRotation().applyTo(offset.getRotationRate());
        Vector3D rOmegaDot = this.getRotation().applyTo(offset.getRotationAcceleration());
        return new TimeStampedAngularCoordinates(this.date, this.getRotation().compose(offset.getRotation(), RotationConvention.VECTOR_OPERATOR), (Vector3D)this.getRotationRate().add((Vector)rOmega), new Vector3D(1.0, this.getRotationAcceleration(), 1.0, rOmegaDot, -1.0, Vector3D.crossProduct(this.getRotationRate(), rOmega)));
    }

    @Override
    public TimeStampedAngularCoordinates subtractOffset(AngularCoordinates offset) {
        return this.addOffset(offset.revert());
    }

    /*
     * WARNING - void declaration
     */
    public static TimeStampedAngularCoordinates interpolate(AbsoluteDate date, AngularDerivativesFilter filter, Collection<TimeStampedAngularCoordinates> sample) {
        void var10_12;
        Vector3D meanRate;
        Vector<Euclidean3D> sum;
        double epsilon = Math.PI * 2 / (double)sample.size();
        double threshold = FastMath.min(-0.9999, -FastMath.cos(epsilon / 4.0));
        if (filter != AngularDerivativesFilter.USE_R) {
            sum = Vector3D.ZERO;
            for (TimeStampedAngularCoordinates timeStampedAngularCoordinates : sample) {
                sum = ((Vector3D)sum).add((Vector)timeStampedAngularCoordinates.getRotationRate());
            }
            meanRate = new Vector3D(1.0 / (double)sample.size(), (Vector3D)sum);
        } else {
            if (sample.size() < 2) {
                throw new OrekitException((Localizable)OrekitMessages.NOT_ENOUGH_DATA_FOR_INTERPOLATION, sample.size());
            }
            sum = Vector3D.ZERO;
            TimeStampedAngularCoordinates previous = null;
            for (TimeStampedAngularCoordinates datedAC : sample) {
                if (previous != null) {
                    sum = ((Vector3D)sum).add((Vector)TimeStampedAngularCoordinates.estimateRate(previous.getRotation(), datedAC.getRotation(), datedAC.date.durationFrom(previous.date)));
                }
                previous = datedAC;
            }
            meanRate = new Vector3D(1.0 / (double)(sample.size() - 1), (Vector3D)sum);
        }
        TimeStampedAngularCoordinates offset = new TimeStampedAngularCoordinates(date, Rotation.IDENTITY, meanRate, Vector3D.ZERO);
        boolean restart = true;
        boolean bl = false;
        while (restart && var10_12 < sample.size() + 2) {
            restart = false;
            HermiteInterpolator interpolator = new HermiteInterpolator();
            double sign = 1.0;
            Rotation previous = Rotation.IDENTITY;
            block8: for (TimeStampedAngularCoordinates timeStampedAngularCoordinates : sample) {
                double dt = timeStampedAngularCoordinates.date.durationFrom(date);
                TimeStampedAngularCoordinates fixed = timeStampedAngularCoordinates.subtractOffset(offset.shiftedBy(dt));
                double dot = MathArrays.linearCombination(fixed.getRotation().getQ0(), previous.getQ0(), fixed.getRotation().getQ1(), previous.getQ1(), fixed.getRotation().getQ2(), previous.getQ2(), fixed.getRotation().getQ3(), previous.getQ3());
                sign = FastMath.copySign(1.0, dot * sign);
                previous = fixed.getRotation();
                if (fixed.getRotation().getQ0() * sign < threshold) {
                    restart = true;
                    break;
                }
                double[][] rodrigues = fixed.getModifiedRodrigues(sign);
                switch (filter) {
                    case USE_RRA: {
                        interpolator.addSamplePoint(dt, rodrigues[0], rodrigues[1], rodrigues[2]);
                        continue block8;
                    }
                    case USE_RR: {
                        interpolator.addSamplePoint(dt, rodrigues[0], rodrigues[1]);
                        continue block8;
                    }
                    case USE_R: {
                        interpolator.addSamplePoint(dt, new double[][]{rodrigues[0]});
                        continue block8;
                    }
                }
                throw new OrekitInternalError(null);
            }
            if (!restart) {
                double[][] p = interpolator.derivatives(0.0, 2);
                AngularCoordinates angularCoordinates = TimeStampedAngularCoordinates.createFromModifiedRodrigues(p);
                return new TimeStampedAngularCoordinates(offset.getDate(), angularCoordinates.getRotation(), angularCoordinates.getRotationRate(), angularCoordinates.getRotationAcceleration()).addOffset(offset);
            }
            offset = offset.addOffset(new AngularCoordinates(new Rotation(Vector3D.PLUS_I, epsilon, RotationConvention.VECTOR_OPERATOR), Vector3D.ZERO, Vector3D.ZERO));
            ++var10_12;
        }
        throw new OrekitInternalError(null);
    }
}

