# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class Fill(BaseModel):
    """
    Fill
    """ # noqa: E501
    fill_id: StrictStr = Field(description="Unique identifier for this fill")
    trade_id: StrictStr = Field(description="Unique identifier for this fill (legacy field name, same as fill_id)")
    order_id: StrictStr = Field(description="Unique identifier for the order that resulted in this fill")
    client_order_id: Optional[StrictStr] = Field(default=None, description="Client-provided identifier for the order that resulted in this fill")
    ticker: StrictStr = Field(description="Unique identifier for the market")
    market_ticker: StrictStr = Field(description="Unique identifier for the market (legacy field name, same as ticker)")
    side: StrictStr = Field(description="Specifies if this is a 'yes' or 'no' fill")
    action: StrictStr = Field(description="Specifies if this is a buy or sell order")
    count: StrictInt = Field(description="Number of contracts bought or sold in this fill")
    price: Union[StrictFloat, StrictInt] = Field(description="Fill price (deprecated - use yes_price or no_price)")
    yes_price: StrictInt = Field(description="Fill price for the yes side in cents")
    no_price: StrictInt = Field(description="Fill price for the no side in cents")
    yes_price_fixed: StrictStr = Field(description="Fill price for the yes side in fixed point dollars")
    no_price_fixed: StrictStr = Field(description="Fill price for the no side in fixed point dollars")
    is_taker: StrictBool = Field(description="If true, this fill was a taker (removed liquidity from the order book)")
    created_time: Optional[datetime] = Field(default=None, description="Timestamp when this fill was executed")
    ts: Optional[StrictInt] = Field(default=None, description="Unix timestamp when this fill was executed (legacy field name)")
    __properties: ClassVar[List[str]] = ["fill_id", "trade_id", "order_id", "client_order_id", "ticker", "market_ticker", "side", "action", "count", "price", "yes_price", "no_price", "yes_price_fixed", "no_price_fixed", "is_taker", "created_time", "ts"]

    @field_validator('side')
    def side_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['yes', 'no']):
            raise ValueError("must be one of enum values ('yes', 'no')")
        return value

    @field_validator('action')
    def action_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['buy', 'sell']):
            raise ValueError("must be one of enum values ('buy', 'sell')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Fill from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Fill from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fill_id": obj.get("fill_id"),
            "trade_id": obj.get("trade_id"),
            "order_id": obj.get("order_id"),
            "client_order_id": obj.get("client_order_id"),
            "ticker": obj.get("ticker"),
            "market_ticker": obj.get("market_ticker"),
            "side": obj.get("side"),
            "action": obj.get("action"),
            "count": obj.get("count"),
            "price": obj.get("price"),
            "yes_price": obj.get("yes_price"),
            "no_price": obj.get("no_price"),
            "yes_price_fixed": obj.get("yes_price_fixed"),
            "no_price_fixed": obj.get("no_price_fixed"),
            "is_taker": obj.get("is_taker"),
            "created_time": obj.get("created_time"),
            "ts": obj.get("ts")
        })
        return _obj


