# coding: utf-8

"""
    Kalshi Trade API Manual Endpoints

    Manually defined OpenAPI spec for endpoints being migrated to spec-first approach

    The version of the OpenAPI document: 3.2.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List
from kalshi_python_sync.models.scope_list import ScopeList
from typing import Optional, Set
from typing_extensions import Self

class SportFilterDetails(BaseModel):
    """
    SportFilterDetails
    """ # noqa: E501
    scopes: List[StrictStr] = Field(description="List of scopes available for this sport")
    competitions: Dict[str, ScopeList] = Field(description="Mapping of competitions to their scope lists")
    __properties: ClassVar[List[str]] = ["scopes", "competitions"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SportFilterDetails from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in competitions (dict)
        _field_dict = {}
        if self.competitions:
            for _key_competitions in self.competitions:
                if self.competitions[_key_competitions]:
                    _field_dict[_key_competitions] = self.competitions[_key_competitions].to_dict()
            _dict['competitions'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SportFilterDetails from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "scopes": obj.get("scopes"),
            "competitions": dict(
                (_k, ScopeList.from_dict(_v))
                for _k, _v in obj["competitions"].items()
            )
            if obj.get("competitions") is not None
            else None
        })
        return _obj


