# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AdvSecurityObjectListResponse(_serialization.Model):
    """advanced security object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: response value. Required.
    :vartype value: ~azure.mgmt.paloaltonetworks.models.AdvSecurityObjectModel
    :ivar next_link: next link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "AdvSecurityObjectModel"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: "_models.AdvSecurityObjectModel", next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: response value. Required.
        :paramtype value: ~azure.mgmt.paloaltonetworks.models.AdvSecurityObjectModel
        :keyword next_link: next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AdvSecurityObjectModel(_serialization.Model):
    """List of custom and predefined url category.

    All required parameters must be populated in order to send to Azure.

    :ivar type: type of object.
    :vartype type: str
    :ivar entry: URL entry. Required.
    :vartype entry: list[~azure.mgmt.paloaltonetworks.models.NameDescriptionObject]
    """

    _validation = {
        "entry": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "entry": {"key": "entry", "type": "[NameDescriptionObject]"},
    }

    def __init__(
        self, *, entry: List["_models.NameDescriptionObject"], type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: type of object.
        :paramtype type: str
        :keyword entry: URL entry. Required.
        :paramtype entry: list[~azure.mgmt.paloaltonetworks.models.NameDescriptionObject]
        """
        super().__init__(**kwargs)
        self.type = type
        self.entry = entry


class ApplicationInsights(_serialization.Model):
    """Application Insights key.

    :ivar id: Resource id for Application Insights.
    :vartype id: str
    :ivar key: Application Insights key.
    :vartype key: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "key": {"key": "key", "type": "str"},
    }

    def __init__(
        self, *, id: Optional[str] = None, key: Optional[str] = None, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Resource id for Application Insights.
        :paramtype id: str
        :keyword key: Application Insights key.
        :paramtype key: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.key = key


class AppSeenData(_serialization.Model):
    """Data Type for App Seen.

    All required parameters must be populated in order to send to Azure.

    :ivar count: number of rows. Required.
    :vartype count: int
    :ivar app_seen_list: array of appSeen. Required.
    :vartype app_seen_list: list[~azure.mgmt.paloaltonetworks.models.AppSeenInfo]
    """

    _validation = {
        "count": {"required": True},
        "app_seen_list": {"required": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "app_seen_list": {"key": "appSeenList", "type": "[AppSeenInfo]"},
    }

    def __init__(self, *, count: int, app_seen_list: List["_models.AppSeenInfo"], **kwargs: Any) -> None:
        """
        :keyword count: number of rows. Required.
        :paramtype count: int
        :keyword app_seen_list: array of appSeen. Required.
        :paramtype app_seen_list: list[~azure.mgmt.paloaltonetworks.models.AppSeenInfo]
        """
        super().__init__(**kwargs)
        self.count = count
        self.app_seen_list = app_seen_list


class AppSeenInfo(_serialization.Model):
    """Definition for App Seen.

    All required parameters must be populated in order to send to Azure.

    :ivar title: title. Required.
    :vartype title: str
    :ivar category: category. Required.
    :vartype category: str
    :ivar sub_category: subCategory. Required.
    :vartype sub_category: str
    :ivar risk: risk. Required.
    :vartype risk: str
    :ivar tag: tag. Required.
    :vartype tag: str
    :ivar technology: technology. Required.
    :vartype technology: str
    :ivar standard_ports: standardPorts. Required.
    :vartype standard_ports: str
    """

    _validation = {
        "title": {"required": True},
        "category": {"required": True},
        "sub_category": {"required": True},
        "risk": {"required": True},
        "tag": {"required": True},
        "technology": {"required": True},
        "standard_ports": {"required": True},
    }

    _attribute_map = {
        "title": {"key": "title", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "sub_category": {"key": "subCategory", "type": "str"},
        "risk": {"key": "risk", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "technology": {"key": "technology", "type": "str"},
        "standard_ports": {"key": "standardPorts", "type": "str"},
    }

    def __init__(
        self,
        *,
        title: str,
        category: str,
        sub_category: str,
        risk: str,
        tag: str,
        technology: str,
        standard_ports: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword title: title. Required.
        :paramtype title: str
        :keyword category: category. Required.
        :paramtype category: str
        :keyword sub_category: subCategory. Required.
        :paramtype sub_category: str
        :keyword risk: risk. Required.
        :paramtype risk: str
        :keyword tag: tag. Required.
        :paramtype tag: str
        :keyword technology: technology. Required.
        :paramtype technology: str
        :keyword standard_ports: standardPorts. Required.
        :paramtype standard_ports: str
        """
        super().__init__(**kwargs)
        self.title = title
        self.category = category
        self.sub_category = sub_category
        self.risk = risk
        self.tag = tag
        self.technology = technology
        self.standard_ports = standard_ports


class AzureResourceManagerManagedIdentityProperties(_serialization.Model):
    """The properties of the managed service identities assigned to this resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar tenant_id: The Active Directory tenant id of the principal.
    :vartype tenant_id: str
    :ivar principal_id: The active directory identifier of this principal.
    :vartype principal_id: str
    :ivar type: The type of managed identity assigned to this resource. Required. Known values are:
     "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.paloaltonetworks.models.ManagedIdentityType
    :ivar user_assigned_identities: The identities assigned to this resource by the user.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerUserAssignedIdentity]
    """

    _validation = {
        "tenant_id": {"readonly": True},
        "principal_id": {"readonly": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "tenant_id": {"key": "tenantId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{AzureResourceManagerUserAssignedIdentity}",
        },
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.AzureResourceManagerUserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity assigned to this resource. Required. Known values
         are: "None", "SystemAssigned", "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.paloaltonetworks.models.ManagedIdentityType
        :keyword user_assigned_identities: The identities assigned to this resource by the user.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerUserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.tenant_id = None
        self.principal_id = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class AzureResourceManagerUserAssignedIdentity(_serialization.Model):
    """A managed identity assigned by the user.

    :ivar client_id: The active directory client identifier for this principal.
    :vartype client_id: str
    :ivar principal_id: The active directory identifier for this principal.
    :vartype principal_id: str
    """

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
    }

    def __init__(self, *, client_id: Optional[str] = None, principal_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The active directory client identifier for this principal.
        :paramtype client_id: str
        :keyword principal_id: The active directory identifier for this principal.
        :paramtype principal_id: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.principal_id = principal_id


class Category(_serialization.Model):
    """URL/EDL to match.

    All required parameters must be populated in order to send to Azure.

    :ivar url_custom: custom URL. Required.
    :vartype url_custom: list[str]
    :ivar feeds: feed list. Required.
    :vartype feeds: list[str]
    """

    _validation = {
        "url_custom": {"required": True},
        "feeds": {"required": True},
    }

    _attribute_map = {
        "url_custom": {"key": "urlCustom", "type": "[str]"},
        "feeds": {"key": "feeds", "type": "[str]"},
    }

    def __init__(self, *, url_custom: List[str], feeds: List[str], **kwargs: Any) -> None:
        """
        :keyword url_custom: custom URL. Required.
        :paramtype url_custom: list[str]
        :keyword feeds: feed list. Required.
        :paramtype feeds: list[str]
        """
        super().__init__(**kwargs)
        self.url_custom = url_custom
        self.feeds = feeds


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class CertificateObjectGlobalRulestackResource(ProxyResource):
    """GlobalRulestack Certificate Object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar certificate_signer_resource_id: Resource Id of certificate signer, to be populated only
     when certificateSelfSigned is false.
    :vartype certificate_signer_resource_id: str
    :ivar certificate_self_signed: use certificate self signed. Required. Known values are: "TRUE"
     and "FALSE".
    :vartype certificate_self_signed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar description: user description for this object.
    :vartype description: str
    :ivar etag: read only string representing last create or update.
    :vartype etag: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "certificate_self_signed": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "certificate_signer_resource_id": {"key": "properties.certificateSignerResourceId", "type": "str"},
        "certificate_self_signed": {"key": "properties.certificateSelfSigned", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "etag": {"key": "properties.etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificate_self_signed: Union[str, "_models.BooleanEnum"],
        certificate_signer_resource_id: Optional[str] = None,
        audit_comment: Optional[str] = None,
        description: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificate_signer_resource_id: Resource Id of certificate signer, to be populated
         only when certificateSelfSigned is false.
        :paramtype certificate_signer_resource_id: str
        :keyword certificate_self_signed: use certificate self signed. Required. Known values are:
         "TRUE" and "FALSE".
        :paramtype certificate_self_signed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        :keyword description: user description for this object.
        :paramtype description: str
        :keyword etag: read only string representing last create or update.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.certificate_signer_resource_id = certificate_signer_resource_id
        self.certificate_self_signed = certificate_self_signed
        self.audit_comment = audit_comment
        self.description = description
        self.etag = etag
        self.provisioning_state = None


class CertificateObjectGlobalRulestackResourceListResult(_serialization.Model):
    """The response of a CertificateObjectGlobalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value:
     list[~azure.mgmt.paloaltonetworks.models.CertificateObjectGlobalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateObjectGlobalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.CertificateObjectGlobalRulestackResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.paloaltonetworks.models.CertificateObjectGlobalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CertificateObjectLocalRulestackResource(ProxyResource):
    """LocalRulestack Certificate Object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar certificate_signer_resource_id: Resource Id of certificate signer, to be populated only
     when certificateSelfSigned is false.
    :vartype certificate_signer_resource_id: str
    :ivar certificate_self_signed: use certificate self signed. Required. Known values are: "TRUE"
     and "FALSE".
    :vartype certificate_self_signed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar description: user description for this object.
    :vartype description: str
    :ivar etag: read only string representing last create or update.
    :vartype etag: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "certificate_self_signed": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "certificate_signer_resource_id": {"key": "properties.certificateSignerResourceId", "type": "str"},
        "certificate_self_signed": {"key": "properties.certificateSelfSigned", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "etag": {"key": "properties.etag", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificate_self_signed: Union[str, "_models.BooleanEnum"],
        certificate_signer_resource_id: Optional[str] = None,
        audit_comment: Optional[str] = None,
        description: Optional[str] = None,
        etag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword certificate_signer_resource_id: Resource Id of certificate signer, to be populated
         only when certificateSelfSigned is false.
        :paramtype certificate_signer_resource_id: str
        :keyword certificate_self_signed: use certificate self signed. Required. Known values are:
         "TRUE" and "FALSE".
        :paramtype certificate_self_signed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        :keyword description: user description for this object.
        :paramtype description: str
        :keyword etag: read only string representing last create or update.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.certificate_signer_resource_id = certificate_signer_resource_id
        self.certificate_self_signed = certificate_self_signed
        self.audit_comment = audit_comment
        self.description = description
        self.etag = etag
        self.provisioning_state = None


class CertificateObjectLocalRulestackResourceListResult(_serialization.Model):
    """The response of a CertificateObjectLocalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value:
     list[~azure.mgmt.paloaltonetworks.models.CertificateObjectLocalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateObjectLocalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.CertificateObjectLocalRulestackResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value:
         list[~azure.mgmt.paloaltonetworks.models.CertificateObjectLocalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Changelog(_serialization.Model):
    """Changelog list.

    All required parameters must be populated in order to send to Azure.

    :ivar changes: list of changes. Required.
    :vartype changes: list[str]
    :ivar last_committed: lastCommitted timestamp.
    :vartype last_committed: ~datetime.datetime
    :ivar last_modified: lastModified timestamp.
    :vartype last_modified: ~datetime.datetime
    """

    _validation = {
        "changes": {"required": True},
    }

    _attribute_map = {
        "changes": {"key": "changes", "type": "[str]"},
        "last_committed": {"key": "lastCommitted", "type": "iso-8601"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        changes: List[str],
        last_committed: Optional[datetime.datetime] = None,
        last_modified: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword changes: list of changes. Required.
        :paramtype changes: list[str]
        :keyword last_committed: lastCommitted timestamp.
        :paramtype last_committed: ~datetime.datetime
        :keyword last_modified: lastModified timestamp.
        :paramtype last_modified: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.changes = changes
        self.last_committed = last_committed
        self.last_modified = last_modified


class CountriesResponse(_serialization.Model):
    """Countries Response Object.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of countries. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.Country]
    :ivar next_link: next link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Country]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Country"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of countries. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.Country]
        :keyword next_link: next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Country(_serialization.Model):
    """Country Description.

    All required parameters must be populated in order to send to Azure.

    :ivar code: country code. Required.
    :vartype code: str
    :ivar description: code description.
    :vartype description: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, code: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: country code. Required.
        :paramtype code: str
        :keyword description: code description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.description = description


class DestinationAddr(_serialization.Model):
    """destination address.

    :ivar cidrs: special value 'any'.
    :vartype cidrs: list[str]
    :ivar countries: list of countries.
    :vartype countries: list[str]
    :ivar feeds: list of feeds.
    :vartype feeds: list[str]
    :ivar prefix_lists: prefix list.
    :vartype prefix_lists: list[str]
    :ivar fqdn_lists: fqdn list.
    :vartype fqdn_lists: list[str]
    """

    _attribute_map = {
        "cidrs": {"key": "cidrs", "type": "[str]"},
        "countries": {"key": "countries", "type": "[str]"},
        "feeds": {"key": "feeds", "type": "[str]"},
        "prefix_lists": {"key": "prefixLists", "type": "[str]"},
        "fqdn_lists": {"key": "fqdnLists", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        cidrs: Optional[List[str]] = None,
        countries: Optional[List[str]] = None,
        feeds: Optional[List[str]] = None,
        prefix_lists: Optional[List[str]] = None,
        fqdn_lists: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cidrs: special value 'any'.
        :paramtype cidrs: list[str]
        :keyword countries: list of countries.
        :paramtype countries: list[str]
        :keyword feeds: list of feeds.
        :paramtype feeds: list[str]
        :keyword prefix_lists: prefix list.
        :paramtype prefix_lists: list[str]
        :keyword fqdn_lists: fqdn list.
        :paramtype fqdn_lists: list[str]
        """
        super().__init__(**kwargs)
        self.cidrs = cidrs
        self.countries = countries
        self.feeds = feeds
        self.prefix_lists = prefix_lists
        self.fqdn_lists = fqdn_lists


class DNSSettings(_serialization.Model):
    """DNS Proxy settings for Firewall.

    :ivar enable_dns_proxy: Enable DNS proxy, disabled by default. Known values are: "DISABLED" and
     "ENABLED".
    :vartype enable_dns_proxy: str or ~azure.mgmt.paloaltonetworks.models.DNSProxy
    :ivar enabled_dns_type: Enabled DNS proxy type, disabled by default. Known values are: "CUSTOM"
     and "AZURE".
    :vartype enabled_dns_type: str or ~azure.mgmt.paloaltonetworks.models.EnabledDNSType
    :ivar dns_servers: List of IPs associated with the Firewall.
    :vartype dns_servers: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
    """

    _attribute_map = {
        "enable_dns_proxy": {"key": "enableDnsProxy", "type": "str"},
        "enabled_dns_type": {"key": "enabledDnsType", "type": "str"},
        "dns_servers": {"key": "dnsServers", "type": "[IPAddress]"},
    }

    def __init__(
        self,
        *,
        enable_dns_proxy: Optional[Union[str, "_models.DNSProxy"]] = None,
        enabled_dns_type: Optional[Union[str, "_models.EnabledDNSType"]] = None,
        dns_servers: Optional[List["_models.IPAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enable_dns_proxy: Enable DNS proxy, disabled by default. Known values are: "DISABLED"
         and "ENABLED".
        :paramtype enable_dns_proxy: str or ~azure.mgmt.paloaltonetworks.models.DNSProxy
        :keyword enabled_dns_type: Enabled DNS proxy type, disabled by default. Known values are:
         "CUSTOM" and "AZURE".
        :paramtype enabled_dns_type: str or ~azure.mgmt.paloaltonetworks.models.EnabledDNSType
        :keyword dns_servers: List of IPs associated with the Firewall.
        :paramtype dns_servers: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
        """
        super().__init__(**kwargs)
        self.enable_dns_proxy = enable_dns_proxy
        self.enabled_dns_type = enabled_dns_type
        self.dns_servers = dns_servers


class EndpointConfiguration(_serialization.Model):
    """Endpoint Configuration for frontend and backend.

    All required parameters must be populated in order to send to Azure.

    :ivar port: port ID. Required.
    :vartype port: str
    :ivar address: Address Space. Required.
    :vartype address: ~azure.mgmt.paloaltonetworks.models.IPAddress
    """

    _validation = {
        "port": {"required": True},
        "address": {"required": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "str"},
        "address": {"key": "address", "type": "IPAddress"},
    }

    def __init__(self, *, port: str, address: "_models.IPAddress", **kwargs: Any) -> None:
        """
        :keyword port: port ID. Required.
        :paramtype port: str
        :keyword address: Address Space. Required.
        :paramtype address: ~azure.mgmt.paloaltonetworks.models.IPAddress
        """
        super().__init__(**kwargs)
        self.port = port
        self.address = address


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.paloaltonetworks.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.paloaltonetworks.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.paloaltonetworks.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.paloaltonetworks.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventHub(_serialization.Model):
    """EventHub configurations.

    :ivar id: Resource ID of EventHub.
    :vartype id: str
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    :ivar name: EventHub name.
    :vartype name: str
    :ivar name_space: EventHub namespace.
    :vartype name_space: str
    :ivar policy_name: EventHub policy name.
    :vartype policy_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "name_space": {"key": "nameSpace", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subscription_id: Optional[str] = None,
        name: Optional[str] = None,
        name_space: Optional[str] = None,
        policy_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of EventHub.
        :paramtype id: str
        :keyword subscription_id: Subscription Id.
        :paramtype subscription_id: str
        :keyword name: EventHub name.
        :paramtype name: str
        :keyword name_space: EventHub namespace.
        :paramtype name_space: str
        :keyword policy_name: EventHub policy name.
        :paramtype policy_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.subscription_id = subscription_id
        self.name = name
        self.name_space = name_space
        self.policy_name = policy_name


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class FirewallResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """PaloAltoNetworks Firewall.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar pan_etag: panEtag info.
    :vartype pan_etag: str
    :ivar network_profile: Network settings. Required.
    :vartype network_profile: ~azure.mgmt.paloaltonetworks.models.NetworkProfile
    :ivar is_panorama_managed: Panorama Managed: Default is False. Default will be CloudSec
     managed. Known values are: "TRUE" and "FALSE".
    :vartype is_panorama_managed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar panorama_config: Panorama Configuration.
    :vartype panorama_config: ~azure.mgmt.paloaltonetworks.models.PanoramaConfig
    :ivar associated_rulestack: Associated Rulestack.
    :vartype associated_rulestack: ~azure.mgmt.paloaltonetworks.models.RulestackDetails
    :ivar dns_settings: DNS settings for Firewall. Required.
    :vartype dns_settings: ~azure.mgmt.paloaltonetworks.models.DNSSettings
    :ivar front_end_settings: Frontend settings for Firewall.
    :vartype front_end_settings: list[~azure.mgmt.paloaltonetworks.models.FrontendSetting]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    :ivar plan_data: Billing plan information. Required.
    :vartype plan_data: ~azure.mgmt.paloaltonetworks.models.PlanData
    :ivar marketplace_details: Marketplace details. Required.
    :vartype marketplace_details: ~azure.mgmt.paloaltonetworks.models.MarketplaceDetails
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "network_profile": {"required": True},
        "dns_settings": {"required": True},
        "provisioning_state": {"readonly": True},
        "plan_data": {"required": True},
        "marketplace_details": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "pan_etag": {"key": "properties.panEtag", "type": "str"},
        "network_profile": {"key": "properties.networkProfile", "type": "NetworkProfile"},
        "is_panorama_managed": {"key": "properties.isPanoramaManaged", "type": "str"},
        "panorama_config": {"key": "properties.panoramaConfig", "type": "PanoramaConfig"},
        "associated_rulestack": {"key": "properties.associatedRulestack", "type": "RulestackDetails"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "DNSSettings"},
        "front_end_settings": {"key": "properties.frontEndSettings", "type": "[FrontendSetting]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "plan_data": {"key": "properties.planData", "type": "PlanData"},
        "marketplace_details": {"key": "properties.marketplaceDetails", "type": "MarketplaceDetails"},
    }

    def __init__(
        self,
        *,
        location: str,
        network_profile: "_models.NetworkProfile",
        dns_settings: "_models.DNSSettings",
        plan_data: "_models.PlanData",
        marketplace_details: "_models.MarketplaceDetails",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        pan_etag: Optional[str] = None,
        is_panorama_managed: Optional[Union[str, "_models.BooleanEnum"]] = None,
        panorama_config: Optional["_models.PanoramaConfig"] = None,
        associated_rulestack: Optional["_models.RulestackDetails"] = None,
        front_end_settings: Optional[List["_models.FrontendSetting"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword pan_etag: panEtag info.
        :paramtype pan_etag: str
        :keyword network_profile: Network settings. Required.
        :paramtype network_profile: ~azure.mgmt.paloaltonetworks.models.NetworkProfile
        :keyword is_panorama_managed: Panorama Managed: Default is False. Default will be CloudSec
         managed. Known values are: "TRUE" and "FALSE".
        :paramtype is_panorama_managed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword panorama_config: Panorama Configuration.
        :paramtype panorama_config: ~azure.mgmt.paloaltonetworks.models.PanoramaConfig
        :keyword associated_rulestack: Associated Rulestack.
        :paramtype associated_rulestack: ~azure.mgmt.paloaltonetworks.models.RulestackDetails
        :keyword dns_settings: DNS settings for Firewall. Required.
        :paramtype dns_settings: ~azure.mgmt.paloaltonetworks.models.DNSSettings
        :keyword front_end_settings: Frontend settings for Firewall.
        :paramtype front_end_settings: list[~azure.mgmt.paloaltonetworks.models.FrontendSetting]
        :keyword plan_data: Billing plan information. Required.
        :paramtype plan_data: ~azure.mgmt.paloaltonetworks.models.PlanData
        :keyword marketplace_details: Marketplace details. Required.
        :paramtype marketplace_details: ~azure.mgmt.paloaltonetworks.models.MarketplaceDetails
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.pan_etag = pan_etag
        self.network_profile = network_profile
        self.is_panorama_managed = is_panorama_managed
        self.panorama_config = panorama_config
        self.associated_rulestack = associated_rulestack
        self.dns_settings = dns_settings
        self.front_end_settings = front_end_settings
        self.provisioning_state = None
        self.plan_data = plan_data
        self.marketplace_details = marketplace_details


class FirewallResourceListResult(_serialization.Model):
    """The response of a FirewallResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.FirewallResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FirewallResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.FirewallResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.FirewallResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FirewallResourceUpdate(_serialization.Model):
    """The type used for update operations of the FirewallResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the FirewallResource.
    :vartype properties: ~azure.mgmt.paloaltonetworks.models.FirewallResourceUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "FirewallResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.FirewallResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the FirewallResource.
        :paramtype properties: ~azure.mgmt.paloaltonetworks.models.FirewallResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.properties = properties


class FirewallResourceUpdateProperties(_serialization.Model):
    """The updatable properties of the FirewallResource.

    :ivar pan_etag: panEtag info.
    :vartype pan_etag: str
    :ivar network_profile: Network settings.
    :vartype network_profile: ~azure.mgmt.paloaltonetworks.models.NetworkProfile
    :ivar is_panorama_managed: Panorama Managed: Default is False. Default will be CloudSec
     managed. Known values are: "TRUE" and "FALSE".
    :vartype is_panorama_managed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar panorama_config: Panorama Configuration.
    :vartype panorama_config: ~azure.mgmt.paloaltonetworks.models.PanoramaConfig
    :ivar associated_rulestack: Associated Rulestack.
    :vartype associated_rulestack: ~azure.mgmt.paloaltonetworks.models.RulestackDetails
    :ivar dns_settings: DNS settings for Firewall.
    :vartype dns_settings: ~azure.mgmt.paloaltonetworks.models.DNSSettings
    :ivar front_end_settings: Frontend settings for Firewall.
    :vartype front_end_settings: list[~azure.mgmt.paloaltonetworks.models.FrontendSetting]
    :ivar plan_data: Billing plan information.
    :vartype plan_data: ~azure.mgmt.paloaltonetworks.models.PlanData
    :ivar marketplace_details: Marketplace details.
    :vartype marketplace_details: ~azure.mgmt.paloaltonetworks.models.MarketplaceDetails
    """

    _attribute_map = {
        "pan_etag": {"key": "panEtag", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfile"},
        "is_panorama_managed": {"key": "isPanoramaManaged", "type": "str"},
        "panorama_config": {"key": "panoramaConfig", "type": "PanoramaConfig"},
        "associated_rulestack": {"key": "associatedRulestack", "type": "RulestackDetails"},
        "dns_settings": {"key": "dnsSettings", "type": "DNSSettings"},
        "front_end_settings": {"key": "frontEndSettings", "type": "[FrontendSetting]"},
        "plan_data": {"key": "planData", "type": "PlanData"},
        "marketplace_details": {"key": "marketplaceDetails", "type": "MarketplaceDetails"},
    }

    def __init__(
        self,
        *,
        pan_etag: Optional[str] = None,
        network_profile: Optional["_models.NetworkProfile"] = None,
        is_panorama_managed: Optional[Union[str, "_models.BooleanEnum"]] = None,
        panorama_config: Optional["_models.PanoramaConfig"] = None,
        associated_rulestack: Optional["_models.RulestackDetails"] = None,
        dns_settings: Optional["_models.DNSSettings"] = None,
        front_end_settings: Optional[List["_models.FrontendSetting"]] = None,
        plan_data: Optional["_models.PlanData"] = None,
        marketplace_details: Optional["_models.MarketplaceDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pan_etag: panEtag info.
        :paramtype pan_etag: str
        :keyword network_profile: Network settings.
        :paramtype network_profile: ~azure.mgmt.paloaltonetworks.models.NetworkProfile
        :keyword is_panorama_managed: Panorama Managed: Default is False. Default will be CloudSec
         managed. Known values are: "TRUE" and "FALSE".
        :paramtype is_panorama_managed: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword panorama_config: Panorama Configuration.
        :paramtype panorama_config: ~azure.mgmt.paloaltonetworks.models.PanoramaConfig
        :keyword associated_rulestack: Associated Rulestack.
        :paramtype associated_rulestack: ~azure.mgmt.paloaltonetworks.models.RulestackDetails
        :keyword dns_settings: DNS settings for Firewall.
        :paramtype dns_settings: ~azure.mgmt.paloaltonetworks.models.DNSSettings
        :keyword front_end_settings: Frontend settings for Firewall.
        :paramtype front_end_settings: list[~azure.mgmt.paloaltonetworks.models.FrontendSetting]
        :keyword plan_data: Billing plan information.
        :paramtype plan_data: ~azure.mgmt.paloaltonetworks.models.PlanData
        :keyword marketplace_details: Marketplace details.
        :paramtype marketplace_details: ~azure.mgmt.paloaltonetworks.models.MarketplaceDetails
        """
        super().__init__(**kwargs)
        self.pan_etag = pan_etag
        self.network_profile = network_profile
        self.is_panorama_managed = is_panorama_managed
        self.panorama_config = panorama_config
        self.associated_rulestack = associated_rulestack
        self.dns_settings = dns_settings
        self.front_end_settings = front_end_settings
        self.plan_data = plan_data
        self.marketplace_details = marketplace_details


class FqdnListGlobalRulestackResource(ProxyResource):
    """GlobalRulestack fqdnList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar description: fqdn object description.
    :vartype description: str
    :ivar fqdn_list: fqdn list. Required.
    :vartype fqdn_list: list[str]
    :ivar etag: etag info.
    :vartype etag: str
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "fqdn_list": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "fqdn_list": {"key": "properties.fqdnList", "type": "[str]"},
        "etag": {"key": "properties.etag", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        fqdn_list: List[str],
        description: Optional[str] = None,
        etag: Optional[str] = None,
        audit_comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: fqdn object description.
        :paramtype description: str
        :keyword fqdn_list: fqdn list. Required.
        :paramtype fqdn_list: list[str]
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.fqdn_list = fqdn_list
        self.etag = etag
        self.audit_comment = audit_comment
        self.provisioning_state = None


class FqdnListGlobalRulestackResourceListResult(_serialization.Model):
    """The response of a FqdnListGlobalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.FqdnListGlobalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FqdnListGlobalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.FqdnListGlobalRulestackResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.FqdnListGlobalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FqdnListLocalRulestackResource(ProxyResource):
    """LocalRulestack fqdnList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar description: fqdn object description.
    :vartype description: str
    :ivar fqdn_list: fqdn list. Required.
    :vartype fqdn_list: list[str]
    :ivar etag: etag info.
    :vartype etag: str
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "fqdn_list": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "fqdn_list": {"key": "properties.fqdnList", "type": "[str]"},
        "etag": {"key": "properties.etag", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        fqdn_list: List[str],
        description: Optional[str] = None,
        etag: Optional[str] = None,
        audit_comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: fqdn object description.
        :paramtype description: str
        :keyword fqdn_list: fqdn list. Required.
        :paramtype fqdn_list: list[str]
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.fqdn_list = fqdn_list
        self.etag = etag
        self.audit_comment = audit_comment
        self.provisioning_state = None


class FqdnListLocalRulestackResourceListResult(_serialization.Model):
    """The response of a FqdnListLocalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.FqdnListLocalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[FqdnListLocalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.FqdnListLocalRulestackResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.FqdnListLocalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FrontendSetting(_serialization.Model):
    """Frontend setting for Firewall.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Settings name. Required.
    :vartype name: str
    :ivar protocol: Protocol Type. Required. Known values are: "TCP" and "UDP".
    :vartype protocol: str or ~azure.mgmt.paloaltonetworks.models.ProtocolType
    :ivar frontend_configuration: Frontend configurations. Required.
    :vartype frontend_configuration: ~azure.mgmt.paloaltonetworks.models.EndpointConfiguration
    :ivar backend_configuration: Backend configurations. Required.
    :vartype backend_configuration: ~azure.mgmt.paloaltonetworks.models.EndpointConfiguration
    """

    _validation = {
        "name": {"required": True},
        "protocol": {"required": True},
        "frontend_configuration": {"required": True},
        "backend_configuration": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "protocol": {"key": "protocol", "type": "str"},
        "frontend_configuration": {"key": "frontendConfiguration", "type": "EndpointConfiguration"},
        "backend_configuration": {"key": "backendConfiguration", "type": "EndpointConfiguration"},
    }

    def __init__(
        self,
        *,
        name: str,
        protocol: Union[str, "_models.ProtocolType"],
        frontend_configuration: "_models.EndpointConfiguration",
        backend_configuration: "_models.EndpointConfiguration",
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Settings name. Required.
        :paramtype name: str
        :keyword protocol: Protocol Type. Required. Known values are: "TCP" and "UDP".
        :paramtype protocol: str or ~azure.mgmt.paloaltonetworks.models.ProtocolType
        :keyword frontend_configuration: Frontend configurations. Required.
        :paramtype frontend_configuration: ~azure.mgmt.paloaltonetworks.models.EndpointConfiguration
        :keyword backend_configuration: Backend configurations. Required.
        :paramtype backend_configuration: ~azure.mgmt.paloaltonetworks.models.EndpointConfiguration
        """
        super().__init__(**kwargs)
        self.name = name
        self.protocol = protocol
        self.frontend_configuration = frontend_configuration
        self.backend_configuration = backend_configuration


class GlobalRulestackInfo(_serialization.Model):
    """PAN Rulestack Describe Object.

    All required parameters must be populated in order to send to Azure.

    :ivar azure_id: rulestack description. Required.
    :vartype azure_id: str
    """

    _validation = {
        "azure_id": {"required": True},
    }

    _attribute_map = {
        "azure_id": {"key": "azureId", "type": "str"},
    }

    def __init__(self, *, azure_id: str, **kwargs: Any) -> None:
        """
        :keyword azure_id: rulestack description. Required.
        :paramtype azure_id: str
        """
        super().__init__(**kwargs)
        self.azure_id = azure_id


class GlobalRulestackResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """PaloAltoNetworks GlobalRulestack.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar location: Global Location. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar pan_etag: PanEtag info.
    :vartype pan_etag: str
    :ivar pan_location: Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks.
    :vartype pan_location: str
    :ivar scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
    :vartype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
    :ivar associated_subscriptions: subscription scope of global rulestack.
    :vartype associated_subscriptions: list[str]
    :ivar description: rulestack description.
    :vartype description: str
    :ivar default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL", and
     "NONE".
    :vartype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
    :ivar min_app_id_version: minimum version.
    :vartype min_app_id_version: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    :ivar security_services: Security Profile.
    :vartype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "pan_etag": {"key": "properties.panEtag", "type": "str"},
        "pan_location": {"key": "properties.panLocation", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "associated_subscriptions": {"key": "properties.associatedSubscriptions", "type": "[str]"},
        "description": {"key": "properties.description", "type": "str"},
        "default_mode": {"key": "properties.defaultMode", "type": "str"},
        "min_app_id_version": {"key": "properties.minAppIdVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "security_services": {"key": "properties.securityServices", "type": "SecurityServices"},
    }

    def __init__(
        self,
        *,
        location: str,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        pan_etag: Optional[str] = None,
        pan_location: Optional[str] = None,
        scope: Optional[Union[str, "_models.ScopeType"]] = None,
        associated_subscriptions: Optional[List[str]] = None,
        description: Optional[str] = None,
        default_mode: Optional[Union[str, "_models.DefaultMode"]] = None,
        min_app_id_version: Optional[str] = None,
        security_services: Optional["_models.SecurityServices"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Global Location. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword pan_etag: PanEtag info.
        :paramtype pan_etag: str
        :keyword pan_location: Rulestack Location, Required for GlobalRulestacks, Not for
         LocalRulestacks.
        :paramtype pan_location: str
        :keyword scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
        :paramtype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
        :keyword associated_subscriptions: subscription scope of global rulestack.
        :paramtype associated_subscriptions: list[str]
        :keyword description: rulestack description.
        :paramtype description: str
        :keyword default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL",
         and "NONE".
        :paramtype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
        :keyword min_app_id_version: minimum version.
        :paramtype min_app_id_version: str
        :keyword security_services: Security Profile.
        :paramtype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.pan_etag = pan_etag
        self.pan_location = pan_location
        self.scope = scope
        self.associated_subscriptions = associated_subscriptions
        self.description = description
        self.default_mode = default_mode
        self.min_app_id_version = min_app_id_version
        self.provisioning_state = None
        self.security_services = security_services


class GlobalRulestackResourceListResult(_serialization.Model):
    """The response of a GlobalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.GlobalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GlobalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.GlobalRulestackResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.GlobalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class GlobalRulestackResourceUpdate(_serialization.Model):
    """The type used for update operations of the GlobalRulestackResource.

    :ivar location: Global Location.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar properties: The updatable properties of the GlobalRulestackResource.
    :vartype properties:
     ~azure.mgmt.paloaltonetworks.models.GlobalRulestackResourceUpdateProperties
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "properties": {"key": "properties", "type": "GlobalRulestackResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        properties: Optional["_models.GlobalRulestackResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Global Location.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword properties: The updatable properties of the GlobalRulestackResource.
        :paramtype properties:
         ~azure.mgmt.paloaltonetworks.models.GlobalRulestackResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.identity = identity
        self.properties = properties


class GlobalRulestackResourceUpdateProperties(_serialization.Model):
    """The updatable properties of the GlobalRulestackResource.

    :ivar pan_etag: PanEtag info.
    :vartype pan_etag: str
    :ivar pan_location: Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks.
    :vartype pan_location: str
    :ivar scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
    :vartype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
    :ivar associated_subscriptions: subscription scope of global rulestack.
    :vartype associated_subscriptions: list[str]
    :ivar description: rulestack description.
    :vartype description: str
    :ivar default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL", and
     "NONE".
    :vartype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
    :ivar min_app_id_version: minimum version.
    :vartype min_app_id_version: str
    :ivar security_services: Security Profile.
    :vartype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
    """

    _attribute_map = {
        "pan_etag": {"key": "panEtag", "type": "str"},
        "pan_location": {"key": "panLocation", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "associated_subscriptions": {"key": "associatedSubscriptions", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
        "default_mode": {"key": "defaultMode", "type": "str"},
        "min_app_id_version": {"key": "minAppIdVersion", "type": "str"},
        "security_services": {"key": "securityServices", "type": "SecurityServices"},
    }

    def __init__(
        self,
        *,
        pan_etag: Optional[str] = None,
        pan_location: Optional[str] = None,
        scope: Optional[Union[str, "_models.ScopeType"]] = None,
        associated_subscriptions: Optional[List[str]] = None,
        description: Optional[str] = None,
        default_mode: Optional[Union[str, "_models.DefaultMode"]] = None,
        min_app_id_version: Optional[str] = None,
        security_services: Optional["_models.SecurityServices"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pan_etag: PanEtag info.
        :paramtype pan_etag: str
        :keyword pan_location: Rulestack Location, Required for GlobalRulestacks, Not for
         LocalRulestacks.
        :paramtype pan_location: str
        :keyword scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
        :paramtype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
        :keyword associated_subscriptions: subscription scope of global rulestack.
        :paramtype associated_subscriptions: list[str]
        :keyword description: rulestack description.
        :paramtype description: str
        :keyword default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL",
         and "NONE".
        :paramtype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
        :keyword min_app_id_version: minimum version.
        :paramtype min_app_id_version: str
        :keyword security_services: Security Profile.
        :paramtype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
        """
        super().__init__(**kwargs)
        self.pan_etag = pan_etag
        self.pan_location = pan_location
        self.scope = scope
        self.associated_subscriptions = associated_subscriptions
        self.description = description
        self.default_mode = default_mode
        self.min_app_id_version = min_app_id_version
        self.security_services = security_services


class IPAddress(_serialization.Model):
    """IP Address.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar address: Address value.
    :vartype address: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address": {"key": "address", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        :keyword address: Address value.
        :paramtype address: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address = address


class IPAddressSpace(_serialization.Model):
    """IP Address Space.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar address_space: Address Space.
    :vartype address_space: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "address_space": {"key": "addressSpace", "type": "str"},
    }

    def __init__(
        self, *, resource_id: Optional[str] = None, address_space: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        :keyword address_space: Address Space.
        :paramtype address_space: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.address_space = address_space


class ListAppIdResponse(_serialization.Model):
    """ListAppIdResponse.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of AppIds. Required.
    :vartype value: list[str]
    :ivar next_link: next Link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: List of AppIds. Required.
        :paramtype value: list[str]
        :keyword next_link: next Link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ListFirewallsResponse(_serialization.Model):
    """List firewalls response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: firewalls list. Required.
    :vartype value: list[str]
    :ivar next_link: next link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[str]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List[str], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: firewalls list. Required.
        :paramtype value: list[str]
        :keyword next_link: next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LocalRulesResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """LocalRulestack rule list.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar etag: etag info.
    :vartype etag: str
    :ivar rule_name: rule name. Required.
    :vartype rule_name: str
    :ivar priority:
    :vartype priority: int
    :ivar description: rule description.
    :vartype description: str
    :ivar rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
    :vartype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar source: source address.
    :vartype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
    :ivar negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar destination: destination address.
    :vartype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
    :ivar negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar applications: array of rule applications.
    :vartype applications: list[str]
    :ivar category: rule category.
    :vartype category: ~azure.mgmt.paloaltonetworks.models.Category
    :ivar protocol: any, application-default, TCP:number, UDP:number.
    :vartype protocol: str
    :ivar protocol_port_list: prot port list.
    :vartype protocol_port_list: list[str]
    :ivar inbound_inspection_certificate: inbound Inspection Certificate.
    :vartype inbound_inspection_certificate: str
    :ivar audit_comment: rule comment.
    :vartype audit_comment: str
    :ivar action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer", and
     "DenyResetBoth".
    :vartype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
    :ivar enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
    :vartype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar decryption_rule_type: enable or disable decryption. Known values are:
     "SSLOutboundInspection", "SSLInboundInspection", and "None".
    :vartype decryption_rule_type: str or
     ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
    :ivar tags: tag for rule.
    :vartype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "rule_name": {"required": True},
        "priority": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "properties.etag", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "description": {"key": "properties.description", "type": "str"},
        "rule_state": {"key": "properties.ruleState", "type": "str"},
        "source": {"key": "properties.source", "type": "SourceAddr"},
        "negate_source": {"key": "properties.negateSource", "type": "str"},
        "destination": {"key": "properties.destination", "type": "DestinationAddr"},
        "negate_destination": {"key": "properties.negateDestination", "type": "str"},
        "applications": {"key": "properties.applications", "type": "[str]"},
        "category": {"key": "properties.category", "type": "Category"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "protocol_port_list": {"key": "properties.protocolPortList", "type": "[str]"},
        "inbound_inspection_certificate": {"key": "properties.inboundInspectionCertificate", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "action_type": {"key": "properties.actionType", "type": "str"},
        "enable_logging": {"key": "properties.enableLogging", "type": "str"},
        "decryption_rule_type": {"key": "properties.decryptionRuleType", "type": "str"},
        "tags": {"key": "properties.tags", "type": "[TagInfo]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        rule_name: str,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        rule_state: Optional[Union[str, "_models.StateEnum"]] = None,
        source: Optional["_models.SourceAddr"] = None,
        negate_source: Optional[Union[str, "_models.BooleanEnum"]] = None,
        destination: Optional["_models.DestinationAddr"] = None,
        negate_destination: Optional[Union[str, "_models.BooleanEnum"]] = None,
        applications: Optional[List[str]] = None,
        category: Optional["_models.Category"] = None,
        protocol: str = "application-default",
        protocol_port_list: Optional[List[str]] = None,
        inbound_inspection_certificate: Optional[str] = None,
        audit_comment: Optional[str] = None,
        action_type: Optional[Union[str, "_models.ActionEnum"]] = None,
        enable_logging: Optional[Union[str, "_models.StateEnum"]] = None,
        decryption_rule_type: Optional[Union[str, "_models.DecryptionRuleTypeEnum"]] = None,
        tags: Optional[List["_models.TagInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword rule_name: rule name. Required.
        :paramtype rule_name: str
        :keyword description: rule description.
        :paramtype description: str
        :keyword rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
        :paramtype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword source: source address.
        :paramtype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
        :keyword negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword destination: destination address.
        :paramtype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
        :keyword negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword applications: array of rule applications.
        :paramtype applications: list[str]
        :keyword category: rule category.
        :paramtype category: ~azure.mgmt.paloaltonetworks.models.Category
        :keyword protocol: any, application-default, TCP:number, UDP:number.
        :paramtype protocol: str
        :keyword protocol_port_list: prot port list.
        :paramtype protocol_port_list: list[str]
        :keyword inbound_inspection_certificate: inbound Inspection Certificate.
        :paramtype inbound_inspection_certificate: str
        :keyword audit_comment: rule comment.
        :paramtype audit_comment: str
        :keyword action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer",
         and "DenyResetBoth".
        :paramtype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
        :keyword enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
        :paramtype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword decryption_rule_type: enable or disable decryption. Known values are:
         "SSLOutboundInspection", "SSLInboundInspection", and "None".
        :paramtype decryption_rule_type: str or
         ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
        :keyword tags: tag for rule.
        :paramtype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.rule_name = rule_name
        self.priority = None
        self.description = description
        self.rule_state = rule_state
        self.source = source
        self.negate_source = negate_source
        self.destination = destination
        self.negate_destination = negate_destination
        self.applications = applications
        self.category = category
        self.protocol = protocol
        self.protocol_port_list = protocol_port_list
        self.inbound_inspection_certificate = inbound_inspection_certificate
        self.audit_comment = audit_comment
        self.action_type = action_type
        self.enable_logging = enable_logging
        self.decryption_rule_type = decryption_rule_type
        self.tags = tags
        self.provisioning_state = None


class LocalRulesResourceListResult(_serialization.Model):
    """The response of a LocalRulesResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.LocalRulesResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalRulesResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.LocalRulesResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.LocalRulesResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LocalRulestackResource(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """PaloAltoNetworks LocalRulestack.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar pan_etag: PanEtag info.
    :vartype pan_etag: str
    :ivar pan_location: Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks.
    :vartype pan_location: str
    :ivar scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
    :vartype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
    :ivar associated_subscriptions: subscription scope of global rulestack.
    :vartype associated_subscriptions: list[str]
    :ivar description: rulestack description.
    :vartype description: str
    :ivar default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL", and
     "NONE".
    :vartype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
    :ivar min_app_id_version: minimum version.
    :vartype min_app_id_version: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    :ivar security_services: Security Profile.
    :vartype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "pan_etag": {"key": "properties.panEtag", "type": "str"},
        "pan_location": {"key": "properties.panLocation", "type": "str"},
        "scope": {"key": "properties.scope", "type": "str"},
        "associated_subscriptions": {"key": "properties.associatedSubscriptions", "type": "[str]"},
        "description": {"key": "properties.description", "type": "str"},
        "default_mode": {"key": "properties.defaultMode", "type": "str"},
        "min_app_id_version": {"key": "properties.minAppIdVersion", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "security_services": {"key": "properties.securityServices", "type": "SecurityServices"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        pan_etag: Optional[str] = None,
        pan_location: Optional[str] = None,
        scope: Optional[Union[str, "_models.ScopeType"]] = None,
        associated_subscriptions: Optional[List[str]] = None,
        description: Optional[str] = None,
        default_mode: Optional[Union[str, "_models.DefaultMode"]] = None,
        min_app_id_version: Optional[str] = None,
        security_services: Optional["_models.SecurityServices"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword pan_etag: PanEtag info.
        :paramtype pan_etag: str
        :keyword pan_location: Rulestack Location, Required for GlobalRulestacks, Not for
         LocalRulestacks.
        :paramtype pan_location: str
        :keyword scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
        :paramtype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
        :keyword associated_subscriptions: subscription scope of global rulestack.
        :paramtype associated_subscriptions: list[str]
        :keyword description: rulestack description.
        :paramtype description: str
        :keyword default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL",
         and "NONE".
        :paramtype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
        :keyword min_app_id_version: minimum version.
        :paramtype min_app_id_version: str
        :keyword security_services: Security Profile.
        :paramtype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.pan_etag = pan_etag
        self.pan_location = pan_location
        self.scope = scope
        self.associated_subscriptions = associated_subscriptions
        self.description = description
        self.default_mode = default_mode
        self.min_app_id_version = min_app_id_version
        self.provisioning_state = None
        self.security_services = security_services


class LocalRulestackResourceListResult(_serialization.Model):
    """The response of a LocalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.LocalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.LocalRulestackResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.LocalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LocalRulestackResourceUpdate(_serialization.Model):
    """The type used for update operations of the LocalRulestackResource.

    :ivar identity: The managed service identities assigned to this resource.
    :vartype identity:
     ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar properties: The updatable properties of the LocalRulestackResource.
    :vartype properties: ~azure.mgmt.paloaltonetworks.models.LocalRulestackResourceUpdateProperties
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "AzureResourceManagerManagedIdentityProperties"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "LocalRulestackResourceUpdateProperties"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.AzureResourceManagerManagedIdentityProperties"] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.LocalRulestackResourceUpdateProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identities assigned to this resource.
        :paramtype identity:
         ~azure.mgmt.paloaltonetworks.models.AzureResourceManagerManagedIdentityProperties
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword properties: The updatable properties of the LocalRulestackResource.
        :paramtype properties:
         ~azure.mgmt.paloaltonetworks.models.LocalRulestackResourceUpdateProperties
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags
        self.properties = properties


class LocalRulestackResourceUpdateProperties(_serialization.Model):
    """The updatable properties of the LocalRulestackResource.

    :ivar pan_etag: PanEtag info.
    :vartype pan_etag: str
    :ivar pan_location: Rulestack Location, Required for GlobalRulestacks, Not for LocalRulestacks.
    :vartype pan_location: str
    :ivar scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
    :vartype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
    :ivar associated_subscriptions: subscription scope of global rulestack.
    :vartype associated_subscriptions: list[str]
    :ivar description: rulestack description.
    :vartype description: str
    :ivar default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL", and
     "NONE".
    :vartype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
    :ivar min_app_id_version: minimum version.
    :vartype min_app_id_version: str
    :ivar security_services: Security Profile.
    :vartype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
    """

    _attribute_map = {
        "pan_etag": {"key": "panEtag", "type": "str"},
        "pan_location": {"key": "panLocation", "type": "str"},
        "scope": {"key": "scope", "type": "str"},
        "associated_subscriptions": {"key": "associatedSubscriptions", "type": "[str]"},
        "description": {"key": "description", "type": "str"},
        "default_mode": {"key": "defaultMode", "type": "str"},
        "min_app_id_version": {"key": "minAppIdVersion", "type": "str"},
        "security_services": {"key": "securityServices", "type": "SecurityServices"},
    }

    def __init__(
        self,
        *,
        pan_etag: Optional[str] = None,
        pan_location: Optional[str] = None,
        scope: Optional[Union[str, "_models.ScopeType"]] = None,
        associated_subscriptions: Optional[List[str]] = None,
        description: Optional[str] = None,
        default_mode: Optional[Union[str, "_models.DefaultMode"]] = None,
        min_app_id_version: Optional[str] = None,
        security_services: Optional["_models.SecurityServices"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword pan_etag: PanEtag info.
        :paramtype pan_etag: str
        :keyword pan_location: Rulestack Location, Required for GlobalRulestacks, Not for
         LocalRulestacks.
        :paramtype pan_location: str
        :keyword scope: Rulestack Type. Known values are: "LOCAL" and "GLOBAL".
        :paramtype scope: str or ~azure.mgmt.paloaltonetworks.models.ScopeType
        :keyword associated_subscriptions: subscription scope of global rulestack.
        :paramtype associated_subscriptions: list[str]
        :keyword description: rulestack description.
        :paramtype description: str
        :keyword default_mode: Mode for default rules creation. Known values are: "IPS", "FIREWALL",
         and "NONE".
        :paramtype default_mode: str or ~azure.mgmt.paloaltonetworks.models.DefaultMode
        :keyword min_app_id_version: minimum version.
        :paramtype min_app_id_version: str
        :keyword security_services: Security Profile.
        :paramtype security_services: ~azure.mgmt.paloaltonetworks.models.SecurityServices
        """
        super().__init__(**kwargs)
        self.pan_etag = pan_etag
        self.pan_location = pan_location
        self.scope = scope
        self.associated_subscriptions = associated_subscriptions
        self.description = description
        self.default_mode = default_mode
        self.min_app_id_version = min_app_id_version
        self.security_services = security_services


class LogDestination(_serialization.Model):
    """Log Destination.

    :ivar storage_configurations: Storage account configurations.
    :vartype storage_configurations: ~azure.mgmt.paloaltonetworks.models.StorageAccount
    :ivar event_hub_configurations: Event Hub configurations.
    :vartype event_hub_configurations: ~azure.mgmt.paloaltonetworks.models.EventHub
    :ivar monitor_configurations: Monitor Log configurations.
    :vartype monitor_configurations: ~azure.mgmt.paloaltonetworks.models.MonitorLog
    """

    _attribute_map = {
        "storage_configurations": {"key": "storageConfigurations", "type": "StorageAccount"},
        "event_hub_configurations": {"key": "eventHubConfigurations", "type": "EventHub"},
        "monitor_configurations": {"key": "monitorConfigurations", "type": "MonitorLog"},
    }

    def __init__(
        self,
        *,
        storage_configurations: Optional["_models.StorageAccount"] = None,
        event_hub_configurations: Optional["_models.EventHub"] = None,
        monitor_configurations: Optional["_models.MonitorLog"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_configurations: Storage account configurations.
        :paramtype storage_configurations: ~azure.mgmt.paloaltonetworks.models.StorageAccount
        :keyword event_hub_configurations: Event Hub configurations.
        :paramtype event_hub_configurations: ~azure.mgmt.paloaltonetworks.models.EventHub
        :keyword monitor_configurations: Monitor Log configurations.
        :paramtype monitor_configurations: ~azure.mgmt.paloaltonetworks.models.MonitorLog
        """
        super().__init__(**kwargs)
        self.storage_configurations = storage_configurations
        self.event_hub_configurations = event_hub_configurations
        self.monitor_configurations = monitor_configurations


class LogSettings(_serialization.Model):
    """Log Settings for Firewall.

    :ivar log_type: One of possible log type. Known values are: "TRAFFIC", "THREAT", "DECRYPTION",
     "WILDFIRE", "DLP", and "AUDIT".
    :vartype log_type: str or ~azure.mgmt.paloaltonetworks.models.LogType
    :ivar log_option: Log option SAME/INDIVIDUAL. Known values are: "SAME_DESTINATION" and
     "INDIVIDUAL_DESTINATION".
    :vartype log_option: str or ~azure.mgmt.paloaltonetworks.models.LogOption
    :ivar application_insights: Application Insight details.
    :vartype application_insights: ~azure.mgmt.paloaltonetworks.models.ApplicationInsights
    :ivar common_destination: Common destination configurations.
    :vartype common_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
    :ivar traffic_log_destination: Traffic destination configurations.
    :vartype traffic_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
    :ivar threat_log_destination: Threat destination configurations.
    :vartype threat_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
    :ivar decrypt_log_destination: Decrypt destination configurations.
    :vartype decrypt_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
    """

    _attribute_map = {
        "log_type": {"key": "logType", "type": "str"},
        "log_option": {"key": "logOption", "type": "str"},
        "application_insights": {"key": "applicationInsights", "type": "ApplicationInsights"},
        "common_destination": {"key": "commonDestination", "type": "LogDestination"},
        "traffic_log_destination": {"key": "trafficLogDestination", "type": "LogDestination"},
        "threat_log_destination": {"key": "threatLogDestination", "type": "LogDestination"},
        "decrypt_log_destination": {"key": "decryptLogDestination", "type": "LogDestination"},
    }

    def __init__(
        self,
        *,
        log_type: Optional[Union[str, "_models.LogType"]] = None,
        log_option: Optional[Union[str, "_models.LogOption"]] = None,
        application_insights: Optional["_models.ApplicationInsights"] = None,
        common_destination: Optional["_models.LogDestination"] = None,
        traffic_log_destination: Optional["_models.LogDestination"] = None,
        threat_log_destination: Optional["_models.LogDestination"] = None,
        decrypt_log_destination: Optional["_models.LogDestination"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_type: One of possible log type. Known values are: "TRAFFIC", "THREAT",
         "DECRYPTION", "WILDFIRE", "DLP", and "AUDIT".
        :paramtype log_type: str or ~azure.mgmt.paloaltonetworks.models.LogType
        :keyword log_option: Log option SAME/INDIVIDUAL. Known values are: "SAME_DESTINATION" and
         "INDIVIDUAL_DESTINATION".
        :paramtype log_option: str or ~azure.mgmt.paloaltonetworks.models.LogOption
        :keyword application_insights: Application Insight details.
        :paramtype application_insights: ~azure.mgmt.paloaltonetworks.models.ApplicationInsights
        :keyword common_destination: Common destination configurations.
        :paramtype common_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
        :keyword traffic_log_destination: Traffic destination configurations.
        :paramtype traffic_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
        :keyword threat_log_destination: Threat destination configurations.
        :paramtype threat_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
        :keyword decrypt_log_destination: Decrypt destination configurations.
        :paramtype decrypt_log_destination: ~azure.mgmt.paloaltonetworks.models.LogDestination
        """
        super().__init__(**kwargs)
        self.log_type = log_type
        self.log_option = log_option
        self.application_insights = application_insights
        self.common_destination = common_destination
        self.traffic_log_destination = traffic_log_destination
        self.threat_log_destination = threat_log_destination
        self.decrypt_log_destination = decrypt_log_destination


class MarketplaceDetails(_serialization.Model):
    """MarketplaceDetails of PAN Firewall resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar marketplace_subscription_id: Marketplace Subscription Id.
    :vartype marketplace_subscription_id: str
    :ivar offer_id: Offer Id. Required.
    :vartype offer_id: str
    :ivar publisher_id: Publisher Id. Required.
    :vartype publisher_id: str
    :ivar marketplace_subscription_status: Marketplace Subscription Status. Known values are:
     "PendingFulfillmentStart", "Subscribed", "Suspended", "Unsubscribed", "NotStarted", and
     "FulfillmentRequested".
    :vartype marketplace_subscription_status: str or
     ~azure.mgmt.paloaltonetworks.models.MarketplaceSubscriptionStatus
    """

    _validation = {
        "marketplace_subscription_id": {"readonly": True},
        "offer_id": {"required": True},
        "publisher_id": {"required": True},
    }

    _attribute_map = {
        "marketplace_subscription_id": {"key": "marketplaceSubscriptionId", "type": "str"},
        "offer_id": {"key": "offerId", "type": "str"},
        "publisher_id": {"key": "publisherId", "type": "str"},
        "marketplace_subscription_status": {"key": "marketplaceSubscriptionStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        offer_id: str,
        publisher_id: str,
        marketplace_subscription_status: Optional[Union[str, "_models.MarketplaceSubscriptionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword offer_id: Offer Id. Required.
        :paramtype offer_id: str
        :keyword publisher_id: Publisher Id. Required.
        :paramtype publisher_id: str
        :keyword marketplace_subscription_status: Marketplace Subscription Status. Known values are:
         "PendingFulfillmentStart", "Subscribed", "Suspended", "Unsubscribed", "NotStarted", and
         "FulfillmentRequested".
        :paramtype marketplace_subscription_status: str or
         ~azure.mgmt.paloaltonetworks.models.MarketplaceSubscriptionStatus
        """
        super().__init__(**kwargs)
        self.marketplace_subscription_id = None
        self.offer_id = offer_id
        self.publisher_id = publisher_id
        self.marketplace_subscription_status = marketplace_subscription_status


class MonitorLog(_serialization.Model):
    """MonitorLog configurations.

    :ivar id: Resource ID of MonitorLog.
    :vartype id: str
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    :ivar workspace: MonitorLog workspace.
    :vartype workspace: str
    :ivar primary_key: Primary Key value for Monitor.
    :vartype primary_key: str
    :ivar secondary_key: Secondary Key value for Monitor.
    :vartype secondary_key: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "workspace": {"key": "workspace", "type": "str"},
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subscription_id: Optional[str] = None,
        workspace: Optional[str] = None,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of MonitorLog.
        :paramtype id: str
        :keyword subscription_id: Subscription Id.
        :paramtype subscription_id: str
        :keyword workspace: MonitorLog workspace.
        :paramtype workspace: str
        :keyword primary_key: Primary Key value for Monitor.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary Key value for Monitor.
        :paramtype secondary_key: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.subscription_id = subscription_id
        self.workspace = workspace
        self.primary_key = primary_key
        self.secondary_key = secondary_key


class NameDescriptionObject(_serialization.Model):
    """object type info.

    All required parameters must be populated in order to send to Azure.

    :ivar name: name value. Required.
    :vartype name: str
    :ivar description: description value.
    :vartype description: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, *, name: str, description: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: name value. Required.
        :paramtype name: str
        :keyword description: description value.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.description = description


class NetworkProfile(_serialization.Model):
    """Network settings for Firewall.

    All required parameters must be populated in order to send to Azure.

    :ivar vnet_configuration: Vnet configurations.
    :vartype vnet_configuration: ~azure.mgmt.paloaltonetworks.models.VnetConfiguration
    :ivar vwan_configuration: Vwan configurations.
    :vartype vwan_configuration: ~azure.mgmt.paloaltonetworks.models.VwanConfiguration
    :ivar network_type: vnet or vwan, cannot be updated. Required. Known values are: "VNET" and
     "VWAN".
    :vartype network_type: str or ~azure.mgmt.paloaltonetworks.models.NetworkType
    :ivar public_ips: List of IPs associated with the Firewall. Required.
    :vartype public_ips: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
    :ivar enable_egress_nat: Enable egress NAT, enabled by default. Required. Known values are:
     "DISABLED" and "ENABLED".
    :vartype enable_egress_nat: str or ~azure.mgmt.paloaltonetworks.models.EgressNat
    :ivar egress_nat_ip: Egress nat IP to use.
    :vartype egress_nat_ip: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
    """

    _validation = {
        "network_type": {"required": True},
        "public_ips": {"required": True},
        "enable_egress_nat": {"required": True},
    }

    _attribute_map = {
        "vnet_configuration": {"key": "vnetConfiguration", "type": "VnetConfiguration"},
        "vwan_configuration": {"key": "vwanConfiguration", "type": "VwanConfiguration"},
        "network_type": {"key": "networkType", "type": "str"},
        "public_ips": {"key": "publicIps", "type": "[IPAddress]"},
        "enable_egress_nat": {"key": "enableEgressNat", "type": "str"},
        "egress_nat_ip": {"key": "egressNatIp", "type": "[IPAddress]"},
    }

    def __init__(
        self,
        *,
        network_type: Union[str, "_models.NetworkType"],
        public_ips: List["_models.IPAddress"],
        enable_egress_nat: Union[str, "_models.EgressNat"],
        vnet_configuration: Optional["_models.VnetConfiguration"] = None,
        vwan_configuration: Optional["_models.VwanConfiguration"] = None,
        egress_nat_ip: Optional[List["_models.IPAddress"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vnet_configuration: Vnet configurations.
        :paramtype vnet_configuration: ~azure.mgmt.paloaltonetworks.models.VnetConfiguration
        :keyword vwan_configuration: Vwan configurations.
        :paramtype vwan_configuration: ~azure.mgmt.paloaltonetworks.models.VwanConfiguration
        :keyword network_type: vnet or vwan, cannot be updated. Required. Known values are: "VNET" and
         "VWAN".
        :paramtype network_type: str or ~azure.mgmt.paloaltonetworks.models.NetworkType
        :keyword public_ips: List of IPs associated with the Firewall. Required.
        :paramtype public_ips: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
        :keyword enable_egress_nat: Enable egress NAT, enabled by default. Required. Known values are:
         "DISABLED" and "ENABLED".
        :paramtype enable_egress_nat: str or ~azure.mgmt.paloaltonetworks.models.EgressNat
        :keyword egress_nat_ip: Egress nat IP to use.
        :paramtype egress_nat_ip: list[~azure.mgmt.paloaltonetworks.models.IPAddress]
        """
        super().__init__(**kwargs)
        self.vnet_configuration = vnet_configuration
        self.vwan_configuration = vwan_configuration
        self.network_type = network_type
        self.public_ips = public_ips
        self.enable_egress_nat = enable_egress_nat
        self.egress_nat_ip = egress_nat_ip


class Operation(_serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.paloaltonetworks.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.paloaltonetworks.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionType
    """

    _validation = {
        "name": {"readonly": True},
        "is_data_action": {"readonly": True},
        "origin": {"readonly": True},
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "action_type": {"key": "actionType", "type": "str"},
    }

    def __init__(self, *, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any) -> None:
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.paloaltonetworks.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(_serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
        "resource": {"readonly": True},
        "operation": {"readonly": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(_serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link
    to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PanoramaConfig(_serialization.Model):
    """Panorama Config.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar config_string: Base64 encoded string representing Panorama parameters to be used by
     Firewall to connect to Panorama. This string is generated via azure plugin in Panorama.
     Required.
    :vartype config_string: str
    :ivar vm_auth_key: VM auth key for panorama connectivity.
    :vartype vm_auth_key: str
    :ivar panorama_server: Primary Panorama Server IP address value in dotted format for IPv4.
    :vartype panorama_server: str
    :ivar panorama_server2: Secondary Panorama Server IP address value in dotted format for IPv4.
    :vartype panorama_server2: str
    :ivar dg_name: Panorama Device Group to join.
    :vartype dg_name: str
    :ivar tpl_name: Panorama Template Stack to join - (Once configured we can not edit the value).
    :vartype tpl_name: str
    :ivar cg_name: Panorama Collector Group to join - (Once configured we can not edit the value).
    :vartype cg_name: str
    :ivar host_name: Resource name(may be unique) for PN admin.
    :vartype host_name: str
    """

    _validation = {
        "config_string": {"required": True},
        "vm_auth_key": {"readonly": True},
        "panorama_server": {"readonly": True},
        "panorama_server2": {"readonly": True},
        "dg_name": {"readonly": True},
        "tpl_name": {"readonly": True},
        "cg_name": {"readonly": True},
        "host_name": {"readonly": True},
    }

    _attribute_map = {
        "config_string": {"key": "configString", "type": "str"},
        "vm_auth_key": {"key": "vmAuthKey", "type": "str"},
        "panorama_server": {"key": "panoramaServer", "type": "str"},
        "panorama_server2": {"key": "panoramaServer2", "type": "str"},
        "dg_name": {"key": "dgName", "type": "str"},
        "tpl_name": {"key": "tplName", "type": "str"},
        "cg_name": {"key": "cgName", "type": "str"},
        "host_name": {"key": "hostName", "type": "str"},
    }

    def __init__(self, *, config_string: str, **kwargs: Any) -> None:
        """
        :keyword config_string: Base64 encoded string representing Panorama parameters to be used by
         Firewall to connect to Panorama. This string is generated via azure plugin in Panorama.
         Required.
        :paramtype config_string: str
        """
        super().__init__(**kwargs)
        self.config_string = config_string
        self.vm_auth_key = None
        self.panorama_server = None
        self.panorama_server2 = None
        self.dg_name = None
        self.tpl_name = None
        self.cg_name = None
        self.host_name = None


class PlanData(_serialization.Model):
    """Billing plan information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar usage_type: different usage type like PAYG/COMMITTED. Known values are: "PAYG" and
     "COMMITTED".
    :vartype usage_type: str or ~azure.mgmt.paloaltonetworks.models.UsageType
    :ivar billing_cycle: different billing cycles like MONTHLY/WEEKLY. Required. Known values are:
     "WEEKLY" and "MONTHLY".
    :vartype billing_cycle: str or ~azure.mgmt.paloaltonetworks.models.BillingCycle
    :ivar plan_id: plan id as published by Liftr.PAN. Required.
    :vartype plan_id: str
    :ivar effective_date: date when plan was applied.
    :vartype effective_date: ~datetime.datetime
    """

    _validation = {
        "billing_cycle": {"required": True},
        "plan_id": {"required": True, "max_length": 50},
        "effective_date": {"readonly": True},
    }

    _attribute_map = {
        "usage_type": {"key": "usageType", "type": "str"},
        "billing_cycle": {"key": "billingCycle", "type": "str"},
        "plan_id": {"key": "planId", "type": "str"},
        "effective_date": {"key": "effectiveDate", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        billing_cycle: Union[str, "_models.BillingCycle"],
        plan_id: str,
        usage_type: Optional[Union[str, "_models.UsageType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword usage_type: different usage type like PAYG/COMMITTED. Known values are: "PAYG" and
         "COMMITTED".
        :paramtype usage_type: str or ~azure.mgmt.paloaltonetworks.models.UsageType
        :keyword billing_cycle: different billing cycles like MONTHLY/WEEKLY. Required. Known values
         are: "WEEKLY" and "MONTHLY".
        :paramtype billing_cycle: str or ~azure.mgmt.paloaltonetworks.models.BillingCycle
        :keyword plan_id: plan id as published by Liftr.PAN. Required.
        :paramtype plan_id: str
        """
        super().__init__(**kwargs)
        self.usage_type = usage_type
        self.billing_cycle = billing_cycle
        self.plan_id = plan_id
        self.effective_date = None


class PostRulesResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """PostRulestack rule list.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar etag: etag info.
    :vartype etag: str
    :ivar rule_name: rule name. Required.
    :vartype rule_name: str
    :ivar priority:
    :vartype priority: int
    :ivar description: rule description.
    :vartype description: str
    :ivar rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
    :vartype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar source: source address.
    :vartype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
    :ivar negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar destination: destination address.
    :vartype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
    :ivar negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar applications: array of rule applications.
    :vartype applications: list[str]
    :ivar category: rule category.
    :vartype category: ~azure.mgmt.paloaltonetworks.models.Category
    :ivar protocol: any, application-default, TCP:number, UDP:number.
    :vartype protocol: str
    :ivar protocol_port_list: prot port list.
    :vartype protocol_port_list: list[str]
    :ivar inbound_inspection_certificate: inbound Inspection Certificate.
    :vartype inbound_inspection_certificate: str
    :ivar audit_comment: rule comment.
    :vartype audit_comment: str
    :ivar action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer", and
     "DenyResetBoth".
    :vartype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
    :ivar enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
    :vartype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar decryption_rule_type: enable or disable decryption. Known values are:
     "SSLOutboundInspection", "SSLInboundInspection", and "None".
    :vartype decryption_rule_type: str or
     ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
    :ivar tags: tag for rule.
    :vartype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "rule_name": {"required": True},
        "priority": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "properties.etag", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "description": {"key": "properties.description", "type": "str"},
        "rule_state": {"key": "properties.ruleState", "type": "str"},
        "source": {"key": "properties.source", "type": "SourceAddr"},
        "negate_source": {"key": "properties.negateSource", "type": "str"},
        "destination": {"key": "properties.destination", "type": "DestinationAddr"},
        "negate_destination": {"key": "properties.negateDestination", "type": "str"},
        "applications": {"key": "properties.applications", "type": "[str]"},
        "category": {"key": "properties.category", "type": "Category"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "protocol_port_list": {"key": "properties.protocolPortList", "type": "[str]"},
        "inbound_inspection_certificate": {"key": "properties.inboundInspectionCertificate", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "action_type": {"key": "properties.actionType", "type": "str"},
        "enable_logging": {"key": "properties.enableLogging", "type": "str"},
        "decryption_rule_type": {"key": "properties.decryptionRuleType", "type": "str"},
        "tags": {"key": "properties.tags", "type": "[TagInfo]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        rule_name: str,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        rule_state: Optional[Union[str, "_models.StateEnum"]] = None,
        source: Optional["_models.SourceAddr"] = None,
        negate_source: Optional[Union[str, "_models.BooleanEnum"]] = None,
        destination: Optional["_models.DestinationAddr"] = None,
        negate_destination: Optional[Union[str, "_models.BooleanEnum"]] = None,
        applications: Optional[List[str]] = None,
        category: Optional["_models.Category"] = None,
        protocol: str = "application-default",
        protocol_port_list: Optional[List[str]] = None,
        inbound_inspection_certificate: Optional[str] = None,
        audit_comment: Optional[str] = None,
        action_type: Optional[Union[str, "_models.ActionEnum"]] = None,
        enable_logging: Optional[Union[str, "_models.StateEnum"]] = None,
        decryption_rule_type: Optional[Union[str, "_models.DecryptionRuleTypeEnum"]] = None,
        tags: Optional[List["_models.TagInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword rule_name: rule name. Required.
        :paramtype rule_name: str
        :keyword description: rule description.
        :paramtype description: str
        :keyword rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
        :paramtype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword source: source address.
        :paramtype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
        :keyword negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword destination: destination address.
        :paramtype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
        :keyword negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword applications: array of rule applications.
        :paramtype applications: list[str]
        :keyword category: rule category.
        :paramtype category: ~azure.mgmt.paloaltonetworks.models.Category
        :keyword protocol: any, application-default, TCP:number, UDP:number.
        :paramtype protocol: str
        :keyword protocol_port_list: prot port list.
        :paramtype protocol_port_list: list[str]
        :keyword inbound_inspection_certificate: inbound Inspection Certificate.
        :paramtype inbound_inspection_certificate: str
        :keyword audit_comment: rule comment.
        :paramtype audit_comment: str
        :keyword action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer",
         and "DenyResetBoth".
        :paramtype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
        :keyword enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
        :paramtype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword decryption_rule_type: enable or disable decryption. Known values are:
         "SSLOutboundInspection", "SSLInboundInspection", and "None".
        :paramtype decryption_rule_type: str or
         ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
        :keyword tags: tag for rule.
        :paramtype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.rule_name = rule_name
        self.priority = None
        self.description = description
        self.rule_state = rule_state
        self.source = source
        self.negate_source = negate_source
        self.destination = destination
        self.negate_destination = negate_destination
        self.applications = applications
        self.category = category
        self.protocol = protocol
        self.protocol_port_list = protocol_port_list
        self.inbound_inspection_certificate = inbound_inspection_certificate
        self.audit_comment = audit_comment
        self.action_type = action_type
        self.enable_logging = enable_logging
        self.decryption_rule_type = decryption_rule_type
        self.tags = tags
        self.provisioning_state = None


class PostRulesResourceListResult(_serialization.Model):
    """The response of a PostRulesResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.PostRulesResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PostRulesResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PostRulesResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.PostRulesResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PredefinedUrlCategoriesResponse(_serialization.Model):
    """predefined url categories response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: predefined url categories. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.PredefinedUrlCategory]
    :ivar next_link: next link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PredefinedUrlCategory]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PredefinedUrlCategory"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: predefined url categories. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.PredefinedUrlCategory]
        :keyword next_link: next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PredefinedUrlCategory(_serialization.Model):
    """Predefined URL category object.

    All required parameters must be populated in order to send to Azure.

    :ivar action: Required.
    :vartype action: str
    :ivar name: Required.
    :vartype name: str
    """

    _validation = {
        "action": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "action": {"key": "action", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, action: str, name: str, **kwargs: Any) -> None:
        """
        :keyword action: Required.
        :paramtype action: str
        :keyword name: Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.action = action
        self.name = name


class PrefixListGlobalRulestackResource(ProxyResource):
    """GlobalRulestack prefixList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar description: prefix description.
    :vartype description: str
    :ivar prefix_list: prefix list. Required.
    :vartype prefix_list: list[str]
    :ivar etag: etag info.
    :vartype etag: str
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "prefix_list": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "prefix_list": {"key": "properties.prefixList", "type": "[str]"},
        "etag": {"key": "properties.etag", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        prefix_list: List[str],
        description: Optional[str] = None,
        etag: Optional[str] = None,
        audit_comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: prefix description.
        :paramtype description: str
        :keyword prefix_list: prefix list. Required.
        :paramtype prefix_list: list[str]
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.prefix_list = prefix_list
        self.etag = etag
        self.audit_comment = audit_comment
        self.provisioning_state = None


class PrefixListGlobalRulestackResourceListResult(_serialization.Model):
    """The response of a PrefixListGlobalRulestackResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.PrefixListGlobalRulestackResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrefixListGlobalRulestackResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: List["_models.PrefixListGlobalRulestackResource"],
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.PrefixListGlobalRulestackResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrefixListResource(ProxyResource):
    """LocalRulestack prefixList.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar description: prefix description.
    :vartype description: str
    :ivar prefix_list: prefix list. Required.
    :vartype prefix_list: list[str]
    :ivar etag: etag info.
    :vartype etag: str
    :ivar audit_comment: comment for this object.
    :vartype audit_comment: str
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "prefix_list": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "prefix_list": {"key": "properties.prefixList", "type": "[str]"},
        "etag": {"key": "properties.etag", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        prefix_list: List[str],
        description: Optional[str] = None,
        etag: Optional[str] = None,
        audit_comment: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: prefix description.
        :paramtype description: str
        :keyword prefix_list: prefix list. Required.
        :paramtype prefix_list: list[str]
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword audit_comment: comment for this object.
        :paramtype audit_comment: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.prefix_list = prefix_list
        self.etag = etag
        self.audit_comment = audit_comment
        self.provisioning_state = None


class PrefixListResourceListResult(_serialization.Model):
    """The response of a PrefixListResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.PrefixListResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PrefixListResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PrefixListResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.PrefixListResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PreRulesResource(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """PreRulestack rule list.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.paloaltonetworks.models.SystemData
    :ivar etag: etag info.
    :vartype etag: str
    :ivar rule_name: rule name. Required.
    :vartype rule_name: str
    :ivar priority:
    :vartype priority: int
    :ivar description: rule description.
    :vartype description: str
    :ivar rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
    :vartype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar source: source address.
    :vartype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
    :ivar negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar destination: destination address.
    :vartype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
    :ivar negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
    :vartype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar applications: array of rule applications.
    :vartype applications: list[str]
    :ivar category: rule category.
    :vartype category: ~azure.mgmt.paloaltonetworks.models.Category
    :ivar protocol: any, application-default, TCP:number, UDP:number.
    :vartype protocol: str
    :ivar protocol_port_list: prot port list.
    :vartype protocol_port_list: list[str]
    :ivar inbound_inspection_certificate: inbound Inspection Certificate.
    :vartype inbound_inspection_certificate: str
    :ivar audit_comment: rule comment.
    :vartype audit_comment: str
    :ivar action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer", and
     "DenyResetBoth".
    :vartype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
    :ivar enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
    :vartype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
    :ivar decryption_rule_type: enable or disable decryption. Known values are:
     "SSLOutboundInspection", "SSLInboundInspection", and "None".
    :vartype decryption_rule_type: str or
     ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
    :ivar tags: tag for rule.
    :vartype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Accepted",
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", "Canceled", "Deleted", and
     "NotSpecified".
    :vartype provisioning_state: str or ~azure.mgmt.paloaltonetworks.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "rule_name": {"required": True},
        "priority": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "etag": {"key": "properties.etag", "type": "str"},
        "rule_name": {"key": "properties.ruleName", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "description": {"key": "properties.description", "type": "str"},
        "rule_state": {"key": "properties.ruleState", "type": "str"},
        "source": {"key": "properties.source", "type": "SourceAddr"},
        "negate_source": {"key": "properties.negateSource", "type": "str"},
        "destination": {"key": "properties.destination", "type": "DestinationAddr"},
        "negate_destination": {"key": "properties.negateDestination", "type": "str"},
        "applications": {"key": "properties.applications", "type": "[str]"},
        "category": {"key": "properties.category", "type": "Category"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "protocol_port_list": {"key": "properties.protocolPortList", "type": "[str]"},
        "inbound_inspection_certificate": {"key": "properties.inboundInspectionCertificate", "type": "str"},
        "audit_comment": {"key": "properties.auditComment", "type": "str"},
        "action_type": {"key": "properties.actionType", "type": "str"},
        "enable_logging": {"key": "properties.enableLogging", "type": "str"},
        "decryption_rule_type": {"key": "properties.decryptionRuleType", "type": "str"},
        "tags": {"key": "properties.tags", "type": "[TagInfo]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        rule_name: str,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        rule_state: Optional[Union[str, "_models.StateEnum"]] = None,
        source: Optional["_models.SourceAddr"] = None,
        negate_source: Optional[Union[str, "_models.BooleanEnum"]] = None,
        destination: Optional["_models.DestinationAddr"] = None,
        negate_destination: Optional[Union[str, "_models.BooleanEnum"]] = None,
        applications: Optional[List[str]] = None,
        category: Optional["_models.Category"] = None,
        protocol: str = "application-default",
        protocol_port_list: Optional[List[str]] = None,
        inbound_inspection_certificate: Optional[str] = None,
        audit_comment: Optional[str] = None,
        action_type: Optional[Union[str, "_models.ActionEnum"]] = None,
        enable_logging: Optional[Union[str, "_models.StateEnum"]] = None,
        decryption_rule_type: Optional[Union[str, "_models.DecryptionRuleTypeEnum"]] = None,
        tags: Optional[List["_models.TagInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword etag: etag info.
        :paramtype etag: str
        :keyword rule_name: rule name. Required.
        :paramtype rule_name: str
        :keyword description: rule description.
        :paramtype description: str
        :keyword rule_state: state of this rule. Known values are: "DISABLED" and "ENABLED".
        :paramtype rule_state: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword source: source address.
        :paramtype source: ~azure.mgmt.paloaltonetworks.models.SourceAddr
        :keyword negate_source: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_source: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword destination: destination address.
        :paramtype destination: ~azure.mgmt.paloaltonetworks.models.DestinationAddr
        :keyword negate_destination: cidr should not be 'any'. Known values are: "TRUE" and "FALSE".
        :paramtype negate_destination: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword applications: array of rule applications.
        :paramtype applications: list[str]
        :keyword category: rule category.
        :paramtype category: ~azure.mgmt.paloaltonetworks.models.Category
        :keyword protocol: any, application-default, TCP:number, UDP:number.
        :paramtype protocol: str
        :keyword protocol_port_list: prot port list.
        :paramtype protocol_port_list: list[str]
        :keyword inbound_inspection_certificate: inbound Inspection Certificate.
        :paramtype inbound_inspection_certificate: str
        :keyword audit_comment: rule comment.
        :paramtype audit_comment: str
        :keyword action_type: rule action. Known values are: "Allow", "DenySilent", "DenyResetServer",
         and "DenyResetBoth".
        :paramtype action_type: str or ~azure.mgmt.paloaltonetworks.models.ActionEnum
        :keyword enable_logging: enable or disable logging. Known values are: "DISABLED" and "ENABLED".
        :paramtype enable_logging: str or ~azure.mgmt.paloaltonetworks.models.StateEnum
        :keyword decryption_rule_type: enable or disable decryption. Known values are:
         "SSLOutboundInspection", "SSLInboundInspection", and "None".
        :paramtype decryption_rule_type: str or
         ~azure.mgmt.paloaltonetworks.models.DecryptionRuleTypeEnum
        :keyword tags: tag for rule.
        :paramtype tags: list[~azure.mgmt.paloaltonetworks.models.TagInfo]
        """
        super().__init__(**kwargs)
        self.etag = etag
        self.rule_name = rule_name
        self.priority = None
        self.description = description
        self.rule_state = rule_state
        self.source = source
        self.negate_source = negate_source
        self.destination = destination
        self.negate_destination = negate_destination
        self.applications = applications
        self.category = category
        self.protocol = protocol
        self.protocol_port_list = protocol_port_list
        self.inbound_inspection_certificate = inbound_inspection_certificate
        self.audit_comment = audit_comment
        self.action_type = action_type
        self.enable_logging = enable_logging
        self.decryption_rule_type = decryption_rule_type
        self.tags = tags
        self.provisioning_state = None


class PreRulesResourceListResult(_serialization.Model):
    """The response of a PreRulesResource list operation.

    All required parameters must be populated in order to send to Azure.

    :ivar value: The items on this page. Required.
    :vartype value: list[~azure.mgmt.paloaltonetworks.models.PreRulesResource]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PreRulesResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: List["_models.PreRulesResource"], next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The items on this page. Required.
        :paramtype value: list[~azure.mgmt.paloaltonetworks.models.PreRulesResource]
        :keyword next_link: The link to the next page of items.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RuleCounter(_serialization.Model):
    """Rule counter.

    All required parameters must be populated in order to send to Azure.

    :ivar priority: priority number. Required.
    :vartype priority: str
    :ivar rule_stack_name: rule Stack Name.
    :vartype rule_stack_name: str
    :ivar rule_list_name: rule list name.
    :vartype rule_list_name: str
    :ivar firewall_name: firewall name.
    :vartype firewall_name: str
    :ivar rule_name: rule name. Required.
    :vartype rule_name: str
    :ivar hit_count: hit count.
    :vartype hit_count: int
    :ivar app_seen: apps seen.
    :vartype app_seen: ~azure.mgmt.paloaltonetworks.models.AppSeenData
    :ivar timestamp: timestamp of response.
    :vartype timestamp: ~datetime.datetime
    :ivar request_timestamp: timestamp of request.
    :vartype request_timestamp: ~datetime.datetime
    :ivar last_updated_timestamp: last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    """

    _validation = {
        "priority": {"required": True},
        "rule_name": {"required": True},
    }

    _attribute_map = {
        "priority": {"key": "priority", "type": "str"},
        "rule_stack_name": {"key": "ruleStackName", "type": "str"},
        "rule_list_name": {"key": "ruleListName", "type": "str"},
        "firewall_name": {"key": "firewallName", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
        "hit_count": {"key": "hitCount", "type": "int"},
        "app_seen": {"key": "appSeen", "type": "AppSeenData"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "request_timestamp": {"key": "requestTimestamp", "type": "iso-8601"},
        "last_updated_timestamp": {"key": "lastUpdatedTimestamp", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        priority: str,
        rule_name: str,
        rule_stack_name: Optional[str] = None,
        rule_list_name: Optional[str] = None,
        firewall_name: Optional[str] = None,
        hit_count: Optional[int] = None,
        app_seen: Optional["_models.AppSeenData"] = None,
        timestamp: Optional[datetime.datetime] = None,
        request_timestamp: Optional[datetime.datetime] = None,
        last_updated_timestamp: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword priority: priority number. Required.
        :paramtype priority: str
        :keyword rule_stack_name: rule Stack Name.
        :paramtype rule_stack_name: str
        :keyword rule_list_name: rule list name.
        :paramtype rule_list_name: str
        :keyword firewall_name: firewall name.
        :paramtype firewall_name: str
        :keyword rule_name: rule name. Required.
        :paramtype rule_name: str
        :keyword hit_count: hit count.
        :paramtype hit_count: int
        :keyword app_seen: apps seen.
        :paramtype app_seen: ~azure.mgmt.paloaltonetworks.models.AppSeenData
        :keyword timestamp: timestamp of response.
        :paramtype timestamp: ~datetime.datetime
        :keyword request_timestamp: timestamp of request.
        :paramtype request_timestamp: ~datetime.datetime
        :keyword last_updated_timestamp: last updated timestamp.
        :paramtype last_updated_timestamp: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.priority = priority
        self.rule_stack_name = rule_stack_name
        self.rule_list_name = rule_list_name
        self.firewall_name = firewall_name
        self.rule_name = rule_name
        self.hit_count = hit_count
        self.app_seen = app_seen
        self.timestamp = timestamp
        self.request_timestamp = request_timestamp
        self.last_updated_timestamp = last_updated_timestamp


class RuleCounterReset(_serialization.Model):
    """Rule counter reset.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar priority: priority number.
    :vartype priority: str
    :ivar rule_stack_name: rule Stack Name.
    :vartype rule_stack_name: str
    :ivar rule_list_name: rule list name.
    :vartype rule_list_name: str
    :ivar firewall_name: firewall name.
    :vartype firewall_name: str
    :ivar rule_name: rule name.
    :vartype rule_name: str
    """

    _validation = {
        "priority": {"readonly": True},
    }

    _attribute_map = {
        "priority": {"key": "priority", "type": "str"},
        "rule_stack_name": {"key": "ruleStackName", "type": "str"},
        "rule_list_name": {"key": "ruleListName", "type": "str"},
        "firewall_name": {"key": "firewallName", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
    }

    def __init__(
        self,
        *,
        rule_stack_name: Optional[str] = None,
        rule_list_name: Optional[str] = None,
        firewall_name: Optional[str] = None,
        rule_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_stack_name: rule Stack Name.
        :paramtype rule_stack_name: str
        :keyword rule_list_name: rule list name.
        :paramtype rule_list_name: str
        :keyword firewall_name: firewall name.
        :paramtype firewall_name: str
        :keyword rule_name: rule name.
        :paramtype rule_name: str
        """
        super().__init__(**kwargs)
        self.priority = None
        self.rule_stack_name = rule_stack_name
        self.rule_list_name = rule_list_name
        self.firewall_name = firewall_name
        self.rule_name = rule_name


class RulestackDetails(_serialization.Model):
    """Associated rulestack details.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar rulestack_id: Associated rulestack Id.
    :vartype rulestack_id: str
    :ivar location: Rulestack location.
    :vartype location: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "rulestack_id": {"key": "rulestackId", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        rulestack_id: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        :keyword rulestack_id: Associated rulestack Id.
        :paramtype rulestack_id: str
        :keyword location: Rulestack location.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.rulestack_id = rulestack_id
        self.location = location


class SecurityServices(_serialization.Model):
    """security services.

    :ivar vulnerability_profile: IPs Vulnerability Profile Data.
    :vartype vulnerability_profile: str
    :ivar anti_spyware_profile: Anti spyware Profile data.
    :vartype anti_spyware_profile: str
    :ivar anti_virus_profile: anti virus profile data.
    :vartype anti_virus_profile: str
    :ivar url_filtering_profile: URL filtering profile data.
    :vartype url_filtering_profile: str
    :ivar file_blocking_profile: File blocking profile data.
    :vartype file_blocking_profile: str
    :ivar dns_subscription: DNS Subscription profile data.
    :vartype dns_subscription: str
    :ivar outbound_un_trust_certificate: Untrusted Egress Decryption profile data.
    :vartype outbound_un_trust_certificate: str
    :ivar outbound_trust_certificate: Trusted Egress Decryption profile data.
    :vartype outbound_trust_certificate: str
    """

    _attribute_map = {
        "vulnerability_profile": {"key": "vulnerabilityProfile", "type": "str"},
        "anti_spyware_profile": {"key": "antiSpywareProfile", "type": "str"},
        "anti_virus_profile": {"key": "antiVirusProfile", "type": "str"},
        "url_filtering_profile": {"key": "urlFilteringProfile", "type": "str"},
        "file_blocking_profile": {"key": "fileBlockingProfile", "type": "str"},
        "dns_subscription": {"key": "dnsSubscription", "type": "str"},
        "outbound_un_trust_certificate": {"key": "outboundUnTrustCertificate", "type": "str"},
        "outbound_trust_certificate": {"key": "outboundTrustCertificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        vulnerability_profile: Optional[str] = None,
        anti_spyware_profile: Optional[str] = None,
        anti_virus_profile: Optional[str] = None,
        url_filtering_profile: Optional[str] = None,
        file_blocking_profile: Optional[str] = None,
        dns_subscription: Optional[str] = None,
        outbound_un_trust_certificate: Optional[str] = None,
        outbound_trust_certificate: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vulnerability_profile: IPs Vulnerability Profile Data.
        :paramtype vulnerability_profile: str
        :keyword anti_spyware_profile: Anti spyware Profile data.
        :paramtype anti_spyware_profile: str
        :keyword anti_virus_profile: anti virus profile data.
        :paramtype anti_virus_profile: str
        :keyword url_filtering_profile: URL filtering profile data.
        :paramtype url_filtering_profile: str
        :keyword file_blocking_profile: File blocking profile data.
        :paramtype file_blocking_profile: str
        :keyword dns_subscription: DNS Subscription profile data.
        :paramtype dns_subscription: str
        :keyword outbound_un_trust_certificate: Untrusted Egress Decryption profile data.
        :paramtype outbound_un_trust_certificate: str
        :keyword outbound_trust_certificate: Trusted Egress Decryption profile data.
        :paramtype outbound_trust_certificate: str
        """
        super().__init__(**kwargs)
        self.vulnerability_profile = vulnerability_profile
        self.anti_spyware_profile = anti_spyware_profile
        self.anti_virus_profile = anti_virus_profile
        self.url_filtering_profile = url_filtering_profile
        self.file_blocking_profile = file_blocking_profile
        self.dns_subscription = dns_subscription
        self.outbound_un_trust_certificate = outbound_un_trust_certificate
        self.outbound_trust_certificate = outbound_trust_certificate


class SecurityServicesResponse(_serialization.Model):
    """Security services list response.

    All required parameters must be populated in order to send to Azure.

    :ivar value: response value. Required.
    :vartype value: ~azure.mgmt.paloaltonetworks.models.SecurityServicesTypeList
    :ivar next_link: next link.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "SecurityServicesTypeList"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: "_models.SecurityServicesTypeList", next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: response value. Required.
        :paramtype value: ~azure.mgmt.paloaltonetworks.models.SecurityServicesTypeList
        :keyword next_link: next link.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityServicesTypeList(_serialization.Model):
    """Security services type list.

    All required parameters must be populated in order to send to Azure.

    :ivar type: security services type.
    :vartype type: str
    :ivar entry: list. Required.
    :vartype entry: list[~azure.mgmt.paloaltonetworks.models.NameDescriptionObject]
    """

    _validation = {
        "entry": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "entry": {"key": "entry", "type": "[NameDescriptionObject]"},
    }

    def __init__(
        self, *, entry: List["_models.NameDescriptionObject"], type: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword type: security services type.
        :paramtype type: str
        :keyword entry: list. Required.
        :paramtype entry: list[~azure.mgmt.paloaltonetworks.models.NameDescriptionObject]
        """
        super().__init__(**kwargs)
        self.type = type
        self.entry = entry


class SourceAddr(_serialization.Model):
    """Address properties.

    :ivar cidrs: special value 'any'.
    :vartype cidrs: list[str]
    :ivar countries: list of countries.
    :vartype countries: list[str]
    :ivar feeds: list of feeds.
    :vartype feeds: list[str]
    :ivar prefix_lists: prefix list.
    :vartype prefix_lists: list[str]
    """

    _attribute_map = {
        "cidrs": {"key": "cidrs", "type": "[str]"},
        "countries": {"key": "countries", "type": "[str]"},
        "feeds": {"key": "feeds", "type": "[str]"},
        "prefix_lists": {"key": "prefixLists", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        cidrs: Optional[List[str]] = None,
        countries: Optional[List[str]] = None,
        feeds: Optional[List[str]] = None,
        prefix_lists: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cidrs: special value 'any'.
        :paramtype cidrs: list[str]
        :keyword countries: list of countries.
        :paramtype countries: list[str]
        :keyword feeds: list of feeds.
        :paramtype feeds: list[str]
        :keyword prefix_lists: prefix list.
        :paramtype prefix_lists: list[str]
        """
        super().__init__(**kwargs)
        self.cidrs = cidrs
        self.countries = countries
        self.feeds = feeds
        self.prefix_lists = prefix_lists


class StorageAccount(_serialization.Model):
    """Storage Account configurations.

    :ivar id: Resource ID of storage account.
    :vartype id: str
    :ivar subscription_id: Subscription Id.
    :vartype subscription_id: str
    :ivar account_name: Storage account name.
    :vartype account_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        subscription_id: Optional[str] = None,
        account_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of storage account.
        :paramtype id: str
        :keyword subscription_id: Subscription Id.
        :paramtype subscription_id: str
        :keyword account_name: Storage account name.
        :paramtype account_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.subscription_id = subscription_id
        self.account_name = account_name


class SupportInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Support information for the resource.

    :ivar product_sku: product SKU associated with given resource.
    :vartype product_sku: str
    :ivar product_serial: product Serial associated with given resource.
    :vartype product_serial: str
    :ivar account_registered: account registered in Customer Support Portal. Known values are:
     "TRUE" and "FALSE".
    :vartype account_registered: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar account_id: Support account associated with given resource.
    :vartype account_id: str
    :ivar user_domain_supported: user domain is supported in Customer Support Portal. Known values
     are: "TRUE" and "FALSE".
    :vartype user_domain_supported: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar user_registered: user registered in Customer Support Portal. Known values are: "TRUE" and
     "FALSE".
    :vartype user_registered: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar free_trial: Product usage is in free trial period. Known values are: "TRUE" and "FALSE".
    :vartype free_trial: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
    :ivar free_trial_days_left: Free trial days remaining.
    :vartype free_trial_days_left: int
    :ivar free_trial_credit_left: Free trial credit remaining.
    :vartype free_trial_credit_left: int
    :ivar help_url: URL for paloaltonetworks live community.
    :vartype help_url: str
    :ivar support_url: URL for paloaltonetworks Customer Service Portal.
    :vartype support_url: str
    :ivar register_url: URL for registering product in paloaltonetworks Customer Service Portal.
    :vartype register_url: str
    """

    _attribute_map = {
        "product_sku": {"key": "productSku", "type": "str"},
        "product_serial": {"key": "productSerial", "type": "str"},
        "account_registered": {"key": "accountRegistered", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "user_domain_supported": {"key": "userDomainSupported", "type": "str"},
        "user_registered": {"key": "userRegistered", "type": "str"},
        "free_trial": {"key": "freeTrial", "type": "str"},
        "free_trial_days_left": {"key": "freeTrialDaysLeft", "type": "int"},
        "free_trial_credit_left": {"key": "freeTrialCreditLeft", "type": "int"},
        "help_url": {"key": "helpURL", "type": "str"},
        "support_url": {"key": "supportURL", "type": "str"},
        "register_url": {"key": "registerURL", "type": "str"},
    }

    def __init__(
        self,
        *,
        product_sku: Optional[str] = None,
        product_serial: Optional[str] = None,
        account_registered: Optional[Union[str, "_models.BooleanEnum"]] = None,
        account_id: Optional[str] = None,
        user_domain_supported: Optional[Union[str, "_models.BooleanEnum"]] = None,
        user_registered: Optional[Union[str, "_models.BooleanEnum"]] = None,
        free_trial: Optional[Union[str, "_models.BooleanEnum"]] = None,
        free_trial_days_left: Optional[int] = None,
        free_trial_credit_left: Optional[int] = None,
        help_url: Optional[str] = None,
        support_url: Optional[str] = None,
        register_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword product_sku: product SKU associated with given resource.
        :paramtype product_sku: str
        :keyword product_serial: product Serial associated with given resource.
        :paramtype product_serial: str
        :keyword account_registered: account registered in Customer Support Portal. Known values are:
         "TRUE" and "FALSE".
        :paramtype account_registered: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword account_id: Support account associated with given resource.
        :paramtype account_id: str
        :keyword user_domain_supported: user domain is supported in Customer Support Portal. Known
         values are: "TRUE" and "FALSE".
        :paramtype user_domain_supported: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword user_registered: user registered in Customer Support Portal. Known values are: "TRUE"
         and "FALSE".
        :paramtype user_registered: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword free_trial: Product usage is in free trial period. Known values are: "TRUE" and
         "FALSE".
        :paramtype free_trial: str or ~azure.mgmt.paloaltonetworks.models.BooleanEnum
        :keyword free_trial_days_left: Free trial days remaining.
        :paramtype free_trial_days_left: int
        :keyword free_trial_credit_left: Free trial credit remaining.
        :paramtype free_trial_credit_left: int
        :keyword help_url: URL for paloaltonetworks live community.
        :paramtype help_url: str
        :keyword support_url: URL for paloaltonetworks Customer Service Portal.
        :paramtype support_url: str
        :keyword register_url: URL for registering product in paloaltonetworks Customer Service Portal.
        :paramtype register_url: str
        """
        super().__init__(**kwargs)
        self.product_sku = product_sku
        self.product_serial = product_serial
        self.account_registered = account_registered
        self.account_id = account_id
        self.user_domain_supported = user_domain_supported
        self.user_registered = user_registered
        self.free_trial = free_trial
        self.free_trial_days_left = free_trial_days_left
        self.free_trial_credit_left = free_trial_credit_left
        self.help_url = help_url
        self.support_url = support_url
        self.register_url = register_url


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.paloaltonetworks.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.paloaltonetworks.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.paloaltonetworks.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.paloaltonetworks.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagInfo(_serialization.Model):
    """Tag.

    All required parameters must be populated in order to send to Azure.

    :ivar key: tag name. Required.
    :vartype key: str
    :ivar value: tag value. Required.
    :vartype value: str
    """

    _validation = {
        "key": {"required": True},
        "value": {"required": True},
    }

    _attribute_map = {
        "key": {"key": "key", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, key: str, value: str, **kwargs: Any) -> None:
        """
        :keyword key: tag name. Required.
        :paramtype key: str
        :keyword value: tag value. Required.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.key = key
        self.value = value


class VnetConfiguration(_serialization.Model):
    """VnetInfo for Firewall Networking.

    All required parameters must be populated in order to send to Azure.

    :ivar vnet: Azure Virtual Network. Required.
    :vartype vnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar trust_subnet: Trust Subnet. Required.
    :vartype trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar un_trust_subnet: Untrust Subnet. Required.
    :vartype un_trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar ip_of_trust_subnet_for_udr: IP of trust subnet for UDR.
    :vartype ip_of_trust_subnet_for_udr: ~azure.mgmt.paloaltonetworks.models.IPAddress
    """

    _validation = {
        "vnet": {"required": True},
        "trust_subnet": {"required": True},
        "un_trust_subnet": {"required": True},
    }

    _attribute_map = {
        "vnet": {"key": "vnet", "type": "IPAddressSpace"},
        "trust_subnet": {"key": "trustSubnet", "type": "IPAddressSpace"},
        "un_trust_subnet": {"key": "unTrustSubnet", "type": "IPAddressSpace"},
        "ip_of_trust_subnet_for_udr": {"key": "ipOfTrustSubnetForUdr", "type": "IPAddress"},
    }

    def __init__(
        self,
        *,
        vnet: "_models.IPAddressSpace",
        trust_subnet: "_models.IPAddressSpace",
        un_trust_subnet: "_models.IPAddressSpace",
        ip_of_trust_subnet_for_udr: Optional["_models.IPAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vnet: Azure Virtual Network. Required.
        :paramtype vnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword trust_subnet: Trust Subnet. Required.
        :paramtype trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword un_trust_subnet: Untrust Subnet. Required.
        :paramtype un_trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword ip_of_trust_subnet_for_udr: IP of trust subnet for UDR.
        :paramtype ip_of_trust_subnet_for_udr: ~azure.mgmt.paloaltonetworks.models.IPAddress
        """
        super().__init__(**kwargs)
        self.vnet = vnet
        self.trust_subnet = trust_subnet
        self.un_trust_subnet = un_trust_subnet
        self.ip_of_trust_subnet_for_udr = ip_of_trust_subnet_for_udr


class VwanConfiguration(_serialization.Model):
    """VwanInfo for Firewall Networking.

    All required parameters must be populated in order to send to Azure.

    :ivar network_virtual_appliance_id: Network Virtual Appliance resource ID.
    :vartype network_virtual_appliance_id: str
    :ivar v_hub: vHub Address. Required.
    :vartype v_hub: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar trust_subnet: Trust Subnet.
    :vartype trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar un_trust_subnet: Untrust Subnet.
    :vartype un_trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
    :ivar ip_of_trust_subnet_for_udr: IP of trust subnet for UDR.
    :vartype ip_of_trust_subnet_for_udr: ~azure.mgmt.paloaltonetworks.models.IPAddress
    """

    _validation = {
        "v_hub": {"required": True},
    }

    _attribute_map = {
        "network_virtual_appliance_id": {"key": "networkVirtualApplianceId", "type": "str"},
        "v_hub": {"key": "vHub", "type": "IPAddressSpace"},
        "trust_subnet": {"key": "trustSubnet", "type": "IPAddressSpace"},
        "un_trust_subnet": {"key": "unTrustSubnet", "type": "IPAddressSpace"},
        "ip_of_trust_subnet_for_udr": {"key": "ipOfTrustSubnetForUdr", "type": "IPAddress"},
    }

    def __init__(
        self,
        *,
        v_hub: "_models.IPAddressSpace",
        network_virtual_appliance_id: Optional[str] = None,
        trust_subnet: Optional["_models.IPAddressSpace"] = None,
        un_trust_subnet: Optional["_models.IPAddressSpace"] = None,
        ip_of_trust_subnet_for_udr: Optional["_models.IPAddress"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_virtual_appliance_id: Network Virtual Appliance resource ID.
        :paramtype network_virtual_appliance_id: str
        :keyword v_hub: vHub Address. Required.
        :paramtype v_hub: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword trust_subnet: Trust Subnet.
        :paramtype trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword un_trust_subnet: Untrust Subnet.
        :paramtype un_trust_subnet: ~azure.mgmt.paloaltonetworks.models.IPAddressSpace
        :keyword ip_of_trust_subnet_for_udr: IP of trust subnet for UDR.
        :paramtype ip_of_trust_subnet_for_udr: ~azure.mgmt.paloaltonetworks.models.IPAddress
        """
        super().__init__(**kwargs)
        self.network_virtual_appliance_id = network_virtual_appliance_id
        self.v_hub = v_hub
        self.trust_subnet = trust_subnet
        self.un_trust_subnet = un_trust_subnet
        self.ip_of_trust_subnet_for_udr = ip_of_trust_subnet_for_udr
