# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """ActionEnum."""

    ALLOW = "Allow"
    DENY_SILENT = "DenySilent"
    DENY_RESET_SERVER = "DenyResetServer"
    DENY_RESET_BOTH = "DenyResetBoth"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class AdvSecurityObjectTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """AdvSecurityObjectTypeEnum."""

    URL_CUSTOM = "urlCustom"
    FEEDS = "feeds"


class BillingCycle(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Billing cycle."""

    WEEKLY = "WEEKLY"
    MONTHLY = "MONTHLY"


class BooleanEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Boolean Enum."""

    TRUE = "TRUE"
    FALSE = "FALSE"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DecryptionRuleTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DecryptionRuleTypeEnum."""

    SSL_OUTBOUND_INSPECTION = "SSLOutboundInspection"
    SSL_INBOUND_INSPECTION = "SSLInboundInspection"
    NONE = "None"


class DefaultMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type for Default Mode for rules creation."""

    IPS = "IPS"
    FIREWALL = "FIREWALL"
    NONE = "NONE"


class DNSProxy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS Proxy."""

    DISABLED = "DISABLED"
    ENABLED = "ENABLED"


class EgressNat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Egress NAT."""

    DISABLED = "DISABLED"
    ENABLED = "ENABLED"


class EnabledDNSType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enabled DNS type values."""

    CUSTOM = "CUSTOM"
    AZURE = "AZURE"


class LogOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log options possible."""

    SAME_DESTINATION = "SAME_DESTINATION"
    INDIVIDUAL_DESTINATION = "INDIVIDUAL_DESTINATION"


class LogType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Possible log types."""

    TRAFFIC = "TRAFFIC"
    THREAT = "THREAT"
    DECRYPTION = "DECRYPTION"
    WILDFIRE = "WILDFIRE"
    DLP = "DLP"
    AUDIT = "AUDIT"


class ManagedIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of managed identity assigned to this resource."""

    NONE = "None"
    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_AND_USER_ASSIGNED = "SystemAssigned,UserAssigned"


class MarketplaceSubscriptionStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Marketplace Subscription Status."""

    PENDING_FULFILLMENT_START = "PendingFulfillmentStart"
    SUBSCRIBED = "Subscribed"
    SUSPENDED = "Suspended"
    UNSUBSCRIBED = "Unsubscribed"
    NOT_STARTED = "NotStarted"
    FULFILLMENT_REQUESTED = "FulfillmentRequested"


class NetworkType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """NetworkType Enum."""

    VNET = "VNET"
    VWAN = "VWAN"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProtocolType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Protocol Enum."""

    TCP = "TCP"
    UDP = "UDP"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the firewall resource."""

    ACCEPTED = "Accepted"
    CREATING = "Creating"
    UPDATING = "Updating"
    DELETING = "Deleting"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
    DELETED = "Deleted"
    NOT_SPECIFIED = "NotSpecified"


class ScopeType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Rulestack Type."""

    LOCAL = "LOCAL"
    GLOBAL = "GLOBAL"


class SecurityServicesTypeEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SecurityServicesTypeEnum."""

    ANTI_SPYWARE = "antiSpyware"
    ANTI_VIRUS = "antiVirus"
    IPS_VULNERABILITY = "ipsVulnerability"
    URL_FILTERING = "urlFiltering"
    FILE_BLOCKING = "fileBlocking"
    DNS_SUBSCRIPTION = "dnsSubscription"


class StateEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enabled or Disabled Enum."""

    DISABLED = "DISABLED"
    ENABLED = "ENABLED"


class UsageType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Usage Type."""

    PAYG = "PAYG"
    COMMITTED = "COMMITTED"
