
# Autogenerated by mlir-tblgen; don't manually edit.

from jaxlib.mlir.dialects._ods_common import _cext as _ods_cext
from jaxlib.mlir.dialects._ods_common import (
    equally_sized_accessor as _ods_equally_sized_accessor,
    get_default_loc_context as _ods_get_default_loc_context,
    get_op_result_or_op_results as _get_op_result_or_op_results,
    get_op_results_or_values as _get_op_results_or_values,
    segmented_accessor as _ods_segmented_accessor,
)
_ods_ir = _ods_cext.ir

import builtins
from typing import Sequence as _Sequence, Union as _Union


@_ods_cext.register_dialect
class _Dialect(_ods_ir.Dialect):
  DIALECT_NAMESPACE = "mosaic_gpu"

@_ods_cext.register_operation(_Dialect)
class ArriveExpectTxOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.arrive_expect_tx"

  _ODS_REGIONS = (0, True)

  def __init__(self, barrier, expect_tx, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(barrier)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["expect_tx"] = (expect_tx if (
    isinstance(expect_tx, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I32Attr')) else
      _ods_ir.AttrBuilder.get('I32Attr')(expect_tx, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def barrier(self):
    return self.operation.operands[0]

  @builtins.property
  def expect_tx(self):
    return self.operation.attributes["expect_tx"]

  @expect_tx.setter
  def expect_tx(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["expect_tx"] = value

def arrive_expect_tx(barrier, expect_tx, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ArriveExpectTxOp(barrier=barrier, expect_tx=expect_tx, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AsyncLoadOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.async_load"

  _ODS_OPERAND_SEGMENTS = [1,1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, destination, barrier, indices, slice_lengths, collective, *, predicate=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(destination)
    operands.append(barrier)
    operands.append(_get_op_results_or_values(indices))
    operands.append(predicate)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["slice_lengths"] = (slice_lengths if (
    isinstance(slice_lengths, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(slice_lengths, context=_ods_context))
    attributes["collective"] = (collective if (
    isinstance(collective, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_709')) else
      _ods_ir.AttrBuilder.get('anonymous_709')(collective, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def destination(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def barrier(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range

  @builtins.property
  def predicate(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def slice_lengths(self):
    return self.operation.attributes["slice_lengths"]

  @slice_lengths.setter
  def slice_lengths(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["slice_lengths"] = value

  @builtins.property
  def collective(self):
    return self.operation.attributes["collective"]

  @collective.setter
  def collective(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["collective"] = value

def async_load(source, destination, barrier, indices, slice_lengths, collective, *, predicate=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AsyncLoadOp(source=source, destination=destination, barrier=barrier, indices=indices, slice_lengths=slice_lengths, collective=collective, predicate=predicate, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AsyncLoadTmemOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.async_load_tmem"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(source)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self):
    return self.operation.operands[0]

def async_load_tmem(source, *, loc=None, ip=None) -> _ods_ir.Value:
  return AsyncLoadTmemOp(source=source, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class AsyncStoreOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.async_store"

  _ODS_OPERAND_SEGMENTS = [1,1,-1,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, source, destination, indices, slice_lengths, *, predicate=None, commit_group=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(destination)
    operands.append(_get_op_results_or_values(indices))
    operands.append(predicate)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["slice_lengths"] = (slice_lengths if (
    isinstance(slice_lengths, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(slice_lengths, context=_ods_context))
    if commit_group is not None: attributes["commit_group"] = (commit_group if (
        isinstance(commit_group, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(commit_group, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def destination(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def indices(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range

  @builtins.property
  def predicate(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def slice_lengths(self):
    return self.operation.attributes["slice_lengths"]

  @slice_lengths.setter
  def slice_lengths(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["slice_lengths"] = value

  @builtins.property
  def commit_group(self):
    if "commit_group" not in self.operation.attributes:
      return None
    return self.operation.attributes["commit_group"]

  @commit_group.setter
  def commit_group(self, value):
    if value is not None:
      self.operation.attributes["commit_group"] = value
    elif "commit_group" in self.operation.attributes:
      del self.operation.attributes["commit_group"]

  @commit_group.deleter
  def commit_group(self):
    del self.operation.attributes["commit_group"]

def async_store(source, destination, indices, slice_lengths, *, predicate=None, commit_group=None, loc=None, ip=None) -> _ods_ir.Operation:
  return AsyncStoreOp(source=source, destination=destination, indices=indices, slice_lengths=slice_lengths, predicate=predicate, commit_group=commit_group, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class AsyncStoreTmemOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.async_store_tmem"

  _ODS_REGIONS = (0, True)

  def __init__(self, source, destination, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(source)
    operands.append(destination)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def source(self):
    return self.operation.operands[0]

  @builtins.property
  def destination(self):
    return self.operation.operands[1]

def async_store_tmem(source, destination, *, loc=None, ip=None) -> _ods_ir.Operation:
  return AsyncStoreTmemOp(source=source, destination=destination, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class BroadcastInDimOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.broadcast_in_dim"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, operand, broadcast_dimensions, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(operand)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["broadcast_dimensions"] = (broadcast_dimensions if (
    isinstance(broadcast_dimensions, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('DenseI64ArrayAttr')) else
      _ods_ir.AttrBuilder.get('DenseI64ArrayAttr')(broadcast_dimensions, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operand(self):
    return self.operation.operands[0]

  @builtins.property
  def broadcast_dimensions(self):
    return self.operation.attributes["broadcast_dimensions"]

  @broadcast_dimensions.setter
  def broadcast_dimensions(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["broadcast_dimensions"] = value

def broadcast_in_dim(result, operand, broadcast_dimensions, *, loc=None, ip=None) -> _ods_ir.Value:
  return BroadcastInDimOp(result=result, operand=operand, broadcast_dimensions=broadcast_dimensions, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class CustomPrimitiveOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.custom_primitive"

  _ODS_REGIONS = (1, True)

  def __init__(self, result, operands_, in_layouts, in_transforms, out_layouts, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["in_layouts"] = (in_layouts if (
    isinstance(in_layouts, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(in_layouts, context=_ods_context))
    attributes["in_transforms"] = (in_transforms if (
    isinstance(in_transforms, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(in_transforms, context=_ods_context))
    attributes["out_layouts"] = (out_layouts if (
    isinstance(out_layouts, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(out_layouts, context=_ods_context))
    results.extend(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

  @builtins.property
  def in_layouts(self):
    return self.operation.attributes["in_layouts"]

  @in_layouts.setter
  def in_layouts(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["in_layouts"] = value

  @builtins.property
  def in_transforms(self):
    return self.operation.attributes["in_transforms"]

  @in_transforms.setter
  def in_transforms(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["in_transforms"] = value

  @builtins.property
  def out_layouts(self):
    return self.operation.attributes["out_layouts"]

  @out_layouts.setter
  def out_layouts(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["out_layouts"] = value

  @builtins.property
  def body(self):
    return self.regions[0]

def custom_primitive(result, operands_, in_layouts, in_transforms, out_layouts, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(CustomPrimitiveOp(result=result, operands_=operands_, in_layouts=in_layouts, in_transforms=in_transforms, out_layouts=out_layouts, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class InitializeBarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.initialize_barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, barriers_ref, base_pointer, arrival_count, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(base_pointer)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["arrival_count"] = (arrival_count if (
    isinstance(arrival_count, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('I64Attr')) else
      _ods_ir.AttrBuilder.get('I64Attr')(arrival_count, context=_ods_context))
    results.append(barriers_ref)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def base_pointer(self):
    return self.operation.operands[0]

  @builtins.property
  def arrival_count(self):
    return self.operation.attributes["arrival_count"]

  @arrival_count.setter
  def arrival_count(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["arrival_count"] = value

  @builtins.property
  def barriers_ref(self):
    return self.operation.results[0]

def initialize_barrier(barriers_ref, base_pointer, arrival_count, *, loc=None, ip=None) -> _ods_ir.Value:
  return InitializeBarrierOp(barriers_ref=barriers_ref, base_pointer=base_pointer, arrival_count=arrival_count, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class LayoutCastOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.layout_cast"

  _ODS_REGIONS = (0, True)

  def __init__(self, x, new_layout, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(x)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["new_layout"] = (new_layout if (
    isinstance(new_layout, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('anonymous_715')) else
      _ods_ir.AttrBuilder.get('anonymous_715')(new_layout, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def x(self):
    return self.operation.operands[0]

  @builtins.property
  def new_layout(self):
    return self.operation.attributes["new_layout"]

  @new_layout.setter
  def new_layout(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["new_layout"] = value

def layout_cast(x, new_layout, *, loc=None, ip=None) -> _ods_ir.Value:
  return LayoutCastOp(x=x, new_layout=new_layout, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class OptimizationBarrierOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.optimization_barrier"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def optimization_barrier(operands_, *, loc=None, ip=None) -> _ods_ir.Value:
  return _get_op_result_or_op_results(OptimizationBarrierOp(operands_=operands_, loc=loc, ip=ip))

@_ods_cext.register_operation(_Dialect)
class ReturnOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.return"

  _ODS_REGIONS = (0, True)

  def __init__(self, operands_, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.extend(_get_op_results_or_values(operands_))
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def operands_(self):
    _ods_variadic_group_length = len(self.operation.operands) - 1 + 1
    return self.operation.operands[0:0 + _ods_variadic_group_length]

def return_(operands_, *, loc=None, ip=None) -> _ods_ir.Operation:
  return ReturnOp(operands_=operands_, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class SliceSMEMOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.slice_smem"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, offset, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(offset)
    _ods_context = _ods_get_default_loc_context(loc)
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def offset(self):
    return self.operation.operands[0]

def slice_smem(result, offset, *, loc=None, ip=None) -> _ods_ir.Value:
  return SliceSMEMOp(result=result, offset=offset, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TcGen05MMAOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.tcgen05_mma"

  _ODS_OPERAND_SEGMENTS = [1,1,1,1,0,0,]

  _ODS_REGIONS = (0, True)

  def __init__(self, accumulator, a, b, accumulate, *, a_scale=None, b_scale=None, collective=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(accumulator)
    operands.append(a)
    operands.append(b)
    operands.append(accumulate)
    operands.append(a_scale)
    operands.append(b_scale)
    _ods_context = _ods_get_default_loc_context(loc)
    if collective is not None: attributes["collective"] = (collective if (
        isinstance(collective, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(collective, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def accumulator(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 0)
    return operand_range[0]

  @builtins.property
  def a(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 1)
    return operand_range[0]

  @builtins.property
  def b(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 2)
    return operand_range[0]

  @builtins.property
  def accumulate(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 3)
    return operand_range[0]

  @builtins.property
  def a_scale(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 4)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def b_scale(self):
    operand_range = _ods_segmented_accessor(
         self.operation.operands,
         self.operation.attributes["operandSegmentSizes"], 5)
    return operand_range[0] if len(operand_range) > 0 else None

  @builtins.property
  def collective(self):
    return self.operation.attributes["collective"]

  @collective.setter
  def collective(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["collective"] = value

def tcgen05_mma(accumulator, a, b, accumulate, *, a_scale=None, b_scale=None, collective=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TcGen05MMAOp(accumulator=accumulator, a=a, b=b, accumulate=accumulate, a_scale=a_scale, b_scale=b_scale, collective=collective, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TmemAllocOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.tmem_alloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, result, smem_ptr, *, collective=None, exact=None, packing=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(smem_ptr)
    _ods_context = _ods_get_default_loc_context(loc)
    if collective is not None: attributes["collective"] = (collective if (
        isinstance(collective, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(collective, context=_ods_context))
    if exact is not None: attributes["exact"] = (exact if (
        isinstance(exact, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(exact, context=_ods_context))
    if packing is not None: attributes["packing"] = (packing if (
        isinstance(packing, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('I32Attr')) else
          _ods_ir.AttrBuilder.get('I32Attr')(packing, context=_ods_context))
    results.append(result)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def smem_ptr(self):
    return self.operation.operands[0]

  @builtins.property
  def collective(self):
    return self.operation.attributes["collective"]

  @collective.setter
  def collective(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["collective"] = value

  @builtins.property
  def exact(self):
    return self.operation.attributes["exact"]

  @exact.setter
  def exact(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["exact"] = value

  @builtins.property
  def packing(self):
    return self.operation.attributes["packing"]

  @packing.setter
  def packing(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["packing"] = value

def tmem_alloc(result, smem_ptr, *, collective=None, exact=None, packing=None, loc=None, ip=None) -> _ods_ir.Value:
  return TmemAllocOp(result=result, smem_ptr=smem_ptr, collective=collective, exact=exact, packing=packing, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class TmemDeallocOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.tmem_dealloc"

  _ODS_REGIONS = (0, True)

  def __init__(self, tmem_ref, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(tmem_ref)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def tmem_ref(self):
    return self.operation.operands[0]

def tmem_dealloc(tmem_ref, *, loc=None, ip=None) -> _ods_ir.Operation:
  return TmemDeallocOp(tmem_ref=tmem_ref, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class TmemRelinquishAllocPermitOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.tmem_relinquish_alloc_permit"

  _ODS_REGIONS = (0, True)

  def __init__(self, *, collective=None, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    _ods_context = _ods_get_default_loc_context(loc)
    if collective is not None: attributes["collective"] = (collective if (
        isinstance(collective, _ods_ir.Attribute) or
        not _ods_ir.AttrBuilder.contains('BoolAttr')) else
          _ods_ir.AttrBuilder.get('BoolAttr')(collective, context=_ods_context))
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def collective(self):
    return self.operation.attributes["collective"]

  @collective.setter
  def collective(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["collective"] = value

def tmem_relinquish_alloc_permit(*, collective=None, loc=None, ip=None) -> _ods_ir.Operation:
  return TmemRelinquishAllocPermitOp(collective=collective, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WGMMAOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.wgmma"

  _ODS_REGIONS = (0, True)

  def __init__(self, accumulator, a, b, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(accumulator)
    operands.append(a)
    operands.append(b)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def accumulator(self):
    return self.operation.operands[0]

  @builtins.property
  def a(self):
    return self.operation.operands[1]

  @builtins.property
  def b(self):
    return self.operation.operands[2]

def wgmma(accumulator, a, b, *, loc=None, ip=None) -> _ods_ir.Value:
  return WGMMAOp(accumulator=accumulator, a=a, b=b, loc=loc, ip=ip).result

@_ods_cext.register_operation(_Dialect)
class WaitOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.wait"

  _ODS_REGIONS = (0, True)

  def __init__(self, barrier, parity, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(barrier)
    operands.append(parity)
    _ods_context = _ods_get_default_loc_context(loc)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, results=results, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def barrier(self):
    return self.operation.operands[0]

  @builtins.property
  def parity(self):
    return self.operation.operands[1]

def wait(barrier, parity, *, loc=None, ip=None) -> _ods_ir.Operation:
  return WaitOp(barrier=barrier, parity=parity, loc=loc, ip=ip)

@_ods_cext.register_operation(_Dialect)
class WithTransformsOp(_ods_ir.OpView):
  OPERATION_NAME = "mosaic_gpu.with_transforms"

  _ODS_REGIONS = (0, True)

  def __init__(self, ref, transforms, *, loc=None, ip=None):
    operands = []
    results = []
    attributes = {}
    regions = None
    operands.append(ref)
    _ods_context = _ods_get_default_loc_context(loc)
    attributes["transforms"] = (transforms if (
    isinstance(transforms, _ods_ir.Attribute) or
    not _ods_ir.AttrBuilder.contains('ArrayAttr')) else
      _ods_ir.AttrBuilder.get('ArrayAttr')(transforms, context=_ods_context))
    results.extend([operands[0].type] * 1)
    _ods_successors = None
    super().__init__(self.OPERATION_NAME, self._ODS_REGIONS, self._ODS_OPERAND_SEGMENTS, self._ODS_RESULT_SEGMENTS, attributes=attributes, operands=operands, successors=_ods_successors, regions=regions, loc=loc, ip=ip)

  @builtins.property
  def ref(self):
    return self.operation.operands[0]

  @builtins.property
  def transforms(self):
    return self.operation.attributes["transforms"]

  @transforms.setter
  def transforms(self, value):
    if value is None:
      raise ValueError("'None' not allowed as value for mandatory attributes")
    self.operation.attributes["transforms"] = value

def with_transforms(ref, transforms, *, loc=None, ip=None) -> _ods_ir.Value:
  return WithTransformsOp(ref=ref, transforms=transforms, loc=loc, ip=ip).result
