"""Unicode Properties from Unicode version 13.0.0 (autogen)."""
from typing import Dict

unicode_numeric_values: Dict[str, str] = {
    "0": "\x30\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0c78\u0ce6\u0d66\u0de6\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u17f0\u1810\u1946\u19d0\u1a80\u1a90\u1b50\u1bb0\u1c40\u1c50\u2070\u2080\u2189\u24ea\u24ff\u3007\u96f6\ua620\ua6ef\ua8d0\ua900\ua9d0\ua9f0\uaa50\uabf0\uf9b2\uff10\U0001018a\U000104a0\U00010d30\U00011066\U000110f0\U00011136\U000111d0\U000112f0\U00011450\U000114d0\U00011650\U000116c0\U00011730\U000118e0\U00011950\U00011c50\U00011d50\U00011da0\U00016a60\U00016b50\U00016e80\U0001d2e0\U0001d7ce\U0001d7d8\U0001d7e2\U0001d7ec\U0001d7f6\U0001e140\U0001e2f0\U0001e950\U0001f100-\U0001f101\U0001f10b-\U0001f10c\U0001fbf0",
    "1": "\x31\xb9\u0661\u06f1\u07c1\u0967\u09e7\u0a67\u0ae7\u0b67\u0be7\u0c67\u0c79\u0c7c\u0ce7\u0d67\u0de7\u0e51\u0ed1\u0f21\u1041\u1091\u1369\u17e1\u17f1\u1811\u1947\u19d1\u19da\u1a81\u1a91\u1b51\u1bb1\u1c41\u1c51\u2081\u215f-\u2160\u2170\u2460\u2474\u2488\u24f5\u2776\u2780\u278a\u3021\u3192\u3220\u3280\u4e00\u58f1\u58f9\u5e7a\u5f0c\ua621\ua6e6\ua8d1\ua901\ua9d1\ua9f1\uaa51\uabf1\uff11\U00010107\U00010142\U00010158-\U0001015a\U000102e1\U00010320\U000103d1\U000104a1\U00010858\U00010879\U000108a7\U000108fb\U00010916\U000109c0\U00010a40\U00010a7d\U00010a9d\U00010aeb\U00010b58\U00010b78\U00010ba9\U00010cfa\U00010d31\U00010e60\U00010f1d\U00010f51\U00010fc5\U00011052\U00011067\U000110f1\U00011137\U000111d1\U000111e1\U000112f1\U00011451\U000114d1\U00011651\U000116c1\U00011731\U000118e1\U00011951\U00011c51\U00011c5a\U00011d51\U00011da1\U00012415\U0001241e\U0001242c\U00012434\U0001244f\U00012458\U00016a61\U00016b51\U00016e81\U00016e94\U0001d2e1\U0001d360\U0001d372\U0001d377\U0001d7cf\U0001d7d9\U0001d7e3\U0001d7ed\U0001d7f7\U0001e141\U0001e2f1\U0001e8c7\U0001e951\U0001ec71\U0001eca3\U0001ecb1\U0001ed01\U0001f102\U0001fbf1\U0002092a",
    "1/10": "\u0d5c\u2152\U00011fcb",
    "1/12": "\U000109f6",
    "1/16": "\u09f4\u0b75\u0d76\ua833\U00011fc9-\U00011fca",
    "1/160": "\u0d58\U00011fc1",
    "1/2": "\xbd\u0b73\u0d74\u0f2a\u0f33\u2cfd\ua831\U00010141\U00010175-\U00010176\U000109bd\U000109fb\U00010a48\U00010e7b\U00010f26\U00011fd1-\U00011fd2\U00012464\U0001ecae\U0001ed3c",
    "1/20": "\u0d5b\U00011fc8",
    "1/3": "\u2153\U000109f9\U00010e7d\U0001245a\U0001245d\U00012465",
    "1/32": "\U00011fc5",
    "1/320": "\U00011fc0\U00011fd4",
    "1/4": "\xbc\u09f7\u0b72\u0d73\ua830\U00010140\U0001018b\U000109f8\U00010e7c\U00011fd0\U00012460\U00012462-\U00012463\U0001ecad",
    "1/40": "\u0d59\U00011fc4",
    "1/5": "\u0d5e\u2155\U00011fcf",
    "1/6": "\u2159\U000109f7\U00012461\U0001ed3d",
    "1/64": "\U00011fc3",
    "1/7": "\u2150",
    "1/8": "\u09f5\u0b76\u0d77\u215b\ua834\U00011fcc\U0001245f",
    "1/80": "\U00011fc2",
    "1/9": "\u2151",
    "10": "\u0bf0\u0d70\u1372\u2169\u2179\u2469\u247d\u2491\u24fe\u277f\u2789\u2793\u3038\u3229\u3248\u3289\u4ec0\u5341\u62fe\uf973\uf9fd\U00010110\U00010149\U00010150\U00010157\U00010160-\U00010164\U000102ea\U00010322\U000103d3\U0001085b\U0001087e\U000108ad\U000108fd\U00010917\U000109c9\U00010a44\U00010a9e\U00010aed\U00010b5c\U00010b7c\U00010bad\U00010cfc\U00010e69\U00010f22\U00010f52\U00010fc9\U0001105b\U000111ea\U0001173a\U000118ea\U00011c63\U00016b5b\U00016e8a\U0001d2ea\U0001d369\U0001ec7a\U0001ed0a\U0001ed37",
    "100": "\u0bf1\u0d71\u137b\u216d\u217d\u4f70\u767e\u964c\U00010119\U0001014b\U00010152\U0001016a\U000102f3\U000103d5\U0001085d\U000108af\U000108ff\U00010919\U000109d2\U00010a46\U00010aef\U00010b5e\U00010b7e\U00010baf\U00010cfe\U00010e72\U00010f25\U00010f54\U00010fcb\U00011064\U000111f3\U00011c6c\U00016b5c\U0001ec83\U0001ed13",
    "1000": "\u0bf2\u0d72\u216f\u217f-\u2180\u4edf\u5343\u9621\U00010122\U0001014d\U00010154\U00010171\U0001085e\U000109db\U00010a47\U00010b5f\U00010b7f\U00010cff\U00011065\U000111f4\U0001ec8c\U0001ed1c",
    "10000": "\u137c\u2182\u4e07\u842c\U0001012b\U00010155\U0001085f\U000109e4\U00016b5d\U0001ec95\U0001ecb3\U0001ed25\U0001ed3b",
    "100000": "\u2188\U000109ed\U0001ec9e\U0001eca0\U0001ecb4",
    "1000000": "\U00016b5e",
    "10000000": "\U0001eca1",
    "100000000": "\u4ebf\u5104\U00016b5f",
    "10000000000": "\U00016b60",
    "1000000000000": "\u5146\U00016b61",
    "11": "\u216a\u217a\u246a\u247e\u2492\u24eb\U00016e8b\U0001d2eb",
    "11/12": "\U000109bc",
    "11/2": "\u0f2f",
    "12": "\u216b\u217b\u246b\u247f\u2493\u24ec\U00016e8c\U0001d2ec",
    "13": "\u246c\u2480\u2494\u24ed\U00016e8d\U0001d2ed",
    "13/2": "\u0f30",
    "14": "\u246d\u2481\u2495\u24ee\U00016e8e\U0001d2ee",
    "15": "\u246e\u2482\u2496\u24ef\U00016e8f\U0001d2ef",
    "15/2": "\u0f31",
    "16": "\u09f9\u246f\u2483\u2497\u24f0\U00016e90\U0001d2f0",
    "17": "\u16ee\u2470\u2484\u2498\u24f1\U00016e91\U0001d2f1",
    "17/2": "\u0f32",
    "18": "\u16ef\u2471\u2485\u2499\u24f2\U00016e92\U0001d2f2",
    "19": "\u16f0\u2472\u2486\u249a\u24f3\U00016e93\U0001d2f3",
    "2": "\x32\xb2\u0662\u06f2\u07c2\u0968\u09e8\u0a68\u0ae8\u0b68\u0be8\u0c68\u0c7a\u0c7d\u0ce8\u0d68\u0de8\u0e52\u0ed2\u0f22\u1042\u1092\u136a\u17e2\u17f2\u1812\u1948\u19d2\u1a82\u1a92\u1b52\u1bb2\u1c42\u1c52\u2082\u2161\u2171\u2461\u2475\u2489\u24f6\u2777\u2781\u278b\u3022\u3193\u3221\u3281\u3483\u4e8c\u5169\u5f0d\u5f10\u8cae\u8cb3\u8d30\ua622\ua6e7\ua8d2\ua902\ua9d2\ua9f2\uaa52\uabf2\uf978\uff12\U00010108\U0001015b-\U0001015e\U000102e2\U000103d2\U000104a2\U00010859\U0001087a\U000108a8\U0001091a\U000109c1\U00010a41\U00010b59\U00010b79\U00010baa\U00010d32\U00010e61\U00010f1e\U00010fc6\U00011053\U00011068\U000110f2\U00011138\U000111d2\U000111e2\U000112f2\U00011452\U000114d2\U00011652\U000116c2\U00011732\U000118e2\U00011952\U00011c52\U00011c5b\U00011d52\U00011da2\U00012400\U00012416\U0001241f\U00012423\U0001242d\U00012435\U0001244a\U00012450\U00012456\U00012459\U00016a62\U00016b52\U00016e82\U00016e95\U0001d2e2\U0001d361\U0001d373\U0001d7d0\U0001d7da\U0001d7e4\U0001d7ee\U0001d7f8\U0001e142\U0001e2f2\U0001e8c8\U0001e952\U0001ec72\U0001eca4\U0001ecb2\U0001ed02\U0001ed2f\U0001f103\U0001fbf2\U00022390",
    "2/3": "\u2154\U00010177\U000109fd\U00010e7e\U0001245b\U0001245e\U00012466",
    "2/5": "\u2156",
    "20": "\u1373\u2473\u2487\u249b\u24f4\u3039\u3249\u5344\u5eff\U00010111\U000102eb\U000103d4\U0001085c\U0001087f\U000108ae\U000108fe\U00010918\U000109ca\U00010a45\U00010a9f\U00010aee\U00010b5d\U00010b7d\U00010bae\U00010e6a\U00010f23\U00010f53\U00010fca\U0001105c\U000111eb\U0001173b\U000118eb\U00011c64\U0001d36a\U0001ec7b\U0001ed0b",
    "200": "\U0001011a\U000102f4\U000109d3\U00010e73\U0001ec84\U0001ed14",
    "2000": "\U00010123\U000109dc\U0001ec8d\U0001ed1d\U0001ed3a",
    "20000": "\U0001012c\U000109e5\U0001ec96\U0001ed26",
    "200000": "\U000109ee\U0001ec9f",
    "20000000": "\U0001eca2",
    "21": "\u3251",
    "216000": "\U00012432",
    "22": "\u3252",
    "23": "\u3253",
    "24": "\u3254",
    "25": "\u3255",
    "26": "\u3256",
    "27": "\u3257",
    "28": "\u3258",
    "29": "\u3259",
    "3": "\x33\xb3\u0663\u06f3\u07c3\u0969\u09e9\u0a69\u0ae9\u0b69\u0be9\u0c69\u0c7b\u0c7e\u0ce9\u0d69\u0de9\u0e53\u0ed3\u0f23\u1043\u1093\u136b\u17e3\u17f3\u1813\u1949\u19d3\u1a83\u1a93\u1b53\u1bb3\u1c43\u1c53\u2083\u2162\u2172\u2462\u2476\u248a\u24f7\u2778\u2782\u278c\u3023\u3194\u3222\u3282\u4e09\u4ee8\u53c1-\u53c4\u5f0e\ua623\ua6e8\ua8d3\ua903\ua9d3\ua9f3\uaa53\uabf3\uf96b\uff13\U00010109\U000102e3\U000104a3\U0001085a\U0001087b\U000108a9\U0001091b\U000109c2\U00010a42\U00010b5a\U00010b7a\U00010bab\U00010d33\U00010e62\U00010f1f\U00010fc7\U00011054\U00011069\U000110f3\U00011139\U000111d3\U000111e3\U000112f3\U00011453\U000114d3\U00011653\U000116c3\U00011733\U000118e3\U00011953\U00011c53\U00011c5c\U00011d53\U00011da3\U00012401\U00012408\U00012417\U00012420\U00012424-\U00012425\U0001242e-\U0001242f\U00012436-\U00012437\U0001243a-\U0001243b\U0001244b\U00012451\U00012457\U00016a63\U00016b53\U00016e83\U00016e96\U0001d2e3\U0001d362\U0001d374\U0001d7d1\U0001d7db\U0001d7e5\U0001d7ef\U0001d7f9\U0001e143\U0001e2f3\U0001e8c9\U0001e953\U0001ec73\U0001eca5\U0001ed03\U0001ed30\U0001f104\U0001fbf3\U00020afd\U00020b19\U00022998\U00023b1b",
    "3/16": "\u09f6\u0b77\u0d78\ua835\U00011fce",
    "3/2": "\u0f2b",
    "3/20": "\u0d5d\U00011fcd",
    "3/4": "\xbe\u09f8\u0b74\u0d75\ua832\U00010178\U000109fe\U00011fd3\U0001ecaf",
    "3/5": "\u2157",
    "3/64": "\U00011fc7",
    "3/8": "\u215c",
    "3/80": "\u0d5a\U00011fc6",
    "30": "\u1374\u303a\u324a\u325a\u5345\U00010112\U00010165\U000102ec\U000109cb\U00010e6b\U00010f24\U0001105d\U000111ec\U000118ec\U00011c65\U0001d36b\U0001ec7c\U0001ed0c\U00020983",
    "300": "\U0001011b\U0001016b\U000102f5\U000109d4\U00010e74\U0001ec85\U0001ed15",
    "3000": "\U00010124\U000109dd\U0001ec8e\U0001ed1e",
    "30000": "\U0001012d\U000109e6\U0001ec97\U0001ed27",
    "300000": "\U000109ef",
    "31": "\u325b",
    "32": "\u325c",
    "33": "\u325d",
    "34": "\u325e",
    "35": "\u325f",
    "36": "\u32b1",
    "37": "\u32b2",
    "38": "\u32b3",
    "39": "\u32b4",
    "4": "\x34\u0664\u06f4\u07c4\u096a\u09ea\u0a6a\u0aea\u0b6a\u0bea\u0c6a\u0cea\u0d6a\u0dea\u0e54\u0ed4\u0f24\u1044\u1094\u136c\u17e4\u17f4\u1814\u194a\u19d4\u1a84\u1a94\u1b54\u1bb4\u1c44\u1c54\u2074\u2084\u2163\u2173\u2463\u2477\u248b\u24f8\u2779\u2783\u278d\u3024\u3195\u3223\u3283\u4e96\u56db\u8086\ua624\ua6e9\ua8d4\ua904\ua9d4\ua9f4\uaa54\uabf4\uff14\U0001010a\U000102e4\U000104a4\U0001087c\U000108aa-\U000108ab\U000109c3\U00010a43\U00010b5b\U00010b7b\U00010bac\U00010d34\U00010e63\U00010f20\U00010fc8\U00011055\U0001106a\U000110f4\U0001113a\U000111d4\U000111e4\U000112f4\U00011454\U000114d4\U00011654\U000116c4\U00011734\U000118e4\U00011954\U00011c54\U00011c5d\U00011d54\U00011da4\U00012402\U00012409\U0001240f\U00012418\U00012421\U00012426\U00012430\U00012438\U0001243c-\U0001243f\U0001244c\U00012452-\U00012453\U00012469\U00016a64\U00016b54\U00016e84\U0001d2e4\U0001d363\U0001d375\U0001d7d2\U0001d7dc\U0001d7e6\U0001d7f0\U0001d7fa\U0001e144\U0001e2f4\U0001e8ca\U0001e954\U0001ec74\U0001eca6\U0001ed04\U0001ed31\U0001f105\U0001fbf4\U00020064\U000200e2\U0002626d",
    "4/5": "\u2158",
    "40": "\u1375\u324b\u32b5\u534c\U00010113\U000102ed\U000109cc\U00010e6c\U0001105e\U000111ed\U000118ed\U00011c66\U00012467\U0001d36c\U0001ec7d\U0001ed0d\U0002098c\U0002099c",
    "400": "\U0001011c\U000102f6\U000109d5\U00010e75\U0001ec86\U0001ed16\U0001ed38",
    "4000": "\U00010125\U000109de\U0001ec8f\U0001ed1f",
    "40000": "\U0001012e\U000109e7\U0001ec98\U0001ed28",
    "400000": "\U000109f0",
    "41": "\u32b6",
    "42": "\u32b7",
    "43": "\u32b8",
    "432000": "\U00012433",
    "44": "\u32b9",
    "45": "\u32ba",
    "46": "\u32bb",
    "47": "\u32bc",
    "48": "\u32bd",
    "49": "\u32be",
    "5": "\x35\u0665\u06f5\u07c5\u096b\u09eb\u0a6b\u0aeb\u0b6b\u0beb\u0c6b\u0ceb\u0d6b\u0deb\u0e55\u0ed5\u0f25\u1045\u1095\u136d\u17e5\u17f5\u1815\u194b\u19d5\u1a85\u1a95\u1b55\u1bb5\u1c45\u1c55\u2075\u2085\u2164\u2174\u2464\u2478\u248c\u24f9\u277a\u2784\u278e\u3025\u3224\u3284\u3405\u382a\u4e94\u4f0d\ua625\ua6ea\ua8d5\ua905\ua9d5\ua9f5\uaa55\uabf5\uff15\U0001010b\U00010143\U00010148\U0001014f\U0001015f\U00010173\U000102e5\U00010321\U000104a5\U0001087d\U000108ac\U000108fc\U000109c4\U00010aec\U00010cfb\U00010d35\U00010e64\U00010f21\U00011056\U0001106b\U000110f5\U0001113b\U000111d5\U000111e5\U000112f5\U00011455\U000114d5\U00011655\U000116c5\U00011735\U000118e5\U00011955\U00011c55\U00011c5e\U00011d55\U00011da5\U00012403\U0001240a\U00012410\U00012419\U00012422\U00012427\U00012431\U00012439\U0001244d\U00012454-\U00012455\U0001246a\U00016a65\U00016b55\U00016e85\U0001d2e5\U0001d364\U0001d376\U0001d378\U0001d7d3\U0001d7dd\U0001d7e7\U0001d7f1\U0001d7fb\U0001e145\U0001e2f5\U0001e8cb\U0001e955\U0001ec75\U0001eca7\U0001ed05\U0001ed32\U0001f106\U0001fbf5\U00020121",
    "5/12": "\U000109fa",
    "5/2": "\u0f2c",
    "5/6": "\u215a\U000109ff\U0001245c",
    "5/8": "\u215d",
    "50": "\u1376\u216c\u217c\u2186\u324c\u32bf\U00010114\U00010144\U0001014a\U00010151\U00010166-\U00010169\U00010174\U000102ee\U00010323\U000109cd\U00010a7e\U00010cfd\U00010e6d\U0001105f\U000111ee\U000118ee\U00011c67\U00012468\U0001d36d\U0001ec7e\U0001ed0e",
    "500": "\u216e\u217e\U0001011d\U00010145\U0001014c\U00010153\U0001016c-\U00010170\U000102f7\U000109d6\U00010e76\U0001ec87\U0001ed17",
    "5000": "\u2181\U00010126\U00010146\U0001014e\U00010172\U000109df\U0001ec90\U0001ed20",
    "50000": "\u2187\U0001012f\U00010147\U00010156\U000109e8\U0001ec99\U0001ed29",
    "500000": "\U000109f1",
    "6": "\x36\u0666\u06f6\u07c6\u096c\u09ec\u0a6c\u0aec\u0b6c\u0bec\u0c6c\u0cec\u0d6c\u0dec\u0e56\u0ed6\u0f26\u1046\u1096\u136e\u17e6\u17f6\u1816\u194c\u19d6\u1a86\u1a96\u1b56\u1bb6\u1c46\u1c56\u2076\u2086\u2165\u2175\u2185\u2465\u2479\u248d\u24fa\u277b\u2785\u278f\u3026\u3225\u3285\u516d\u9646\u9678\ua626\ua6eb\ua8d6\ua906\ua9d6\ua9f6\uaa56\uabf6\uf9d1\uf9d3\uff16\U0001010c\U000102e6\U000104a6\U000109c5\U00010d36\U00010e65\U00011057\U0001106c\U000110f6\U0001113c\U000111d6\U000111e6\U000112f6\U00011456\U000114d6\U00011656\U000116c6\U00011736\U000118e6\U00011956\U00011c56\U00011c5f\U00011d56\U00011da6\U00012404\U0001240b\U00012411\U0001241a\U00012428\U00012440\U0001244e\U0001246b\U00016a66\U00016b56\U00016e86\U0001d2e6\U0001d365\U0001d7d4\U0001d7de\U0001d7e8\U0001d7f2\U0001d7fc\U0001e146\U0001e2f6\U0001e8cc\U0001e956\U0001ec76\U0001eca8\U0001ed06\U0001ed33\U0001f107\U0001fbf6\U00020aea",
    "60": "\u1377\u324d\U00010115\U000102ef\U000109ce\U00010e6e\U00011060\U000111ef\U000118ef\U00011c68\U0001d36e\U0001ec7f\U0001ed0f",
    "600": "\U0001011e\U000102f8\U000109d7\U00010e77\U0001ec88\U0001ed18\U0001ed39",
    "6000": "\U00010127\U000109e0\U0001ec91\U0001ed21",
    "60000": "\U00010130\U000109e9\U0001ec9a\U0001ed2a",
    "600000": "\U000109f2",
    "7": "\x37\u0667\u06f7\u07c7\u096d\u09ed\u0a6d\u0aed\u0b6d\u0bed\u0c6d\u0ced\u0d6d\u0ded\u0e57\u0ed7\u0f27\u1047\u1097\u136f\u17e7\u17f7\u1817\u194d\u19d7\u1a87\u1a97\u1b57\u1bb7\u1c47\u1c57\u2077\u2087\u2166\u2176\u2466\u247a\u248e\u24fb\u277c\u2786\u2790\u3027\u3226\u3286\u3b4d\u4e03\u67d2\u6f06\ua627\ua6ec\ua8d7\ua907\ua9d7\ua9f7\uaa57\uabf7\uff17\U0001010d\U000102e7\U000104a7\U000109c6\U00010d37\U00010e66\U00011058\U0001106d\U000110f7\U0001113d\U000111d7\U000111e7\U000112f7\U00011457\U000114d7\U00011657\U000116c7\U00011737\U000118e7\U00011957\U00011c57\U00011c60\U00011d57\U00011da7\U00012405\U0001240c\U00012412\U0001241b\U00012429\U00012441-\U00012443\U0001246c\U00016a67\U00016b57\U00016e87\U0001d2e7\U0001d366\U0001d7d5\U0001d7df\U0001d7e9\U0001d7f3\U0001d7fd\U0001e147\U0001e2f7\U0001e8cd\U0001e957\U0001ec77\U0001eca9\U0001ed07\U0001ed34\U0001f108\U0001fbf7\U00020001",
    "7/12": "\U000109fc",
    "7/2": "\u0f2d",
    "7/8": "\u215e",
    "70": "\u1378\u324e\U00010116\U000102f0\U000109cf\U00010e6f\U00011061\U000111f0\U000118f0\U00011c69\U0001d36f\U0001ec80\U0001ed10",
    "700": "\U0001011f\U000102f9\U000109d8\U00010e78\U0001ec89\U0001ed19",
    "7000": "\U00010128\U000109e1\U0001ec92\U0001ed22",
    "70000": "\U00010131\U000109ea\U0001ec9b\U0001ed2b",
    "700000": "\U000109f3",
    "8": "\x38\u0668\u06f8\u07c8\u096e\u09ee\u0a6e\u0aee\u0b6e\u0bee\u0c6e\u0cee\u0d6e\u0dee\u0e58\u0ed8\u0f28\u1048\u1098\u1370\u17e8\u17f8\u1818\u194e\u19d8\u1a88\u1a98\u1b58\u1bb8\u1c48\u1c58\u2078\u2088\u2167\u2177\u2467\u247b\u248f\u24fc\u277d\u2787\u2791\u3028\u3227\u3287\u516b\u634c\ua628\ua6ed\ua8d8\ua908\ua9d8\ua9f8\uaa58\uabf8\uff18\U0001010e\U000102e8\U000104a8\U000109c7\U00010d38\U00010e67\U00011059\U0001106e\U000110f8\U0001113e\U000111d8\U000111e8\U000112f8\U00011458\U000114d8\U00011658\U000116c8\U00011738\U000118e8\U00011958\U00011c58\U00011c61\U00011d58\U00011da8\U00012406\U0001240d\U00012413\U0001241c\U0001242a\U00012444-\U00012445\U0001246d\U00016a68\U00016b58\U00016e88\U0001d2e8\U0001d367\U0001d7d6\U0001d7e0\U0001d7ea\U0001d7f4\U0001d7fe\U0001e148\U0001e2f8\U0001e8ce\U0001e958\U0001ec78\U0001ecaa\U0001ed08\U0001ed35\U0001f109\U0001fbf8",
    "80": "\u1379\u324f\U00010117\U000102f1\U00010e70\U00011062\U000111f1\U000118f1\U00011c6a\U0001d370\U0001ec81\U0001ed11",
    "800": "\U00010120\U000102fa\U000109d9\U00010e79\U0001ec8a\U0001ed1a",
    "8000": "\U00010129\U000109e2\U0001ec93\U0001ed23",
    "80000": "\U00010132\U000109eb\U0001ec9c\U0001ed2c",
    "800000": "\U000109f4",
    "9": "\x39\u0669\u06f9\u07c9\u096f\u09ef\u0a6f\u0aef\u0b6f\u0bef\u0c6f\u0cef\u0d6f\u0def\u0e59\u0ed9\u0f29\u1049\u1099\u1371\u17e9\u17f9\u1819\u194f\u19d9\u1a89\u1a99\u1b59\u1bb9\u1c49\u1c59\u2079\u2089\u2168\u2178\u2468\u247c\u2490\u24fd\u277e\u2788\u2792\u3029\u3228\u3288\u4e5d\u5efe\u7396\ua629\ua6ee\ua8d9\ua909\ua9d9\ua9f9\uaa59\uabf9\uff19\U0001010f\U000102e9\U000104a9\U000109c8\U00010d39\U00010e68\U0001105a\U0001106f\U000110f9\U0001113f\U000111d9\U000111e9\U000112f9\U00011459\U000114d9\U00011659\U000116c9\U00011739\U000118e9\U00011959\U00011c59\U00011c62\U00011d59\U00011da9\U00012407\U0001240e\U00012414\U0001241d\U0001242b\U00012446-\U00012449\U0001246e\U00016a69\U00016b59\U00016e89\U0001d2e9\U0001d368\U0001d7d7\U0001d7e1\U0001d7eb\U0001d7f5\U0001d7ff\U0001e149\U0001e2f9\U0001e8cf\U0001e959\U0001ec79\U0001ecab\U0001ed09\U0001ed36\U0001f10a\U0001fbf9\U0002f890",
    "9/2": "\u0f2e",
    "90": "\u137a\U00010118\U000102f2\U00010341\U00010e71\U00011063\U000111f2\U000118f2\U00011c6b\U0001d371\U0001ec82\U0001ed12",
    "900": "\U00010121\U000102fb\U0001034a\U000109da\U00010e7a\U0001ec8b\U0001ed1b",
    "9000": "\U0001012a\U000109e3\U0001ec94\U0001ed24",
    "90000": "\U00010133\U000109ec\U0001ec9d\U0001ed2d",
    "900000": "\U000109f5",
    "^0": "\x00-\x2f\x31-\u065f\u0661-\u06ef\u06f1-\u07bf\u07c1-\u0965\u0967-\u09e5\u09e7-\u0a65\u0a67-\u0ae5\u0ae7-\u0b65\u0b67-\u0be5\u0be7-\u0c65\u0c67-\u0c77\u0c79-\u0ce5\u0ce7-\u0d65\u0d67-\u0de5\u0de7-\u0e4f\u0e51-\u0ecf\u0ed1-\u0f1f\u0f21-\u103f\u1041-\u108f\u1091-\u17df\u17e1-\u17ef\u17f1-\u180f\u1811-\u1945\u1947-\u19cf\u19d1-\u1a7f\u1a81-\u1a8f\u1a91-\u1b4f\u1b51-\u1baf\u1bb1-\u1c3f\u1c41-\u1c4f\u1c51-\u206f\u2071-\u207f\u2081-\u2188\u218a-\u24e9\u24eb-\u24fe\u2500-\u3006\u3008-\u96f5\u96f7-\ua61f\ua621-\ua6ee\ua6f0-\ua8cf\ua8d1-\ua8ff\ua901-\ua9cf\ua9d1-\ua9ef\ua9f1-\uaa4f\uaa51-\uabef\uabf1-\uf9b1\uf9b3-\uff0f\uff11-\U00010189\U0001018b-\U0001049f\U000104a1-\U00010d2f\U00010d31-\U00011065\U00011067-\U000110ef\U000110f1-\U00011135\U00011137-\U000111cf\U000111d1-\U000112ef\U000112f1-\U0001144f\U00011451-\U000114cf\U000114d1-\U0001164f\U00011651-\U000116bf\U000116c1-\U0001172f\U00011731-\U000118df\U000118e1-\U0001194f\U00011951-\U00011c4f\U00011c51-\U00011d4f\U00011d51-\U00011d9f\U00011da1-\U00016a5f\U00016a61-\U00016b4f\U00016b51-\U00016e7f\U00016e81-\U0001d2df\U0001d2e1-\U0001d7cd\U0001d7cf-\U0001d7d7\U0001d7d9-\U0001d7e1\U0001d7e3-\U0001d7eb\U0001d7ed-\U0001d7f5\U0001d7f7-\U0001e13f\U0001e141-\U0001e2ef\U0001e2f1-\U0001e94f\U0001e951-\U0001f0ff\U0001f102-\U0001f10a\U0001f10d-\U0001fbef\U0001fbf1-\U0010ffff",
    "^1": "\x00-\x30\x32-\xb8\xba-\u0660\u0662-\u06f0\u06f2-\u07c0\u07c2-\u0966\u0968-\u09e6\u09e8-\u0a66\u0a68-\u0ae6\u0ae8-\u0b66\u0b68-\u0be6\u0be8-\u0c66\u0c68-\u0c78\u0c7a-\u0c7b\u0c7d-\u0ce6\u0ce8-\u0d66\u0d68-\u0de6\u0de8-\u0e50\u0e52-\u0ed0\u0ed2-\u0f20\u0f22-\u1040\u1042-\u1090\u1092-\u1368\u136a-\u17e0\u17e2-\u17f0\u17f2-\u1810\u1812-\u1946\u1948-\u19d0\u19d2-\u19d9\u19db-\u1a80\u1a82-\u1a90\u1a92-\u1b50\u1b52-\u1bb0\u1bb2-\u1c40\u1c42-\u1c50\u1c52-\u2080\u2082-\u215e\u2161-\u216f\u2171-\u245f\u2461-\u2473\u2475-\u2487\u2489-\u24f4\u24f6-\u2775\u2777-\u277f\u2781-\u2789\u278b-\u3020\u3022-\u3191\u3193-\u321f\u3221-\u327f\u3281-\u4dff\u4e01-\u58f0\u58f2-\u58f8\u58fa-\u5e79\u5e7b-\u5f0b\u5f0d-\ua620\ua622-\ua6e5\ua6e7-\ua8d0\ua8d2-\ua900\ua902-\ua9d0\ua9d2-\ua9f0\ua9f2-\uaa50\uaa52-\uabf0\uabf2-\uff10\uff12-\U00010106\U00010108-\U00010141\U00010143-\U00010157\U0001015b-\U000102e0\U000102e2-\U0001031f\U00010321-\U000103d0\U000103d2-\U000104a0\U000104a2-\U00010857\U00010859-\U00010878\U0001087a-\U000108a6\U000108a8-\U000108fa\U000108fc-\U00010915\U00010917-\U000109bf\U000109c1-\U00010a3f\U00010a41-\U00010a7c\U00010a7e-\U00010a9c\U00010a9e-\U00010aea\U00010aec-\U00010b57\U00010b59-\U00010b77\U00010b79-\U00010ba8\U00010baa-\U00010cf9\U00010cfb-\U00010d30\U00010d32-\U00010e5f\U00010e61-\U00010f1c\U00010f1e-\U00010f50\U00010f52-\U00010fc4\U00010fc6-\U00011051\U00011053-\U00011066\U00011068-\U000110f0\U000110f2-\U00011136\U00011138-\U000111d0\U000111d2-\U000111e0\U000111e2-\U000112f0\U000112f2-\U00011450\U00011452-\U000114d0\U000114d2-\U00011650\U00011652-\U000116c0\U000116c2-\U00011730\U00011732-\U000118e0\U000118e2-\U00011950\U00011952-\U00011c50\U00011c52-\U00011c59\U00011c5b-\U00011d50\U00011d52-\U00011da0\U00011da2-\U00012414\U00012416-\U0001241d\U0001241f-\U0001242b\U0001242d-\U00012433\U00012435-\U0001244e\U00012450-\U00012457\U00012459-\U00016a60\U00016a62-\U00016b50\U00016b52-\U00016e80\U00016e82-\U00016e93\U00016e95-\U0001d2e0\U0001d2e2-\U0001d35f\U0001d361-\U0001d371\U0001d373-\U0001d376\U0001d378-\U0001d7ce\U0001d7d0-\U0001d7d8\U0001d7da-\U0001d7e2\U0001d7e4-\U0001d7ec\U0001d7ee-\U0001d7f6\U0001d7f8-\U0001e140\U0001e142-\U0001e2f0\U0001e2f2-\U0001e8c6\U0001e8c8-\U0001e950\U0001e952-\U0001ec70\U0001ec72-\U0001eca2\U0001eca4-\U0001ecb0\U0001ecb2-\U0001ed00\U0001ed02-\U0001f101\U0001f103-\U0001fbf0\U0001fbf2-\U00020929\U0002092b-\U0010ffff",
    "^1/10": "\x00-\u0d5b\u0d5d-\u2151\u2153-\U00011fca\U00011fcc-\U0010ffff",
    "^1/12": "\x00-\U000109f5\U000109f7-\U0010ffff",
    "^1/16": "\x00-\u09f3\u09f5-\u0b74\u0b76-\u0d75\u0d77-\ua832\ua834-\U00011fc8\U00011fcb-\U0010ffff",
    "^1/160": "\x00-\u0d57\u0d59-\U00011fc0\U00011fc2-\U0010ffff",
    "^1/2": "\x00-\xbc\xbe-\u0b72\u0b74-\u0d73\u0d75-\u0f29\u0f2b-\u0f32\u0f34-\u2cfc\u2cfe-\ua830\ua832-\U00010140\U00010142-\U00010174\U00010177-\U000109bc\U000109be-\U000109fa\U000109fc-\U00010a47\U00010a49-\U00010e7a\U00010e7c-\U00010f25\U00010f27-\U00011fd0\U00011fd3-\U00012463\U00012465-\U0001ecad\U0001ecaf-\U0001ed3b\U0001ed3d-\U0010ffff",
    "^1/20": "\x00-\u0d5a\u0d5c-\U00011fc7\U00011fc9-\U0010ffff",
    "^1/3": "\x00-\u2152\u2154-\U000109f8\U000109fa-\U00010e7c\U00010e7e-\U00012459\U0001245b-\U0001245c\U0001245e-\U00012464\U00012466-\U0010ffff",
    "^1/32": "\x00-\U00011fc4\U00011fc6-\U0010ffff",
    "^1/320": "\x00-\U00011fbf\U00011fc1-\U00011fd3\U00011fd5-\U0010ffff",
    "^1/4": "\x00-\xbb\xbd-\u09f6\u09f8-\u0b71\u0b73-\u0d72\u0d74-\ua82f\ua831-\U0001013f\U00010141-\U0001018a\U0001018c-\U000109f7\U000109f9-\U00010e7b\U00010e7d-\U00011fcf\U00011fd1-\U0001245f\U00012461\U00012464-\U0001ecac\U0001ecae-\U0010ffff",
    "^1/40": "\x00-\u0d58\u0d5a-\U00011fc3\U00011fc5-\U0010ffff",
    "^1/5": "\x00-\u0d5d\u0d5f-\u2154\u2156-\U00011fce\U00011fd0-\U0010ffff",
    "^1/6": "\x00-\u2158\u215a-\U000109f6\U000109f8-\U00012460\U00012462-\U0001ed3c\U0001ed3e-\U0010ffff",
    "^1/64": "\x00-\U00011fc2\U00011fc4-\U0010ffff",
    "^1/7": "\x00-\u214f\u2151-\U0010ffff",
    "^1/8": "\x00-\u09f4\u09f6-\u0b75\u0b77-\u0d76\u0d78-\u215a\u215c-\ua833\ua835-\U00011fcb\U00011fcd-\U0001245e\U00012460-\U0010ffff",
    "^1/80": "\x00-\U00011fc1\U00011fc3-\U0010ffff",
    "^1/9": "\x00-\u2150\u2152-\U0010ffff",
    "^10": "\x00-\u0bef\u0bf1-\u0d6f\u0d71-\u1371\u1373-\u2168\u216a-\u2178\u217a-\u2468\u246a-\u247c\u247e-\u2490\u2492-\u24fd\u24ff-\u277e\u2780-\u2788\u278a-\u2792\u2794-\u3037\u3039-\u3228\u322a-\u3247\u3249-\u3288\u328a-\u4ebf\u4ec1-\u5340\u5342-\u62fd\u62ff-\uf972\uf974-\uf9fc\uf9fe-\U0001010f\U00010111-\U00010148\U0001014a-\U0001014f\U00010151-\U00010156\U00010158-\U0001015f\U00010165-\U000102e9\U000102eb-\U00010321\U00010323-\U000103d2\U000103d4-\U0001085a\U0001085c-\U0001087d\U0001087f-\U000108ac\U000108ae-\U000108fc\U000108fe-\U00010916\U00010918-\U000109c8\U000109ca-\U00010a43\U00010a45-\U00010a9d\U00010a9f-\U00010aec\U00010aee-\U00010b5b\U00010b5d-\U00010b7b\U00010b7d-\U00010bac\U00010bae-\U00010cfb\U00010cfd-\U00010e68\U00010e6a-\U00010f21\U00010f23-\U00010f51\U00010f53-\U00010fc8\U00010fca-\U0001105a\U0001105c-\U000111e9\U000111eb-\U00011739\U0001173b-\U000118e9\U000118eb-\U00011c62\U00011c64-\U00016b5a\U00016b5c-\U00016e89\U00016e8b-\U0001d2e9\U0001d2eb-\U0001d368\U0001d36a-\U0001ec79\U0001ec7b-\U0001ed09\U0001ed0b-\U0001ed36\U0001ed38-\U0010ffff",
    "^100": "\x00-\u0bf0\u0bf2-\u0d70\u0d72-\u137a\u137c-\u216c\u216e-\u217c\u217e-\u4f6f\u4f71-\u767d\u767f-\u964b\u964d-\U00010118\U0001011a-\U0001014a\U0001014c-\U00010151\U00010153-\U00010169\U0001016b-\U000102f2\U000102f4-\U000103d4\U000103d6-\U0001085c\U0001085e-\U000108ae\U000108b0-\U000108fe\U00010900-\U00010918\U0001091a-\U000109d1\U000109d3-\U00010a45\U00010a47-\U00010aee\U00010af0-\U00010b5d\U00010b5f-\U00010b7d\U00010b7f-\U00010bae\U00010bb0-\U00010cfd\U00010cff-\U00010e71\U00010e73-\U00010f24\U00010f26-\U00010f53\U00010f55-\U00010fca\U00010fcc-\U00011063\U00011065-\U000111f2\U000111f4-\U00011c6b\U00011c6d-\U00016b5b\U00016b5d-\U0001ec82\U0001ec84-\U0001ed12\U0001ed14-\U0010ffff",
    "^1000": "\x00-\u0bf1\u0bf3-\u0d71\u0d73-\u216e\u2170-\u217e\u2181-\u4ede\u4ee0-\u5342\u5344-\u9620\u9622-\U00010121\U00010123-\U0001014c\U0001014e-\U00010153\U00010155-\U00010170\U00010172-\U0001085d\U0001085f-\U000109da\U000109dc-\U00010a46\U00010a48-\U00010b5e\U00010b60-\U00010b7e\U00010b80-\U00010cfe\U00010d00-\U00011064\U00011066-\U000111f3\U000111f5-\U0001ec8b\U0001ec8d-\U0001ed1b\U0001ed1d-\U0010ffff",
    "^10000": "\x00-\u137b\u137d-\u2181\u2183-\u4e06\u4e08-\u842b\u842d-\U0001012a\U0001012c-\U00010154\U00010156-\U0001085e\U00010860-\U000109e3\U000109e5-\U00016b5c\U00016b5e-\U0001ec94\U0001ec96-\U0001ecb2\U0001ecb4-\U0001ed24\U0001ed26-\U0001ed3a\U0001ed3c-\U0010ffff",
    "^100000": "\x00-\u2187\u2189-\U000109ec\U000109ee-\U0001ec9d\U0001ec9f\U0001eca1-\U0001ecb3\U0001ecb5-\U0010ffff",
    "^1000000": "\x00-\U00016b5d\U00016b5f-\U0010ffff",
    "^10000000": "\x00-\U0001eca0\U0001eca2-\U0010ffff",
    "^100000000": "\x00-\u4ebe\u4ec0-\u5103\u5105-\U00016b5e\U00016b60-\U0010ffff",
    "^10000000000": "\x00-\U00016b5f\U00016b61-\U0010ffff",
    "^1000000000000": "\x00-\u5145\u5147-\U00016b60\U00016b62-\U0010ffff",
    "^11": "\x00-\u2169\u216b-\u2179\u217b-\u2469\u246b-\u247d\u247f-\u2491\u2493-\u24ea\u24ec-\U00016e8a\U00016e8c-\U0001d2ea\U0001d2ec-\U0010ffff",
    "^11/12": "\x00-\U000109bb\U000109bd-\U0010ffff",
    "^11/2": "\x00-\u0f2e\u0f30-\U0010ffff",
    "^12": "\x00-\u216a\u216c-\u217a\u217c-\u246a\u246c-\u247e\u2480-\u2492\u2494-\u24eb\u24ed-\U00016e8b\U00016e8d-\U0001d2eb\U0001d2ed-\U0010ffff",
    "^13": "\x00-\u246b\u246d-\u247f\u2481-\u2493\u2495-\u24ec\u24ee-\U00016e8c\U00016e8e-\U0001d2ec\U0001d2ee-\U0010ffff",
    "^13/2": "\x00-\u0f2f\u0f31-\U0010ffff",
    "^14": "\x00-\u246c\u246e-\u2480\u2482-\u2494\u2496-\u24ed\u24ef-\U00016e8d\U00016e8f-\U0001d2ed\U0001d2ef-\U0010ffff",
    "^15": "\x00-\u246d\u246f-\u2481\u2483-\u2495\u2497-\u24ee\u24f0-\U00016e8e\U00016e90-\U0001d2ee\U0001d2f0-\U0010ffff",
    "^15/2": "\x00-\u0f30\u0f32-\U0010ffff",
    "^16": "\x00-\u09f8\u09fa-\u246e\u2470-\u2482\u2484-\u2496\u2498-\u24ef\u24f1-\U00016e8f\U00016e91-\U0001d2ef\U0001d2f1-\U0010ffff",
    "^17": "\x00-\u16ed\u16ef-\u246f\u2471-\u2483\u2485-\u2497\u2499-\u24f0\u24f2-\U00016e90\U00016e92-\U0001d2f0\U0001d2f2-\U0010ffff",
    "^17/2": "\x00-\u0f31\u0f33-\U0010ffff",
    "^18": "\x00-\u16ee\u16f0-\u2470\u2472-\u2484\u2486-\u2498\u249a-\u24f1\u24f3-\U00016e91\U00016e93-\U0001d2f1\U0001d2f3-\U0010ffff",
    "^19": "\x00-\u16ef\u16f1-\u2471\u2473-\u2485\u2487-\u2499\u249b-\u24f2\u24f4-\U00016e92\U00016e94-\U0001d2f2\U0001d2f4-\U0010ffff",
    "^2": "\x00-\x31\x33-\xb1\xb3-\u0661\u0663-\u06f1\u06f3-\u07c1\u07c3-\u0967\u0969-\u09e7\u09e9-\u0a67\u0a69-\u0ae7\u0ae9-\u0b67\u0b69-\u0be7\u0be9-\u0c67\u0c69-\u0c79\u0c7b-\u0c7c\u0c7e-\u0ce7\u0ce9-\u0d67\u0d69-\u0de7\u0de9-\u0e51\u0e53-\u0ed1\u0ed3-\u0f21\u0f23-\u1041\u1043-\u1091\u1093-\u1369\u136b-\u17e1\u17e3-\u17f1\u17f3-\u1811\u1813-\u1947\u1949-\u19d1\u19d3-\u1a81\u1a83-\u1a91\u1a93-\u1b51\u1b53-\u1bb1\u1bb3-\u1c41\u1c43-\u1c51\u1c53-\u2081\u2083-\u2160\u2162-\u2170\u2172-\u2460\u2462-\u2474\u2476-\u2488\u248a-\u24f5\u24f7-\u2776\u2778-\u2780\u2782-\u278a\u278c-\u3021\u3023-\u3192\u3194-\u3220\u3222-\u3280\u3282-\u3482\u3484-\u4e8b\u4e8d-\u5168\u516a-\u5f0c\u5f0e-\u5f0f\u5f11-\u8cad\u8caf-\u8cb2\u8cb4-\u8d2f\u8d31-\ua621\ua623-\ua6e6\ua6e8-\ua8d1\ua8d3-\ua901\ua903-\ua9d1\ua9d3-\ua9f1\ua9f3-\uaa51\uaa53-\uabf1\uabf3-\uf977\uf979-\uff11\uff13-\U00010107\U00010109-\U0001015a\U0001015f-\U000102e1\U000102e3-\U000103d1\U000103d3-\U000104a1\U000104a3-\U00010858\U0001085a-\U00010879\U0001087b-\U000108a7\U000108a9-\U00010919\U0001091b-\U000109c0\U000109c2-\U00010a40\U00010a42-\U00010b58\U00010b5a-\U00010b78\U00010b7a-\U00010ba9\U00010bab-\U00010d31\U00010d33-\U00010e60\U00010e62-\U00010f1d\U00010f1f-\U00010fc5\U00010fc7-\U00011052\U00011054-\U00011067\U00011069-\U000110f1\U000110f3-\U00011137\U00011139-\U000111d1\U000111d3-\U000111e1\U000111e3-\U000112f1\U000112f3-\U00011451\U00011453-\U000114d1\U000114d3-\U00011651\U00011653-\U000116c1\U000116c3-\U00011731\U00011733-\U000118e1\U000118e3-\U00011951\U00011953-\U00011c51\U00011c53-\U00011c5a\U00011c5c-\U00011d51\U00011d53-\U00011da1\U00011da3-\U000123ff\U00012401-\U00012415\U00012417-\U0001241e\U00012420-\U00012422\U00012424-\U0001242c\U0001242e-\U00012434\U00012436-\U00012449\U0001244b-\U0001244f\U00012451-\U00012455\U00012457-\U00012458\U0001245a-\U00016a61\U00016a63-\U00016b51\U00016b53-\U00016e81\U00016e83-\U00016e94\U00016e96-\U0001d2e1\U0001d2e3-\U0001d360\U0001d362-\U0001d372\U0001d374-\U0001d7cf\U0001d7d1-\U0001d7d9\U0001d7db-\U0001d7e3\U0001d7e5-\U0001d7ed\U0001d7ef-\U0001d7f7\U0001d7f9-\U0001e141\U0001e143-\U0001e2f1\U0001e2f3-\U0001e8c7\U0001e8c9-\U0001e951\U0001e953-\U0001ec71\U0001ec73-\U0001eca3\U0001eca5-\U0001ecb1\U0001ecb3-\U0001ed01\U0001ed03-\U0001ed2e\U0001ed30-\U0001f102\U0001f104-\U0001fbf1\U0001fbf3-\U0002238f\U00022391-\U0010ffff",
    "^2/3": "\x00-\u2153\u2155-\U00010176\U00010178-\U000109fc\U000109fe-\U00010e7d\U00010e7f-\U0001245a\U0001245c-\U0001245d\U0001245f-\U00012465\U00012467-\U0010ffff",
    "^2/5": "\x00-\u2155\u2157-\U0010ffff",
    "^20": "\x00-\u1372\u1374-\u2472\u2474-\u2486\u2488-\u249a\u249c-\u24f3\u24f5-\u3038\u303a-\u3248\u324a-\u5343\u5345-\u5efe\u5f00-\U00010110\U00010112-\U000102ea\U000102ec-\U000103d3\U000103d5-\U0001085b\U0001085d-\U0001087e\U00010880-\U000108ad\U000108af-\U000108fd\U000108ff-\U00010917\U00010919-\U000109c9\U000109cb-\U00010a44\U00010a46-\U00010a9e\U00010aa0-\U00010aed\U00010aef-\U00010b5c\U00010b5e-\U00010b7c\U00010b7e-\U00010bad\U00010baf-\U00010e69\U00010e6b-\U00010f22\U00010f24-\U00010f52\U00010f54-\U00010fc9\U00010fcb-\U0001105b\U0001105d-\U000111ea\U000111ec-\U0001173a\U0001173c-\U000118ea\U000118ec-\U00011c63\U00011c65-\U0001d369\U0001d36b-\U0001ec7a\U0001ec7c-\U0001ed0a\U0001ed0c-\U0010ffff",
    "^200": "\x00-\U00010119\U0001011b-\U000102f3\U000102f5-\U000109d2\U000109d4-\U00010e72\U00010e74-\U0001ec83\U0001ec85-\U0001ed13\U0001ed15-\U0010ffff",
    "^2000": "\x00-\U00010122\U00010124-\U000109db\U000109dd-\U0001ec8c\U0001ec8e-\U0001ed1c\U0001ed1e-\U0001ed39\U0001ed3b-\U0010ffff",
    "^20000": "\x00-\U0001012b\U0001012d-\U000109e4\U000109e6-\U0001ec95\U0001ec97-\U0001ed25\U0001ed27-\U0010ffff",
    "^200000": "\x00-\U000109ed\U000109ef-\U0001ec9e\U0001eca0-\U0010ffff",
    "^20000000": "\x00-\U0001eca1\U0001eca3-\U0010ffff",
    "^21": "\x00-\u3250\u3252-\U0010ffff",
    "^216000": "\x00-\U00012431\U00012433-\U0010ffff",
    "^22": "\x00-\u3251\u3253-\U0010ffff",
    "^23": "\x00-\u3252\u3254-\U0010ffff",
    "^24": "\x00-\u3253\u3255-\U0010ffff",
    "^25": "\x00-\u3254\u3256-\U0010ffff",
    "^26": "\x00-\u3255\u3257-\U0010ffff",
    "^27": "\x00-\u3256\u3258-\U0010ffff",
    "^28": "\x00-\u3257\u3259-\U0010ffff",
    "^29": "\x00-\u3258\u325a-\U0010ffff",
    "^3": "\x00-\x32\x34-\xb2\xb4-\u0662\u0664-\u06f2\u06f4-\u07c2\u07c4-\u0968\u096a-\u09e8\u09ea-\u0a68\u0a6a-\u0ae8\u0aea-\u0b68\u0b6a-\u0be8\u0bea-\u0c68\u0c6a-\u0c7a\u0c7c-\u0c7d\u0c7f-\u0ce8\u0cea-\u0d68\u0d6a-\u0de8\u0dea-\u0e52\u0e54-\u0ed2\u0ed4-\u0f22\u0f24-\u1042\u1044-\u1092\u1094-\u136a\u136c-\u17e2\u17e4-\u17f2\u17f4-\u1812\u1814-\u1948\u194a-\u19d2\u19d4-\u1a82\u1a84-\u1a92\u1a94-\u1b52\u1b54-\u1bb2\u1bb4-\u1c42\u1c44-\u1c52\u1c54-\u2082\u2084-\u2161\u2163-\u2171\u2173-\u2461\u2463-\u2475\u2477-\u2489\u248b-\u24f6\u24f8-\u2777\u2779-\u2781\u2783-\u278b\u278d-\u3022\u3024-\u3193\u3195-\u3221\u3223-\u3281\u3283-\u4e08\u4e0a-\u4ee7\u4ee9-\u53c0\u53c5-\u5f0d\u5f0f-\ua622\ua624-\ua6e7\ua6e9-\ua8d2\ua8d4-\ua902\ua904-\ua9d2\ua9d4-\ua9f2\ua9f4-\uaa52\uaa54-\uabf2\uabf4-\uf96a\uf96c-\uff12\uff14-\U00010108\U0001010a-\U000102e2\U000102e4-\U000104a2\U000104a4-\U00010859\U0001085b-\U0001087a\U0001087c-\U000108a8\U000108aa-\U0001091a\U0001091c-\U000109c1\U000109c3-\U00010a41\U00010a43-\U00010b59\U00010b5b-\U00010b79\U00010b7b-\U00010baa\U00010bac-\U00010d32\U00010d34-\U00010e61\U00010e63-\U00010f1e\U00010f20-\U00010fc6\U00010fc8-\U00011053\U00011055-\U00011068\U0001106a-\U000110f2\U000110f4-\U00011138\U0001113a-\U000111d2\U000111d4-\U000111e2\U000111e4-\U000112f2\U000112f4-\U00011452\U00011454-\U000114d2\U000114d4-\U00011652\U00011654-\U000116c2\U000116c4-\U00011732\U00011734-\U000118e2\U000118e4-\U00011952\U00011954-\U00011c52\U00011c54-\U00011c5b\U00011c5d-\U00011d52\U00011d54-\U00011da2\U00011da4-\U00012400\U00012402-\U00012407\U00012409-\U00012416\U00012418-\U0001241f\U00012421-\U00012423\U00012426-\U0001242d\U00012430-\U00012435\U00012438-\U00012439\U0001243c-\U0001244a\U0001244c-\U00012450\U00012452-\U00012456\U00012458-\U00016a62\U00016a64-\U00016b52\U00016b54-\U00016e82\U00016e84-\U00016e95\U00016e97-\U0001d2e2\U0001d2e4-\U0001d361\U0001d363-\U0001d373\U0001d375-\U0001d7d0\U0001d7d2-\U0001d7da\U0001d7dc-\U0001d7e4\U0001d7e6-\U0001d7ee\U0001d7f0-\U0001d7f8\U0001d7fa-\U0001e142\U0001e144-\U0001e2f2\U0001e2f4-\U0001e8c8\U0001e8ca-\U0001e952\U0001e954-\U0001ec72\U0001ec74-\U0001eca4\U0001eca6-\U0001ed02\U0001ed04-\U0001ed2f\U0001ed31-\U0001f103\U0001f105-\U0001fbf2\U0001fbf4-\U00020afc\U00020afe-\U00020b18\U00020b1a-\U00022997\U00022999-\U00023b1a\U00023b1c-\U0010ffff",
    "^3/16": "\x00-\u09f5\u09f7-\u0b76\u0b78-\u0d77\u0d79-\ua834\ua836-\U00011fcd\U00011fcf-\U0010ffff",
    "^3/2": "\x00-\u0f2a\u0f2c-\U0010ffff",
    "^3/20": "\x00-\u0d5c\u0d5e-\U00011fcc\U00011fce-\U0010ffff",
    "^3/4": "\x00-\xbd\xbf-\u09f7\u09f9-\u0b73\u0b75-\u0d74\u0d76-\ua831\ua833-\U00010177\U00010179-\U000109fd\U000109ff-\U00011fd2\U00011fd4-\U0001ecae\U0001ecb0-\U0010ffff",
    "^3/5": "\x00-\u2156\u2158-\U0010ffff",
    "^3/64": "\x00-\U00011fc6\U00011fc8-\U0010ffff",
    "^3/8": "\x00-\u215b\u215d-\U0010ffff",
    "^3/80": "\x00-\u0d59\u0d5b-\U00011fc5\U00011fc7-\U0010ffff",
    "^30": "\x00-\u1373\u1375-\u3039\u303b-\u3249\u324b-\u3259\u325b-\u5344\u5346-\U00010111\U00010113-\U00010164\U00010166-\U000102eb\U000102ed-\U000109ca\U000109cc-\U00010e6a\U00010e6c-\U00010f23\U00010f25-\U0001105c\U0001105e-\U000111eb\U000111ed-\U000118eb\U000118ed-\U00011c64\U00011c66-\U0001d36a\U0001d36c-\U0001ec7b\U0001ec7d-\U0001ed0b\U0001ed0d-\U00020982\U00020984-\U0010ffff",
    "^300": "\x00-\U0001011a\U0001011c-\U0001016a\U0001016c-\U000102f4\U000102f6-\U000109d3\U000109d5-\U00010e73\U00010e75-\U0001ec84\U0001ec86-\U0001ed14\U0001ed16-\U0010ffff",
    "^3000": "\x00-\U00010123\U00010125-\U000109dc\U000109de-\U0001ec8d\U0001ec8f-\U0001ed1d\U0001ed1f-\U0010ffff",
    "^30000": "\x00-\U0001012c\U0001012e-\U000109e5\U000109e7-\U0001ec96\U0001ec98-\U0001ed26\U0001ed28-\U0010ffff",
    "^300000": "\x00-\U000109ee\U000109f0-\U0010ffff",
    "^31": "\x00-\u325a\u325c-\U0010ffff",
    "^32": "\x00-\u325b\u325d-\U0010ffff",
    "^33": "\x00-\u325c\u325e-\U0010ffff",
    "^34": "\x00-\u325d\u325f-\U0010ffff",
    "^35": "\x00-\u325e\u3260-\U0010ffff",
    "^36": "\x00-\u32b0\u32b2-\U0010ffff",
    "^37": "\x00-\u32b1\u32b3-\U0010ffff",
    "^38": "\x00-\u32b2\u32b4-\U0010ffff",
    "^39": "\x00-\u32b3\u32b5-\U0010ffff",
    "^4": "\x00-\x33\x35-\u0663\u0665-\u06f3\u06f5-\u07c3\u07c5-\u0969\u096b-\u09e9\u09eb-\u0a69\u0a6b-\u0ae9\u0aeb-\u0b69\u0b6b-\u0be9\u0beb-\u0c69\u0c6b-\u0ce9\u0ceb-\u0d69\u0d6b-\u0de9\u0deb-\u0e53\u0e55-\u0ed3\u0ed5-\u0f23\u0f25-\u1043\u1045-\u1093\u1095-\u136b\u136d-\u17e3\u17e5-\u17f3\u17f5-\u1813\u1815-\u1949\u194b-\u19d3\u19d5-\u1a83\u1a85-\u1a93\u1a95-\u1b53\u1b55-\u1bb3\u1bb5-\u1c43\u1c45-\u1c53\u1c55-\u2073\u2075-\u2083\u2085-\u2162\u2164-\u2172\u2174-\u2462\u2464-\u2476\u2478-\u248a\u248c-\u24f7\u24f9-\u2778\u277a-\u2782\u2784-\u278c\u278e-\u3023\u3025-\u3194\u3196-\u3222\u3224-\u3282\u3284-\u4e95\u4e97-\u56da\u56dc-\u8085\u8087-\ua623\ua625-\ua6e8\ua6ea-\ua8d3\ua8d5-\ua903\ua905-\ua9d3\ua9d5-\ua9f3\ua9f5-\uaa53\uaa55-\uabf3\uabf5-\uff13\uff15-\U00010109\U0001010b-\U000102e3\U000102e5-\U000104a3\U000104a5-\U0001087b\U0001087d-\U000108a9\U000108ac-\U000109c2\U000109c4-\U00010a42\U00010a44-\U00010b5a\U00010b5c-\U00010b7a\U00010b7c-\U00010bab\U00010bad-\U00010d33\U00010d35-\U00010e62\U00010e64-\U00010f1f\U00010f21-\U00010fc7\U00010fc9-\U00011054\U00011056-\U00011069\U0001106b-\U000110f3\U000110f5-\U00011139\U0001113b-\U000111d3\U000111d5-\U000111e3\U000111e5-\U000112f3\U000112f5-\U00011453\U00011455-\U000114d3\U000114d5-\U00011653\U00011655-\U000116c3\U000116c5-\U00011733\U00011735-\U000118e3\U000118e5-\U00011953\U00011955-\U00011c53\U00011c55-\U00011c5c\U00011c5e-\U00011d53\U00011d55-\U00011da3\U00011da5-\U00012401\U00012403-\U00012408\U0001240a-\U0001240e\U00012410-\U00012417\U00012419-\U00012420\U00012422-\U00012425\U00012427-\U0001242f\U00012431-\U00012437\U00012439-\U0001243b\U00012440-\U0001244b\U0001244d-\U00012451\U00012454-\U00012468\U0001246a-\U00016a63\U00016a65-\U00016b53\U00016b55-\U00016e83\U00016e85-\U0001d2e3\U0001d2e5-\U0001d362\U0001d364-\U0001d374\U0001d376-\U0001d7d1\U0001d7d3-\U0001d7db\U0001d7dd-\U0001d7e5\U0001d7e7-\U0001d7ef\U0001d7f1-\U0001d7f9\U0001d7fb-\U0001e143\U0001e145-\U0001e2f3\U0001e2f5-\U0001e8c9\U0001e8cb-\U0001e953\U0001e955-\U0001ec73\U0001ec75-\U0001eca5\U0001eca7-\U0001ed03\U0001ed05-\U0001ed30\U0001ed32-\U0001f104\U0001f106-\U0001fbf3\U0001fbf5-\U00020063\U00020065-\U000200e1\U000200e3-\U0002626c\U0002626e-\U0010ffff",
    "^4/5": "\x00-\u2157\u2159-\U0010ffff",
    "^40": "\x00-\u1374\u1376-\u324a\u324c-\u32b4\u32b6-\u534b\u534d-\U00010112\U00010114-\U000102ec\U000102ee-\U000109cb\U000109cd-\U00010e6b\U00010e6d-\U0001105d\U0001105f-\U000111ec\U000111ee-\U000118ec\U000118ee-\U00011c65\U00011c67-\U00012466\U00012468-\U0001d36b\U0001d36d-\U0001ec7c\U0001ec7e-\U0001ed0c\U0001ed0e-\U0002098b\U0002098d-\U0002099b\U0002099d-\U0010ffff",
    "^400": "\x00-\U0001011b\U0001011d-\U000102f5\U000102f7-\U000109d4\U000109d6-\U00010e74\U00010e76-\U0001ec85\U0001ec87-\U0001ed15\U0001ed17-\U0001ed37\U0001ed39-\U0010ffff",
    "^4000": "\x00-\U00010124\U00010126-\U000109dd\U000109df-\U0001ec8e\U0001ec90-\U0001ed1e\U0001ed20-\U0010ffff",
    "^40000": "\x00-\U0001012d\U0001012f-\U000109e6\U000109e8-\U0001ec97\U0001ec99-\U0001ed27\U0001ed29-\U0010ffff",
    "^400000": "\x00-\U000109ef\U000109f1-\U0010ffff",
    "^41": "\x00-\u32b5\u32b7-\U0010ffff",
    "^42": "\x00-\u32b6\u32b8-\U0010ffff",
    "^43": "\x00-\u32b7\u32b9-\U0010ffff",
    "^432000": "\x00-\U00012432\U00012434-\U0010ffff",
    "^44": "\x00-\u32b8\u32ba-\U0010ffff",
    "^45": "\x00-\u32b9\u32bb-\U0010ffff",
    "^46": "\x00-\u32ba\u32bc-\U0010ffff",
    "^47": "\x00-\u32bb\u32bd-\U0010ffff",
    "^48": "\x00-\u32bc\u32be-\U0010ffff",
    "^49": "\x00-\u32bd\u32bf-\U0010ffff",
    "^5": "\x00-\x34\x36-\u0664\u0666-\u06f4\u06f6-\u07c4\u07c6-\u096a\u096c-\u09ea\u09ec-\u0a6a\u0a6c-\u0aea\u0aec-\u0b6a\u0b6c-\u0bea\u0bec-\u0c6a\u0c6c-\u0cea\u0cec-\u0d6a\u0d6c-\u0dea\u0dec-\u0e54\u0e56-\u0ed4\u0ed6-\u0f24\u0f26-\u1044\u1046-\u1094\u1096-\u136c\u136e-\u17e4\u17e6-\u17f4\u17f6-\u1814\u1816-\u194a\u194c-\u19d4\u19d6-\u1a84\u1a86-\u1a94\u1a96-\u1b54\u1b56-\u1bb4\u1bb6-\u1c44\u1c46-\u1c54\u1c56-\u2074\u2076-\u2084\u2086-\u2163\u2165-\u2173\u2175-\u2463\u2465-\u2477\u2479-\u248b\u248d-\u24f8\u24fa-\u2779\u277b-\u2783\u2785-\u278d\u278f-\u3024\u3026-\u3223\u3225-\u3283\u3285-\u3404\u3406-\u3829\u382b-\u4e93\u4e95-\u4f0c\u4f0e-\ua624\ua626-\ua6e9\ua6eb-\ua8d4\ua8d6-\ua904\ua906-\ua9d4\ua9d6-\ua9f4\ua9f6-\uaa54\uaa56-\uabf4\uabf6-\uff14\uff16-\U0001010a\U0001010c-\U00010142\U00010144-\U00010147\U00010149-\U0001014e\U00010150-\U0001015e\U00010160-\U00010172\U00010174-\U000102e4\U000102e6-\U00010320\U00010322-\U000104a4\U000104a6-\U0001087c\U0001087e-\U000108ab\U000108ad-\U000108fb\U000108fd-\U000109c3\U000109c5-\U00010aeb\U00010aed-\U00010cfa\U00010cfc-\U00010d34\U00010d36-\U00010e63\U00010e65-\U00010f20\U00010f22-\U00011055\U00011057-\U0001106a\U0001106c-\U000110f4\U000110f6-\U0001113a\U0001113c-\U000111d4\U000111d6-\U000111e4\U000111e6-\U000112f4\U000112f6-\U00011454\U00011456-\U000114d4\U000114d6-\U00011654\U00011656-\U000116c4\U000116c6-\U00011734\U00011736-\U000118e4\U000118e6-\U00011954\U00011956-\U00011c54\U00011c56-\U00011c5d\U00011c5f-\U00011d54\U00011d56-\U00011da4\U00011da6-\U00012402\U00012404-\U00012409\U0001240b-\U0001240f\U00012411-\U00012418\U0001241a-\U00012421\U00012423-\U00012426\U00012428-\U00012430\U00012432-\U00012438\U0001243a-\U0001244c\U0001244e-\U00012453\U00012456-\U00012469\U0001246b-\U00016a64\U00016a66-\U00016b54\U00016b56-\U00016e84\U00016e86-\U0001d2e4\U0001d2e6-\U0001d363\U0001d365-\U0001d375\U0001d377\U0001d379-\U0001d7d2\U0001d7d4-\U0001d7dc\U0001d7de-\U0001d7e6\U0001d7e8-\U0001d7f0\U0001d7f2-\U0001d7fa\U0001d7fc-\U0001e144\U0001e146-\U0001e2f4\U0001e2f6-\U0001e8ca\U0001e8cc-\U0001e954\U0001e956-\U0001ec74\U0001ec76-\U0001eca6\U0001eca8-\U0001ed04\U0001ed06-\U0001ed31\U0001ed33-\U0001f105\U0001f107-\U0001fbf4\U0001fbf6-\U00020120\U00020122-\U0010ffff",
    "^5/12": "\x00-\U000109f9\U000109fb-\U0010ffff",
    "^5/2": "\x00-\u0f2b\u0f2d-\U0010ffff",
    "^5/6": "\x00-\u2159\u215b-\U000109fe\U00010a00-\U0001245b\U0001245d-\U0010ffff",
    "^5/8": "\x00-\u215c\u215e-\U0010ffff",
    "^50": "\x00-\u1375\u1377-\u216b\u216d-\u217b\u217d-\u2185\u2187-\u324b\u324d-\u32be\u32c0-\U00010113\U00010115-\U00010143\U00010145-\U00010149\U0001014b-\U00010150\U00010152-\U00010165\U0001016a-\U00010173\U00010175-\U000102ed\U000102ef-\U00010322\U00010324-\U000109cc\U000109ce-\U00010a7d\U00010a7f-\U00010cfc\U00010cfe-\U00010e6c\U00010e6e-\U0001105e\U00011060-\U000111ed\U000111ef-\U000118ed\U000118ef-\U00011c66\U00011c68-\U00012467\U00012469-\U0001d36c\U0001d36e-\U0001ec7d\U0001ec7f-\U0001ed0d\U0001ed0f-\U0010ffff",
    "^500": "\x00-\u216d\u216f-\u217d\u217f-\U0001011c\U0001011e-\U00010144\U00010146-\U0001014b\U0001014d-\U00010152\U00010154-\U0001016b\U00010171-\U000102f6\U000102f8-\U000109d5\U000109d7-\U00010e75\U00010e77-\U0001ec86\U0001ec88-\U0001ed16\U0001ed18-\U0010ffff",
    "^5000": "\x00-\u2180\u2182-\U00010125\U00010127-\U00010145\U00010147-\U0001014d\U0001014f-\U00010171\U00010173-\U000109de\U000109e0-\U0001ec8f\U0001ec91-\U0001ed1f\U0001ed21-\U0010ffff",
    "^50000": "\x00-\u2186\u2188-\U0001012e\U00010130-\U00010146\U00010148-\U00010155\U00010157-\U000109e7\U000109e9-\U0001ec98\U0001ec9a-\U0001ed28\U0001ed2a-\U0010ffff",
    "^500000": "\x00-\U000109f0\U000109f2-\U0010ffff",
    "^6": "\x00-\x35\x37-\u0665\u0667-\u06f5\u06f7-\u07c5\u07c7-\u096b\u096d-\u09eb\u09ed-\u0a6b\u0a6d-\u0aeb\u0aed-\u0b6b\u0b6d-\u0beb\u0bed-\u0c6b\u0c6d-\u0ceb\u0ced-\u0d6b\u0d6d-\u0deb\u0ded-\u0e55\u0e57-\u0ed5\u0ed7-\u0f25\u0f27-\u1045\u1047-\u1095\u1097-\u136d\u136f-\u17e5\u17e7-\u17f5\u17f7-\u1815\u1817-\u194b\u194d-\u19d5\u19d7-\u1a85\u1a87-\u1a95\u1a97-\u1b55\u1b57-\u1bb5\u1bb7-\u1c45\u1c47-\u1c55\u1c57-\u2075\u2077-\u2085\u2087-\u2164\u2166-\u2174\u2176-\u2184\u2186-\u2464\u2466-\u2478\u247a-\u248c\u248e-\u24f9\u24fb-\u277a\u277c-\u2784\u2786-\u278e\u2790-\u3025\u3027-\u3224\u3226-\u3284\u3286-\u516c\u516e-\u9645\u9647-\u9677\u9679-\ua625\ua627-\ua6ea\ua6ec-\ua8d5\ua8d7-\ua905\ua907-\ua9d5\ua9d7-\ua9f5\ua9f7-\uaa55\uaa57-\uabf5\uabf7-\uf9d0\uf9d2\uf9d4-\uff15\uff17-\U0001010b\U0001010d-\U000102e5\U000102e7-\U000104a5\U000104a7-\U000109c4\U000109c6-\U00010d35\U00010d37-\U00010e64\U00010e66-\U00011056\U00011058-\U0001106b\U0001106d-\U000110f5\U000110f7-\U0001113b\U0001113d-\U000111d5\U000111d7-\U000111e5\U000111e7-\U000112f5\U000112f7-\U00011455\U00011457-\U000114d5\U000114d7-\U00011655\U00011657-\U000116c5\U000116c7-\U00011735\U00011737-\U000118e5\U000118e7-\U00011955\U00011957-\U00011c55\U00011c57-\U00011c5e\U00011c60-\U00011d55\U00011d57-\U00011da5\U00011da7-\U00012403\U00012405-\U0001240a\U0001240c-\U00012410\U00012412-\U00012419\U0001241b-\U00012427\U00012429-\U0001243f\U00012441-\U0001244d\U0001244f-\U0001246a\U0001246c-\U00016a65\U00016a67-\U00016b55\U00016b57-\U00016e85\U00016e87-\U0001d2e5\U0001d2e7-\U0001d364\U0001d366-\U0001d7d3\U0001d7d5-\U0001d7dd\U0001d7df-\U0001d7e7\U0001d7e9-\U0001d7f1\U0001d7f3-\U0001d7fb\U0001d7fd-\U0001e145\U0001e147-\U0001e2f5\U0001e2f7-\U0001e8cb\U0001e8cd-\U0001e955\U0001e957-\U0001ec75\U0001ec77-\U0001eca7\U0001eca9-\U0001ed05\U0001ed07-\U0001ed32\U0001ed34-\U0001f106\U0001f108-\U0001fbf5\U0001fbf7-\U00020ae9\U00020aeb-\U0010ffff",
    "^60": "\x00-\u1376\u1378-\u324c\u324e-\U00010114\U00010116-\U000102ee\U000102f0-\U000109cd\U000109cf-\U00010e6d\U00010e6f-\U0001105f\U00011061-\U000111ee\U000111f0-\U000118ee\U000118f0-\U00011c67\U00011c69-\U0001d36d\U0001d36f-\U0001ec7e\U0001ec80-\U0001ed0e\U0001ed10-\U0010ffff",
    "^600": "\x00-\U0001011d\U0001011f-\U000102f7\U000102f9-\U000109d6\U000109d8-\U00010e76\U00010e78-\U0001ec87\U0001ec89-\U0001ed17\U0001ed19-\U0001ed38\U0001ed3a-\U0010ffff",
    "^6000": "\x00-\U00010126\U00010128-\U000109df\U000109e1-\U0001ec90\U0001ec92-\U0001ed20\U0001ed22-\U0010ffff",
    "^60000": "\x00-\U0001012f\U00010131-\U000109e8\U000109ea-\U0001ec99\U0001ec9b-\U0001ed29\U0001ed2b-\U0010ffff",
    "^600000": "\x00-\U000109f1\U000109f3-\U0010ffff",
    "^7": "\x00-\x36\x38-\u0666\u0668-\u06f6\u06f8-\u07c6\u07c8-\u096c\u096e-\u09ec\u09ee-\u0a6c\u0a6e-\u0aec\u0aee-\u0b6c\u0b6e-\u0bec\u0bee-\u0c6c\u0c6e-\u0cec\u0cee-\u0d6c\u0d6e-\u0dec\u0dee-\u0e56\u0e58-\u0ed6\u0ed8-\u0f26\u0f28-\u1046\u1048-\u1096\u1098-\u136e\u1370-\u17e6\u17e8-\u17f6\u17f8-\u1816\u1818-\u194c\u194e-\u19d6\u19d8-\u1a86\u1a88-\u1a96\u1a98-\u1b56\u1b58-\u1bb6\u1bb8-\u1c46\u1c48-\u1c56\u1c58-\u2076\u2078-\u2086\u2088-\u2165\u2167-\u2175\u2177-\u2465\u2467-\u2479\u247b-\u248d\u248f-\u24fa\u24fc-\u277b\u277d-\u2785\u2787-\u278f\u2791-\u3026\u3028-\u3225\u3227-\u3285\u3287-\u3b4c\u3b4e-\u4e02\u4e04-\u67d1\u67d3-\u6f05\u6f07-\ua626\ua628-\ua6eb\ua6ed-\ua8d6\ua8d8-\ua906\ua908-\ua9d6\ua9d8-\ua9f6\ua9f8-\uaa56\uaa58-\uabf6\uabf8-\uff16\uff18-\U0001010c\U0001010e-\U000102e6\U000102e8-\U000104a6\U000104a8-\U000109c5\U000109c7-\U00010d36\U00010d38-\U00010e65\U00010e67-\U00011057\U00011059-\U0001106c\U0001106e-\U000110f6\U000110f8-\U0001113c\U0001113e-\U000111d6\U000111d8-\U000111e6\U000111e8-\U000112f6\U000112f8-\U00011456\U00011458-\U000114d6\U000114d8-\U00011656\U00011658-\U000116c6\U000116c8-\U00011736\U00011738-\U000118e6\U000118e8-\U00011956\U00011958-\U00011c56\U00011c58-\U00011c5f\U00011c61-\U00011d56\U00011d58-\U00011da6\U00011da8-\U00012404\U00012406-\U0001240b\U0001240d-\U00012411\U00012413-\U0001241a\U0001241c-\U00012428\U0001242a-\U00012440\U00012444-\U0001246b\U0001246d-\U00016a66\U00016a68-\U00016b56\U00016b58-\U00016e86\U00016e88-\U0001d2e6\U0001d2e8-\U0001d365\U0001d367-\U0001d7d4\U0001d7d6-\U0001d7de\U0001d7e0-\U0001d7e8\U0001d7ea-\U0001d7f2\U0001d7f4-\U0001d7fc\U0001d7fe-\U0001e146\U0001e148-\U0001e2f6\U0001e2f8-\U0001e8cc\U0001e8ce-\U0001e956\U0001e958-\U0001ec76\U0001ec78-\U0001eca8\U0001ecaa-\U0001ed06\U0001ed08-\U0001ed33\U0001ed35-\U0001f107\U0001f109-\U0001fbf6\U0001fbf8-\U00020000\U00020002-\U0010ffff",
    "^7/12": "\x00-\U000109fb\U000109fd-\U0010ffff",
    "^7/2": "\x00-\u0f2c\u0f2e-\U0010ffff",
    "^7/8": "\x00-\u215d\u215f-\U0010ffff",
    "^70": "\x00-\u1377\u1379-\u324d\u324f-\U00010115\U00010117-\U000102ef\U000102f1-\U000109ce\U000109d0-\U00010e6e\U00010e70-\U00011060\U00011062-\U000111ef\U000111f1-\U000118ef\U000118f1-\U00011c68\U00011c6a-\U0001d36e\U0001d370-\U0001ec7f\U0001ec81-\U0001ed0f\U0001ed11-\U0010ffff",
    "^700": "\x00-\U0001011e\U00010120-\U000102f8\U000102fa-\U000109d7\U000109d9-\U00010e77\U00010e79-\U0001ec88\U0001ec8a-\U0001ed18\U0001ed1a-\U0010ffff",
    "^7000": "\x00-\U00010127\U00010129-\U000109e0\U000109e2-\U0001ec91\U0001ec93-\U0001ed21\U0001ed23-\U0010ffff",
    "^70000": "\x00-\U00010130\U00010132-\U000109e9\U000109eb-\U0001ec9a\U0001ec9c-\U0001ed2a\U0001ed2c-\U0010ffff",
    "^700000": "\x00-\U000109f2\U000109f4-\U0010ffff",
    "^8": "\x00-\x37\x39-\u0667\u0669-\u06f7\u06f9-\u07c7\u07c9-\u096d\u096f-\u09ed\u09ef-\u0a6d\u0a6f-\u0aed\u0aef-\u0b6d\u0b6f-\u0bed\u0bef-\u0c6d\u0c6f-\u0ced\u0cef-\u0d6d\u0d6f-\u0ded\u0def-\u0e57\u0e59-\u0ed7\u0ed9-\u0f27\u0f29-\u1047\u1049-\u1097\u1099-\u136f\u1371-\u17e7\u17e9-\u17f7\u17f9-\u1817\u1819-\u194d\u194f-\u19d7\u19d9-\u1a87\u1a89-\u1a97\u1a99-\u1b57\u1b59-\u1bb7\u1bb9-\u1c47\u1c49-\u1c57\u1c59-\u2077\u2079-\u2087\u2089-\u2166\u2168-\u2176\u2178-\u2466\u2468-\u247a\u247c-\u248e\u2490-\u24fb\u24fd-\u277c\u277e-\u2786\u2788-\u2790\u2792-\u3027\u3029-\u3226\u3228-\u3286\u3288-\u516a\u516c-\u634b\u634d-\ua627\ua629-\ua6ec\ua6ee-\ua8d7\ua8d9-\ua907\ua909-\ua9d7\ua9d9-\ua9f7\ua9f9-\uaa57\uaa59-\uabf7\uabf9-\uff17\uff19-\U0001010d\U0001010f-\U000102e7\U000102e9-\U000104a7\U000104a9-\U000109c6\U000109c8-\U00010d37\U00010d39-\U00010e66\U00010e68-\U00011058\U0001105a-\U0001106d\U0001106f-\U000110f7\U000110f9-\U0001113d\U0001113f-\U000111d7\U000111d9-\U000111e7\U000111e9-\U000112f7\U000112f9-\U00011457\U00011459-\U000114d7\U000114d9-\U00011657\U00011659-\U000116c7\U000116c9-\U00011737\U00011739-\U000118e7\U000118e9-\U00011957\U00011959-\U00011c57\U00011c59-\U00011c60\U00011c62-\U00011d57\U00011d59-\U00011da7\U00011da9-\U00012405\U00012407-\U0001240c\U0001240e-\U00012412\U00012414-\U0001241b\U0001241d-\U00012429\U0001242b-\U00012443\U00012446-\U0001246c\U0001246e-\U00016a67\U00016a69-\U00016b57\U00016b59-\U00016e87\U00016e89-\U0001d2e7\U0001d2e9-\U0001d366\U0001d368-\U0001d7d5\U0001d7d7-\U0001d7df\U0001d7e1-\U0001d7e9\U0001d7eb-\U0001d7f3\U0001d7f5-\U0001d7fd\U0001d7ff-\U0001e147\U0001e149-\U0001e2f7\U0001e2f9-\U0001e8cd\U0001e8cf-\U0001e957\U0001e959-\U0001ec77\U0001ec79-\U0001eca9\U0001ecab-\U0001ed07\U0001ed09-\U0001ed34\U0001ed36-\U0001f108\U0001f10a-\U0001fbf7\U0001fbf9-\U0010ffff",
    "^80": "\x00-\u1378\u137a-\u324e\u3250-\U00010116\U00010118-\U000102f0\U000102f2-\U00010e6f\U00010e71-\U00011061\U00011063-\U000111f0\U000111f2-\U000118f0\U000118f2-\U00011c69\U00011c6b-\U0001d36f\U0001d371-\U0001ec80\U0001ec82-\U0001ed10\U0001ed12-\U0010ffff",
    "^800": "\x00-\U0001011f\U00010121-\U000102f9\U000102fb-\U000109d8\U000109da-\U00010e78\U00010e7a-\U0001ec89\U0001ec8b-\U0001ed19\U0001ed1b-\U0010ffff",
    "^8000": "\x00-\U00010128\U0001012a-\U000109e1\U000109e3-\U0001ec92\U0001ec94-\U0001ed22\U0001ed24-\U0010ffff",
    "^80000": "\x00-\U00010131\U00010133-\U000109ea\U000109ec-\U0001ec9b\U0001ec9d-\U0001ed2b\U0001ed2d-\U0010ffff",
    "^800000": "\x00-\U000109f3\U000109f5-\U0010ffff",
    "^9": "\x00-\x38\x3a-\u0668\u066a-\u06f8\u06fa-\u07c8\u07ca-\u096e\u0970-\u09ee\u09f0-\u0a6e\u0a70-\u0aee\u0af0-\u0b6e\u0b70-\u0bee\u0bf0-\u0c6e\u0c70-\u0cee\u0cf0-\u0d6e\u0d70-\u0dee\u0df0-\u0e58\u0e5a-\u0ed8\u0eda-\u0f28\u0f2a-\u1048\u104a-\u1098\u109a-\u1370\u1372-\u17e8\u17ea-\u17f8\u17fa-\u1818\u181a-\u194e\u1950-\u19d8\u19da-\u1a88\u1a8a-\u1a98\u1a9a-\u1b58\u1b5a-\u1bb8\u1bba-\u1c48\u1c4a-\u1c58\u1c5a-\u2078\u207a-\u2088\u208a-\u2167\u2169-\u2177\u2179-\u2467\u2469-\u247b\u247d-\u248f\u2491-\u24fc\u24fe-\u277d\u277f-\u2787\u2789-\u2791\u2793-\u3028\u302a-\u3227\u3229-\u3287\u3289-\u4e5c\u4e5e-\u5efd\u5eff-\u7395\u7397-\ua628\ua62a-\ua6ed\ua6ef-\ua8d8\ua8da-\ua908\ua90a-\ua9d8\ua9da-\ua9f8\ua9fa-\uaa58\uaa5a-\uabf8\uabfa-\uff18\uff1a-\U0001010e\U00010110-\U000102e8\U000102ea-\U000104a8\U000104aa-\U000109c7\U000109c9-\U00010d38\U00010d3a-\U00010e67\U00010e69-\U00011059\U0001105b-\U0001106e\U00011070-\U000110f8\U000110fa-\U0001113e\U00011140-\U000111d8\U000111da-\U000111e8\U000111ea-\U000112f8\U000112fa-\U00011458\U0001145a-\U000114d8\U000114da-\U00011658\U0001165a-\U000116c8\U000116ca-\U00011738\U0001173a-\U000118e8\U000118ea-\U00011958\U0001195a-\U00011c58\U00011c5a-\U00011c61\U00011c63-\U00011d58\U00011d5a-\U00011da8\U00011daa-\U00012406\U00012408-\U0001240d\U0001240f-\U00012413\U00012415-\U0001241c\U0001241e-\U0001242a\U0001242c-\U00012445\U0001244a-\U0001246d\U0001246f-\U00016a68\U00016a6a-\U00016b58\U00016b5a-\U00016e88\U00016e8a-\U0001d2e8\U0001d2ea-\U0001d367\U0001d369-\U0001d7d6\U0001d7d8-\U0001d7e0\U0001d7e2-\U0001d7ea\U0001d7ec-\U0001d7f4\U0001d7f6-\U0001d7fe\U0001d800-\U0001e148\U0001e14a-\U0001e2f8\U0001e2fa-\U0001e8ce\U0001e8d0-\U0001e958\U0001e95a-\U0001ec78\U0001ec7a-\U0001ecaa\U0001ecac-\U0001ed08\U0001ed0a-\U0001ed35\U0001ed37-\U0001f109\U0001f10b-\U0001fbf8\U0001fbfa-\U0002f88f\U0002f891-\U0010ffff",
    "^9/2": "\x00-\u0f2d\u0f2f-\U0010ffff",
    "^90": "\x00-\u1379\u137b-\U00010117\U00010119-\U000102f1\U000102f3-\U00010340\U00010342-\U00010e70\U00010e72-\U00011062\U00011064-\U000111f1\U000111f3-\U000118f1\U000118f3-\U00011c6a\U00011c6c-\U0001d370\U0001d372-\U0001ec81\U0001ec83-\U0001ed11\U0001ed13-\U0010ffff",
    "^900": "\x00-\U00010120\U00010122-\U000102fa\U000102fc-\U00010349\U0001034b-\U000109d9\U000109db-\U00010e79\U00010e7b-\U0001ec8a\U0001ec8c-\U0001ed1a\U0001ed1c-\U0010ffff",
    "^9000": "\x00-\U00010129\U0001012b-\U000109e2\U000109e4-\U0001ec93\U0001ec95-\U0001ed23\U0001ed25-\U0010ffff",
    "^90000": "\x00-\U00010132\U00010134-\U000109eb\U000109ed-\U0001ec9c\U0001ec9e-\U0001ed2c\U0001ed2e-\U0010ffff",
    "^900000": "\x00-\U000109f4\U000109f6-\U0010ffff",
    "^nan": "\x30-\x39\xb2-\xb3\xb9\xbc-\xbe\u0660-\u0669\u06f0-\u06f9\u07c0-\u07c9\u0966-\u096f\u09e6-\u09ef\u09f4-\u09f9\u0a66-\u0a6f\u0ae6-\u0aef\u0b66-\u0b6f\u0b72-\u0b77\u0be6-\u0bf2\u0c66-\u0c6f\u0c78-\u0c7e\u0ce6-\u0cef\u0d58-\u0d5e\u0d66-\u0d78\u0de6-\u0def\u0e50-\u0e59\u0ed0-\u0ed9\u0f20-\u0f33\u1040-\u1049\u1090-\u1099\u1369-\u137c\u16ee-\u16f0\u17e0-\u17e9\u17f0-\u17f9\u1810-\u1819\u1946-\u194f\u19d0-\u19da\u1a80-\u1a89\u1a90-\u1a99\u1b50-\u1b59\u1bb0-\u1bb9\u1c40-\u1c49\u1c50-\u1c59\u2070\u2074-\u2079\u2080-\u2089\u2150-\u2182\u2185-\u2189\u2460-\u249b\u24ea-\u24ff\u2776-\u2793\u2cfd\u3007\u3021-\u3029\u3038-\u303a\u3192-\u3195\u3220-\u3229\u3248-\u324f\u3251-\u325f\u3280-\u3289\u32b1-\u32bf\u3405\u3483\u382a\u3b4d\u4e00\u4e03\u4e07\u4e09\u4e5d\u4e8c\u4e94\u4e96\u4ebf-\u4ec0\u4edf\u4ee8\u4f0d\u4f70\u5104\u5146\u5169\u516b\u516d\u5341\u5343-\u5345\u534c\u53c1-\u53c4\u56db\u58f1\u58f9\u5e7a\u5efe-\u5eff\u5f0c-\u5f0e\u5f10\u62fe\u634c\u67d2\u6f06\u7396\u767e\u8086\u842c\u8cae\u8cb3\u8d30\u9621\u9646\u964c\u9678\u96f6\ua620-\ua629\ua6e6-\ua6ef\ua830-\ua835\ua8d0-\ua8d9\ua900-\ua909\ua9d0-\ua9d9\ua9f0-\ua9f9\uaa50-\uaa59\uabf0-\uabf9\uf96b\uf973\uf978\uf9b2\uf9d1\uf9d3\uf9fd\uff10-\uff19\U00010107-\U00010133\U00010140-\U00010178\U0001018a-\U0001018b\U000102e1-\U000102fb\U00010320-\U00010323\U00010341\U0001034a\U000103d1-\U000103d5\U000104a0-\U000104a9\U00010858-\U0001085f\U00010879-\U0001087f\U000108a7-\U000108af\U000108fb-\U000108ff\U00010916-\U0001091b\U000109bc-\U000109bd\U000109c0-\U000109cf\U000109d2-\U000109ff\U00010a40-\U00010a48\U00010a7d-\U00010a7e\U00010a9d-\U00010a9f\U00010aeb-\U00010aef\U00010b58-\U00010b5f\U00010b78-\U00010b7f\U00010ba9-\U00010baf\U00010cfa-\U00010cff\U00010d30-\U00010d39\U00010e60-\U00010e7e\U00010f1d-\U00010f26\U00010f51-\U00010f54\U00010fc5-\U00010fcb\U00011052-\U0001106f\U000110f0-\U000110f9\U00011136-\U0001113f\U000111d0-\U000111d9\U000111e1-\U000111f4\U000112f0-\U000112f9\U00011450-\U00011459\U000114d0-\U000114d9\U00011650-\U00011659\U000116c0-\U000116c9\U00011730-\U0001173b\U000118e0-\U000118f2\U00011950-\U00011959\U00011c50-\U00011c6c\U00011d50-\U00011d59\U00011da0-\U00011da9\U00011fc0-\U00011fd4\U00012400-\U0001246e\U00016a60-\U00016a69\U00016b50-\U00016b59\U00016b5b-\U00016b61\U00016e80-\U00016e96\U0001d2e0-\U0001d2f3\U0001d360-\U0001d378\U0001d7ce-\U0001d7ff\U0001e140-\U0001e149\U0001e2f0-\U0001e2f9\U0001e8c7-\U0001e8cf\U0001e950-\U0001e959\U0001ec71-\U0001ecab\U0001ecad-\U0001ecaf\U0001ecb1-\U0001ecb4\U0001ed01-\U0001ed2d\U0001ed2f-\U0001ed3d\U0001f100-\U0001f10c\U0001fbf0-\U0001fbf9\U00020001\U00020064\U000200e2\U00020121\U0002092a\U00020983\U0002098c\U0002099c\U00020aea\U00020afd\U00020b19\U00022390\U00022998\U00023b1b\U0002626d\U0002f890",
    "nan": "\x00-\x2f\x3a-\xb1\xb4-\xb8\xba-\xbb\xbf-\u065f\u066a-\u06ef\u06fa-\u07bf\u07ca-\u0965\u0970-\u09e5\u09f0-\u09f3\u09fa-\u0a65\u0a70-\u0ae5\u0af0-\u0b65\u0b70-\u0b71\u0b78-\u0be5\u0bf3-\u0c65\u0c70-\u0c77\u0c7f-\u0ce5\u0cf0-\u0d57\u0d5f-\u0d65\u0d79-\u0de5\u0df0-\u0e4f\u0e5a-\u0ecf\u0eda-\u0f1f\u0f34-\u103f\u104a-\u108f\u109a-\u1368\u137d-\u16ed\u16f1-\u17df\u17ea-\u17ef\u17fa-\u180f\u181a-\u1945\u1950-\u19cf\u19db-\u1a7f\u1a8a-\u1a8f\u1a9a-\u1b4f\u1b5a-\u1baf\u1bba-\u1c3f\u1c4a-\u1c4f\u1c5a-\u206f\u2071-\u2073\u207a-\u207f\u208a-\u214f\u2183-\u2184\u218a-\u245f\u249c-\u24e9\u2500-\u2775\u2794-\u2cfc\u2cfe-\u3006\u3008-\u3020\u302a-\u3037\u303b-\u3191\u3196-\u321f\u322a-\u3247\u3250\u3260-\u327f\u328a-\u32b0\u32c0-\u3404\u3406-\u3482\u3484-\u3829\u382b-\u3b4c\u3b4e-\u4dff\u4e01-\u4e02\u4e04-\u4e06\u4e08\u4e0a-\u4e5c\u4e5e-\u4e8b\u4e8d-\u4e93\u4e95\u4e97-\u4ebe\u4ec1-\u4ede\u4ee0-\u4ee7\u4ee9-\u4f0c\u4f0e-\u4f6f\u4f71-\u5103\u5105-\u5145\u5147-\u5168\u516a\u516c\u516e-\u5340\u5342\u5346-\u534b\u534d-\u53c0\u53c5-\u56da\u56dc-\u58f0\u58f2-\u58f8\u58fa-\u5e79\u5e7b-\u5efd\u5f00-\u5f0b\u5f0f\u5f11-\u62fd\u62ff-\u634b\u634d-\u67d1\u67d3-\u6f05\u6f07-\u7395\u7397-\u767d\u767f-\u8085\u8087-\u842b\u842d-\u8cad\u8caf-\u8cb2\u8cb4-\u8d2f\u8d31-\u9620\u9622-\u9645\u9647-\u964b\u964d-\u9677\u9679-\u96f5\u96f7-\ua61f\ua62a-\ua6e5\ua6f0-\ua82f\ua836-\ua8cf\ua8da-\ua8ff\ua90a-\ua9cf\ua9da-\ua9ef\ua9fa-\uaa4f\uaa5a-\uabef\uabfa-\uf96a\uf96c-\uf972\uf974-\uf977\uf979-\uf9b1\uf9b3-\uf9d0\uf9d2\uf9d4-\uf9fc\uf9fe-\uff0f\uff1a-\U00010106\U00010134-\U0001013f\U00010179-\U00010189\U0001018c-\U000102e0\U000102fc-\U0001031f\U00010324-\U00010340\U00010342-\U00010349\U0001034b-\U000103d0\U000103d6-\U0001049f\U000104aa-\U00010857\U00010860-\U00010878\U00010880-\U000108a6\U000108b0-\U000108fa\U00010900-\U00010915\U0001091c-\U000109bb\U000109be-\U000109bf\U000109d0-\U000109d1\U00010a00-\U00010a3f\U00010a49-\U00010a7c\U00010a7f-\U00010a9c\U00010aa0-\U00010aea\U00010af0-\U00010b57\U00010b60-\U00010b77\U00010b80-\U00010ba8\U00010bb0-\U00010cf9\U00010d00-\U00010d2f\U00010d3a-\U00010e5f\U00010e7f-\U00010f1c\U00010f27-\U00010f50\U00010f55-\U00010fc4\U00010fcc-\U00011051\U00011070-\U000110ef\U000110fa-\U00011135\U00011140-\U000111cf\U000111da-\U000111e0\U000111f5-\U000112ef\U000112fa-\U0001144f\U0001145a-\U000114cf\U000114da-\U0001164f\U0001165a-\U000116bf\U000116ca-\U0001172f\U0001173c-\U000118df\U000118f3-\U0001194f\U0001195a-\U00011c4f\U00011c6d-\U00011d4f\U00011d5a-\U00011d9f\U00011daa-\U00011fbf\U00011fd5-\U000123ff\U0001246f-\U00016a5f\U00016a6a-\U00016b4f\U00016b5a\U00016b62-\U00016e7f\U00016e97-\U0001d2df\U0001d2f4-\U0001d35f\U0001d379-\U0001d7cd\U0001d800-\U0001e13f\U0001e14a-\U0001e2ef\U0001e2fa-\U0001e8c6\U0001e8d0-\U0001e94f\U0001e95a-\U0001ec70\U0001ecac\U0001ecb0\U0001ecb5-\U0001ed00\U0001ed2e\U0001ed3e-\U0001f0ff\U0001f10d-\U0001fbef\U0001fbfa-\U00020000\U00020002-\U00020063\U00020065-\U000200e1\U000200e3-\U00020120\U00020122-\U00020929\U0002092b-\U00020982\U00020984-\U0002098b\U0002098d-\U0002099b\U0002099d-\U00020ae9\U00020aeb-\U00020afc\U00020afe-\U00020b18\U00020b1a-\U0002238f\U00022391-\U00022997\U00022999-\U00023b1a\U00023b1c-\U0002626c\U0002626e-\U0002f88f\U0002f891-\U0010ffff"
}
ascii_numeric_values: Dict[str, str] = {
    "0": "\x30",
    "1": "\x31",
    "1/10": "",
    "1/12": "",
    "1/16": "",
    "1/160": "",
    "1/2": "",
    "1/20": "",
    "1/3": "",
    "1/32": "",
    "1/320": "",
    "1/4": "",
    "1/40": "",
    "1/5": "",
    "1/6": "",
    "1/64": "",
    "1/7": "",
    "1/8": "",
    "1/80": "",
    "1/9": "",
    "10": "",
    "100": "",
    "1000": "",
    "10000": "",
    "100000": "",
    "1000000": "",
    "10000000": "",
    "100000000": "",
    "10000000000": "",
    "1000000000000": "",
    "11": "",
    "11/12": "",
    "11/2": "",
    "12": "",
    "13": "",
    "13/2": "",
    "14": "",
    "15": "",
    "15/2": "",
    "16": "",
    "17": "",
    "17/2": "",
    "18": "",
    "19": "",
    "2": "\x32",
    "2/3": "",
    "2/5": "",
    "20": "",
    "200": "",
    "2000": "",
    "20000": "",
    "200000": "",
    "20000000": "",
    "21": "",
    "216000": "",
    "22": "",
    "23": "",
    "24": "",
    "25": "",
    "26": "",
    "27": "",
    "28": "",
    "29": "",
    "3": "\x33",
    "3/16": "",
    "3/2": "",
    "3/20": "",
    "3/4": "",
    "3/5": "",
    "3/64": "",
    "3/8": "",
    "3/80": "",
    "30": "",
    "300": "",
    "3000": "",
    "30000": "",
    "300000": "",
    "31": "",
    "32": "",
    "33": "",
    "34": "",
    "35": "",
    "36": "",
    "37": "",
    "38": "",
    "39": "",
    "4": "\x34",
    "4/5": "",
    "40": "",
    "400": "",
    "4000": "",
    "40000": "",
    "400000": "",
    "41": "",
    "42": "",
    "43": "",
    "432000": "",
    "44": "",
    "45": "",
    "46": "",
    "47": "",
    "48": "",
    "49": "",
    "5": "\x35",
    "5/12": "",
    "5/2": "",
    "5/6": "",
    "5/8": "",
    "50": "",
    "500": "",
    "5000": "",
    "50000": "",
    "500000": "",
    "6": "\x36",
    "60": "",
    "600": "",
    "6000": "",
    "60000": "",
    "600000": "",
    "7": "\x37",
    "7/12": "",
    "7/2": "",
    "7/8": "",
    "70": "",
    "700": "",
    "7000": "",
    "70000": "",
    "700000": "",
    "8": "\x38",
    "80": "",
    "800": "",
    "8000": "",
    "80000": "",
    "800000": "",
    "9": "\x39",
    "9/2": "",
    "90": "",
    "900": "",
    "9000": "",
    "90000": "",
    "900000": "",
    "^0": "\x00-\x2f\x31-\U0010ffff",
    "^1": "\x00-\x30\x32-\U0010ffff",
    "^1/10": "\x00-\U0010ffff",
    "^1/12": "\x00-\U0010ffff",
    "^1/16": "\x00-\U0010ffff",
    "^1/160": "\x00-\U0010ffff",
    "^1/2": "\x00-\U0010ffff",
    "^1/20": "\x00-\U0010ffff",
    "^1/3": "\x00-\U0010ffff",
    "^1/32": "\x00-\U0010ffff",
    "^1/320": "\x00-\U0010ffff",
    "^1/4": "\x00-\U0010ffff",
    "^1/40": "\x00-\U0010ffff",
    "^1/5": "\x00-\U0010ffff",
    "^1/6": "\x00-\U0010ffff",
    "^1/64": "\x00-\U0010ffff",
    "^1/7": "\x00-\U0010ffff",
    "^1/8": "\x00-\U0010ffff",
    "^1/80": "\x00-\U0010ffff",
    "^1/9": "\x00-\U0010ffff",
    "^10": "\x00-\U0010ffff",
    "^100": "\x00-\U0010ffff",
    "^1000": "\x00-\U0010ffff",
    "^10000": "\x00-\U0010ffff",
    "^100000": "\x00-\U0010ffff",
    "^1000000": "\x00-\U0010ffff",
    "^10000000": "\x00-\U0010ffff",
    "^100000000": "\x00-\U0010ffff",
    "^10000000000": "\x00-\U0010ffff",
    "^1000000000000": "\x00-\U0010ffff",
    "^11": "\x00-\U0010ffff",
    "^11/12": "\x00-\U0010ffff",
    "^11/2": "\x00-\U0010ffff",
    "^12": "\x00-\U0010ffff",
    "^13": "\x00-\U0010ffff",
    "^13/2": "\x00-\U0010ffff",
    "^14": "\x00-\U0010ffff",
    "^15": "\x00-\U0010ffff",
    "^15/2": "\x00-\U0010ffff",
    "^16": "\x00-\U0010ffff",
    "^17": "\x00-\U0010ffff",
    "^17/2": "\x00-\U0010ffff",
    "^18": "\x00-\U0010ffff",
    "^19": "\x00-\U0010ffff",
    "^2": "\x00-\x31\x33-\U0010ffff",
    "^2/3": "\x00-\U0010ffff",
    "^2/5": "\x00-\U0010ffff",
    "^20": "\x00-\U0010ffff",
    "^200": "\x00-\U0010ffff",
    "^2000": "\x00-\U0010ffff",
    "^20000": "\x00-\U0010ffff",
    "^200000": "\x00-\U0010ffff",
    "^20000000": "\x00-\U0010ffff",
    "^21": "\x00-\U0010ffff",
    "^216000": "\x00-\U0010ffff",
    "^22": "\x00-\U0010ffff",
    "^23": "\x00-\U0010ffff",
    "^24": "\x00-\U0010ffff",
    "^25": "\x00-\U0010ffff",
    "^26": "\x00-\U0010ffff",
    "^27": "\x00-\U0010ffff",
    "^28": "\x00-\U0010ffff",
    "^29": "\x00-\U0010ffff",
    "^3": "\x00-\x32\x34-\U0010ffff",
    "^3/16": "\x00-\U0010ffff",
    "^3/2": "\x00-\U0010ffff",
    "^3/20": "\x00-\U0010ffff",
    "^3/4": "\x00-\U0010ffff",
    "^3/5": "\x00-\U0010ffff",
    "^3/64": "\x00-\U0010ffff",
    "^3/8": "\x00-\U0010ffff",
    "^3/80": "\x00-\U0010ffff",
    "^30": "\x00-\U0010ffff",
    "^300": "\x00-\U0010ffff",
    "^3000": "\x00-\U0010ffff",
    "^30000": "\x00-\U0010ffff",
    "^300000": "\x00-\U0010ffff",
    "^31": "\x00-\U0010ffff",
    "^32": "\x00-\U0010ffff",
    "^33": "\x00-\U0010ffff",
    "^34": "\x00-\U0010ffff",
    "^35": "\x00-\U0010ffff",
    "^36": "\x00-\U0010ffff",
    "^37": "\x00-\U0010ffff",
    "^38": "\x00-\U0010ffff",
    "^39": "\x00-\U0010ffff",
    "^4": "\x00-\x33\x35-\U0010ffff",
    "^4/5": "\x00-\U0010ffff",
    "^40": "\x00-\U0010ffff",
    "^400": "\x00-\U0010ffff",
    "^4000": "\x00-\U0010ffff",
    "^40000": "\x00-\U0010ffff",
    "^400000": "\x00-\U0010ffff",
    "^41": "\x00-\U0010ffff",
    "^42": "\x00-\U0010ffff",
    "^43": "\x00-\U0010ffff",
    "^432000": "\x00-\U0010ffff",
    "^44": "\x00-\U0010ffff",
    "^45": "\x00-\U0010ffff",
    "^46": "\x00-\U0010ffff",
    "^47": "\x00-\U0010ffff",
    "^48": "\x00-\U0010ffff",
    "^49": "\x00-\U0010ffff",
    "^5": "\x00-\x34\x36-\U0010ffff",
    "^5/12": "\x00-\U0010ffff",
    "^5/2": "\x00-\U0010ffff",
    "^5/6": "\x00-\U0010ffff",
    "^5/8": "\x00-\U0010ffff",
    "^50": "\x00-\U0010ffff",
    "^500": "\x00-\U0010ffff",
    "^5000": "\x00-\U0010ffff",
    "^50000": "\x00-\U0010ffff",
    "^500000": "\x00-\U0010ffff",
    "^6": "\x00-\x35\x37-\U0010ffff",
    "^60": "\x00-\U0010ffff",
    "^600": "\x00-\U0010ffff",
    "^6000": "\x00-\U0010ffff",
    "^60000": "\x00-\U0010ffff",
    "^600000": "\x00-\U0010ffff",
    "^7": "\x00-\x36\x38-\U0010ffff",
    "^7/12": "\x00-\U0010ffff",
    "^7/2": "\x00-\U0010ffff",
    "^7/8": "\x00-\U0010ffff",
    "^70": "\x00-\U0010ffff",
    "^700": "\x00-\U0010ffff",
    "^7000": "\x00-\U0010ffff",
    "^70000": "\x00-\U0010ffff",
    "^700000": "\x00-\U0010ffff",
    "^8": "\x00-\x37\x39-\U0010ffff",
    "^80": "\x00-\U0010ffff",
    "^800": "\x00-\U0010ffff",
    "^8000": "\x00-\U0010ffff",
    "^80000": "\x00-\U0010ffff",
    "^800000": "\x00-\U0010ffff",
    "^9": "\x00-\x38\x3a-\U0010ffff",
    "^9/2": "\x00-\U0010ffff",
    "^90": "\x00-\U0010ffff",
    "^900": "\x00-\U0010ffff",
    "^9000": "\x00-\U0010ffff",
    "^90000": "\x00-\U0010ffff",
    "^900000": "\x00-\U0010ffff",
    "^nan": "\x30-\x39",
    "nan": "\x00-\x2f\x3a-\U0010ffff"
}
