# 🎯 suggest参数使用指南

## 📋 概述

`suggest` 参数是 `collect_feedback` 工具的一个重要功能，允许AI提供预设的建议选项，用户可以快速选择而无需手动输入。

## 🔧 参数格式

### 基本语法

```python
collect_feedback(
    work_summary="工作汇报内容",
    suggest=["选项1", "选项2", "选项3"]  # 数组格式
)
```

**参数说明**:
- **类型**: 字符串数组 `["选项1", "选项2"]`
- **默认值**: 无建议选项
- **支持**: 中英文混合内容

## 💡 使用示例

### 基础用法

```python
# 简单的建议选项
collect_feedback(
    work_summary="任务完成，请提供反馈",
    suggest=["满意", "需要改进", "有问题"]
)
```

### 详细建议选项

```python
# 更具体的建议选项
collect_feedback(
    work_summary="代码重构完成",
    suggest=[
        "代码质量很好，可以合并",
        "需要添加更多注释",
        "建议优化性能",
        "需要补充测试用例",
        "整体满意，小幅调整即可"
    ]
)
```

### 多语言支持

```python
# 支持中英文混合
collect_feedback(
    work_summary="Feature development completed",
    suggest=[
        "Perfect! Ready to deploy",
        "需要小幅调整",
        "Good but needs testing",
        "建议增加文档说明"
    ]
)
```

## 🌐 前端界面效果

### 建议选项显示

当提供 `suggest` 参数时，前端界面会显示：

```
💡 建议选项（点击直接提交或复制到输入框）：

┌─────────────────────────────────────┐
│ 满意                          📋 ✅ │
├─────────────────────────────────────┤
│ 需要改进                      📋 ✅ │
├─────────────────────────────────────┤
│ 有问题                        📋 ✅ │
└─────────────────────────────────────┘
```

### 交互功能

- **📋 复制按钮**: 将建议复制到文本输入框
- **✅ 提交按钮**: 直接提交该建议作为反馈
- **🖱️ 点击文本**: 直接提交该建议

## ✅ 验证测试

### 测试用例

```python
# 测试suggest参数功能
result = collect_feedback(
    work_summary="测试suggest参数功能",
    suggest=["功能正常", "有问题", "需要优化"]
)
```

### 预期结果

- ✅ 建议选项正确显示在界面上
- ✅ 用户可以点击选项快速提交
- ✅ 用户可以复制选项到输入框编辑
- ✅ 支持中文字符正常显示

### 实际验证

通过实际测试确认：
- **用户反馈**: "功能正常，建议选项显示正确"
- **技术验证**: 数据流从MCP → 服务器 → 前端完全正确
- **类型安全**: 全程使用数组类型，无不必要转换
- **界面功能**: 建议选项正确显示，复制和提交功能正常

## 🔍 故障排除

### 常见问题

1. **建议选项不显示**
   - 确认 `suggest` 参数格式正确：`["选项1", "选项2"]`
   - 检查列表不为空

2. **中文字符显示异常**
   - 确认使用UTF-8编码
   - 重启浏览器重新加载

3. **点击无响应**
   - 刷新页面重试
   - 检查网络连接

## 📋 最佳实践

### 建议选项设计

1. **简洁明确**: 每个选项应该简洁明了
2. **覆盖全面**: 涵盖常见的反馈类型
3. **数量适中**: 建议3-6个选项，避免过多
4. **语言一致**: 保持选项语言风格一致

### 示例模板

```python
# 代码审查场景
suggest=[
    "代码质量优秀，可以合并",
    "需要小幅修改后合并", 
    "建议重构部分代码",
    "需要补充测试用例"
]

# 功能测试场景
suggest=[
    "功能完全正常",
    "有小问题需要修复",
    "需要优化用户体验", 
    "建议增加新功能"
]

# 文档审查场景
suggest=[
    "文档清晰完整",
    "需要补充示例",
    "建议优化结构",
    "需要更新过时信息"
]
```

---

**🎯 suggest参数为用户提供了快速反馈的便捷方式，提升了交互效率和用户体验！** 