# 反馈收集工具用户手册

## 1. 引言

欢迎使用反馈收集工具！本工具旨在帮助您轻松、高效地向我们提供关于 AI 助手工作表现的反馈。您的宝贵意见将直接帮助我们改进 AI 的能力和服务质量。

本手册将引导您了解工具的主要功能以及如何使用它们。

## 2. 快速上手与界面概览

当您打开反馈工具时，会看到一个清晰简洁的界面，主要分为两个区域：AI 工作汇报区和您的反馈区。

`[此处需要一张反馈主界面的截图，突出显示以下主要区域：顶部的 AI 工作汇报区，底部的反馈输入区，超时信息和进度条，以及提交和取消按钮。]`

**界面主要组成部分说明:**

*   **AI 工作汇报区 (通常在界面上半部分):**
    *   **AI 工作完成汇报 (`📋 AI工作完成汇报`):** 这个区域会展示 AI 助手当前完成的工作内容或汇报。
    *   **超时信息与进度条 (`timeoutInfo`, `timeoutProgressBar`):**
        *   **超时消息 (`timeoutMessage`):** 显示例如“此窗口将在 X分X秒 后自动提交”或“时间已到，正在提交...”或“已暂停 (用户活动中)”等信息。
        *   **倒计时 (`timeoutCountdown`):** 实时显示剩余的超时时间。
        *   **进度条 (`timeoutProgressBar`):** 可视化展示剩余时间的进度。
    *   **设置新超时 (`customTimeoutInput`, `applyCustomTimeoutBtn`):** 您可以在此输入框中设置新的超时时长（秒），然后点击“应用”按钮使其生效。
    *   **调整汇报区域大小 (`toggleReportBtn`):** 点击“↔️ 调整”按钮可以调整 AI 工作汇报区域的大小。
*   **您的反馈区 (通常在界面下半部分，包含在一个表单内):**
    *   **反馈输入标题 (`💬 您的反馈（文字+图片，可选）`):** 标识这是您输入反馈的地方。
    *   **展开/收起反馈区域 (`toggleFeedbackBtn`):** 点击“📏 展开/收起”按钮可以展开或折叠反馈输入区域。
    *   **建议选项 (`suggestOptions`, `suggestList`):** (如果出现) 这里会列出一些建议的反馈选项，您可以点击直接采纳或复制。
    *   **图片预览区 (`imagePreview`):** 当您上传图片后，图片的缩略图会显示在这里。
    *   **文本输入框 (`textFeedback`):** 这是您输入文字反馈的主要区域。您可以直接输入文字，或者按 `Ctrl+V` 粘贴图片。
    *   **操作按钮组:**
        *   **图片按钮 (`uploadBtn` - 🖼️ 图片):** 点击此按钮可以选择本地图片文件进行上传。
        *   **取消按钮 (`❌ 取消`):** 点击此按钮将关闭反馈窗口，您未提交的反馈内容可能会丢失（除非系统有本地备份机制）。
        *   **提交反馈按钮 (`submitBtn` - ✅ 提交反馈):** 当您完成反馈后，点击此按钮提交您的反馈。

## 3. 核心功能使用指南

### 3.1 提交文本反馈

1.  在界面下方的“您的反馈区”找到 **文本输入框** (标有“请在此输入您的反馈、建议或问题...”)。
2.  直接在输入框内点击，然后输入您想要表达的文字内容。
3.  您可以随时编辑您输入的内容。

### 3.2 上传图片

您可以通过以下两种方式上传图片：

*   **通过按钮上传:**
    1.  点击文本输入框下方的 **图片按钮** (图标为 🖼️，文字提示“图片”)。
    2.  系统会弹出文件选择对话框。
    3.  在对话框中选择您想要上传的一张或多张图片文件。
    4.  确认选择后，图片会开始上传，并在 **图片预览区** 显示缩略图。
*   **通过粘贴上传:**
    1.  复制您想要上传的图片 (例如，使用截图工具截屏后会自动复制到剪贴板，或者在图片文件上右键选择“复制”)。
    2.  在反馈工具的 **文本输入框** 内，按下键盘上的 `Ctrl+V` (Windows) 或 `Cmd+V` (Mac) 组合键。
    3.  图片会自动上传并在 **图片预览区** 显示。
*   **通过拖拽上传:**
    1.  从您的电脑文件夹中，用鼠标拖动一张或多张图片文件。
    2.  将图片拖拽到 **文本输入框** 区域。
    3.  松开鼠标，图片会自动上传并在 **图片预览区** 显示。

**图片限制:**
*   请注意，系统可能对上传的图片文件大小和格式有所限制。常见的支持格式包括 `PNG`, `JPG`, `JPEG`, `GIF`, `BMP`, `WEBP`。如果上传失败，请尝试使用较小的图片或常见格式的图片。
*   `[此处需要一张图片上传成功后，图片预览区显示缩略图的截图，并高亮图片按钮和预览区。]`

### 3.3 理解超时机制

为了确保反馈的及时性，反馈窗口设有一个超时倒计时。

*   **倒计时显示:** 您可以在界面顶部的 **超时信息**区域看到剩余时间 (`timeoutCountdown`) 和一个动态变化的 **进度条** (`timeoutProgressBar`)。
*   **用户活动的影响:**
    *   当您在反馈窗口进行操作时，例如在文本框中打字、移动鼠标等，**倒计时通常会自动暂停**。此时，超时消息可能会显示为“已暂停 (用户活动中)”。
    *   如果您长时间没有进行任何操作，**暂停的倒计时会自动恢复**。
*   **自定义超时:** 您可以通过界面上“设置新超时”输入框和“应用”按钮来调整默认的超时时长。最短可设置的时间通常为30秒。
*   **超时发生时:** 当倒计时结束，如果您还未手动提交反馈，系统通常会尝试**自动捕获您当前已输入的内容（包括文字和已选择的图片）并进行提交**。此时，超时消息会提示“时间已到，正在提交...”，提交按钮可能会变为不可用状态并显示“已超时”。

### 3.4 提交操作

1.  当您完成了文本输入和图片上传（如果需要）后，请检查您的反馈内容。
2.  点击界面右下角的 **提交反馈按钮** (图标为 ✅)。
3.  提交成功后，通常会看到成功的提示信息，例如“反馈提交成功！”。

## 4. 超时后的情况

如“理解超时机制”中所述，如果因为超时导致窗口自动处理：

*   **数据自动提交:** 系统会尽力自动收集您在文本框中输入的内容以及已经添加到预览区的图片，并尝试将这些数据提交。
*   **本地备份 (可能存在):** 在某些情况下，如果自动提交因网络等原因失败，系统可能会尝试将您的反馈数据备份在您的本地浏览器中。当您下次打开反馈工具或网络恢复时，可能会提示您恢复之前未成功提交的内容。具体行为取决于系统的实现。
    *   `[如果系统明确支持本地备份且有对应UI提示，此处可补充描述或标记截图位置。例如：如果网络断开，可能会出现“网络连接错误，数据已本地备份”的提示。]`

## 5. 通知与提示信息

在使用过程中，您可能会在界面上看到不同类型的通知信息，帮助您了解当前的状态或操作结果。这些通知通常会显示在屏幕的右上角，并会在几秒钟后自动消失。

常见的通知类型及其含义：

*   **成功提示 (通常带有 ✅ 图标):**
    *   例如：“反馈提交成功！感谢您的反馈。” - 表示您的反馈已成功发送到服务器。
    *   例如：“图片上传成功。”
*   **警告提示 (通常带有 ⚠️ 图标):**
    *   例如：“图片文件过大，请选择小于 X MB的图片。” - 提示您上传的图片超出了大小限制。
    *   例如：“超时时间已更新为 XX 秒。”
*   **错误提示 (通常带有 ❌ 图标):**
    *   例如：“反馈提交失败: 网络连接错误。” - 表示由于网络问题，反馈未能成功发送。
    *   例如：“图片上传失败，请重试。”
    *   例如：“CSRF token missing or invalid” - 这是一个安全相关的错误，通常刷新页面可以解决。
*   **超时相关提示 (显示在超时信息区域):**
    *   “此窗口将在 X分X秒 后自动提交” - 正常的倒计时提示。
    *   “已暂停 (用户活动中)” - 当您正在操作时，倒计时暂停。
    *   “已暂停 (因不活动)” - 如果倒计时曾因用户活动暂停，之后又因长时间无活动而恢复前，可能会短暂显示。
    *   “时间已到，正在提交...” - 超时发生，系统正在尝试自动提交。
    *   “已完成” - 反馈成功提交后，倒计时停止。
    *   “已超时” - 超时后，提交按钮可能会显示此状态。

`[此处可考虑一张通用通知样式的截图，例如一个成功或错误通知条的样式。]`

## 6. 常见问题解答 (FAQ)

*   **问：如果我不小心关闭了反馈窗口，我输入的内容会丢失吗？**
    *   答：这取决于系统的具体实现。如果系统支持本地备份功能，并且在您关闭前数据已被自动或手动保存到本地，那么下次打开时可能可以恢复。但最保险的做法是在关闭前完成提交。如果是因为超时自动提交，那么数据通常已经被发送了。

*   **问：我可以上传多大的图片？支持哪些图片格式？**
    *   答：通常系统会对图片大小有限制（例如，单个文件不超过16MB，总体积不超过50MB）。支持的常见图片格式包括 PNG, JPG, JPEG, GIF, BMP, WEBP。如果遇到上传问题，请尝试压缩图片或使用标准格式。具体的限制请留意界面上可能出现的提示信息。

*   **问：如果我长时间不操作，会怎么样？**
    *   答：如果您长时间不进行任何操作（如打字、鼠标移动），之前因您的活动而暂停的超时倒计时会自动恢复。当倒计时结束后，系统会尝试自动提交您已输入的内容。

*   **问：我可以修改超时时间吗？**
    *   答：是的，在界面上通常会有一个“设置新超时”的输入框，您可以输入希望的秒数（通常有最小值限制，如30秒），然后点击“应用”按钮来更新当前的超时设置。

*   **问：为什么倒计时有时候会暂停？**
    *   答：为了方便您输入反馈，当您在反馈窗口进行打字、移动鼠标等操作时，倒计时会自动暂停。当您停止操作一段时间后，倒计时会自动恢复。

*   **问：提交反馈后，窗口会自动关闭吗？**
    *   答：这取决于系统的设计。通常在成功提交反馈后，窗口可能会保持打开状态，让您看到成功提示，或者也可能自动关闭。您可以留意提交成功后的界面变化或提示。

---
*文档版本: 1.0*
*最后更新日期: {{CURRENT_DATE}}*