# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""`OpenQL` is a C++/Python framework for high-level quantum programming. The framework provides a compiler for compiling and optimizing quantum code. The compiler produces the intermediate quantum assembly language in cQASM (Common QASM) and the compiled eQASM (executable QASM) for various target platforms. While the eQASM is platform-specific, the quantum assembly code (QASM) is hardware-agnostic and can be simulated on the QX simulator."""

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _openql
else:
    import _openql

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _openql.delete_SwigPyIterator

    def value(self):
        return _openql.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _openql.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _openql.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _openql.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _openql.SwigPyIterator_equal(self, x)

    def copy(self):
        return _openql.SwigPyIterator_copy(self)

    def next(self):
        return _openql.SwigPyIterator_next(self)

    def __next__(self):
        return _openql.SwigPyIterator___next__(self)

    def previous(self):
        return _openql.SwigPyIterator_previous(self)

    def advance(self, n):
        return _openql.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _openql.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _openql.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _openql.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _openql.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _openql.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _openql.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _openql:
_openql.SwigPyIterator_swigregister(SwigPyIterator)

class vectori(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectori_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectori___nonzero__(self)

    def __bool__(self):
        return _openql.vectori___bool__(self)

    def __len__(self):
        return _openql.vectori___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectori___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectori___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectori___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectori___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectori___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectori___setitem__(self, *args)

    def pop(self):
        return _openql.vectori_pop(self)

    def append(self, x):
        return _openql.vectori_append(self, x)

    def empty(self):
        return _openql.vectori_empty(self)

    def size(self):
        return _openql.vectori_size(self)

    def swap(self, v):
        return _openql.vectori_swap(self, v)

    def begin(self):
        return _openql.vectori_begin(self)

    def end(self):
        return _openql.vectori_end(self)

    def rbegin(self):
        return _openql.vectori_rbegin(self)

    def rend(self):
        return _openql.vectori_rend(self)

    def clear(self):
        return _openql.vectori_clear(self)

    def get_allocator(self):
        return _openql.vectori_get_allocator(self)

    def pop_back(self):
        return _openql.vectori_pop_back(self)

    def erase(self, *args):
        return _openql.vectori_erase(self, *args)

    def __init__(self, *args):
        _openql.vectori_swiginit(self, _openql.new_vectori(*args))

    def push_back(self, x):
        return _openql.vectori_push_back(self, x)

    def front(self):
        return _openql.vectori_front(self)

    def back(self):
        return _openql.vectori_back(self)

    def assign(self, n, x):
        return _openql.vectori_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectori_resize(self, *args)

    def insert(self, *args):
        return _openql.vectori_insert(self, *args)

    def reserve(self, n):
        return _openql.vectori_reserve(self, n)

    def capacity(self):
        return _openql.vectori_capacity(self)
    __swig_destroy__ = _openql.delete_vectori

# Register vectori in _openql:
_openql.vectori_swigregister(vectori)

class vectorui(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectorui_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectorui___nonzero__(self)

    def __bool__(self):
        return _openql.vectorui___bool__(self)

    def __len__(self):
        return _openql.vectorui___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectorui___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectorui___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectorui___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectorui___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectorui___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectorui___setitem__(self, *args)

    def pop(self):
        return _openql.vectorui_pop(self)

    def append(self, x):
        return _openql.vectorui_append(self, x)

    def empty(self):
        return _openql.vectorui_empty(self)

    def size(self):
        return _openql.vectorui_size(self)

    def swap(self, v):
        return _openql.vectorui_swap(self, v)

    def begin(self):
        return _openql.vectorui_begin(self)

    def end(self):
        return _openql.vectorui_end(self)

    def rbegin(self):
        return _openql.vectorui_rbegin(self)

    def rend(self):
        return _openql.vectorui_rend(self)

    def clear(self):
        return _openql.vectorui_clear(self)

    def get_allocator(self):
        return _openql.vectorui_get_allocator(self)

    def pop_back(self):
        return _openql.vectorui_pop_back(self)

    def erase(self, *args):
        return _openql.vectorui_erase(self, *args)

    def __init__(self, *args):
        _openql.vectorui_swiginit(self, _openql.new_vectorui(*args))

    def push_back(self, x):
        return _openql.vectorui_push_back(self, x)

    def front(self):
        return _openql.vectorui_front(self)

    def back(self):
        return _openql.vectorui_back(self)

    def assign(self, n, x):
        return _openql.vectorui_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectorui_resize(self, *args)

    def insert(self, *args):
        return _openql.vectorui_insert(self, *args)

    def reserve(self, n):
        return _openql.vectorui_reserve(self, n)

    def capacity(self):
        return _openql.vectorui_capacity(self)
    __swig_destroy__ = _openql.delete_vectorui

# Register vectorui in _openql:
_openql.vectorui_swigregister(vectorui)

class vectorf(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectorf_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectorf___nonzero__(self)

    def __bool__(self):
        return _openql.vectorf___bool__(self)

    def __len__(self):
        return _openql.vectorf___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectorf___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectorf___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectorf___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectorf___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectorf___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectorf___setitem__(self, *args)

    def pop(self):
        return _openql.vectorf_pop(self)

    def append(self, x):
        return _openql.vectorf_append(self, x)

    def empty(self):
        return _openql.vectorf_empty(self)

    def size(self):
        return _openql.vectorf_size(self)

    def swap(self, v):
        return _openql.vectorf_swap(self, v)

    def begin(self):
        return _openql.vectorf_begin(self)

    def end(self):
        return _openql.vectorf_end(self)

    def rbegin(self):
        return _openql.vectorf_rbegin(self)

    def rend(self):
        return _openql.vectorf_rend(self)

    def clear(self):
        return _openql.vectorf_clear(self)

    def get_allocator(self):
        return _openql.vectorf_get_allocator(self)

    def pop_back(self):
        return _openql.vectorf_pop_back(self)

    def erase(self, *args):
        return _openql.vectorf_erase(self, *args)

    def __init__(self, *args):
        _openql.vectorf_swiginit(self, _openql.new_vectorf(*args))

    def push_back(self, x):
        return _openql.vectorf_push_back(self, x)

    def front(self):
        return _openql.vectorf_front(self)

    def back(self):
        return _openql.vectorf_back(self)

    def assign(self, n, x):
        return _openql.vectorf_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectorf_resize(self, *args)

    def insert(self, *args):
        return _openql.vectorf_insert(self, *args)

    def reserve(self, n):
        return _openql.vectorf_reserve(self, n)

    def capacity(self):
        return _openql.vectorf_capacity(self)
    __swig_destroy__ = _openql.delete_vectorf

# Register vectorf in _openql:
_openql.vectorf_swigregister(vectorf)

class vectord(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectord_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectord___nonzero__(self)

    def __bool__(self):
        return _openql.vectord___bool__(self)

    def __len__(self):
        return _openql.vectord___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectord___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectord___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectord___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectord___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectord___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectord___setitem__(self, *args)

    def pop(self):
        return _openql.vectord_pop(self)

    def append(self, x):
        return _openql.vectord_append(self, x)

    def empty(self):
        return _openql.vectord_empty(self)

    def size(self):
        return _openql.vectord_size(self)

    def swap(self, v):
        return _openql.vectord_swap(self, v)

    def begin(self):
        return _openql.vectord_begin(self)

    def end(self):
        return _openql.vectord_end(self)

    def rbegin(self):
        return _openql.vectord_rbegin(self)

    def rend(self):
        return _openql.vectord_rend(self)

    def clear(self):
        return _openql.vectord_clear(self)

    def get_allocator(self):
        return _openql.vectord_get_allocator(self)

    def pop_back(self):
        return _openql.vectord_pop_back(self)

    def erase(self, *args):
        return _openql.vectord_erase(self, *args)

    def __init__(self, *args):
        _openql.vectord_swiginit(self, _openql.new_vectord(*args))

    def push_back(self, x):
        return _openql.vectord_push_back(self, x)

    def front(self):
        return _openql.vectord_front(self)

    def back(self):
        return _openql.vectord_back(self)

    def assign(self, n, x):
        return _openql.vectord_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectord_resize(self, *args)

    def insert(self, *args):
        return _openql.vectord_insert(self, *args)

    def reserve(self, n):
        return _openql.vectord_reserve(self, n)

    def capacity(self):
        return _openql.vectord_capacity(self)
    __swig_destroy__ = _openql.delete_vectord

# Register vectord in _openql:
_openql.vectord_swigregister(vectord)

class vectorc(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _openql.vectorc_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _openql.vectorc___nonzero__(self)

    def __bool__(self):
        return _openql.vectorc___bool__(self)

    def __len__(self):
        return _openql.vectorc___len__(self)

    def __getslice__(self, i, j):
        return _openql.vectorc___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _openql.vectorc___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _openql.vectorc___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _openql.vectorc___delitem__(self, *args)

    def __getitem__(self, *args):
        return _openql.vectorc___getitem__(self, *args)

    def __setitem__(self, *args):
        return _openql.vectorc___setitem__(self, *args)

    def pop(self):
        return _openql.vectorc_pop(self)

    def append(self, x):
        return _openql.vectorc_append(self, x)

    def empty(self):
        return _openql.vectorc_empty(self)

    def size(self):
        return _openql.vectorc_size(self)

    def swap(self, v):
        return _openql.vectorc_swap(self, v)

    def begin(self):
        return _openql.vectorc_begin(self)

    def end(self):
        return _openql.vectorc_end(self)

    def rbegin(self):
        return _openql.vectorc_rbegin(self)

    def rend(self):
        return _openql.vectorc_rend(self)

    def clear(self):
        return _openql.vectorc_clear(self)

    def get_allocator(self):
        return _openql.vectorc_get_allocator(self)

    def pop_back(self):
        return _openql.vectorc_pop_back(self)

    def erase(self, *args):
        return _openql.vectorc_erase(self, *args)

    def __init__(self, *args):
        _openql.vectorc_swiginit(self, _openql.new_vectorc(*args))

    def push_back(self, x):
        return _openql.vectorc_push_back(self, x)

    def front(self):
        return _openql.vectorc_front(self)

    def back(self):
        return _openql.vectorc_back(self)

    def assign(self, n, x):
        return _openql.vectorc_assign(self, n, x)

    def resize(self, *args):
        return _openql.vectorc_resize(self, *args)

    def insert(self, *args):
        return _openql.vectorc_insert(self, *args)

    def reserve(self, n):
        return _openql.vectorc_reserve(self, n)

    def capacity(self):
        return _openql.vectorc_capacity(self)
    __swig_destroy__ = _openql.delete_vectorc

# Register vectorc in _openql:
_openql.vectorc_swigregister(vectorc)


def get_version():
    r"""
     Returns OpenQL version

    Parameters
    ----------
    None

    Returns
    -------
    str
        version number as a string

    """
    return _openql.get_version()

def set_option(option_name, option_value):
    r"""
     Sets any of the following OpenQL options:

    ===================  ============= ==================================================
    Opt. Name               Defaults                       Possible values
    ===================  ============= ==================================================
    log_level             LOG_NOTHING   LOG_{NOTHING/CRITICAL/ERROR/WARNING/INFO/DEBUG}
    output_dir            test_output   <output directory>
    optimize              no            yes/no
    use_default_gates     yes           yes/no
    decompose_toffoli     no            yes/no
    scheduler             ASAP          ASAP/ALAP
    scheduler_uniform     no            yes/no
    scheduler_commute     no            yes/no
    scheduler_post179     yes           yes/no
    cz_mode               manual        auto/manual
    ===================  ============= ==================================================


    Parameters
    ----------
    arg1 : str
        Option name
    arg2 : str
        Option value

    """
    return _openql.set_option(option_name, option_value)

def get_option(option_name):
    r"""
     Returns value of any of the following OpenQL options:

    ===================  ============= ==================================================
    Opt. Name               Defaults                       Possible values
    ===================  ============= ==================================================
    log_level             LOG_NOTHING   LOG_{NOTHING/CRITICAL/ERROR/WARNING/INFO/DEBUG}
    output_dir            test_output   <output directory>
    optimize              no            yes/no
    use_default_gates     yes           yes/no
    decompose_toffoli     no            yes/no
    scheduler             ASAP          ASAP/ALAP
    scheduler_uniform     no            yes/no
    scheduler_commute     no            yes/no
    scheduler_post179     yes           yes/no
    cz_mode               manual        auto/manual
    ===================  ============= ==================================================

    Parameters
    ----------
    arg1 : str
        Option name

    Returns
    -------
    str
        Option value

    """
    return _openql.get_option(option_name)

def print_options():
    r"""
    Prints a list of available OpenQL options with their values.


    """
    return _openql.print_options()
class Platform(object):
    r""" Platform class specifying the target platform to be used for compilation."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Platform_name_get, _openql.Platform_name_set)
    config_file = property(_openql.Platform_config_file_get, _openql.Platform_config_file_set)
    platform = property(_openql.Platform_platform_get, _openql.Platform_platform_set)

    def __init__(self, *args):
        r"""
         Constructs a Platform object.

        Parameters
        ----------
        arg1 : str
            name of the Platform
        arg2 : str
            name of the configuration file specifying the platform

        """
        _openql.Platform_swiginit(self, _openql.new_Platform(*args))

    def get_qubit_number(self):
        r"""
         returns number of qubits in the platform.

        Parameters
        ----------
        None

        Returns
        -------
        int
            number of qubits

        """
        return _openql.Platform_get_qubit_number(self)
    __swig_destroy__ = _openql.delete_Platform

# Register Platform in _openql:
_openql.Platform_swigregister(Platform)

class CReg(object):
    r""" Classical register class."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    creg = property(_openql.CReg_creg_get, _openql.CReg_creg_set)

    def __init__(self):
        r"""
         Constructs a classical register which can be source/destination for classical operations.

        Parameters
        ----------
        None

        Returns
        -------
        CReg
            classical register object


        """
        _openql.CReg_swiginit(self, _openql.new_CReg())
    __swig_destroy__ = _openql.delete_CReg

# Register CReg in _openql:
_openql.CReg_swigregister(CReg)

class Operation(object):
    r""" Operation class representing classical operations."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    operation = property(_openql.Operation_operation_get, _openql.Operation_operation_set)

    def __init__(self, *args):
        r"""
         Constructs an Operation object (used for initializing with immediate values).

        Parameters
        ----------
        arg1 : int
            immediate value

        """
        _openql.Operation_swiginit(self, _openql.new_Operation(*args))
    __swig_destroy__ = _openql.delete_Operation

# Register Operation in _openql:
_openql.Operation_swigregister(Operation)

class Unitary(object):
    r""" Unitary class to hold the matrix and its decomposition"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Unitary_name_get, _openql.Unitary_name_set)
    unitary = property(_openql.Unitary_unitary_get, _openql.Unitary_unitary_set)

    def __init__(self, name, matrix):
        r"""
         Constructs a unitary

        Parameters
        ----------
        arg1 : str
            name of the unitary
        arg2 : matrix
            complex unitary matrix

        Returns
        -------
        None

        """
        _openql.Unitary_swiginit(self, _openql.new_Unitary(name, matrix))

    def decompose(self):
        r"""
         Decomposes the unitary matrix

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Unitary_decompose(self)
    __swig_destroy__ = _openql.delete_Unitary

    @staticmethod
    def is_decompose_support_enabled():
        return _openql.Unitary_is_decompose_support_enabled()

# Register Unitary in _openql:
_openql.Unitary_swigregister(Unitary)

def Unitary_is_decompose_support_enabled():
    return _openql.Unitary_is_decompose_support_enabled()

class Kernel(object):
    r""" Kernel class which contains various quantum instructions."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Kernel_name_get, _openql.Kernel_name_set)
    platform = property(_openql.Kernel_platform_get, _openql.Kernel_platform_set)
    qubit_count = property(_openql.Kernel_qubit_count_get, _openql.Kernel_qubit_count_set)
    creg_count = property(_openql.Kernel_creg_count_get, _openql.Kernel_creg_count_set)
    kernel = property(_openql.Kernel_kernel_get, _openql.Kernel_kernel_set)

    def __init__(self, *args):
        r"""
         Constructs a Kernel object.

        Parameters
        ----------
        arg1 : str
            name of the Kernel
        arg2 : Platform
            target platform for which the kernel will be compiled
        arg3 : int
            qubit count
        arg4 : int
            classical register count

        """
        _openql.Kernel_swiginit(self, _openql.new_Kernel(*args))

    def identity(self, q0):
        r"""
         Applies identity on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_identity(self, q0)

    def hadamard(self, q0):
        r"""
         Applies hadamard on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_hadamard(self, q0)

    def s(self, q0):
        r"""
         Applies x on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_s(self, q0)

    def sdag(self, q0):
        r"""
         Applies sdag on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_sdag(self, q0)

    def t(self, q0):
        return _openql.Kernel_t(self, q0)

    def tdag(self, q0):
        return _openql.Kernel_tdag(self, q0)

    def x(self, q0):
        return _openql.Kernel_x(self, q0)

    def y(self, q0):
        r"""
         Applies y on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_y(self, q0)

    def z(self, q0):
        r"""
         Applies z on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_z(self, q0)

    def rx90(self, q0):
        r"""
         Applies rx90 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_rx90(self, q0)

    def mrx90(self, q0):
        r"""
         Applies mrx90 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_mrx90(self, q0)

    def rx180(self, q0):
        r"""
         Applies rx180 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_rx180(self, q0)

    def ry90(self, q0):
        return _openql.Kernel_ry90(self, q0)

    def mry90(self, q0):
        return _openql.Kernel_mry90(self, q0)

    def ry180(self, q0):
        r"""
         Applies ry180 on the qubit specified in argument.

        Parameters
        ----------
        arg1 : int
            target qubit

        """
        return _openql.Kernel_ry180(self, q0)

    def rx(self, q0, angle):
        return _openql.Kernel_rx(self, q0, angle)

    def ry(self, q0, angle):
        return _openql.Kernel_ry(self, q0, angle)

    def rz(self, q0, angle):
        return _openql.Kernel_rz(self, q0, angle)

    def measure(self, q0):
        r"""
         measures input qubit.

        Parameters
        ----------
        arg1 : int
            input qubit

        """
        return _openql.Kernel_measure(self, q0)

    def prepz(self, q0):
        return _openql.Kernel_prepz(self, q0)

    def cnot(self, q0, q1):
        r"""
         Applies controlled-not operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            target qubit

        """
        return _openql.Kernel_cnot(self, q0, q1)

    def cphase(self, q0, q1):
        r"""
         Applies controlled-phase operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            target qubit

        """
        return _openql.Kernel_cphase(self, q0, q1)

    def cz(self, q0, q1):
        return _openql.Kernel_cz(self, q0, q1)

    def toffoli(self, q0, q1, q2):
        r"""
         Applies controlled-controlled-not operation.

        Parameters
        ----------
        arg1 : int
            control qubit
        arg2 : int
            control qubit
        arg3 : int
            target qubit

        """
        return _openql.Kernel_toffoli(self, q0, q1, q2)

    def clifford(self, id, q0):
        r"""
         Applies clifford operation of the specified id on the qubit.

        The ids and the corresponding operations are:

        ====  ==========================
         id    Operations
        ====  ==========================
        0       ['I']
        1       ['Y90', 'X90']
        2       ['mX90', 'mY90']
        3       ['X180']
        4       ['mY90', 'mX90']
        5       ['X90', 'mY90']
        6       ['Y180']
        7       ['mY90', 'X90']
        8       ['X90', 'Y90']
        9       ['X180', 'Y180']
        10      ['Y90', 'mX90']
        11      ['mX90', 'Y90']
        12      ['Y90', 'X180']
        13      ['mX90']
        14      ['X90', 'mY90', 'mX90']
        15      ['mY90']
        16      ['X90']
        17      ['X90', 'Y90', 'X90']
        18      ['mY90', 'X180']
        19      ['X90', 'Y180']
        20      ['X90', 'mY90', 'X90']
        21      ['Y90']
        22      ['mX90', 'Y180']
        23      ['X90', 'Y90', 'mX90']
        ====  ==========================

        Parameters
        ----------
        arg1 : int
            clifford operation id
        arg2 : int
            target qubit

        """
        return _openql.Kernel_clifford(self, id, q0)

    def wait(self, qubits, duration):
        r"""
         inserts explicit wait of specified duration on specified qubits.

            wait with duration '0' is equivalent to barrier on specified list of qubits.
            If no qubits are specified, then wait/barrier is applied on all the qubits.


        Parameters
        ----------
        arg1 : []
            list of qubits
        arg2 : int
            duration in ns

        """
        return _openql.Kernel_wait(self, qubits, duration)

    def barrier(self, *args):
        r"""
         inserts explicit barrier on specified qubits.

            wait with duration '0' is also equivalent to applying barrier on specified list of qubits.
            If no qubits are specified, then barrier is applied on all the qubits.

        Parameters
        ----------
        arg1 : []
            list of qubits

        """
        return _openql.Kernel_barrier(self, *args)

    def get_custom_instructions(self):
        r"""
         Returns list of available custom instructions.

        Parameters
        ----------
        None

        Returns
        -------
        []
            List of available custom instructions

        """
        return _openql.Kernel_get_custom_instructions(self)

    def display(self):
        r"""
         inserts QX display instruction (so QX specific).

        Parameters
        ----------
        None

        Returns
        -------
        None

        """
        return _openql.Kernel_display(self)

    def gate(self, *args):
        r"""
         adds unitary to kernel.

        Parameters
        ----------
        arg1 : Unitary
            unitary matrix
        arg2 : []
            list of qubits

        """
        return _openql.Kernel_gate(self, *args)

    def classical(self, *args):
        r"""
         adds classical operation kernel.

        Parameters
        ----------
        arg1 : CReg
            destination register for classical operation.
        arg2 : Operation
            classical operation.

        """
        return _openql.Kernel_classical(self, *args)

    def controlled(self, k, control_qubits, ancilla_qubits):
        r"""
         generates controlled version of the kernel from the input kernel.

        Parameters
        ----------

        arg1 : ql::Kernel
            input kernel. Except measure, Kernel to be controlled may contain any of the default gates as well custom gates which are not specialized for a specific qubits.

        arg2 : []
            list of control qubits.

        arg3 : []
            list of ancilla qubits. Number of ancilla qubits should be equal to number of control qubits.


        Returns
        -------
        None

        """
        return _openql.Kernel_controlled(self, k, control_qubits, ancilla_qubits)

    def conjugate(self, k):
        r"""
         generates conjugate version of the kernel from the input kernel.

        Parameters
        ----------

        arg1 : ql::Kernel
            input kernel. Except measure, Kernel to be conjugated.


        Returns
        -------
        None

        """
        return _openql.Kernel_conjugate(self, k)
    __swig_destroy__ = _openql.delete_Kernel

# Register Kernel in _openql:
_openql.Kernel_swigregister(Kernel)

class Program(object):
    r""" Program class which contains one or more kernels."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Program_name_get, _openql.Program_name_set)
    platform = property(_openql.Program_platform_get, _openql.Program_platform_set)
    qubit_count = property(_openql.Program_qubit_count_get, _openql.Program_qubit_count_set)
    creg_count = property(_openql.Program_creg_count_get, _openql.Program_creg_count_set)
    program = property(_openql.Program_program_get, _openql.Program_program_set)

    def __init__(self, *args):
        r"""
         Constructs a program object.

        Parameters
        ----------
        arg1 : str
            name of the program
        arg2 : Platform
            instance of an OpenQL Platform
        arg3 : int
            number of qubits the program will use
        arg4 : int
            number of classical registers the program will use (default: 0)

        """
        _openql.Program_swiginit(self, _openql.new_Program(*args))

    def set_sweep_points(self, sweep_points):
        r"""
         Sets sweep points for an experiment.

        Parameters
        ----------
        arg1 : []
            list of sweep points

        """
        return _openql.Program_set_sweep_points(self, sweep_points)

    def get_sweep_points(self):
        r"""
         Returns sweep points for an experiment.

        Parameters
        ----------
        None

        Returns
        -------
        []
            list of sweep points 
        """
        return _openql.Program_get_sweep_points(self)

    def add_kernel(self, k):
        r"""
         Adds specified kernel to program.

        Parameters
        ----------
        arg1 : kernel
            kernel to be added

        """
        return _openql.Program_add_kernel(self, k)

    def add_program(self, p):
        return _openql.Program_add_program(self, p)

    def add_if(self, *args):
        r"""
         Adds specified sub-program to a program which will be executed if specified condition is true. This allows nesting of operations.

        Parameters
        ----------
        arg1 : Program
            program to be executed
        arg2: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_if(self, *args)

    def add_if_else(self, *args):
        r"""
         Adds specified sub-programs to a program. First sub-program will be executed if specified condition is true. Second sub-program will be executed if specified condition is false.

        Parameters
        ----------
        arg1 : Program
            program to be executed when specified condition is true (if part).
        arg2 : Program
            program to be executed when specified condition is false (else part).
        arg3: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_if_else(self, *args)

    def add_do_while(self, *args):
        r"""
         Adds specified sub-program to a program which will be repeatedly executed while specified condition is true.

        Parameters
        ----------
        arg1 : Program
            program to be executed repeatedly
        arg2: Operation
            classical relational operation (<, >, <=, >=, ==, !=)

        """
        return _openql.Program_add_do_while(self, *args)

    def add_for(self, *args):
        r"""
         Adds specified sub-program to a program which will be executed for specified iterations.

        Parameters
        ----------
        arg1 : Program
            sub-program to be executed repeatedly
        arg2: int
            iteration count

        """
        return _openql.Program_add_for(self, *args)

    def compile(self):
        r"""
         Compiles the program

        Parameters
        ----------
        None

        """
        return _openql.Program_compile(self)

    def microcode(self):
        r"""
         Returns program microcode

        Parameters
        ----------
        None

        Returns
        -------
        str
            microcode

        """
        return _openql.Program_microcode(self)

    def print_interaction_matrix(self):
        return _openql.Program_print_interaction_matrix(self)

    def write_interaction_matrix(self):
        return _openql.Program_write_interaction_matrix(self)
    __swig_destroy__ = _openql.delete_Program

# Register Program in _openql:
_openql.Program_swigregister(Program)

class cQasmReader(object):
    r""" cQasmReader class specifies an interface to add cqasm programs to a program."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    cqasm_reader_ = property(_openql.cQasmReader_cqasm_reader__get, _openql.cQasmReader_cqasm_reader__set)
    platform = property(_openql.cQasmReader_platform_get, _openql.cQasmReader_platform_set)
    program = property(_openql.cQasmReader_program_get, _openql.cQasmReader_program_set)

    def __init__(self, q_platform, q_program):
        r"""
         Constructs a cQasmReader object.

        Parameters
        ----------
        arg1 : platform
            Instance of an OpenQL Platform.
        arg2 : program
            Program class to which the kernels with cqasm quantum instructions are added.

        """
        _openql.cQasmReader_swiginit(self, _openql.new_cQasmReader(q_platform, q_program))

    def string2circuit(self, cqasm_str):
        r"""
         Adds a cqasm program defined in a string.

        Parameters
        ----------
        arg1 : str
            The cqasm that is added to the program.

        """
        return _openql.cQasmReader_string2circuit(self, cqasm_str)

    def file2circuit(self, cqasm_file_path):
        r"""
         Adds a cqasm program read from a file.

        Parameters
        ----------
        arg1 : str
            File path to the file specifying the cqasm that is added to the program.

        """
        return _openql.cQasmReader_file2circuit(self, cqasm_file_path)
    __swig_destroy__ = _openql.delete_cQasmReader

# Register cQasmReader in _openql:
_openql.cQasmReader_swigregister(cQasmReader)

class Compiler(object):
    r""" Compiler class which contains one or more compiler passes."""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_openql.Compiler_name_get, _openql.Compiler_name_set)
    compiler = property(_openql.Compiler_compiler_get, _openql.Compiler_compiler_set)

    def __init__(self, name):
        r"""
         Constructs a compiler object.

        Parameters
        ----------
        arg1 : str
            name of the compiler

        """
        _openql.Compiler_swiginit(self, _openql.new_Compiler(name))

    def compile(self, program):
        r"""
         Compiles the program

        Parameters
        ----------
        arg1 : Program
            program object to be compiled.

        """
        return _openql.Compiler_compile(self, program)

    def add_pass_alias(self, realPassName, symbolicPassName):
        r"""
         Adds a compiler pass under an alias name

        Parameters
        ----------
        arg1 : str
            name of the real pass to be added.
        arg2 : str
            alias name of the pass to be added. 

        """
        return _openql.Compiler_add_pass_alias(self, realPassName, symbolicPassName)

    def add_pass(self, realPassName):
        r"""
         Adds a compiler pass under its real name

        Parameters
        ----------
        arg1 : str
            name of the real pass to be added.

        """
        return _openql.Compiler_add_pass(self, realPassName)

    def set_pass_option(self, passName, optionName, optionValue):
        r"""
         Sets a compiler pass option

        Parameters
        ----------
        arg1 : str
            name (real or alias) of the compiler pass to be added.
        arg2 : str
            option name of the option to be configured. 
        arg3 : str
            value of the option. 

        """
        return _openql.Compiler_set_pass_option(self, passName, optionName, optionValue)
    __swig_destroy__ = _openql.delete_Compiler

# Register Compiler in _openql:
_openql.Compiler_swigregister(Compiler)



