import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TimeProviderConfig {
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/time#alias TimeProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/time time}
*/
export declare class TimeProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "time";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/time time} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TimeProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: TimeProviderConfig);
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
