# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'OccAvailabilityCatalogDetailArgs',
    'OccAvailabilityCatalogMetadataDetailsArgs',
    'OccCapacityRequestDetailArgs',
    'OccCapacityRequestPatchOperationArgs',
    'GetInternalOccAvailabilityCatalogsFilterArgs',
    'GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs',
    'GetOccAvailabilityCatalogsFilterArgs',
    'GetOccCapacityRequestsFilterArgs',
    'GetOccCustomerGroupsFilterArgs',
]

@pulumi.input_type
class OccAvailabilityCatalogDetailArgs:
    def __init__(__self__, *,
                 available_quantity: Optional[pulumi.Input[str]] = None,
                 catalog_id: Optional[pulumi.Input[str]] = None,
                 date_expected_capacity_handover: Optional[pulumi.Input[str]] = None,
                 date_final_customer_order: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] available_quantity: The quantity of available resource that the customer can request.
        :param pulumi.Input[str] catalog_id: The OCID of the availability catalog.
        :param pulumi.Input[str] date_expected_capacity_handover: The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        :param pulumi.Input[str] date_final_customer_order: The date by which the customer must place the order to have their capacity requirements met by the customer handover date.
        :param pulumi.Input[str] namespace: The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        :param pulumi.Input[str] resource_name: The name of the resource that the customer can request.
        :param pulumi.Input[str] resource_type: The different types of resources against which customers can place capacity requests.
        :param pulumi.Input[str] unit: The unit in which the resource available is measured.
        :param pulumi.Input[str] workload_type: The type of workload (Generic/ROW).
        """
        if available_quantity is not None:
            pulumi.set(__self__, "available_quantity", available_quantity)
        if catalog_id is not None:
            pulumi.set(__self__, "catalog_id", catalog_id)
        if date_expected_capacity_handover is not None:
            pulumi.set(__self__, "date_expected_capacity_handover", date_expected_capacity_handover)
        if date_final_customer_order is not None:
            pulumi.set(__self__, "date_final_customer_order", date_final_customer_order)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="availableQuantity")
    def available_quantity(self) -> Optional[pulumi.Input[str]]:
        """
        The quantity of available resource that the customer can request.
        """
        return pulumi.get(self, "available_quantity")

    @available_quantity.setter
    def available_quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "available_quantity", value)

    @property
    @pulumi.getter(name="catalogId")
    def catalog_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the availability catalog.
        """
        return pulumi.get(self, "catalog_id")

    @catalog_id.setter
    def catalog_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "catalog_id", value)

    @property
    @pulumi.getter(name="dateExpectedCapacityHandover")
    def date_expected_capacity_handover(self) -> Optional[pulumi.Input[str]]:
        """
        The date by which the capacity requested by customers before dateFinalCustomerOrder needs to be fulfilled.
        """
        return pulumi.get(self, "date_expected_capacity_handover")

    @date_expected_capacity_handover.setter
    def date_expected_capacity_handover(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_expected_capacity_handover", value)

    @property
    @pulumi.getter(name="dateFinalCustomerOrder")
    def date_final_customer_order(self) -> Optional[pulumi.Input[str]]:
        """
        The date by which the customer must place the order to have their capacity requirements met by the customer handover date.
        """
        return pulumi.get(self, "date_final_customer_order")

    @date_final_customer_order.setter
    def date_final_customer_order(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_final_customer_order", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Oracle Cloud Infrastructure service in consideration. For example, Compute, Exadata, and so on.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource that the customer can request.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        The different types of resources against which customers can place capacity requests.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The unit in which the resource available is measured.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of workload (Generic/ROW).
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class OccAvailabilityCatalogMetadataDetailsArgs:
    def __init__(__self__, *,
                 format_version: pulumi.Input[str]):
        """
        :param pulumi.Input[str] format_version: The version for the format of the catalog file being uploaded.
        """
        pulumi.set(__self__, "format_version", format_version)

    @property
    @pulumi.getter(name="formatVersion")
    def format_version(self) -> pulumi.Input[str]:
        """
        The version for the format of the catalog file being uploaded.
        """
        return pulumi.get(self, "format_version")

    @format_version.setter
    def format_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "format_version", value)


@pulumi.input_type
class OccCapacityRequestDetailArgs:
    def __init__(__self__, *,
                 demand_quantity: pulumi.Input[str],
                 resource_name: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 workload_type: pulumi.Input[str],
                 actual_handover_quantity: Optional[pulumi.Input[str]] = None,
                 date_actual_handover: Optional[pulumi.Input[str]] = None,
                 date_expected_handover: Optional[pulumi.Input[str]] = None,
                 expected_handover_quantity: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] demand_quantity: The number of compute server's with name <resourceName> required by the user.
        :param pulumi.Input[str] resource_name: The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.
        :param pulumi.Input[str] resource_type: The type of the resource against which the user wants to place a capacity request.
        :param pulumi.Input[str] workload_type: The type of the workload (Generic/ROW).
        :param pulumi.Input[str] actual_handover_quantity: The actual handed over quantity of resources at the time of request resolution.
        :param pulumi.Input[str] date_actual_handover: The date on which the actual handover quantity of resources is delivered.
        :param pulumi.Input[str] date_expected_handover: The date on which the latest increment to supplied quantity of resources was delivered.
        :param pulumi.Input[str] expected_handover_quantity: The incremental quantity of resources supplied as the provisioning is underway.
        """
        pulumi.set(__self__, "demand_quantity", demand_quantity)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "workload_type", workload_type)
        if actual_handover_quantity is not None:
            pulumi.set(__self__, "actual_handover_quantity", actual_handover_quantity)
        if date_actual_handover is not None:
            pulumi.set(__self__, "date_actual_handover", date_actual_handover)
        if date_expected_handover is not None:
            pulumi.set(__self__, "date_expected_handover", date_expected_handover)
        if expected_handover_quantity is not None:
            pulumi.set(__self__, "expected_handover_quantity", expected_handover_quantity)

    @property
    @pulumi.getter(name="demandQuantity")
    def demand_quantity(self) -> pulumi.Input[str]:
        """
        The number of compute server's with name <resourceName> required by the user.
        """
        return pulumi.get(self, "demand_quantity")

    @demand_quantity.setter
    def demand_quantity(self, value: pulumi.Input[str]):
        pulumi.set(self, "demand_quantity", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[str]:
        """
        The name of the COMPUTE server shape for which the request is made. Do not use CAPACITY_CONSTRAINT as the resource name.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        The type of the resource against which the user wants to place a capacity request.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> pulumi.Input[str]:
        """
        The type of the workload (Generic/ROW).
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "workload_type", value)

    @property
    @pulumi.getter(name="actualHandoverQuantity")
    def actual_handover_quantity(self) -> Optional[pulumi.Input[str]]:
        """
        The actual handed over quantity of resources at the time of request resolution.
        """
        return pulumi.get(self, "actual_handover_quantity")

    @actual_handover_quantity.setter
    def actual_handover_quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "actual_handover_quantity", value)

    @property
    @pulumi.getter(name="dateActualHandover")
    def date_actual_handover(self) -> Optional[pulumi.Input[str]]:
        """
        The date on which the actual handover quantity of resources is delivered.
        """
        return pulumi.get(self, "date_actual_handover")

    @date_actual_handover.setter
    def date_actual_handover(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_actual_handover", value)

    @property
    @pulumi.getter(name="dateExpectedHandover")
    def date_expected_handover(self) -> Optional[pulumi.Input[str]]:
        """
        The date on which the latest increment to supplied quantity of resources was delivered.
        """
        return pulumi.get(self, "date_expected_handover")

    @date_expected_handover.setter
    def date_expected_handover(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "date_expected_handover", value)

    @property
    @pulumi.getter(name="expectedHandoverQuantity")
    def expected_handover_quantity(self) -> Optional[pulumi.Input[str]]:
        """
        The incremental quantity of resources supplied as the provisioning is underway.
        """
        return pulumi.get(self, "expected_handover_quantity")

    @expected_handover_quantity.setter
    def expected_handover_quantity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expected_handover_quantity", value)


@pulumi.input_type
class OccCapacityRequestPatchOperationArgs:
    def __init__(__self__, *,
                 from_: pulumi.Input[str],
                 operation: pulumi.Input[str],
                 selection: pulumi.Input[str],
                 value: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 position: Optional[pulumi.Input[str]] = None,
                 selected_item: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] from_: (Updatable)
        :param pulumi.Input[str] operation: (Updatable) The operation can be one of these values: `INSERT`, `INSERT_MULTIPLE`, `MERGE`, `MOVE`, `PROHIBIT`, `REMOVE`, `REPLACE`, `REQUIRE`
        :param pulumi.Input[str] selection: (Updatable)
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value: (Updatable)
        :param pulumi.Input[str] position: (Updatable)
        :param pulumi.Input[str] selected_item: (Updatable)
        """
        pulumi.set(__self__, "from_", from_)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "selection", selection)
        pulumi.set(__self__, "value", value)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if selected_item is not None:
            pulumi.set(__self__, "selected_item", selected_item)

    @property
    @pulumi.getter(name="from")
    def from_(self) -> pulumi.Input[str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "from_")

    @from_.setter
    def from_(self, value: pulumi.Input[str]):
        pulumi.set(self, "from_", value)

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Input[str]:
        """
        (Updatable) The operation can be one of these values: `INSERT`, `INSERT_MULTIPLE`, `MERGE`, `MOVE`, `PROHIBIT`, `REMOVE`, `REPLACE`, `REQUIRE`
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def selection(self) -> pulumi.Input[str]:
        """
        (Updatable)
        """
        return pulumi.get(self, "selection")

    @selection.setter
    def selection(self, value: pulumi.Input[str]):
        pulumi.set(self, "selection", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="selectedItem")
    def selected_item(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable)
        """
        return pulumi.get(self, "selected_item")

    @selected_item.setter
    def selected_item(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selected_item", value)


@pulumi.input_type
class GetInternalOccAvailabilityCatalogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOccAvailabilityCatalogOccAvailabilitiesFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOccAvailabilityCatalogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOccCapacityRequestsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetOccCustomerGroupsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


