# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetIpInventorySubnetCidrResult',
    'AwaitableGetIpInventorySubnetCidrResult',
    'get_ip_inventory_subnet_cidr',
    'get_ip_inventory_subnet_cidr_output',
]

@pulumi.output_type
class GetIpInventorySubnetCidrResult:
    """
    A collection of values returned by getIpInventorySubnetCidr.
    """
    def __init__(__self__, compartment_id=None, id=None, ip_inventory_cidr_utilization_summaries=None, ip_inventory_subnet_cidr_count=None, last_updated_timestamp=None, message=None, subnet_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_inventory_cidr_utilization_summaries and not isinstance(ip_inventory_cidr_utilization_summaries, list):
            raise TypeError("Expected argument 'ip_inventory_cidr_utilization_summaries' to be a list")
        pulumi.set(__self__, "ip_inventory_cidr_utilization_summaries", ip_inventory_cidr_utilization_summaries)
        if ip_inventory_subnet_cidr_count and not isinstance(ip_inventory_subnet_cidr_count, int):
            raise TypeError("Expected argument 'ip_inventory_subnet_cidr_count' to be a int")
        pulumi.set(__self__, "ip_inventory_subnet_cidr_count", ip_inventory_subnet_cidr_count)
        if last_updated_timestamp and not isinstance(last_updated_timestamp, str):
            raise TypeError("Expected argument 'last_updated_timestamp' to be a str")
        pulumi.set(__self__, "last_updated_timestamp", last_updated_timestamp)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment of the subnet.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipInventoryCidrUtilizationSummaries")
    def ip_inventory_cidr_utilization_summaries(self) -> Sequence['outputs.GetIpInventorySubnetCidrIpInventoryCidrUtilizationSummaryResult']:
        """
        Lists 'IpInventoryCidrUtilizationSummary` object.
        """
        return pulumi.get(self, "ip_inventory_cidr_utilization_summaries")

    @property
    @pulumi.getter(name="ipInventorySubnetCidrCount")
    def ip_inventory_subnet_cidr_count(self) -> int:
        """
        Specifies the count for the number of results for the response.
        """
        return pulumi.get(self, "ip_inventory_subnet_cidr_count")

    @property
    @pulumi.getter(name="lastUpdatedTimestamp")
    def last_updated_timestamp(self) -> str:
        """
        The Timestamp of the latest update from the database in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "last_updated_timestamp")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Indicates the status of the data.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        return pulumi.get(self, "subnet_id")


class AwaitableGetIpInventorySubnetCidrResult(GetIpInventorySubnetCidrResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpInventorySubnetCidrResult(
            compartment_id=self.compartment_id,
            id=self.id,
            ip_inventory_cidr_utilization_summaries=self.ip_inventory_cidr_utilization_summaries,
            ip_inventory_subnet_cidr_count=self.ip_inventory_subnet_cidr_count,
            last_updated_timestamp=self.last_updated_timestamp,
            message=self.message,
            subnet_id=self.subnet_id)


def get_ip_inventory_subnet_cidr(subnet_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpInventorySubnetCidrResult:
    """
    This data source provides details about a specific Ip Inventory Subnet Cidr resource in Oracle Cloud Infrastructure Core service.

    Gets the CIDR utilization data of the specified subnet. Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_inventory_subnet_cidr = oci.Core.get_ip_inventory_subnet_cidr(subnet_id=test_subnet["id"])
    ```


    :param str subnet_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
    """
    __args__ = dict()
    __args__['subnetId'] = subnet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpInventorySubnetCidr:getIpInventorySubnetCidr', __args__, opts=opts, typ=GetIpInventorySubnetCidrResult).value

    return AwaitableGetIpInventorySubnetCidrResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        ip_inventory_cidr_utilization_summaries=pulumi.get(__ret__, 'ip_inventory_cidr_utilization_summaries'),
        ip_inventory_subnet_cidr_count=pulumi.get(__ret__, 'ip_inventory_subnet_cidr_count'),
        last_updated_timestamp=pulumi.get(__ret__, 'last_updated_timestamp'),
        message=pulumi.get(__ret__, 'message'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'))


@_utilities.lift_output_func(get_ip_inventory_subnet_cidr)
def get_ip_inventory_subnet_cidr_output(subnet_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpInventorySubnetCidrResult]:
    """
    This data source provides details about a specific Ip Inventory Subnet Cidr resource in Oracle Cloud Infrastructure Core service.

    Gets the CIDR utilization data of the specified subnet. Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_inventory_subnet_cidr = oci.Core.get_ip_inventory_subnet_cidr(subnet_id=test_subnet["id"])
    ```


    :param str subnet_id: Specify the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet.
    """
    ...
