# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CloudAutonomousVmClusterArgs', 'CloudAutonomousVmCluster']

@pulumi.input_type
class CloudAutonomousVmClusterArgs:
    def __init__(__self__, *,
                 cloud_exadata_infrastructure_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 cluster_time_zone: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a CloudAutonomousVmCluster resource.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] cluster_time_zone: The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] compute_model: The compute model of the Cloud Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: (Updatable) The number of CPU cores to be enabled per VM cluster node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of database servers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: (Updatable) User defined description of the cloud Autonomous VM cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_mtls_enabled_vm_cluster: Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
               
               This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        :param pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs'] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port. Default is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port. Default is 2484.
        :param pulumi.Input[str] time_updated: The last date and time that the cloud Autonomous VM cluster was updated.
        :param pulumi.Input[int] total_container_databases: (Updatable) The total number of Autonomous Container Databases that can be created.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if autonomous_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count_per_node is not None:
            pulumi.set(__self__, "cpu_core_count_per_node", cpu_core_count_per_node)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_mtls_enabled_vm_cluster is not None:
            pulumi.set(__self__, "is_mtls_enabled_vm_cluster", is_mtls_enabled_vm_cluster)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if maintenance_window_details is not None:
            pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if scan_listener_port_non_tls is not None:
            pulumi.set(__self__, "scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls is not None:
            pulumi.set(__self__, "scan_listener_port_tls", scan_listener_port_tls)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_container_databases is not None:
            pulumi.set(__self__, "total_container_databases", total_container_databases)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        The compute model of the Cloud Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to be enabled per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of database servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User defined description of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        """
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @is_mtls_enabled_vm_cluster.setter
    def is_mtls_enabled_vm_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_enabled_vm_cluster", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener Non TLS port. Default is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener TLS port. Default is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last date and time that the cloud Autonomous VM cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The total number of Autonomous Container Databases that can be created.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_container_databases", value)


@pulumi.input_type
class _CloudAutonomousVmClusterState:
    def __init__(__self__, *,
                 autonomous_data_storage_percentage: Optional[pulumi.Input[float]] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 available_container_databases: Optional[pulumi.Input[int]] = None,
                 available_cpus: Optional[pulumi.Input[float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 cpu_percentage: Optional[pulumi.Input[float]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[float]] = None,
                 data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 exadata_storage_in_tbs_lowest_scaled_value: Optional[pulumi.Input[float]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[bool]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 last_update_history_entry_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]]] = None,
                 max_acds_lowest_scaled_value: Optional[pulumi.Input[int]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 non_provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ocpu_count: Optional[pulumi.Input[float]] = None,
                 ocpus_lowest_scaled_value: Optional[pulumi.Input[int]] = None,
                 provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
                 provisioned_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
                 provisioned_cpus: Optional[pulumi.Input[float]] = None,
                 reclaimable_cpus: Optional[pulumi.Input[float]] = None,
                 reserved_cpus: Optional[pulumi.Input[float]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_autonomous_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 total_cpus: Optional[pulumi.Input[float]] = None):
        """
        Input properties used for looking up and filtering CloudAutonomousVmCluster resources.
        :param pulumi.Input[float] autonomous_data_storage_percentage: The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the cloud Autonomous VM cluster is located in.
        :param pulumi.Input[float] available_autonomous_data_storage_size_in_tbs: The data disk group size available for Autonomous Databases, in TBs.
        :param pulumi.Input[int] available_container_databases: The number of Autonomous Container Databases that can be created with the currently available local storage.
        :param pulumi.Input[float] available_cpus: CPU cores available for allocation to Autonomous Databases.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        :param pulumi.Input[str] cluster_time_zone: The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Cloud Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count: The number of CPU cores on the cloud Autonomous VM cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: (Updatable) The number of CPU cores to be enabled per VM cluster node.
        :param pulumi.Input[float] cpu_percentage: The percentage of total number of CPUs used in an Autonomous VM Cluster.
        :param pulumi.Input[float] data_storage_size_in_gb: The total data storage allocated, in gigabytes (GB).
        :param pulumi.Input[float] data_storage_size_in_tbs: The total data storage allocated, in terabytes (TB).
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of database servers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: (Updatable) User defined description of the cloud Autonomous VM cluster.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] domain: The domain name for the cloud Autonomous VM cluster.
        :param pulumi.Input[float] exadata_storage_in_tbs_lowest_scaled_value: The lowest value to which exadataStorage (in TBs) can be scaled down.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the cloud Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled_vm_cluster: Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history. This value is updated when a maintenance update starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
               
               This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs'] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_acds_lowest_scaled_value: The lowest value to which maximum number of ACDs can be scaled down.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of database servers in the cloud VM cluster.
        :param pulumi.Input[int] non_provisionable_autonomous_container_databases: The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: The number of CPU cores on the cloud Autonomous VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[int] ocpus_lowest_scaled_value: The lowest value to which ocpus can be scaled down.
        :param pulumi.Input[int] provisionable_autonomous_container_databases: The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[int] provisioned_autonomous_container_databases: The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[float] provisioned_cpus: The number of CPUs provisioned in an Autonomous VM Cluster.
        :param pulumi.Input[float] reclaimable_cpus: For Autonomous Databases on Dedicated Exadata Infrastructure:
               * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
               * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        :param pulumi.Input[float] reserved_cpus: The number of CPUs reserved in an Autonomous VM Cluster.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port. Default is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port. Default is 2484.
        :param pulumi.Input[str] shape: The model name of the Exadata hardware running the cloud Autonomous VM cluster.
        :param pulumi.Input[str] state: The current state of the cloud Autonomous VM cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        :param pulumi.Input[str] time_created: The date and time that the cloud Autonomous VM cluster was created.
        :param pulumi.Input[str] time_updated: The last date and time that the cloud Autonomous VM cluster was updated.
        :param pulumi.Input[float] total_autonomous_data_storage_in_tbs: The total data disk group size for Autonomous Databases, in TBs.
        :param pulumi.Input[int] total_container_databases: (Updatable) The total number of Autonomous Container Databases that can be created.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[float] total_cpus: The total number of CPUs in an Autonomous VM Cluster.
        """
        if autonomous_data_storage_percentage is not None:
            pulumi.set(__self__, "autonomous_data_storage_percentage", autonomous_data_storage_percentage)
        if autonomous_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "autonomous_data_storage_size_in_tbs", autonomous_data_storage_size_in_tbs)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if available_autonomous_data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "available_autonomous_data_storage_size_in_tbs", available_autonomous_data_storage_size_in_tbs)
        if available_container_databases is not None:
            pulumi.set(__self__, "available_container_databases", available_container_databases)
        if available_cpus is not None:
            pulumi.set(__self__, "available_cpus", available_cpus)
        if cloud_exadata_infrastructure_id is not None:
            pulumi.set(__self__, "cloud_exadata_infrastructure_id", cloud_exadata_infrastructure_id)
        if cluster_time_zone is not None:
            pulumi.set(__self__, "cluster_time_zone", cluster_time_zone)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_model is not None:
            pulumi.set(__self__, "compute_model", compute_model)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if cpu_core_count_per_node is not None:
            pulumi.set(__self__, "cpu_core_count_per_node", cpu_core_count_per_node)
        if cpu_percentage is not None:
            pulumi.set(__self__, "cpu_percentage", cpu_percentage)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storage_size_in_tbs is not None:
            pulumi.set(__self__, "data_storage_size_in_tbs", data_storage_size_in_tbs)
        if db_node_storage_size_in_gbs is not None:
            pulumi.set(__self__, "db_node_storage_size_in_gbs", db_node_storage_size_in_gbs)
        if db_servers is not None:
            pulumi.set(__self__, "db_servers", db_servers)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if exadata_storage_in_tbs_lowest_scaled_value is not None:
            pulumi.set(__self__, "exadata_storage_in_tbs_lowest_scaled_value", exadata_storage_in_tbs_lowest_scaled_value)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_mtls_enabled_vm_cluster is not None:
            pulumi.set(__self__, "is_mtls_enabled_vm_cluster", is_mtls_enabled_vm_cluster)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if last_update_history_entry_id is not None:
            pulumi.set(__self__, "last_update_history_entry_id", last_update_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenance_window_details is not None:
            pulumi.set(__self__, "maintenance_window_details", maintenance_window_details)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if max_acds_lowest_scaled_value is not None:
            pulumi.set(__self__, "max_acds_lowest_scaled_value", max_acds_lowest_scaled_value)
        if memory_per_oracle_compute_unit_in_gbs is not None:
            pulumi.set(__self__, "memory_per_oracle_compute_unit_in_gbs", memory_per_oracle_compute_unit_in_gbs)
        if memory_size_in_gbs is not None:
            pulumi.set(__self__, "memory_size_in_gbs", memory_size_in_gbs)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if non_provisionable_autonomous_container_databases is not None:
            pulumi.set(__self__, "non_provisionable_autonomous_container_databases", non_provisionable_autonomous_container_databases)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if ocpu_count is not None:
            pulumi.set(__self__, "ocpu_count", ocpu_count)
        if ocpus_lowest_scaled_value is not None:
            pulumi.set(__self__, "ocpus_lowest_scaled_value", ocpus_lowest_scaled_value)
        if provisionable_autonomous_container_databases is not None:
            pulumi.set(__self__, "provisionable_autonomous_container_databases", provisionable_autonomous_container_databases)
        if provisioned_autonomous_container_databases is not None:
            pulumi.set(__self__, "provisioned_autonomous_container_databases", provisioned_autonomous_container_databases)
        if provisioned_cpus is not None:
            pulumi.set(__self__, "provisioned_cpus", provisioned_cpus)
        if reclaimable_cpus is not None:
            pulumi.set(__self__, "reclaimable_cpus", reclaimable_cpus)
        if reserved_cpus is not None:
            pulumi.set(__self__, "reserved_cpus", reserved_cpus)
        if scan_listener_port_non_tls is not None:
            pulumi.set(__self__, "scan_listener_port_non_tls", scan_listener_port_non_tls)
        if scan_listener_port_tls is not None:
            pulumi.set(__self__, "scan_listener_port_tls", scan_listener_port_tls)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if total_autonomous_data_storage_in_tbs is not None:
            pulumi.set(__self__, "total_autonomous_data_storage_in_tbs", total_autonomous_data_storage_in_tbs)
        if total_container_databases is not None:
            pulumi.set(__self__, "total_container_databases", total_container_databases)
        if total_cpus is not None:
            pulumi.set(__self__, "total_cpus", total_cpus)

    @property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @autonomous_data_storage_percentage.setter
    def autonomous_data_storage_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_percentage", value)

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @autonomous_data_storage_size_in_tbs.setter
    def autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the cloud Autonomous VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The data disk group size available for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @available_autonomous_data_storage_size_in_tbs.setter
    def available_autonomous_data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_autonomous_data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The number of Autonomous Container Databases that can be created with the currently available local storage.
        """
        return pulumi.get(self, "available_container_databases")

    @available_container_databases.setter
    def available_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "available_container_databases", value)

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> Optional[pulumi.Input[float]]:
        """
        CPU cores available for allocation to Autonomous Databases.
        """
        return pulumi.get(self, "available_cpus")

    @available_cpus.setter
    def available_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "available_cpus", value)

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @cloud_exadata_infrastructure_id.setter
    def cloud_exadata_infrastructure_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_exadata_infrastructure_id", value)

    @property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "cluster_time_zone")

    @cluster_time_zone.setter
    def cluster_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_time_zone", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> Optional[pulumi.Input[str]]:
        """
        The compute model of the Cloud Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @compute_model.setter
    def compute_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compute_model", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU cores on the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The number of CPU cores to be enabled per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @cpu_core_count_per_node.setter
    def cpu_core_count_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count_per_node", value)

    @property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        The percentage of total number of CPUs used in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "cpu_percentage")

    @cpu_percentage.setter
    def cpu_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cpu_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[float]]:
        """
        The total data storage allocated, in gigabytes (GB).
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total data storage allocated, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "data_storage_size_in_tbs", value)

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_node_storage_size_in_gbs", value)

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of database servers.
        """
        return pulumi.get(self, "db_servers")

    @db_servers.setter
    def db_servers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_servers", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User defined description of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="exadataStorageInTbsLowestScaledValue")
    def exadata_storage_in_tbs_lowest_scaled_value(self) -> Optional[pulumi.Input[float]]:
        """
        The lowest value to which exadataStorage (in TBs) can be scaled down.
        """
        return pulumi.get(self, "exadata_storage_in_tbs_lowest_scaled_value")

    @exadata_storage_in_tbs_lowest_scaled_value.setter
    def exadata_storage_in_tbs_lowest_scaled_value(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exadata_storage_in_tbs_lowest_scaled_value", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> Optional[pulumi.Input[bool]]:
        """
        Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        """
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @is_mtls_enabled_vm_cluster.setter
    def is_mtls_enabled_vm_cluster(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_mtls_enabled_vm_cluster", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @last_update_history_entry_id.setter
    def last_update_history_entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_update_history_entry_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @maintenance_window_details.setter
    def maintenance_window_details(self, value: Optional[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs']]):
        pulumi.set(self, "maintenance_window_details", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CloudAutonomousVmClusterMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="maxAcdsLowestScaledValue")
    def max_acds_lowest_scaled_value(self) -> Optional[pulumi.Input[int]]:
        """
        The lowest value to which maximum number of ACDs can be scaled down.
        """
        return pulumi.get(self, "max_acds_lowest_scaled_value")

    @max_acds_lowest_scaled_value.setter
    def max_acds_lowest_scaled_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_acds_lowest_scaled_value", value)

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @memory_per_oracle_compute_unit_in_gbs.setter
    def memory_per_oracle_compute_unit_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_per_oracle_compute_unit_in_gbs", value)

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> Optional[pulumi.Input[int]]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory_size_in_gbs", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of database servers in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @non_provisionable_autonomous_container_databases.setter
    def non_provisionable_autonomous_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "non_provisionable_autonomous_container_databases", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> Optional[pulumi.Input[float]]:
        """
        The number of CPU cores on the cloud Autonomous VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @ocpu_count.setter
    def ocpu_count(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "ocpu_count", value)

    @property
    @pulumi.getter(name="ocpusLowestScaledValue")
    def ocpus_lowest_scaled_value(self) -> Optional[pulumi.Input[int]]:
        """
        The lowest value to which ocpus can be scaled down.
        """
        return pulumi.get(self, "ocpus_lowest_scaled_value")

    @ocpus_lowest_scaled_value.setter
    def ocpus_lowest_scaled_value(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ocpus_lowest_scaled_value", value)

    @property
    @pulumi.getter(name="provisionableAutonomousContainerDatabases")
    def provisionable_autonomous_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisionable_autonomous_container_databases")

    @provisionable_autonomous_container_databases.setter
    def provisionable_autonomous_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisionable_autonomous_container_databases", value)

    @property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @provisioned_autonomous_container_databases.setter
    def provisioned_autonomous_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "provisioned_autonomous_container_databases", value)

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> Optional[pulumi.Input[float]]:
        """
        The number of CPUs provisioned in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_cpus")

    @provisioned_cpus.setter
    def provisioned_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "provisioned_cpus", value)

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> Optional[pulumi.Input[float]]:
        """
        For Autonomous Databases on Dedicated Exadata Infrastructure:
        * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @reclaimable_cpus.setter
    def reclaimable_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reclaimable_cpus", value)

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> Optional[pulumi.Input[float]]:
        """
        The number of CPUs reserved in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "reserved_cpus")

    @reserved_cpus.setter
    def reserved_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "reserved_cpus", value)

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener Non TLS port. Default is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @scan_listener_port_non_tls.setter
    def scan_listener_port_non_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_non_tls", value)

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> Optional[pulumi.Input[int]]:
        """
        The SCAN Listener TLS port. Default is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @scan_listener_port_tls.setter
    def scan_listener_port_tls(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "scan_listener_port_tls", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The model name of the Exadata hardware running the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time that the cloud Autonomous VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The last date and time that the cloud Autonomous VM cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter(name="totalAutonomousDataStorageInTbs")
    def total_autonomous_data_storage_in_tbs(self) -> Optional[pulumi.Input[float]]:
        """
        The total data disk group size for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "total_autonomous_data_storage_in_tbs")

    @total_autonomous_data_storage_in_tbs.setter
    def total_autonomous_data_storage_in_tbs(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_autonomous_data_storage_in_tbs", value)

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The total number of Autonomous Container Databases that can be created.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_container_databases")

    @total_container_databases.setter
    def total_container_databases(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_container_databases", value)

    @property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> Optional[pulumi.Input[float]]:
        """
        The total number of CPUs in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "total_cpus")

    @total_cpus.setter
    def total_cpus(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "total_cpus", value)


class CloudAutonomousVmCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs', 'CloudAutonomousVmClusterMaintenanceWindowDetailsArgsDict']]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Cloud Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Autonomous Exadata VM cluster in the Oracle cloud. For Exadata Cloud@Customer systems, see [CreateAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/CreateAutonomousVmCluster).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_autonomous_vm_cluster = oci.database.CloudAutonomousVmCluster("test_cloud_autonomous_vm_cluster",
            cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
            compartment_id=compartment_id,
            display_name=cloud_autonomous_vm_cluster_display_name,
            subnet_id=test_subnet["id"],
            autonomous_data_storage_size_in_tbs=cloud_autonomous_vm_cluster_autonomous_data_storage_size_in_tbs,
            cluster_time_zone=cloud_autonomous_vm_cluster_cluster_time_zone,
            compute_model=cloud_autonomous_vm_cluster_compute_model,
            cpu_core_count_per_node=cloud_autonomous_vm_cluster_cpu_core_count_per_node,
            db_servers=cloud_autonomous_vm_cluster_db_servers,
            defined_tags=cloud_autonomous_vm_cluster_defined_tags,
            description=cloud_autonomous_vm_cluster_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_mtls_enabled_vm_cluster=cloud_autonomous_vm_cluster_is_mtls_enabled_vm_cluster,
            license_model=cloud_autonomous_vm_cluster_license_model,
            maintenance_window_details={
                "custom_action_timeout_in_mins": cloud_autonomous_vm_cluster_maintenance_window_details_custom_action_timeout_in_mins,
                "days_of_weeks": [{
                    "name": cloud_autonomous_vm_cluster_maintenance_window_details_days_of_week_name,
                }],
                "hours_of_days": cloud_autonomous_vm_cluster_maintenance_window_details_hours_of_day,
                "is_custom_action_timeout_enabled": cloud_autonomous_vm_cluster_maintenance_window_details_is_custom_action_timeout_enabled,
                "is_monthly_patching_enabled": cloud_autonomous_vm_cluster_maintenance_window_details_is_monthly_patching_enabled,
                "lead_time_in_weeks": cloud_autonomous_vm_cluster_maintenance_window_details_lead_time_in_weeks,
                "months": [{
                    "name": cloud_autonomous_vm_cluster_maintenance_window_details_months_name,
                }],
                "patching_mode": cloud_autonomous_vm_cluster_maintenance_window_details_patching_mode,
                "preference": cloud_autonomous_vm_cluster_maintenance_window_details_preference,
                "weeks_of_months": cloud_autonomous_vm_cluster_maintenance_window_details_weeks_of_month,
            },
            memory_per_oracle_compute_unit_in_gbs=cloud_autonomous_vm_cluster_memory_per_oracle_compute_unit_in_gbs,
            nsg_ids=cloud_autonomous_vm_cluster_nsg_ids,
            scan_listener_port_non_tls=cloud_autonomous_vm_cluster_scan_listener_port_non_tls,
            scan_listener_port_tls=cloud_autonomous_vm_cluster_scan_listener_port_tls,
            total_container_databases=cloud_autonomous_vm_cluster_total_container_databases)
        ```

        ## Import

        CloudAutonomousVmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudAutonomousVmCluster:CloudAutonomousVmCluster test_cloud_autonomous_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        :param pulumi.Input[str] cluster_time_zone: The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Cloud Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: (Updatable) The number of CPU cores to be enabled per VM cluster node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of database servers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: (Updatable) User defined description of the cloud Autonomous VM cluster.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_mtls_enabled_vm_cluster: Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
               
               This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        :param pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs', 'CloudAutonomousVmClusterMaintenanceWindowDetailsArgsDict']] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port. Default is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port. Default is 2484.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        :param pulumi.Input[str] time_updated: The last date and time that the cloud Autonomous VM cluster was updated.
        :param pulumi.Input[int] total_container_databases: (Updatable) The total number of Autonomous Container Databases that can be created.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CloudAutonomousVmClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Cloud Autonomous Vm Cluster resource in Oracle Cloud Infrastructure Database service.

        Creates an Autonomous Exadata VM cluster in the Oracle cloud. For Exadata Cloud@Customer systems, see [CreateAutonomousVmCluster](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/AutonomousVmCluster/CreateAutonomousVmCluster).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_cloud_autonomous_vm_cluster = oci.database.CloudAutonomousVmCluster("test_cloud_autonomous_vm_cluster",
            cloud_exadata_infrastructure_id=test_cloud_exadata_infrastructure["id"],
            compartment_id=compartment_id,
            display_name=cloud_autonomous_vm_cluster_display_name,
            subnet_id=test_subnet["id"],
            autonomous_data_storage_size_in_tbs=cloud_autonomous_vm_cluster_autonomous_data_storage_size_in_tbs,
            cluster_time_zone=cloud_autonomous_vm_cluster_cluster_time_zone,
            compute_model=cloud_autonomous_vm_cluster_compute_model,
            cpu_core_count_per_node=cloud_autonomous_vm_cluster_cpu_core_count_per_node,
            db_servers=cloud_autonomous_vm_cluster_db_servers,
            defined_tags=cloud_autonomous_vm_cluster_defined_tags,
            description=cloud_autonomous_vm_cluster_description,
            freeform_tags={
                "Department": "Finance",
            },
            is_mtls_enabled_vm_cluster=cloud_autonomous_vm_cluster_is_mtls_enabled_vm_cluster,
            license_model=cloud_autonomous_vm_cluster_license_model,
            maintenance_window_details={
                "custom_action_timeout_in_mins": cloud_autonomous_vm_cluster_maintenance_window_details_custom_action_timeout_in_mins,
                "days_of_weeks": [{
                    "name": cloud_autonomous_vm_cluster_maintenance_window_details_days_of_week_name,
                }],
                "hours_of_days": cloud_autonomous_vm_cluster_maintenance_window_details_hours_of_day,
                "is_custom_action_timeout_enabled": cloud_autonomous_vm_cluster_maintenance_window_details_is_custom_action_timeout_enabled,
                "is_monthly_patching_enabled": cloud_autonomous_vm_cluster_maintenance_window_details_is_monthly_patching_enabled,
                "lead_time_in_weeks": cloud_autonomous_vm_cluster_maintenance_window_details_lead_time_in_weeks,
                "months": [{
                    "name": cloud_autonomous_vm_cluster_maintenance_window_details_months_name,
                }],
                "patching_mode": cloud_autonomous_vm_cluster_maintenance_window_details_patching_mode,
                "preference": cloud_autonomous_vm_cluster_maintenance_window_details_preference,
                "weeks_of_months": cloud_autonomous_vm_cluster_maintenance_window_details_weeks_of_month,
            },
            memory_per_oracle_compute_unit_in_gbs=cloud_autonomous_vm_cluster_memory_per_oracle_compute_unit_in_gbs,
            nsg_ids=cloud_autonomous_vm_cluster_nsg_ids,
            scan_listener_port_non_tls=cloud_autonomous_vm_cluster_scan_listener_port_non_tls,
            scan_listener_port_tls=cloud_autonomous_vm_cluster_scan_listener_port_tls,
            total_container_databases=cloud_autonomous_vm_cluster_total_container_databases)
        ```

        ## Import

        CloudAutonomousVmClusters can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Database/cloudAutonomousVmCluster:CloudAutonomousVmCluster test_cloud_autonomous_vm_cluster "id"
        ```

        :param str resource_name: The name of the resource.
        :param CloudAutonomousVmClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CloudAutonomousVmClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
                 cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
                 cluster_time_zone: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compute_model: Optional[pulumi.Input[str]] = None,
                 cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
                 db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_mtls_enabled_vm_cluster: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 maintenance_window_details: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs', 'CloudAutonomousVmClusterMaintenanceWindowDetailsArgsDict']]] = None,
                 memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
                 scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 total_container_databases: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CloudAutonomousVmClusterArgs.__new__(CloudAutonomousVmClusterArgs)

            __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
            if cloud_exadata_infrastructure_id is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_exadata_infrastructure_id'")
            __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
            __props__.__dict__["cluster_time_zone"] = cluster_time_zone
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["compute_model"] = compute_model
            __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
            __props__.__dict__["db_servers"] = db_servers
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_mtls_enabled_vm_cluster"] = is_mtls_enabled_vm_cluster
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["maintenance_window_details"] = maintenance_window_details
            __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
            __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["time_updated"] = time_updated
            __props__.__dict__["total_container_databases"] = total_container_databases
            __props__.__dict__["autonomous_data_storage_percentage"] = None
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = None
            __props__.__dict__["available_container_databases"] = None
            __props__.__dict__["available_cpus"] = None
            __props__.__dict__["cpu_core_count"] = None
            __props__.__dict__["cpu_percentage"] = None
            __props__.__dict__["data_storage_size_in_gb"] = None
            __props__.__dict__["data_storage_size_in_tbs"] = None
            __props__.__dict__["db_node_storage_size_in_gbs"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["exadata_storage_in_tbs_lowest_scaled_value"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["last_update_history_entry_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["max_acds_lowest_scaled_value"] = None
            __props__.__dict__["memory_size_in_gbs"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["non_provisionable_autonomous_container_databases"] = None
            __props__.__dict__["ocpu_count"] = None
            __props__.__dict__["ocpus_lowest_scaled_value"] = None
            __props__.__dict__["provisionable_autonomous_container_databases"] = None
            __props__.__dict__["provisioned_autonomous_container_databases"] = None
            __props__.__dict__["provisioned_cpus"] = None
            __props__.__dict__["reclaimable_cpus"] = None
            __props__.__dict__["reserved_cpus"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["total_autonomous_data_storage_in_tbs"] = None
            __props__.__dict__["total_cpus"] = None
        super(CloudAutonomousVmCluster, __self__).__init__(
            'oci:Database/cloudAutonomousVmCluster:CloudAutonomousVmCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autonomous_data_storage_percentage: Optional[pulumi.Input[float]] = None,
            autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            available_autonomous_data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            available_container_databases: Optional[pulumi.Input[int]] = None,
            available_cpus: Optional[pulumi.Input[float]] = None,
            cloud_exadata_infrastructure_id: Optional[pulumi.Input[str]] = None,
            cluster_time_zone: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compute_model: Optional[pulumi.Input[str]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            cpu_core_count_per_node: Optional[pulumi.Input[int]] = None,
            cpu_percentage: Optional[pulumi.Input[float]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[float]] = None,
            data_storage_size_in_tbs: Optional[pulumi.Input[float]] = None,
            db_node_storage_size_in_gbs: Optional[pulumi.Input[int]] = None,
            db_servers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            exadata_storage_in_tbs_lowest_scaled_value: Optional[pulumi.Input[float]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            is_mtls_enabled_vm_cluster: Optional[pulumi.Input[bool]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            last_update_history_entry_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            maintenance_window_details: Optional[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs', 'CloudAutonomousVmClusterMaintenanceWindowDetailsArgsDict']]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']]]]] = None,
            max_acds_lowest_scaled_value: Optional[pulumi.Input[int]] = None,
            memory_per_oracle_compute_unit_in_gbs: Optional[pulumi.Input[int]] = None,
            memory_size_in_gbs: Optional[pulumi.Input[int]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            non_provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ocpu_count: Optional[pulumi.Input[float]] = None,
            ocpus_lowest_scaled_value: Optional[pulumi.Input[int]] = None,
            provisionable_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
            provisioned_autonomous_container_databases: Optional[pulumi.Input[int]] = None,
            provisioned_cpus: Optional[pulumi.Input[float]] = None,
            reclaimable_cpus: Optional[pulumi.Input[float]] = None,
            reserved_cpus: Optional[pulumi.Input[float]] = None,
            scan_listener_port_non_tls: Optional[pulumi.Input[int]] = None,
            scan_listener_port_tls: Optional[pulumi.Input[int]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            total_autonomous_data_storage_in_tbs: Optional[pulumi.Input[float]] = None,
            total_container_databases: Optional[pulumi.Input[int]] = None,
            total_cpus: Optional[pulumi.Input[float]] = None) -> 'CloudAutonomousVmCluster':
        """
        Get an existing CloudAutonomousVmCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[float] autonomous_data_storage_percentage: The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.
        :param pulumi.Input[float] autonomous_data_storage_size_in_tbs: (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the cloud Autonomous VM cluster is located in.
        :param pulumi.Input[float] available_autonomous_data_storage_size_in_tbs: The data disk group size available for Autonomous Databases, in TBs.
        :param pulumi.Input[int] available_container_databases: The number of Autonomous Container Databases that can be created with the currently available local storage.
        :param pulumi.Input[float] available_cpus: CPU cores available for allocation to Autonomous Databases.
        :param pulumi.Input[str] cloud_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        :param pulumi.Input[str] cluster_time_zone: The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[str] compute_model: The compute model of the Cloud Autonomous VM Cluster.
        :param pulumi.Input[int] cpu_core_count: The number of CPU cores on the cloud Autonomous VM cluster.
        :param pulumi.Input[int] cpu_core_count_per_node: (Updatable) The number of CPU cores to be enabled per VM cluster node.
        :param pulumi.Input[float] cpu_percentage: The percentage of total number of CPUs used in an Autonomous VM Cluster.
        :param pulumi.Input[float] data_storage_size_in_gb: The total data storage allocated, in gigabytes (GB).
        :param pulumi.Input[float] data_storage_size_in_tbs: The total data storage allocated, in terabytes (TB).
        :param pulumi.Input[int] db_node_storage_size_in_gbs: The local node storage allocated in GBs.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_servers: The list of database servers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] description: (Updatable) User defined description of the cloud Autonomous VM cluster.
        :param pulumi.Input[str] display_name: (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        :param pulumi.Input[str] domain: The domain name for the cloud Autonomous VM cluster.
        :param pulumi.Input[float] exadata_storage_in_tbs_lowest_scaled_value: The lowest value to which exadataStorage (in TBs) can be scaled down.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the cloud Autonomous VM cluster.
        :param pulumi.Input[bool] is_mtls_enabled_vm_cluster: Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history. This value is updated when a maintenance update starts.
        :param pulumi.Input[str] license_model: (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.
               
               This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowDetailsArgs', 'CloudAutonomousVmClusterMaintenanceWindowDetailsArgsDict']] maintenance_window_details: (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CloudAutonomousVmClusterMaintenanceWindowArgs', 'CloudAutonomousVmClusterMaintenanceWindowArgsDict']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[int] max_acds_lowest_scaled_value: The lowest value to which maximum number of ACDs can be scaled down.
        :param pulumi.Input[int] memory_per_oracle_compute_unit_in_gbs: The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        :param pulumi.Input[int] memory_size_in_gbs: The memory allocated in GBs.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of database servers in the cloud VM cluster.
        :param pulumi.Input[int] non_provisionable_autonomous_container_databases: The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[float] ocpu_count: The number of CPU cores on the cloud Autonomous VM cluster. Only 1 decimal place is allowed for the fractional part.
        :param pulumi.Input[int] ocpus_lowest_scaled_value: The lowest value to which ocpus can be scaled down.
        :param pulumi.Input[int] provisionable_autonomous_container_databases: The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[int] provisioned_autonomous_container_databases: The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.
        :param pulumi.Input[float] provisioned_cpus: The number of CPUs provisioned in an Autonomous VM Cluster.
        :param pulumi.Input[float] reclaimable_cpus: For Autonomous Databases on Dedicated Exadata Infrastructure:
               * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
               * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        :param pulumi.Input[float] reserved_cpus: The number of CPUs reserved in an Autonomous VM Cluster.
        :param pulumi.Input[int] scan_listener_port_non_tls: The SCAN Listener Non TLS port. Default is 1521.
        :param pulumi.Input[int] scan_listener_port_tls: The SCAN Listener TLS port. Default is 2484.
        :param pulumi.Input[str] shape: The model name of the Exadata hardware running the cloud Autonomous VM cluster.
        :param pulumi.Input[str] state: The current state of the cloud Autonomous VM cluster.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        :param pulumi.Input[str] time_created: The date and time that the cloud Autonomous VM cluster was created.
        :param pulumi.Input[str] time_updated: The last date and time that the cloud Autonomous VM cluster was updated.
        :param pulumi.Input[float] total_autonomous_data_storage_in_tbs: The total data disk group size for Autonomous Databases, in TBs.
        :param pulumi.Input[int] total_container_databases: (Updatable) The total number of Autonomous Container Databases that can be created.
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[float] total_cpus: The total number of CPUs in an Autonomous VM Cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CloudAutonomousVmClusterState.__new__(_CloudAutonomousVmClusterState)

        __props__.__dict__["autonomous_data_storage_percentage"] = autonomous_data_storage_percentage
        __props__.__dict__["autonomous_data_storage_size_in_tbs"] = autonomous_data_storage_size_in_tbs
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["available_autonomous_data_storage_size_in_tbs"] = available_autonomous_data_storage_size_in_tbs
        __props__.__dict__["available_container_databases"] = available_container_databases
        __props__.__dict__["available_cpus"] = available_cpus
        __props__.__dict__["cloud_exadata_infrastructure_id"] = cloud_exadata_infrastructure_id
        __props__.__dict__["cluster_time_zone"] = cluster_time_zone
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compute_model"] = compute_model
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["cpu_core_count_per_node"] = cpu_core_count_per_node
        __props__.__dict__["cpu_percentage"] = cpu_percentage
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["data_storage_size_in_tbs"] = data_storage_size_in_tbs
        __props__.__dict__["db_node_storage_size_in_gbs"] = db_node_storage_size_in_gbs
        __props__.__dict__["db_servers"] = db_servers
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["exadata_storage_in_tbs_lowest_scaled_value"] = exadata_storage_in_tbs_lowest_scaled_value
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["is_mtls_enabled_vm_cluster"] = is_mtls_enabled_vm_cluster
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["last_update_history_entry_id"] = last_update_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["maintenance_window_details"] = maintenance_window_details
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["max_acds_lowest_scaled_value"] = max_acds_lowest_scaled_value
        __props__.__dict__["memory_per_oracle_compute_unit_in_gbs"] = memory_per_oracle_compute_unit_in_gbs
        __props__.__dict__["memory_size_in_gbs"] = memory_size_in_gbs
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["non_provisionable_autonomous_container_databases"] = non_provisionable_autonomous_container_databases
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["ocpu_count"] = ocpu_count
        __props__.__dict__["ocpus_lowest_scaled_value"] = ocpus_lowest_scaled_value
        __props__.__dict__["provisionable_autonomous_container_databases"] = provisionable_autonomous_container_databases
        __props__.__dict__["provisioned_autonomous_container_databases"] = provisioned_autonomous_container_databases
        __props__.__dict__["provisioned_cpus"] = provisioned_cpus
        __props__.__dict__["reclaimable_cpus"] = reclaimable_cpus
        __props__.__dict__["reserved_cpus"] = reserved_cpus
        __props__.__dict__["scan_listener_port_non_tls"] = scan_listener_port_non_tls
        __props__.__dict__["scan_listener_port_tls"] = scan_listener_port_tls
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["total_autonomous_data_storage_in_tbs"] = total_autonomous_data_storage_in_tbs
        __props__.__dict__["total_container_databases"] = total_container_databases
        __props__.__dict__["total_cpus"] = total_cpus
        return CloudAutonomousVmCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autonomousDataStoragePercentage")
    def autonomous_data_storage_percentage(self) -> pulumi.Output[float]:
        """
        The percentage of the data storage used for the Autonomous Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "autonomous_data_storage_percentage")

    @property
    @pulumi.getter(name="autonomousDataStorageSizeInTbs")
    def autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        (Updatable) The data disk group size to be allocated for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the cloud Autonomous VM cluster is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availableAutonomousDataStorageSizeInTbs")
    def available_autonomous_data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The data disk group size available for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "available_autonomous_data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="availableContainerDatabases")
    def available_container_databases(self) -> pulumi.Output[int]:
        """
        The number of Autonomous Container Databases that can be created with the currently available local storage.
        """
        return pulumi.get(self, "available_container_databases")

    @property
    @pulumi.getter(name="availableCpus")
    def available_cpus(self) -> pulumi.Output[float]:
        """
        CPU cores available for allocation to Autonomous Databases.
        """
        return pulumi.get(self, "available_cpus")

    @property
    @pulumi.getter(name="cloudExadataInfrastructureId")
    def cloud_exadata_infrastructure_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the cloud Exadata infrastructure.
        """
        return pulumi.get(self, "cloud_exadata_infrastructure_id")

    @property
    @pulumi.getter(name="clusterTimeZone")
    def cluster_time_zone(self) -> pulumi.Output[str]:
        """
        The time zone to use for the Cloud Autonomous VM cluster. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "cluster_time_zone")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeModel")
    def compute_model(self) -> pulumi.Output[str]:
        """
        The compute model of the Cloud Autonomous VM Cluster.
        """
        return pulumi.get(self, "compute_model")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        The number of CPU cores on the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="cpuCoreCountPerNode")
    def cpu_core_count_per_node(self) -> pulumi.Output[int]:
        """
        (Updatable) The number of CPU cores to be enabled per VM cluster node.
        """
        return pulumi.get(self, "cpu_core_count_per_node")

    @property
    @pulumi.getter(name="cpuPercentage")
    def cpu_percentage(self) -> pulumi.Output[float]:
        """
        The percentage of total number of CPUs used in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "cpu_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[float]:
        """
        The total data storage allocated, in gigabytes (GB).
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorageSizeInTbs")
    def data_storage_size_in_tbs(self) -> pulumi.Output[float]:
        """
        The total data storage allocated, in terabytes (TB).
        """
        return pulumi.get(self, "data_storage_size_in_tbs")

    @property
    @pulumi.getter(name="dbNodeStorageSizeInGbs")
    def db_node_storage_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The local node storage allocated in GBs.
        """
        return pulumi.get(self, "db_node_storage_size_in_gbs")

    @property
    @pulumi.getter(name="dbServers")
    def db_servers(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of database servers.
        """
        return pulumi.get(self, "db_servers")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) User defined description of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The user-friendly name for the cloud Autonomous VM cluster. The name does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="exadataStorageInTbsLowestScaledValue")
    def exadata_storage_in_tbs_lowest_scaled_value(self) -> pulumi.Output[float]:
        """
        The lowest value to which exadataStorage (in TBs) can be scaled down.
        """
        return pulumi.get(self, "exadata_storage_in_tbs_lowest_scaled_value")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname for the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="isMtlsEnabledVmCluster")
    def is_mtls_enabled_vm_cluster(self) -> pulumi.Output[bool]:
        """
        Enable mutual TLS(mTLS) authentication for database at time of provisioning a VMCluster. This is applicable to database TLS Certificates only. Default is TLS
        """
        return pulumi.get(self, "is_mtls_enabled_vm_cluster")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lastUpdateHistoryEntryId")
    def last_update_history_entry_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance update history. This value is updated when a maintenance update starts.
        """
        return pulumi.get(self, "last_update_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        (Updatable) The Oracle license model that applies to the Oracle Autonomous Database. Bring your own license (BYOL) allows you to apply your current on-premises Oracle software licenses to equivalent, highly automated Oracle services in the cloud. License Included allows you to subscribe to new Oracle Database software licenses and the Oracle Database service. Note that when provisioning an [Autonomous Database on dedicated Exadata infrastructure](https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html), this attribute must be null. It is already set at the Autonomous Exadata Infrastructure level. When provisioning an [Autonomous Database Serverless] (https://docs.oracle.com/en/cloud/paas/autonomous-database/index.html) database, if a value is not specified, the system defaults the value to `BRING_YOUR_OWN_LICENSE`. Bring your own license (BYOL) also allows you to select the DB edition using the optional parameter.

        This cannot be updated in parallel with any of the following: cpuCoreCount, computeCount, maxCpuCoreCount, dataStorageSizeInTBs, adminPassword, isMTLSConnectionRequired, dbWorkload, privateEndpointLabel, nsgIds, dbVersion, dbName, scheduledOperations, dbToolsDetails, or isFreeTier.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="maintenanceWindowDetails")
    def maintenance_window_details(self) -> pulumi.Output[Optional['outputs.CloudAutonomousVmClusterMaintenanceWindowDetails']]:
        """
        (Updatable) The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_window_details")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.CloudAutonomousVmClusterMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="maxAcdsLowestScaledValue")
    def max_acds_lowest_scaled_value(self) -> pulumi.Output[int]:
        """
        The lowest value to which maximum number of ACDs can be scaled down.
        """
        return pulumi.get(self, "max_acds_lowest_scaled_value")

    @property
    @pulumi.getter(name="memoryPerOracleComputeUnitInGbs")
    def memory_per_oracle_compute_unit_in_gbs(self) -> pulumi.Output[int]:
        """
        The amount of memory (in GBs) to be enabled per OCPU or ECPU.
        """
        return pulumi.get(self, "memory_per_oracle_compute_unit_in_gbs")

    @property
    @pulumi.getter(name="memorySizeInGbs")
    def memory_size_in_gbs(self) -> pulumi.Output[int]:
        """
        The memory allocated in GBs.
        """
        return pulumi.get(self, "memory_size_in_gbs")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of database servers in the cloud VM cluster.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nonProvisionableAutonomousContainerDatabases")
    def non_provisionable_autonomous_container_databases(self) -> pulumi.Output[int]:
        """
        The number of non-provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "non_provisionable_autonomous_container_databases")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> pulumi.Output[float]:
        """
        The number of CPU cores on the cloud Autonomous VM cluster. Only 1 decimal place is allowed for the fractional part.
        """
        return pulumi.get(self, "ocpu_count")

    @property
    @pulumi.getter(name="ocpusLowestScaledValue")
    def ocpus_lowest_scaled_value(self) -> pulumi.Output[int]:
        """
        The lowest value to which ocpus can be scaled down.
        """
        return pulumi.get(self, "ocpus_lowest_scaled_value")

    @property
    @pulumi.getter(name="provisionableAutonomousContainerDatabases")
    def provisionable_autonomous_container_databases(self) -> pulumi.Output[int]:
        """
        The number of provisionable Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisionable_autonomous_container_databases")

    @property
    @pulumi.getter(name="provisionedAutonomousContainerDatabases")
    def provisioned_autonomous_container_databases(self) -> pulumi.Output[int]:
        """
        The number of provisioned Autonomous Container Databases in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_autonomous_container_databases")

    @property
    @pulumi.getter(name="provisionedCpus")
    def provisioned_cpus(self) -> pulumi.Output[float]:
        """
        The number of CPUs provisioned in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "provisioned_cpus")

    @property
    @pulumi.getter(name="reclaimableCpus")
    def reclaimable_cpus(self) -> pulumi.Output[float]:
        """
        For Autonomous Databases on Dedicated Exadata Infrastructure:
        * These are the CPUs that continue to be included in the count of CPUs available to the Autonomous Container Database even after one of its Autonomous Database is terminated or scaled down. You can release them to the available CPUs at its parent Autonomous VM Cluster level by restarting the Autonomous Container Database.
        * The CPU type (OCPUs or ECPUs) is determined by the parent Autonomous Exadata VM Cluster's compute model.
        """
        return pulumi.get(self, "reclaimable_cpus")

    @property
    @pulumi.getter(name="reservedCpus")
    def reserved_cpus(self) -> pulumi.Output[float]:
        """
        The number of CPUs reserved in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "reserved_cpus")

    @property
    @pulumi.getter(name="scanListenerPortNonTls")
    def scan_listener_port_non_tls(self) -> pulumi.Output[int]:
        """
        The SCAN Listener Non TLS port. Default is 1521.
        """
        return pulumi.get(self, "scan_listener_port_non_tls")

    @property
    @pulumi.getter(name="scanListenerPortTls")
    def scan_listener_port_tls(self) -> pulumi.Output[int]:
        """
        The SCAN Listener TLS port. Default is 2484.
        """
        return pulumi.get(self, "scan_listener_port_tls")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The model name of the Exadata hardware running the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the cloud Autonomous VM cluster.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the cloud Autonomous VM Cluster is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time that the cloud Autonomous VM cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[Optional[str]]:
        """
        The last date and time that the cloud Autonomous VM cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="totalAutonomousDataStorageInTbs")
    def total_autonomous_data_storage_in_tbs(self) -> pulumi.Output[float]:
        """
        The total data disk group size for Autonomous Databases, in TBs.
        """
        return pulumi.get(self, "total_autonomous_data_storage_in_tbs")

    @property
    @pulumi.getter(name="totalContainerDatabases")
    def total_container_databases(self) -> pulumi.Output[int]:
        """
        (Updatable) The total number of Autonomous Container Databases that can be created.

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "total_container_databases")

    @property
    @pulumi.getter(name="totalCpus")
    def total_cpus(self) -> pulumi.Output[float]:
        """
        The total number of CPUs in an Autonomous VM Cluster.
        """
        return pulumi.get(self, "total_cpus")

