# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetExadbVmClusterUpdatesResult',
    'AwaitableGetExadbVmClusterUpdatesResult',
    'get_exadb_vm_cluster_updates',
    'get_exadb_vm_cluster_updates_output',
]

@pulumi.output_type
class GetExadbVmClusterUpdatesResult:
    """
    A collection of values returned by getExadbVmClusterUpdates.
    """
    def __init__(__self__, exadb_vm_cluster_id=None, exadb_vm_cluster_updates=None, filters=None, id=None, update_type=None, version=None):
        if exadb_vm_cluster_id and not isinstance(exadb_vm_cluster_id, str):
            raise TypeError("Expected argument 'exadb_vm_cluster_id' to be a str")
        pulumi.set(__self__, "exadb_vm_cluster_id", exadb_vm_cluster_id)
        if exadb_vm_cluster_updates and not isinstance(exadb_vm_cluster_updates, list):
            raise TypeError("Expected argument 'exadb_vm_cluster_updates' to be a list")
        pulumi.set(__self__, "exadb_vm_cluster_updates", exadb_vm_cluster_updates)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="exadbVmClusterId")
    def exadb_vm_cluster_id(self) -> str:
        return pulumi.get(self, "exadb_vm_cluster_id")

    @property
    @pulumi.getter(name="exadbVmClusterUpdates")
    def exadb_vm_cluster_updates(self) -> Sequence['outputs.GetExadbVmClusterUpdatesExadbVmClusterUpdateResult']:
        """
        The list of exadb_vm_cluster_updates.
        """
        return pulumi.get(self, "exadb_vm_cluster_updates")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetExadbVmClusterUpdatesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> Optional[str]:
        """
        The type of cloud VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the maintenance update package.
        """
        return pulumi.get(self, "version")


class AwaitableGetExadbVmClusterUpdatesResult(GetExadbVmClusterUpdatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExadbVmClusterUpdatesResult(
            exadb_vm_cluster_id=self.exadb_vm_cluster_id,
            exadb_vm_cluster_updates=self.exadb_vm_cluster_updates,
            filters=self.filters,
            id=self.id,
            update_type=self.update_type,
            version=self.version)


def get_exadb_vm_cluster_updates(exadb_vm_cluster_id: Optional[str] = None,
                                 filters: Optional[Sequence[Union['GetExadbVmClusterUpdatesFilterArgs', 'GetExadbVmClusterUpdatesFilterArgsDict']]] = None,
                                 update_type: Optional[str] = None,
                                 version: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExadbVmClusterUpdatesResult:
    """
    This data source provides the list of Exadb Vm Cluster Updates in Oracle Cloud Infrastructure Database service.

    Lists the maintenance updates that can be applied to the specified Exadata VM cluster on Exascale Infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster_updates = oci.Database.get_exadb_vm_cluster_updates(exadb_vm_cluster_id=test_exadb_vm_cluster["id"],
        update_type=exadb_vm_cluster_update_update_type,
        version=exadb_vm_cluster_update_version)
    ```


    :param str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str version: A filter to return only resources that match the given update version exactly.
    """
    __args__ = dict()
    __args__['exadbVmClusterId'] = exadb_vm_cluster_id
    __args__['filters'] = filters
    __args__['updateType'] = update_type
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getExadbVmClusterUpdates:getExadbVmClusterUpdates', __args__, opts=opts, typ=GetExadbVmClusterUpdatesResult).value

    return AwaitableGetExadbVmClusterUpdatesResult(
        exadb_vm_cluster_id=pulumi.get(__ret__, 'exadb_vm_cluster_id'),
        exadb_vm_cluster_updates=pulumi.get(__ret__, 'exadb_vm_cluster_updates'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        update_type=pulumi.get(__ret__, 'update_type'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_exadb_vm_cluster_updates)
def get_exadb_vm_cluster_updates_output(exadb_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetExadbVmClusterUpdatesFilterArgs', 'GetExadbVmClusterUpdatesFilterArgsDict']]]]] = None,
                                        update_type: Optional[pulumi.Input[Optional[str]]] = None,
                                        version: Optional[pulumi.Input[Optional[str]]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetExadbVmClusterUpdatesResult]:
    """
    This data source provides the list of Exadb Vm Cluster Updates in Oracle Cloud Infrastructure Database service.

    Lists the maintenance updates that can be applied to the specified Exadata VM cluster on Exascale Infrastructure.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_exadb_vm_cluster_updates = oci.Database.get_exadb_vm_cluster_updates(exadb_vm_cluster_id=test_exadb_vm_cluster["id"],
        update_type=exadb_vm_cluster_update_update_type,
        version=exadb_vm_cluster_update_version)
    ```


    :param str exadb_vm_cluster_id: The Exadata VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on Exascale Infrastructure.
    :param str update_type: A filter to return only resources that match the given update type exactly.
    :param str version: A filter to return only resources that match the given update version exactly.
    """
    ...
