# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult',
    'AwaitableGetManagedDatabaseSqlTuningAdvisorTasksFindingsResult',
    'get_managed_database_sql_tuning_advisor_tasks_findings',
    'get_managed_database_sql_tuning_advisor_tasks_findings_output',
]

@pulumi.output_type
class GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult:
    """
    A collection of values returned by getManagedDatabaseSqlTuningAdvisorTasksFindings.
    """
    def __init__(__self__, begin_exec_id=None, end_exec_id=None, filters=None, finding_filter=None, id=None, index_hash_filter=None, managed_database_id=None, opc_named_credential_id=None, search_period=None, sql_tuning_advisor_task_finding_collections=None, sql_tuning_advisor_task_id=None, stats_hash_filter=None):
        if begin_exec_id and not isinstance(begin_exec_id, str):
            raise TypeError("Expected argument 'begin_exec_id' to be a str")
        pulumi.set(__self__, "begin_exec_id", begin_exec_id)
        if end_exec_id and not isinstance(end_exec_id, str):
            raise TypeError("Expected argument 'end_exec_id' to be a str")
        pulumi.set(__self__, "end_exec_id", end_exec_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if finding_filter and not isinstance(finding_filter, str):
            raise TypeError("Expected argument 'finding_filter' to be a str")
        pulumi.set(__self__, "finding_filter", finding_filter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if index_hash_filter and not isinstance(index_hash_filter, str):
            raise TypeError("Expected argument 'index_hash_filter' to be a str")
        pulumi.set(__self__, "index_hash_filter", index_hash_filter)
        if managed_database_id and not isinstance(managed_database_id, str):
            raise TypeError("Expected argument 'managed_database_id' to be a str")
        pulumi.set(__self__, "managed_database_id", managed_database_id)
        if opc_named_credential_id and not isinstance(opc_named_credential_id, str):
            raise TypeError("Expected argument 'opc_named_credential_id' to be a str")
        pulumi.set(__self__, "opc_named_credential_id", opc_named_credential_id)
        if search_period and not isinstance(search_period, str):
            raise TypeError("Expected argument 'search_period' to be a str")
        pulumi.set(__self__, "search_period", search_period)
        if sql_tuning_advisor_task_finding_collections and not isinstance(sql_tuning_advisor_task_finding_collections, list):
            raise TypeError("Expected argument 'sql_tuning_advisor_task_finding_collections' to be a list")
        pulumi.set(__self__, "sql_tuning_advisor_task_finding_collections", sql_tuning_advisor_task_finding_collections)
        if sql_tuning_advisor_task_id and not isinstance(sql_tuning_advisor_task_id, str):
            raise TypeError("Expected argument 'sql_tuning_advisor_task_id' to be a str")
        pulumi.set(__self__, "sql_tuning_advisor_task_id", sql_tuning_advisor_task_id)
        if stats_hash_filter and not isinstance(stats_hash_filter, str):
            raise TypeError("Expected argument 'stats_hash_filter' to be a str")
        pulumi.set(__self__, "stats_hash_filter", stats_hash_filter)

    @property
    @pulumi.getter(name="beginExecId")
    def begin_exec_id(self) -> Optional[str]:
        return pulumi.get(self, "begin_exec_id")

    @property
    @pulumi.getter(name="endExecId")
    def end_exec_id(self) -> Optional[str]:
        return pulumi.get(self, "end_exec_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabaseSqlTuningAdvisorTasksFindingsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="findingFilter")
    def finding_filter(self) -> Optional[str]:
        return pulumi.get(self, "finding_filter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="indexHashFilter")
    def index_hash_filter(self) -> Optional[str]:
        return pulumi.get(self, "index_hash_filter")

    @property
    @pulumi.getter(name="managedDatabaseId")
    def managed_database_id(self) -> str:
        return pulumi.get(self, "managed_database_id")

    @property
    @pulumi.getter(name="opcNamedCredentialId")
    def opc_named_credential_id(self) -> Optional[str]:
        return pulumi.get(self, "opc_named_credential_id")

    @property
    @pulumi.getter(name="searchPeriod")
    def search_period(self) -> Optional[str]:
        return pulumi.get(self, "search_period")

    @property
    @pulumi.getter(name="sqlTuningAdvisorTaskFindingCollections")
    def sql_tuning_advisor_task_finding_collections(self) -> Sequence['outputs.GetManagedDatabaseSqlTuningAdvisorTasksFindingsSqlTuningAdvisorTaskFindingCollectionResult']:
        """
        The list of sql_tuning_advisor_task_finding_collection.
        """
        return pulumi.get(self, "sql_tuning_advisor_task_finding_collections")

    @property
    @pulumi.getter(name="sqlTuningAdvisorTaskId")
    def sql_tuning_advisor_task_id(self) -> str:
        """
        The unique identifier of the SQL Tuning Advisor task. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "sql_tuning_advisor_task_id")

    @property
    @pulumi.getter(name="statsHashFilter")
    def stats_hash_filter(self) -> Optional[str]:
        return pulumi.get(self, "stats_hash_filter")


class AwaitableGetManagedDatabaseSqlTuningAdvisorTasksFindingsResult(GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult(
            begin_exec_id=self.begin_exec_id,
            end_exec_id=self.end_exec_id,
            filters=self.filters,
            finding_filter=self.finding_filter,
            id=self.id,
            index_hash_filter=self.index_hash_filter,
            managed_database_id=self.managed_database_id,
            opc_named_credential_id=self.opc_named_credential_id,
            search_period=self.search_period,
            sql_tuning_advisor_task_finding_collections=self.sql_tuning_advisor_task_finding_collections,
            sql_tuning_advisor_task_id=self.sql_tuning_advisor_task_id,
            stats_hash_filter=self.stats_hash_filter)


def get_managed_database_sql_tuning_advisor_tasks_findings(begin_exec_id: Optional[str] = None,
                                                           end_exec_id: Optional[str] = None,
                                                           filters: Optional[Sequence[Union['GetManagedDatabaseSqlTuningAdvisorTasksFindingsFilterArgs', 'GetManagedDatabaseSqlTuningAdvisorTasksFindingsFilterArgsDict']]] = None,
                                                           finding_filter: Optional[str] = None,
                                                           index_hash_filter: Optional[str] = None,
                                                           managed_database_id: Optional[str] = None,
                                                           opc_named_credential_id: Optional[str] = None,
                                                           search_period: Optional[str] = None,
                                                           sql_tuning_advisor_task_id: Optional[str] = None,
                                                           stats_hash_filter: Optional[str] = None,
                                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabaseSqlTuningAdvisorTasksFindingsResult:
    """
    This data source provides the list of Managed Database Sql Tuning Advisor Tasks Findings in Oracle Cloud Infrastructure Database Management service.

    Gets an array of the details of the findings that match specific filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_tasks_findings = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_tasks_findings(managed_database_id=test_managed_database["id"],
        sql_tuning_advisor_task_id=test_sql_tuning_advisor_task["id"],
        begin_exec_id=test_begin_exec["id"],
        end_exec_id=test_end_exec["id"],
        finding_filter=managed_database_sql_tuning_advisor_tasks_finding_finding_filter,
        index_hash_filter=managed_database_sql_tuning_advisor_tasks_finding_index_hash_filter,
        opc_named_credential_id=managed_database_sql_tuning_advisor_tasks_finding_opc_named_credential_id,
        search_period=managed_database_sql_tuning_advisor_tasks_finding_search_period,
        stats_hash_filter=managed_database_sql_tuning_advisor_tasks_finding_stats_hash_filter)
    ```


    :param str begin_exec_id: The optional greater than or equal to filter on the execution ID related to a specific SQL Tuning Advisor task.
    :param str end_exec_id: The optional less than or equal to query parameter to filter on the execution ID related to a specific SQL Tuning Advisor task.
    :param str finding_filter: The filter used to display specific findings in the report.
    :param str index_hash_filter: The hash value of the index table name.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str search_period: The search period during which the API will search for begin and end exec id, if not supplied. Unused if beginExecId and endExecId optional query params are both supplied.
    :param str sql_tuning_advisor_task_id: The SQL tuning task identifier. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str stats_hash_filter: The hash value of the object for the statistic finding search.
    """
    __args__ = dict()
    __args__['beginExecId'] = begin_exec_id
    __args__['endExecId'] = end_exec_id
    __args__['filters'] = filters
    __args__['findingFilter'] = finding_filter
    __args__['indexHashFilter'] = index_hash_filter
    __args__['managedDatabaseId'] = managed_database_id
    __args__['opcNamedCredentialId'] = opc_named_credential_id
    __args__['searchPeriod'] = search_period
    __args__['sqlTuningAdvisorTaskId'] = sql_tuning_advisor_task_id
    __args__['statsHashFilter'] = stats_hash_filter
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabaseSqlTuningAdvisorTasksFindings:getManagedDatabaseSqlTuningAdvisorTasksFindings', __args__, opts=opts, typ=GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult).value

    return AwaitableGetManagedDatabaseSqlTuningAdvisorTasksFindingsResult(
        begin_exec_id=pulumi.get(__ret__, 'begin_exec_id'),
        end_exec_id=pulumi.get(__ret__, 'end_exec_id'),
        filters=pulumi.get(__ret__, 'filters'),
        finding_filter=pulumi.get(__ret__, 'finding_filter'),
        id=pulumi.get(__ret__, 'id'),
        index_hash_filter=pulumi.get(__ret__, 'index_hash_filter'),
        managed_database_id=pulumi.get(__ret__, 'managed_database_id'),
        opc_named_credential_id=pulumi.get(__ret__, 'opc_named_credential_id'),
        search_period=pulumi.get(__ret__, 'search_period'),
        sql_tuning_advisor_task_finding_collections=pulumi.get(__ret__, 'sql_tuning_advisor_task_finding_collections'),
        sql_tuning_advisor_task_id=pulumi.get(__ret__, 'sql_tuning_advisor_task_id'),
        stats_hash_filter=pulumi.get(__ret__, 'stats_hash_filter'))


@_utilities.lift_output_func(get_managed_database_sql_tuning_advisor_tasks_findings)
def get_managed_database_sql_tuning_advisor_tasks_findings_output(begin_exec_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  end_exec_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedDatabaseSqlTuningAdvisorTasksFindingsFilterArgs', 'GetManagedDatabaseSqlTuningAdvisorTasksFindingsFilterArgsDict']]]]] = None,
                                                                  finding_filter: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  index_hash_filter: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  managed_database_id: Optional[pulumi.Input[str]] = None,
                                                                  opc_named_credential_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  search_period: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  sql_tuning_advisor_task_id: Optional[pulumi.Input[str]] = None,
                                                                  stats_hash_filter: Optional[pulumi.Input[Optional[str]]] = None,
                                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabaseSqlTuningAdvisorTasksFindingsResult]:
    """
    This data source provides the list of Managed Database Sql Tuning Advisor Tasks Findings in Oracle Cloud Infrastructure Database Management service.

    Gets an array of the details of the findings that match specific filters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_database_sql_tuning_advisor_tasks_findings = oci.DatabaseManagement.get_managed_database_sql_tuning_advisor_tasks_findings(managed_database_id=test_managed_database["id"],
        sql_tuning_advisor_task_id=test_sql_tuning_advisor_task["id"],
        begin_exec_id=test_begin_exec["id"],
        end_exec_id=test_end_exec["id"],
        finding_filter=managed_database_sql_tuning_advisor_tasks_finding_finding_filter,
        index_hash_filter=managed_database_sql_tuning_advisor_tasks_finding_index_hash_filter,
        opc_named_credential_id=managed_database_sql_tuning_advisor_tasks_finding_opc_named_credential_id,
        search_period=managed_database_sql_tuning_advisor_tasks_finding_search_period,
        stats_hash_filter=managed_database_sql_tuning_advisor_tasks_finding_stats_hash_filter)
    ```


    :param str begin_exec_id: The optional greater than or equal to filter on the execution ID related to a specific SQL Tuning Advisor task.
    :param str end_exec_id: The optional less than or equal to query parameter to filter on the execution ID related to a specific SQL Tuning Advisor task.
    :param str finding_filter: The filter used to display specific findings in the report.
    :param str index_hash_filter: The hash value of the index table name.
    :param str managed_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database.
    :param str opc_named_credential_id: The OCID of the Named Credential.
    :param str search_period: The search period during which the API will search for begin and end exec id, if not supplied. Unused if beginExecId and endExecId optional query params are both supplied.
    :param str sql_tuning_advisor_task_id: The SQL tuning task identifier. This is not the [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    :param str stats_hash_filter: The hash value of the object for the statistic finding search.
    """
    ...
