# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DesktopPoolAvailabilityPolicy',
    'DesktopPoolAvailabilityPolicyStartSchedule',
    'DesktopPoolAvailabilityPolicyStopSchedule',
    'DesktopPoolDevicePolicy',
    'DesktopPoolImage',
    'DesktopPoolNetworkConfiguration',
    'GetDesktopDevicePolicyResult',
    'GetDesktopHostingOptionResult',
    'GetDesktopHostingOptionImageResult',
    'GetDesktopPoolAvailabilityPolicyResult',
    'GetDesktopPoolAvailabilityPolicyStartScheduleResult',
    'GetDesktopPoolAvailabilityPolicyStopScheduleResult',
    'GetDesktopPoolDesktopsDesktopPoolDesktopCollectionResult',
    'GetDesktopPoolDesktopsDesktopPoolDesktopCollectionItemResult',
    'GetDesktopPoolDesktopsFilterResult',
    'GetDesktopPoolDevicePolicyResult',
    'GetDesktopPoolImageResult',
    'GetDesktopPoolNetworkConfigurationResult',
    'GetDesktopPoolVolumesDesktopPoolVolumeCollectionResult',
    'GetDesktopPoolVolumesDesktopPoolVolumeCollectionItemResult',
    'GetDesktopPoolVolumesFilterResult',
    'GetDesktopPoolsDesktopPoolCollectionResult',
    'GetDesktopPoolsDesktopPoolCollectionItemResult',
    'GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyResult',
    'GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStartScheduleResult',
    'GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStopScheduleResult',
    'GetDesktopPoolsDesktopPoolCollectionItemDevicePolicyResult',
    'GetDesktopPoolsDesktopPoolCollectionItemImageResult',
    'GetDesktopPoolsDesktopPoolCollectionItemNetworkConfigurationResult',
    'GetDesktopPoolsFilterResult',
    'GetDesktopsDesktopCollectionResult',
    'GetDesktopsDesktopCollectionItemResult',
    'GetDesktopsFilterResult',
]

@pulumi.output_type
class DesktopPoolAvailabilityPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startSchedule":
            suggest = "start_schedule"
        elif key == "stopSchedule":
            suggest = "stop_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolAvailabilityPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolAvailabilityPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolAvailabilityPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_schedule: 'outputs.DesktopPoolAvailabilityPolicyStartSchedule',
                 stop_schedule: 'outputs.DesktopPoolAvailabilityPolicyStopSchedule'):
        """
        :param 'DesktopPoolAvailabilityPolicyStartScheduleArgs' start_schedule: (Updatable) Provides the schedule information for a desktop.
        :param 'DesktopPoolAvailabilityPolicyStopScheduleArgs' stop_schedule: (Updatable) Provides the schedule information for a desktop.
        """
        pulumi.set(__self__, "start_schedule", start_schedule)
        pulumi.set(__self__, "stop_schedule", stop_schedule)

    @property
    @pulumi.getter(name="startSchedule")
    def start_schedule(self) -> 'outputs.DesktopPoolAvailabilityPolicyStartSchedule':
        """
        (Updatable) Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "start_schedule")

    @property
    @pulumi.getter(name="stopSchedule")
    def stop_schedule(self) -> 'outputs.DesktopPoolAvailabilityPolicyStopSchedule':
        """
        (Updatable) Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "stop_schedule")


@pulumi.output_type
class DesktopPoolAvailabilityPolicyStartSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolAvailabilityPolicyStartSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolAvailabilityPolicyStartSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolAvailabilityPolicyStartSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: (Updatable) A cron expression describing the desktop's schedule.
        :param str timezone: (Updatable) The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        (Updatable) The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class DesktopPoolAvailabilityPolicyStopSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cronExpression":
            suggest = "cron_expression"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolAvailabilityPolicyStopSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolAvailabilityPolicyStopSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolAvailabilityPolicyStopSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: (Updatable) A cron expression describing the desktop's schedule.
        :param str timezone: (Updatable) The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        (Updatable) A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        (Updatable) The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class DesktopPoolDevicePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "audioMode":
            suggest = "audio_mode"
        elif key == "cdmMode":
            suggest = "cdm_mode"
        elif key == "clipboardMode":
            suggest = "clipboard_mode"
        elif key == "isDisplayEnabled":
            suggest = "is_display_enabled"
        elif key == "isKeyboardEnabled":
            suggest = "is_keyboard_enabled"
        elif key == "isPointerEnabled":
            suggest = "is_pointer_enabled"
        elif key == "isPrintingEnabled":
            suggest = "is_printing_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolDevicePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolDevicePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolDevicePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audio_mode: str,
                 cdm_mode: str,
                 clipboard_mode: str,
                 is_display_enabled: bool,
                 is_keyboard_enabled: bool,
                 is_pointer_enabled: bool,
                 is_printing_enabled: bool):
        """
        :param str audio_mode: (Updatable) The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        :param str cdm_mode: (Updatable) The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        :param str clipboard_mode: (Updatable) The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        :param bool is_display_enabled: (Updatable) Indicates whether the display is enabled.
        :param bool is_keyboard_enabled: (Updatable) Indicates whether the keyboard is enabled.
        :param bool is_pointer_enabled: (Updatable) Indicates whether the pointer is enabled.
        :param bool is_printing_enabled: (Updatable) Indicates whether printing is enabled.
        """
        pulumi.set(__self__, "audio_mode", audio_mode)
        pulumi.set(__self__, "cdm_mode", cdm_mode)
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "is_display_enabled", is_display_enabled)
        pulumi.set(__self__, "is_keyboard_enabled", is_keyboard_enabled)
        pulumi.set(__self__, "is_pointer_enabled", is_pointer_enabled)
        pulumi.set(__self__, "is_printing_enabled", is_printing_enabled)

    @property
    @pulumi.getter(name="audioMode")
    def audio_mode(self) -> str:
        """
        (Updatable) The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        return pulumi.get(self, "audio_mode")

    @property
    @pulumi.getter(name="cdmMode")
    def cdm_mode(self) -> str:
        """
        (Updatable) The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        return pulumi.get(self, "cdm_mode")

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> str:
        """
        (Updatable) The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="isDisplayEnabled")
    def is_display_enabled(self) -> bool:
        """
        (Updatable) Indicates whether the display is enabled.
        """
        return pulumi.get(self, "is_display_enabled")

    @property
    @pulumi.getter(name="isKeyboardEnabled")
    def is_keyboard_enabled(self) -> bool:
        """
        (Updatable) Indicates whether the keyboard is enabled.
        """
        return pulumi.get(self, "is_keyboard_enabled")

    @property
    @pulumi.getter(name="isPointerEnabled")
    def is_pointer_enabled(self) -> bool:
        """
        (Updatable) Indicates whether the pointer is enabled.
        """
        return pulumi.get(self, "is_pointer_enabled")

    @property
    @pulumi.getter(name="isPrintingEnabled")
    def is_printing_enabled(self) -> bool:
        """
        (Updatable) Indicates whether printing is enabled.
        """
        return pulumi.get(self, "is_printing_enabled")


@pulumi.output_type
class DesktopPoolImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "imageName":
            suggest = "image_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: str,
                 image_name: str):
        """
        :param str image_id: The OCID of the desktop image.
        :param str image_name: The name of the desktop image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the desktop image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the desktop image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class DesktopPoolNetworkConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "vcnId":
            suggest = "vcn_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DesktopPoolNetworkConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DesktopPoolNetworkConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DesktopPoolNetworkConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param str subnet_id: The OCID of the subnet to use for the desktop pool.
        :param str vcn_id: The OCID of the VCN used by the desktop pool.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet to use for the desktop pool.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN used by the desktop pool.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetDesktopDevicePolicyResult(dict):
    def __init__(__self__, *,
                 audio_mode: str,
                 cdm_mode: str,
                 clipboard_mode: str,
                 is_display_enabled: bool,
                 is_keyboard_enabled: bool,
                 is_pointer_enabled: bool,
                 is_printing_enabled: bool):
        """
        :param str audio_mode: The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        :param str cdm_mode: The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        :param str clipboard_mode: The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        :param bool is_display_enabled: Indicates whether the display is enabled.
        :param bool is_keyboard_enabled: Indicates whether the keyboard is enabled.
        :param bool is_pointer_enabled: Indicates whether the pointer is enabled.
        :param bool is_printing_enabled: Indicates whether printing is enabled.
        """
        pulumi.set(__self__, "audio_mode", audio_mode)
        pulumi.set(__self__, "cdm_mode", cdm_mode)
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "is_display_enabled", is_display_enabled)
        pulumi.set(__self__, "is_keyboard_enabled", is_keyboard_enabled)
        pulumi.set(__self__, "is_pointer_enabled", is_pointer_enabled)
        pulumi.set(__self__, "is_printing_enabled", is_printing_enabled)

    @property
    @pulumi.getter(name="audioMode")
    def audio_mode(self) -> str:
        """
        The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        return pulumi.get(self, "audio_mode")

    @property
    @pulumi.getter(name="cdmMode")
    def cdm_mode(self) -> str:
        """
        The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        return pulumi.get(self, "cdm_mode")

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> str:
        """
        The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="isDisplayEnabled")
    def is_display_enabled(self) -> bool:
        """
        Indicates whether the display is enabled.
        """
        return pulumi.get(self, "is_display_enabled")

    @property
    @pulumi.getter(name="isKeyboardEnabled")
    def is_keyboard_enabled(self) -> bool:
        """
        Indicates whether the keyboard is enabled.
        """
        return pulumi.get(self, "is_keyboard_enabled")

    @property
    @pulumi.getter(name="isPointerEnabled")
    def is_pointer_enabled(self) -> bool:
        """
        Indicates whether the pointer is enabled.
        """
        return pulumi.get(self, "is_pointer_enabled")

    @property
    @pulumi.getter(name="isPrintingEnabled")
    def is_printing_enabled(self) -> bool:
        """
        Indicates whether printing is enabled.
        """
        return pulumi.get(self, "is_printing_enabled")


@pulumi.output_type
class GetDesktopHostingOptionResult(dict):
    def __init__(__self__, *,
                 connect_address: str,
                 images: Sequence['outputs.GetDesktopHostingOptionImageResult']):
        """
        :param str connect_address: The connection address of the desktop.
        :param Sequence['GetDesktopHostingOptionImageArgs'] images: Provides information about the desktop image.
        """
        pulumi.set(__self__, "connect_address", connect_address)
        pulumi.set(__self__, "images", images)

    @property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> str:
        """
        The connection address of the desktop.
        """
        return pulumi.get(self, "connect_address")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetDesktopHostingOptionImageResult']:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "images")


@pulumi.output_type
class GetDesktopHostingOptionImageResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 image_name: str):
        """
        :param str image_id: The OCID of the desktop image.
        :param str image_name: The name of the desktop image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the desktop image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the desktop image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class GetDesktopPoolAvailabilityPolicyResult(dict):
    def __init__(__self__, *,
                 start_schedules: Sequence['outputs.GetDesktopPoolAvailabilityPolicyStartScheduleResult'],
                 stop_schedules: Sequence['outputs.GetDesktopPoolAvailabilityPolicyStopScheduleResult']):
        """
        :param Sequence['GetDesktopPoolAvailabilityPolicyStartScheduleArgs'] start_schedules: Provides the schedule information for a desktop.
        :param Sequence['GetDesktopPoolAvailabilityPolicyStopScheduleArgs'] stop_schedules: Provides the schedule information for a desktop.
        """
        pulumi.set(__self__, "start_schedules", start_schedules)
        pulumi.set(__self__, "stop_schedules", stop_schedules)

    @property
    @pulumi.getter(name="startSchedules")
    def start_schedules(self) -> Sequence['outputs.GetDesktopPoolAvailabilityPolicyStartScheduleResult']:
        """
        Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "start_schedules")

    @property
    @pulumi.getter(name="stopSchedules")
    def stop_schedules(self) -> Sequence['outputs.GetDesktopPoolAvailabilityPolicyStopScheduleResult']:
        """
        Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "stop_schedules")


@pulumi.output_type
class GetDesktopPoolAvailabilityPolicyStartScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: A cron expression describing the desktop's schedule.
        :param str timezone: The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetDesktopPoolAvailabilityPolicyStopScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: A cron expression describing the desktop's schedule.
        :param str timezone: The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetDesktopPoolDesktopsDesktopPoolDesktopCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDesktopPoolDesktopsDesktopPoolDesktopCollectionItemResult']):
        """
        :param Sequence['GetDesktopPoolDesktopsDesktopPoolDesktopCollectionItemArgs'] items: A list of desktops.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDesktopPoolDesktopsDesktopPoolDesktopCollectionItemResult']:
        """
        A list of desktops.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDesktopPoolDesktopsDesktopPoolDesktopCollectionItemResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, str],
                 desktop_id: str,
                 freeform_tags: Mapping[str, str],
                 instance_id: str,
                 is_assigned: bool,
                 state: str,
                 time_created: str,
                 user_name: str):
        """
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str desktop_id: The OCID of the desktop.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str instance_id: The OCID of the compute resource used by this desktop.
        :param bool is_assigned: Indicates whether the desktop is assigned to a user.
        :param str state: A filter to return only results with the given lifecycleState.
        :param str time_created: The date and time the resource was created.
        :param str user_name: The owner of the desktop.
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "desktop_id", desktop_id)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "is_assigned", is_assigned)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="desktopId")
    def desktop_id(self) -> str:
        """
        The OCID of the desktop.
        """
        return pulumi.get(self, "desktop_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The OCID of the compute resource used by this desktop.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="isAssigned")
    def is_assigned(self) -> bool:
        """
        Indicates whether the desktop is assigned to a user.
        """
        return pulumi.get(self, "is_assigned")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only results with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The owner of the desktop.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetDesktopPoolDesktopsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDesktopPoolDevicePolicyResult(dict):
    def __init__(__self__, *,
                 audio_mode: str,
                 cdm_mode: str,
                 clipboard_mode: str,
                 is_display_enabled: bool,
                 is_keyboard_enabled: bool,
                 is_pointer_enabled: bool,
                 is_printing_enabled: bool):
        """
        :param str audio_mode: The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        :param str cdm_mode: The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        :param str clipboard_mode: The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        :param bool is_display_enabled: Indicates whether the display is enabled.
        :param bool is_keyboard_enabled: Indicates whether the keyboard is enabled.
        :param bool is_pointer_enabled: Indicates whether the pointer is enabled.
        :param bool is_printing_enabled: Indicates whether printing is enabled.
        """
        pulumi.set(__self__, "audio_mode", audio_mode)
        pulumi.set(__self__, "cdm_mode", cdm_mode)
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "is_display_enabled", is_display_enabled)
        pulumi.set(__self__, "is_keyboard_enabled", is_keyboard_enabled)
        pulumi.set(__self__, "is_pointer_enabled", is_pointer_enabled)
        pulumi.set(__self__, "is_printing_enabled", is_printing_enabled)

    @property
    @pulumi.getter(name="audioMode")
    def audio_mode(self) -> str:
        """
        The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        return pulumi.get(self, "audio_mode")

    @property
    @pulumi.getter(name="cdmMode")
    def cdm_mode(self) -> str:
        """
        The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        return pulumi.get(self, "cdm_mode")

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> str:
        """
        The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="isDisplayEnabled")
    def is_display_enabled(self) -> bool:
        """
        Indicates whether the display is enabled.
        """
        return pulumi.get(self, "is_display_enabled")

    @property
    @pulumi.getter(name="isKeyboardEnabled")
    def is_keyboard_enabled(self) -> bool:
        """
        Indicates whether the keyboard is enabled.
        """
        return pulumi.get(self, "is_keyboard_enabled")

    @property
    @pulumi.getter(name="isPointerEnabled")
    def is_pointer_enabled(self) -> bool:
        """
        Indicates whether the pointer is enabled.
        """
        return pulumi.get(self, "is_pointer_enabled")

    @property
    @pulumi.getter(name="isPrintingEnabled")
    def is_printing_enabled(self) -> bool:
        """
        Indicates whether printing is enabled.
        """
        return pulumi.get(self, "is_printing_enabled")


@pulumi.output_type
class GetDesktopPoolImageResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 image_name: str):
        """
        :param str image_id: The OCID of the desktop image.
        :param str image_name: The name of the desktop image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the desktop image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the desktop image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class GetDesktopPoolNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param str subnet_id: The OCID of the subnet to use for the desktop pool.
        :param str vcn_id: The OCID of the VCN used by the desktop pool.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet to use for the desktop pool.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN used by the desktop pool.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetDesktopPoolVolumesDesktopPoolVolumeCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDesktopPoolVolumesDesktopPoolVolumeCollectionItemResult']):
        """
        :param Sequence['GetDesktopPoolVolumesDesktopPoolVolumeCollectionItemArgs'] items: A list of desktop pool volumes.
        """
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDesktopPoolVolumesDesktopPoolVolumeCollectionItemResult']:
        """
        A list of desktop pool volumes.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDesktopPoolVolumesDesktopPoolVolumeCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 defined_tags: Mapping[str, str],
                 freeform_tags: Mapping[str, str],
                 id: str,
                 name: str,
                 pool_id: str,
                 state: str,
                 user_name: str):
        """
        :param str availability_domain: The name of the availability domain.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: A filter to return only results with the given OCID.
        :param str name: The name of the desktop pool volume.
        :param str pool_id: The OCID of the desktop pool to which this volume belongs.
        :param str state: A filter to return only results with the given lifecycleState.
        :param str user_name: The owner of the desktop pool volume.
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only results with the given OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the desktop pool volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The OCID of the desktop pool to which this volume belongs.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only results with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The owner of the desktop pool volume.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetDesktopPoolVolumesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name of the desktop pool volume.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the desktop pool volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemResult(dict):
    def __init__(__self__, *,
                 active_desktops: int,
                 are_privileged_users: bool,
                 availability_domain: str,
                 availability_policies: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyResult'],
                 compartment_id: str,
                 contact_details: str,
                 defined_tags: Mapping[str, str],
                 description: str,
                 device_policies: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemDevicePolicyResult'],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 images: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemImageResult'],
                 is_storage_enabled: bool,
                 maximum_size: int,
                 network_configurations: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemNetworkConfigurationResult'],
                 nsg_ids: Sequence[str],
                 shape_name: str,
                 standby_size: int,
                 state: str,
                 storage_backup_policy_id: str,
                 storage_size_in_gbs: int,
                 time_created: str,
                 time_start_scheduled: str,
                 time_stop_scheduled: str):
        """
        :param int active_desktops: The number of active desktops in the desktop pool.
        :param bool are_privileged_users: Indicates whether desktop pool users have administrative privileges on their desktop.
        :param str availability_domain: The name of the availability domain.
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyArgs'] availability_policies: Provides the start and stop schedule information for desktop availability of the desktop pool.
        :param str compartment_id: The OCID of the compartment of the desktop pool.
        :param str contact_details: Contact information of the desktop pool administrator. Avoid entering confidential information.
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: A user friendly description providing additional information about the resource. Avoid entering confidential information.
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemDevicePolicyArgs'] device_policies: Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        :param str display_name: A filter to return only results with the given displayName.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: A filter to return only results with the given OCID.
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemImageArgs'] images: Provides information about the desktop image.
        :param bool is_storage_enabled: Indicates whether storage is enabled for the desktop pool.
        :param int maximum_size: The maximum number of desktops permitted in the desktop pool.
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemNetworkConfigurationArgs'] network_configurations: Provides information about the network configuration of the desktop pool.
        :param Sequence[str] nsg_ids: A list of network security groups for the desktop pool.
        :param str shape_name: The shape of the desktop pool.
        :param int standby_size: The maximum number of standby desktops available in the desktop pool.
        :param str state: A filter to return only results with the given lifecycleState.
        :param str storage_backup_policy_id: The backup policy OCID of the storage.
        :param int storage_size_in_gbs: The size in GBs of the storage for the desktop pool.
        :param str time_created: The date and time the resource was created.
        :param str time_start_scheduled: The start time of the desktop pool.
        :param str time_stop_scheduled: The stop time of the desktop pool.
        """
        pulumi.set(__self__, "active_desktops", active_desktops)
        pulumi.set(__self__, "are_privileged_users", are_privileged_users)
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "availability_policies", availability_policies)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "contact_details", contact_details)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "device_policies", device_policies)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "images", images)
        pulumi.set(__self__, "is_storage_enabled", is_storage_enabled)
        pulumi.set(__self__, "maximum_size", maximum_size)
        pulumi.set(__self__, "network_configurations", network_configurations)
        pulumi.set(__self__, "nsg_ids", nsg_ids)
        pulumi.set(__self__, "shape_name", shape_name)
        pulumi.set(__self__, "standby_size", standby_size)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "storage_backup_policy_id", storage_backup_policy_id)
        pulumi.set(__self__, "storage_size_in_gbs", storage_size_in_gbs)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_start_scheduled", time_start_scheduled)
        pulumi.set(__self__, "time_stop_scheduled", time_stop_scheduled)

    @property
    @pulumi.getter(name="activeDesktops")
    def active_desktops(self) -> int:
        """
        The number of active desktops in the desktop pool.
        """
        return pulumi.get(self, "active_desktops")

    @property
    @pulumi.getter(name="arePrivilegedUsers")
    def are_privileged_users(self) -> bool:
        """
        Indicates whether desktop pool users have administrative privileges on their desktop.
        """
        return pulumi.get(self, "are_privileged_users")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="availabilityPolicies")
    def availability_policies(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyResult']:
        """
        Provides the start and stop schedule information for desktop availability of the desktop pool.
        """
        return pulumi.get(self, "availability_policies")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment of the desktop pool.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contactDetails")
    def contact_details(self) -> str:
        """
        Contact information of the desktop pool administrator. Avoid entering confidential information.
        """
        return pulumi.get(self, "contact_details")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A user friendly description providing additional information about the resource. Avoid entering confidential information.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="devicePolicies")
    def device_policies(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemDevicePolicyResult']:
        """
        Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
        """
        return pulumi.get(self, "device_policies")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only results with the given displayName.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only results with the given OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def images(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemImageResult']:
        """
        Provides information about the desktop image.
        """
        return pulumi.get(self, "images")

    @property
    @pulumi.getter(name="isStorageEnabled")
    def is_storage_enabled(self) -> bool:
        """
        Indicates whether storage is enabled for the desktop pool.
        """
        return pulumi.get(self, "is_storage_enabled")

    @property
    @pulumi.getter(name="maximumSize")
    def maximum_size(self) -> int:
        """
        The maximum number of desktops permitted in the desktop pool.
        """
        return pulumi.get(self, "maximum_size")

    @property
    @pulumi.getter(name="networkConfigurations")
    def network_configurations(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemNetworkConfigurationResult']:
        """
        Provides information about the network configuration of the desktop pool.
        """
        return pulumi.get(self, "network_configurations")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        A list of network security groups for the desktop pool.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        The shape of the desktop pool.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter(name="standbySize")
    def standby_size(self) -> int:
        """
        The maximum number of standby desktops available in the desktop pool.
        """
        return pulumi.get(self, "standby_size")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only results with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageBackupPolicyId")
    def storage_backup_policy_id(self) -> str:
        """
        The backup policy OCID of the storage.
        """
        return pulumi.get(self, "storage_backup_policy_id")

    @property
    @pulumi.getter(name="storageSizeInGbs")
    def storage_size_in_gbs(self) -> int:
        """
        The size in GBs of the storage for the desktop pool.
        """
        return pulumi.get(self, "storage_size_in_gbs")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeStartScheduled")
    def time_start_scheduled(self) -> str:
        """
        The start time of the desktop pool.
        """
        return pulumi.get(self, "time_start_scheduled")

    @property
    @pulumi.getter(name="timeStopScheduled")
    def time_stop_scheduled(self) -> str:
        """
        The stop time of the desktop pool.
        """
        return pulumi.get(self, "time_stop_scheduled")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyResult(dict):
    def __init__(__self__, *,
                 start_schedules: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStartScheduleResult'],
                 stop_schedules: Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStopScheduleResult']):
        """
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStartScheduleArgs'] start_schedules: Provides the schedule information for a desktop.
        :param Sequence['GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStopScheduleArgs'] stop_schedules: Provides the schedule information for a desktop.
        """
        pulumi.set(__self__, "start_schedules", start_schedules)
        pulumi.set(__self__, "stop_schedules", stop_schedules)

    @property
    @pulumi.getter(name="startSchedules")
    def start_schedules(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStartScheduleResult']:
        """
        Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "start_schedules")

    @property
    @pulumi.getter(name="stopSchedules")
    def stop_schedules(self) -> Sequence['outputs.GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStopScheduleResult']:
        """
        Provides the schedule information for a desktop.
        """
        return pulumi.get(self, "stop_schedules")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStartScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: A cron expression describing the desktop's schedule.
        :param str timezone: The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemAvailabilityPolicyStopScheduleResult(dict):
    def __init__(__self__, *,
                 cron_expression: str,
                 timezone: str):
        """
        :param str cron_expression: A cron expression describing the desktop's schedule.
        :param str timezone: The timezone of the desktop's schedule.
        """
        pulumi.set(__self__, "cron_expression", cron_expression)
        pulumi.set(__self__, "timezone", timezone)

    @property
    @pulumi.getter(name="cronExpression")
    def cron_expression(self) -> str:
        """
        A cron expression describing the desktop's schedule.
        """
        return pulumi.get(self, "cron_expression")

    @property
    @pulumi.getter
    def timezone(self) -> str:
        """
        The timezone of the desktop's schedule.
        """
        return pulumi.get(self, "timezone")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemDevicePolicyResult(dict):
    def __init__(__self__, *,
                 audio_mode: str,
                 cdm_mode: str,
                 clipboard_mode: str,
                 is_display_enabled: bool,
                 is_keyboard_enabled: bool,
                 is_pointer_enabled: bool,
                 is_printing_enabled: bool):
        """
        :param str audio_mode: The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        :param str cdm_mode: The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        :param str clipboard_mode: The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        :param bool is_display_enabled: Indicates whether the display is enabled.
        :param bool is_keyboard_enabled: Indicates whether the keyboard is enabled.
        :param bool is_pointer_enabled: Indicates whether the pointer is enabled.
        :param bool is_printing_enabled: Indicates whether printing is enabled.
        """
        pulumi.set(__self__, "audio_mode", audio_mode)
        pulumi.set(__self__, "cdm_mode", cdm_mode)
        pulumi.set(__self__, "clipboard_mode", clipboard_mode)
        pulumi.set(__self__, "is_display_enabled", is_display_enabled)
        pulumi.set(__self__, "is_keyboard_enabled", is_keyboard_enabled)
        pulumi.set(__self__, "is_pointer_enabled", is_pointer_enabled)
        pulumi.set(__self__, "is_printing_enabled", is_printing_enabled)

    @property
    @pulumi.getter(name="audioMode")
    def audio_mode(self) -> str:
        """
        The audio mode. NONE: No access to the local audio devices is permitted. TODESKTOP: The user may record audio on their desktop.  FROMDESKTOP: The user may play audio on their desktop. FULL: The user may play and record audio on their desktop.
        """
        return pulumi.get(self, "audio_mode")

    @property
    @pulumi.getter(name="cdmMode")
    def cdm_mode(self) -> str:
        """
        The client local drive access mode. NONE: No access to local drives permitted. READONLY: The user may read from local drives on their desktop. FULL: The user may read from and write to their local drives on their desktop.
        """
        return pulumi.get(self, "cdm_mode")

    @property
    @pulumi.getter(name="clipboardMode")
    def clipboard_mode(self) -> str:
        """
        The clipboard mode. NONE: No access to the local clipboard is permitted. TODESKTOP: The clipboard can be used to transfer data to the desktop only.  FROMDESKTOP: The clipboard can be used to transfer data from the desktop only. FULL: The clipboard can be used to transfer data to and from the desktop.
        """
        return pulumi.get(self, "clipboard_mode")

    @property
    @pulumi.getter(name="isDisplayEnabled")
    def is_display_enabled(self) -> bool:
        """
        Indicates whether the display is enabled.
        """
        return pulumi.get(self, "is_display_enabled")

    @property
    @pulumi.getter(name="isKeyboardEnabled")
    def is_keyboard_enabled(self) -> bool:
        """
        Indicates whether the keyboard is enabled.
        """
        return pulumi.get(self, "is_keyboard_enabled")

    @property
    @pulumi.getter(name="isPointerEnabled")
    def is_pointer_enabled(self) -> bool:
        """
        Indicates whether the pointer is enabled.
        """
        return pulumi.get(self, "is_pointer_enabled")

    @property
    @pulumi.getter(name="isPrintingEnabled")
    def is_printing_enabled(self) -> bool:
        """
        Indicates whether printing is enabled.
        """
        return pulumi.get(self, "is_printing_enabled")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemImageResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 image_name: str):
        """
        :param str image_id: The OCID of the desktop image.
        :param str image_name: The name of the desktop image.
        """
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the desktop image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of the desktop image.
        """
        return pulumi.get(self, "image_name")


@pulumi.output_type
class GetDesktopPoolsDesktopPoolCollectionItemNetworkConfigurationResult(dict):
    def __init__(__self__, *,
                 subnet_id: str,
                 vcn_id: str):
        """
        :param str subnet_id: The OCID of the subnet to use for the desktop pool.
        :param str vcn_id: The OCID of the VCN used by the desktop pool.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet to use for the desktop pool.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the VCN used by the desktop pool.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetDesktopPoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDesktopsDesktopCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDesktopsDesktopCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDesktopsDesktopCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDesktopsDesktopCollectionItemResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, str],
                 display_name: str,
                 freeform_tags: Mapping[str, str],
                 id: str,
                 pool_id: str,
                 state: str,
                 time_created: str,
                 user_name: str):
        """
        :param Mapping[str, str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only results with the given displayName.
        :param Mapping[str, str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: A filter to return only results with the given OCID.
        :param str pool_id: The OCID of the desktop pool the desktop is a member of.
        :param str state: A filter to return only results with the given lifecycleState.
        :param str time_created: The date and time the resource was created.
        :param str user_name: The owner of the desktop.
        """
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only results with the given displayName.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return only results with the given OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> str:
        """
        The OCID of the desktop pool the desktop is a member of.
        """
        return pulumi.get(self, "pool_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only results with the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> str:
        """
        The owner of the desktop.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class GetDesktopsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


