# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LoadBalancerArgs', 'LoadBalancer']

@pulumi.input_type
class LoadBalancerArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 shape: pulumi.Input[str],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ip_mode: Optional[pulumi.Input[str]] = None,
                 is_delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 is_request_id_enabled: Optional[pulumi.Input[bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id_header: Optional[pulumi.Input[str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]] = None,
                 shape_details: Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']] = None):
        """
        The set of arguments for constructing a LoadBalancer resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        :param pulumi.Input[str] shape: (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] ip_mode: IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.
               
               If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.
               
               If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.
               
               Example: "ipMode":"IPV6"
        :param pulumi.Input[bool] is_delete_protection_enabled: (Updatable) Whether or not the load balancer has delete protection enabled.
               
               If "true", the loadbalancer will be protected against deletion if configured to accept traffic.
               
               If "false", the loadbalancer will not be protected against deletion.
               
               Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        :param pulumi.Input[bool] is_private: Whether the load balancer has a VCN-local (private) IP address.
               
               If "true", the service assigns a private IP address to the load balancer.
               
               If "false", the service assigns a public IP address to the load balancer.
               
               A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).
               
               Example: `true`
        :param pulumi.Input[bool] is_request_id_enabled: (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
               
               If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.
               
               If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.
               
               New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.
               
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.
               
               During the load balancer's creation, the service adds the new load balancer to the specified NSGs.
               
               The benefits of using NSGs with the load balancer include:
               *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
               *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.
               
               Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        :param pulumi.Input[str] request_id_header: (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
               
               If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.
               
               If isRequestIdEnabled is false then this field is ignored.
               
               If this field is not set or is set to "" then this field defaults to X-Request-Id
               
               **Notes:**
               * Unless the header name is "" it must start with "X-" prefix.
               * Setting the header name to "" will set it to the default: X-Request-Id.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]] reserved_ips: An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        :param pulumi.Input['LoadBalancerShapeDetailsArgs'] shape_details: (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "shape", shape)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ip_mode is not None:
            pulumi.set(__self__, "ip_mode", ip_mode)
        if is_delete_protection_enabled is not None:
            pulumi.set(__self__, "is_delete_protection_enabled", is_delete_protection_enabled)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if is_request_id_enabled is not None:
            pulumi.set(__self__, "is_request_id_enabled", is_request_id_enabled)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if request_id_header is not None:
            pulumi.set(__self__, "request_id_header", request_id_header)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if shape_details is not None:
            pulumi.set(__self__, "shape_details", shape_details)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Input[str]:
        """
        (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: pulumi.Input[str]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.

        If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.

        If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.

        Example: "ipMode":"IPV6"
        """
        return pulumi.get(self, "ip_mode")

    @ip_mode.setter
    def ip_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mode", value)

    @property
    @pulumi.getter(name="isDeleteProtectionEnabled")
    def is_delete_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the load balancer has delete protection enabled.

        If "true", the loadbalancer will be protected against deletion if configured to accept traffic.

        If "false", the loadbalancer will not be protected against deletion.

        Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        """
        return pulumi.get(self, "is_delete_protection_enabled")

    @is_delete_protection_enabled.setter
    def is_delete_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_delete_protection_enabled", value)

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the load balancer has a VCN-local (private) IP address.

        If "true", the service assigns a private IP address to the load balancer.

        If "false", the service assigns a public IP address to the load balancer.

        A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_private", value)

    @property
    @pulumi.getter(name="isRequestIdEnabled")
    def is_request_id_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.

        If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.

        If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.

        New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.

        Example: `true`
        """
        return pulumi.get(self, "is_request_id_enabled")

    @is_request_id_enabled.setter
    def is_request_id_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_request_id_enabled", value)

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.

        During the load balancer's creation, the service adds the new load balancer to the specified NSGs.

        The benefits of using NSGs with the load balancer include:
        *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
        *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.

        Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @property
    @pulumi.getter(name="requestIdHeader")
    def request_id_header(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.

        If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.

        If isRequestIdEnabled is false then this field is ignored.

        If this field is not set or is set to "" then this field defaults to X-Request-Id

        **Notes:**
        * Unless the header name is "" it must start with "X-" prefix.
        * Setting the header name to "" will set it to the default: X-Request-Id.
        """
        return pulumi.get(self, "request_id_header")

    @request_id_header.setter
    def request_id_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id_header", value)

    @property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]]:
        """
        An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]]):
        pulumi.set(self, "reserved_ips", value)

    @property
    @pulumi.getter(name="shapeDetails")
    def shape_details(self) -> Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']]:
        """
        (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        """
        return pulumi.get(self, "shape_details")

    @shape_details.setter
    def shape_details(self, value: Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']]):
        pulumi.set(self, "shape_details", value)


@pulumi.input_type
class _LoadBalancerState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ip_address_details: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIpAddressDetailArgs']]]] = None,
                 ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ip_mode: Optional[pulumi.Input[str]] = None,
                 is_delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 is_request_id_enabled: Optional[pulumi.Input[bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id_header: Optional[pulumi.Input[str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_details: Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LoadBalancer resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerIpAddressDetailArgs']]] ip_address_details: An array of IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: An array of IP addresses. Deprecated: use ip_address_details instead
        :param pulumi.Input[str] ip_mode: IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.
               
               If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.
               
               If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.
               
               Example: "ipMode":"IPV6"
        :param pulumi.Input[bool] is_delete_protection_enabled: (Updatable) Whether or not the load balancer has delete protection enabled.
               
               If "true", the loadbalancer will be protected against deletion if configured to accept traffic.
               
               If "false", the loadbalancer will not be protected against deletion.
               
               Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        :param pulumi.Input[bool] is_private: Whether the load balancer has a VCN-local (private) IP address.
               
               If "true", the service assigns a private IP address to the load balancer.
               
               If "false", the service assigns a public IP address to the load balancer.
               
               A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).
               
               Example: `true`
        :param pulumi.Input[bool] is_request_id_enabled: (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
               
               If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.
               
               If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.
               
               New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.
               
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.
               
               During the load balancer's creation, the service adds the new load balancer to the specified NSGs.
               
               The benefits of using NSGs with the load balancer include:
               *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
               *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.
               
               Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        :param pulumi.Input[str] request_id_header: (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
               
               If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.
               
               If isRequestIdEnabled is false then this field is ignored.
               
               If this field is not set or is set to "" then this field defaults to X-Request-Id
               
               **Notes:**
               * Unless the header name is "" it must start with "X-" prefix.
               * Setting the header name to "" will set it to the default: X-Request-Id.
        :param pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]] reserved_ips: An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        :param pulumi.Input[str] shape: (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        :param pulumi.Input['LoadBalancerShapeDetailsArgs'] shape_details: (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        :param pulumi.Input[str] state: The current state of the load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if ip_address_details is not None:
            pulumi.set(__self__, "ip_address_details", ip_address_details)
        if ip_addresses is not None:
            warnings.warn("""The 'ip_addresses' field has been deprecated. Please use 'ip_address_details' instead.""", DeprecationWarning)
            pulumi.log.warn("""ip_addresses is deprecated: The 'ip_addresses' field has been deprecated. Please use 'ip_address_details' instead.""")
        if ip_addresses is not None:
            pulumi.set(__self__, "ip_addresses", ip_addresses)
        if ip_mode is not None:
            pulumi.set(__self__, "ip_mode", ip_mode)
        if is_delete_protection_enabled is not None:
            pulumi.set(__self__, "is_delete_protection_enabled", is_delete_protection_enabled)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if is_request_id_enabled is not None:
            pulumi.set(__self__, "is_request_id_enabled", is_request_id_enabled)
        if network_security_group_ids is not None:
            pulumi.set(__self__, "network_security_group_ids", network_security_group_ids)
        if request_id_header is not None:
            pulumi.set(__self__, "request_id_header", request_id_header)
        if reserved_ips is not None:
            pulumi.set(__self__, "reserved_ips", reserved_ips)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if shape_details is not None:
            pulumi.set(__self__, "shape_details", shape_details)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="ipAddressDetails")
    def ip_address_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIpAddressDetailArgs']]]]:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_address_details")

    @ip_address_details.setter
    def ip_address_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerIpAddressDetailArgs']]]]):
        pulumi.set(self, "ip_address_details", value)

    @property
    @pulumi.getter(name="ipAddresses")
    @_utilities.deprecated("""The 'ip_addresses' field has been deprecated. Please use 'ip_address_details' instead.""")
    def ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of IP addresses. Deprecated: use ip_address_details instead
        """
        return pulumi.get(self, "ip_addresses")

    @ip_addresses.setter
    def ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_addresses", value)

    @property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> Optional[pulumi.Input[str]]:
        """
        IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.

        If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.

        If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.

        Example: "ipMode":"IPV6"
        """
        return pulumi.get(self, "ip_mode")

    @ip_mode.setter
    def ip_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_mode", value)

    @property
    @pulumi.getter(name="isDeleteProtectionEnabled")
    def is_delete_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the load balancer has delete protection enabled.

        If "true", the loadbalancer will be protected against deletion if configured to accept traffic.

        If "false", the loadbalancer will not be protected against deletion.

        Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        """
        return pulumi.get(self, "is_delete_protection_enabled")

    @is_delete_protection_enabled.setter
    def is_delete_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_delete_protection_enabled", value)

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the load balancer has a VCN-local (private) IP address.

        If "true", the service assigns a private IP address to the load balancer.

        If "false", the service assigns a public IP address to the load balancer.

        A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_private", value)

    @property
    @pulumi.getter(name="isRequestIdEnabled")
    def is_request_id_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.

        If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.

        If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.

        New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.

        Example: `true`
        """
        return pulumi.get(self, "is_request_id_enabled")

    @is_request_id_enabled.setter
    def is_request_id_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_request_id_enabled", value)

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.

        During the load balancer's creation, the service adds the new load balancer to the specified NSGs.

        The benefits of using NSGs with the load balancer include:
        *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
        *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.

        Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        """
        return pulumi.get(self, "network_security_group_ids")

    @network_security_group_ids.setter
    def network_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "network_security_group_ids", value)

    @property
    @pulumi.getter(name="requestIdHeader")
    def request_id_header(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.

        If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.

        If isRequestIdEnabled is false then this field is ignored.

        If this field is not set or is set to "" then this field defaults to X-Request-Id

        **Notes:**
        * Unless the header name is "" it must start with "X-" prefix.
        * Setting the header name to "" will set it to the default: X-Request-Id.
        """
        return pulumi.get(self, "request_id_header")

    @request_id_header.setter
    def request_id_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id_header", value)

    @property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]]:
        """
        An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        """
        return pulumi.get(self, "reserved_ips")

    @reserved_ips.setter
    def reserved_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoadBalancerReservedIpArgs']]]]):
        pulumi.set(self, "reserved_ips", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="shapeDetails")
    def shape_details(self) -> Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']]:
        """
        (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        """
        return pulumi.get(self, "shape_details")

    @shape_details.setter
    def shape_details(self, value: Optional[pulumi.Input['LoadBalancerShapeDetailsArgs']]):
        pulumi.set(self, "shape_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the load balancer.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class LoadBalancer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ip_mode: Optional[pulumi.Input[str]] = None,
                 is_delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 is_request_id_enabled: Optional[pulumi.Input[bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id_header: Optional[pulumi.Input[str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerReservedIpArgs', 'LoadBalancerReservedIpArgsDict']]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_details: Optional[pulumi.Input[Union['LoadBalancerShapeDetailsArgs', 'LoadBalancerShapeDetailsArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        This resource provides the Load Balancer resource in Oracle Cloud Infrastructure Load Balancer service.

        Creates a new load balancer in the specified compartment. For general information about load balancers,
        see [Overview of the Load Balancing Service](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm).

        For the purposes of access control, you must provide the OCID of the compartment where you want
        the load balancer to reside. Notice that the load balancer doesn't have to be in the same compartment as the VCN
        or backend set. If you're not sure which compartment to use, put the load balancer in the same compartment as the VCN.
        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You must specify a display name for the load balancer. It does not have to be unique, and you can change it.

        For information about Availability Domains, see
        [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of Availability Domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        All Oracle Cloud Infrastructure resources, including load balancers, get an Oracle-assigned,
        unique ID called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID
        in the response. You can also retrieve a resource's OCID by using a List API operation on that resource type,
        or by viewing the resource in the Console. Fore more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        When you create a load balancer, the system assigns an IP address.
        To get the IP address, use the [GetLoadBalancer](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/GetLoadBalancer) operation.

        ## Supported Aliases

        * `oci_load_balancer`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_load_balancer = oci.load_balancer.LoadBalancer("test_load_balancer",
            compartment_id=compartment_id,
            display_name=load_balancer_display_name,
            shape=load_balancer_shape,
            subnet_ids=load_balancer_subnet_ids,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            ip_mode=load_balancer_ip_mode,
            is_delete_protection_enabled=load_balancer_is_delete_protection_enabled,
            is_private=load_balancer_is_private,
            is_request_id_enabled=load_balancer_is_request_id_enabled,
            network_security_group_ids=load_balancer_network_security_group_ids,
            request_id_header=load_balancer_request_id_header,
            reserved_ips=[{
                "id": load_balancer_reserved_ips_id,
            }],
            shape_details={
                "maximum_bandwidth_in_mbps": load_balancer_shape_details_maximum_bandwidth_in_mbps,
                "minimum_bandwidth_in_mbps": load_balancer_shape_details_minimum_bandwidth_in_mbps,
            })
        ```

        ## Import

        LoadBalancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/loadBalancer:LoadBalancer test_load_balancer "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] ip_mode: IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.
               
               If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.
               
               If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.
               
               Example: "ipMode":"IPV6"
        :param pulumi.Input[bool] is_delete_protection_enabled: (Updatable) Whether or not the load balancer has delete protection enabled.
               
               If "true", the loadbalancer will be protected against deletion if configured to accept traffic.
               
               If "false", the loadbalancer will not be protected against deletion.
               
               Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        :param pulumi.Input[bool] is_private: Whether the load balancer has a VCN-local (private) IP address.
               
               If "true", the service assigns a private IP address to the load balancer.
               
               If "false", the service assigns a public IP address to the load balancer.
               
               A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).
               
               Example: `true`
        :param pulumi.Input[bool] is_request_id_enabled: (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
               
               If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.
               
               If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.
               
               New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.
               
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.
               
               During the load balancer's creation, the service adds the new load balancer to the specified NSGs.
               
               The benefits of using NSGs with the load balancer include:
               *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
               *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.
               
               Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        :param pulumi.Input[str] request_id_header: (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
               
               If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.
               
               If isRequestIdEnabled is false then this field is ignored.
               
               If this field is not set or is set to "" then this field defaults to X-Request-Id
               
               **Notes:**
               * Unless the header name is "" it must start with "X-" prefix.
               * Setting the header name to "" will set it to the default: X-Request-Id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerReservedIpArgs', 'LoadBalancerReservedIpArgsDict']]]] reserved_ips: An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        :param pulumi.Input[str] shape: (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        :param pulumi.Input[Union['LoadBalancerShapeDetailsArgs', 'LoadBalancerShapeDetailsArgsDict']] shape_details: (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LoadBalancerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Load Balancer resource in Oracle Cloud Infrastructure Load Balancer service.

        Creates a new load balancer in the specified compartment. For general information about load balancers,
        see [Overview of the Load Balancing Service](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm).

        For the purposes of access control, you must provide the OCID of the compartment where you want
        the load balancer to reside. Notice that the load balancer doesn't have to be in the same compartment as the VCN
        or backend set. If you're not sure which compartment to use, put the load balancer in the same compartment as the VCN.
        For information about access control and compartments, see
        [Overview of the IAM Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        You must specify a display name for the load balancer. It does not have to be unique, and you can change it.

        For information about Availability Domains, see
        [Regions and Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of Availability Domains, use the `ListAvailabilityDomains` operation
        in the Identity and Access Management Service API.

        All Oracle Cloud Infrastructure resources, including load balancers, get an Oracle-assigned,
        unique ID called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID
        in the response. You can also retrieve a resource's OCID by using a List API operation on that resource type,
        or by viewing the resource in the Console. Fore more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        When you create a load balancer, the system assigns an IP address.
        To get the IP address, use the [GetLoadBalancer](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancer/GetLoadBalancer) operation.

        ## Supported Aliases

        * `oci_load_balancer`

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_load_balancer = oci.load_balancer.LoadBalancer("test_load_balancer",
            compartment_id=compartment_id,
            display_name=load_balancer_display_name,
            shape=load_balancer_shape,
            subnet_ids=load_balancer_subnet_ids,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            freeform_tags={
                "Department": "Finance",
            },
            ip_mode=load_balancer_ip_mode,
            is_delete_protection_enabled=load_balancer_is_delete_protection_enabled,
            is_private=load_balancer_is_private,
            is_request_id_enabled=load_balancer_is_request_id_enabled,
            network_security_group_ids=load_balancer_network_security_group_ids,
            request_id_header=load_balancer_request_id_header,
            reserved_ips=[{
                "id": load_balancer_reserved_ips_id,
            }],
            shape_details={
                "maximum_bandwidth_in_mbps": load_balancer_shape_details_maximum_bandwidth_in_mbps,
                "minimum_bandwidth_in_mbps": load_balancer_shape_details_minimum_bandwidth_in_mbps,
            })
        ```

        ## Import

        LoadBalancers can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/loadBalancer:LoadBalancer test_load_balancer "id"
        ```

        :param str resource_name: The name of the resource.
        :param LoadBalancerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LoadBalancerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 ip_mode: Optional[pulumi.Input[str]] = None,
                 is_delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 is_request_id_enabled: Optional[pulumi.Input[bool]] = None,
                 network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 request_id_header: Optional[pulumi.Input[str]] = None,
                 reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerReservedIpArgs', 'LoadBalancerReservedIpArgsDict']]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 shape_details: Optional[pulumi.Input[Union['LoadBalancerShapeDetailsArgs', 'LoadBalancerShapeDetailsArgsDict']]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LoadBalancerArgs.__new__(LoadBalancerArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["ip_mode"] = ip_mode
            __props__.__dict__["is_delete_protection_enabled"] = is_delete_protection_enabled
            __props__.__dict__["is_private"] = is_private
            __props__.__dict__["is_request_id_enabled"] = is_request_id_enabled
            __props__.__dict__["network_security_group_ids"] = network_security_group_ids
            __props__.__dict__["request_id_header"] = request_id_header
            __props__.__dict__["reserved_ips"] = reserved_ips
            if shape is None and not opts.urn:
                raise TypeError("Missing required property 'shape'")
            __props__.__dict__["shape"] = shape
            __props__.__dict__["shape_details"] = shape_details
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["ip_address_details"] = None
            __props__.__dict__["ip_addresses"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
        super(LoadBalancer, __self__).__init__(
            'oci:LoadBalancer/loadBalancer:LoadBalancer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            ip_address_details: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerIpAddressDetailArgs', 'LoadBalancerIpAddressDetailArgsDict']]]]] = None,
            ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ip_mode: Optional[pulumi.Input[str]] = None,
            is_delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
            is_private: Optional[pulumi.Input[bool]] = None,
            is_request_id_enabled: Optional[pulumi.Input[bool]] = None,
            network_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            request_id_header: Optional[pulumi.Input[str]] = None,
            reserved_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerReservedIpArgs', 'LoadBalancerReservedIpArgsDict']]]]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            shape_details: Optional[pulumi.Input[Union['LoadBalancerShapeDetailsArgs', 'LoadBalancerShapeDetailsArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'LoadBalancer':
        """
        Get an existing LoadBalancer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerIpAddressDetailArgs', 'LoadBalancerIpAddressDetailArgsDict']]]] ip_address_details: An array of IP addresses.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_addresses: An array of IP addresses. Deprecated: use ip_address_details instead
        :param pulumi.Input[str] ip_mode: IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.
               
               If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.
               
               If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.
               
               Example: "ipMode":"IPV6"
        :param pulumi.Input[bool] is_delete_protection_enabled: (Updatable) Whether or not the load balancer has delete protection enabled.
               
               If "true", the loadbalancer will be protected against deletion if configured to accept traffic.
               
               If "false", the loadbalancer will not be protected against deletion.
               
               Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        :param pulumi.Input[bool] is_private: Whether the load balancer has a VCN-local (private) IP address.
               
               If "true", the service assigns a private IP address to the load balancer.
               
               If "false", the service assigns a public IP address to the load balancer.
               
               A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).
               
               Example: `true`
        :param pulumi.Input[bool] is_request_id_enabled: (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.
               
               If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.
               
               If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.
               
               New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.
               
               Example: `true`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] network_security_group_ids: (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.
               
               During the load balancer's creation, the service adds the new load balancer to the specified NSGs.
               
               The benefits of using NSGs with the load balancer include:
               *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
               *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.
               
               Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        :param pulumi.Input[str] request_id_header: (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.
               
               If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.
               
               If isRequestIdEnabled is false then this field is ignored.
               
               If this field is not set or is set to "" then this field defaults to X-Request-Id
               
               **Notes:**
               * Unless the header name is "" it must start with "X-" prefix.
               * Setting the header name to "" will set it to the default: X-Request-Id.
        :param pulumi.Input[Sequence[pulumi.Input[Union['LoadBalancerReservedIpArgs', 'LoadBalancerReservedIpArgsDict']]]] reserved_ips: An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        :param pulumi.Input[str] shape: (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        :param pulumi.Input[Union['LoadBalancerShapeDetailsArgs', 'LoadBalancerShapeDetailsArgsDict']] shape_details: (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        :param pulumi.Input[str] state: The current state of the load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LoadBalancerState.__new__(_LoadBalancerState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["ip_address_details"] = ip_address_details
        __props__.__dict__["ip_addresses"] = ip_addresses
        __props__.__dict__["ip_mode"] = ip_mode
        __props__.__dict__["is_delete_protection_enabled"] = is_delete_protection_enabled
        __props__.__dict__["is_private"] = is_private
        __props__.__dict__["is_request_id_enabled"] = is_request_id_enabled
        __props__.__dict__["network_security_group_ids"] = network_security_group_ids
        __props__.__dict__["request_id_header"] = request_id_header
        __props__.__dict__["reserved_ips"] = reserved_ips
        __props__.__dict__["shape"] = shape
        __props__.__dict__["shape_details"] = shape_details
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        return LoadBalancer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the load balancer.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `example_load_balancer`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="ipAddressDetails")
    def ip_address_details(self) -> pulumi.Output[Sequence['outputs.LoadBalancerIpAddressDetail']]:
        """
        An array of IP addresses.
        """
        return pulumi.get(self, "ip_address_details")

    @property
    @pulumi.getter(name="ipAddresses")
    @_utilities.deprecated("""The 'ip_addresses' field has been deprecated. Please use 'ip_address_details' instead.""")
    def ip_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of IP addresses. Deprecated: use ip_address_details instead
        """
        return pulumi.get(self, "ip_addresses")

    @property
    @pulumi.getter(name="ipMode")
    def ip_mode(self) -> pulumi.Output[str]:
        """
        IPv6 is currently supported only in the Government Cloud. Whether the load balancer has an IPv4 or IPv6 IP address.

        If "IPV4", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.

        If "IPV6", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.

        Example: "ipMode":"IPV6"
        """
        return pulumi.get(self, "ip_mode")

    @property
    @pulumi.getter(name="isDeleteProtectionEnabled")
    def is_delete_protection_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not the load balancer has delete protection enabled.

        If "true", the loadbalancer will be protected against deletion if configured to accept traffic.

        If "false", the loadbalancer will not be protected against deletion.

        Delete protection will not be enabled unless a value of "true" is provided. Example: `true`
        """
        return pulumi.get(self, "is_delete_protection_enabled")

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> pulumi.Output[bool]:
        """
        Whether the load balancer has a VCN-local (private) IP address.

        If "true", the service assigns a private IP address to the load balancer.

        If "false", the service assigns a public IP address to the load balancer.

        A public load balancer is accessible from the internet, depending on your VCN's [security list rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securitylists.htm). For more information about public and private load balancers, see [How Load Balancing Works](https://docs.cloud.oracle.com/iaas/Content/Balance/Concepts/balanceoverview.htm#how-load-balancing-works).

        Example: `true`
        """
        return pulumi.get(self, "is_private")

    @property
    @pulumi.getter(name="isRequestIdEnabled")
    def is_request_id_enabled(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.

        If "true", the load balancer will attach a unique request id header to every request passed through from the load balancer to load balancer backends. This same request id header also will be added to the response the lb received from the backend handling the request before the load balancer returns the response to the requestor. The name of the unique request id header is set the by value of requestIdHeader.

        If "false", the loadbalancer not add this unique request id header to either the request passed through to the load balancer backends nor to the reponse returned to the user.

        New load balancers have the Request Id feature disabled unless isRequestIdEnabled is set to true.

        Example: `true`
        """
        return pulumi.get(self, "is_request_id_enabled")

    @property
    @pulumi.getter(name="networkSecurityGroupIds")
    def network_security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) An array of NSG [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this load balancer.

        During the load balancer's creation, the service adds the new load balancer to the specified NSGs.

        The benefits of using NSGs with the load balancer include:
        *  NSGs define network security rules to govern ingress and egress traffic for the load balancer.
        *  The network security rules of other resources can reference the NSGs associated with the load balancer to ensure access.

        Example: `["ocid1.nsg.oc1.phx.unique_ID"]`
        """
        return pulumi.get(self, "network_security_group_ids")

    @property
    @pulumi.getter(name="requestIdHeader")
    def request_id_header(self) -> pulumi.Output[str]:
        """
        (Updatable) If isRequestIdEnabled is true then this field contains the name of the header field that contains the unique request id that is attached to every request from the load balancer to the load balancer backends and to every response from the load balancer.

        If a request to the load balancer already contains a header with same name as specified in requestIdHeader then the load balancer will not change the value of that field.

        If isRequestIdEnabled is false then this field is ignored.

        If this field is not set or is set to "" then this field defaults to X-Request-Id

        **Notes:**
        * Unless the header name is "" it must start with "X-" prefix.
        * Setting the header name to "" will set it to the default: X-Request-Id.
        """
        return pulumi.get(self, "request_id_header")

    @property
    @pulumi.getter(name="reservedIps")
    def reserved_ips(self) -> pulumi.Output[Optional[Sequence['outputs.LoadBalancerReservedIp']]]:
        """
        An array of reserved Ips. Pre-created public IP that will be used as the IP of this load balancer. This reserved IP will not be deleted when load balancer is deleted. This ip should not be already mapped to any other resource.
        """
        return pulumi.get(self, "reserved_ips")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        (Updatable) A template that determines the total pre-provisioned bandwidth (ingress plus egress). To get a list of available shapes, use the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerShape/ListShapes) operation.  Example: `flexible` NOTE: After May 2023, Fixed shapes - 10Mbps, 100Mbps, 400Mbps, 8000Mbps would be deprecated and only shape allowed would be `Flexible` *Note: When updating shape for a load balancer, all existing connections to the load balancer will be reset during the update process. Also `10Mbps-Micro` shape cannot be updated to any other shape nor can any other shape be updated to `10Mbps-Micro`.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="shapeDetails")
    def shape_details(self) -> pulumi.Output['outputs.LoadBalancerShapeDetails']:
        """
        (Updatable) The configuration details to create load balancer using Flexible shape. This is required only if shapeName is `Flexible`.
        """
        return pulumi.get(self, "shape_details")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the load balancer.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        An array of subnet [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the load balancer was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

