from typing import TYPE_CHECKING, Any

from langchain._api import create_importer

if TYPE_CHECKING:
    from aibaba_ai_community.callbacks.aim_callback import (
        AimCallbackHandler,
        BaseMetadataCallbackHandler,
        import_aim,
    )

# Create a way to dynamically look up deprecated imports.
# Used to consolidate logic for raising deprecation warnings and
# handling optional imports.
DEPRECATED_LOOKUP = {
    "import_aim": "aibaba_ai_community.callbacks.aim_callback",
    "BaseMetadataCallbackHandler": "aibaba_ai_community.callbacks.aim_callback",
    "AimCallbackHandler": "aibaba_ai_community.callbacks.aim_callback",
}

_import_attribute = create_importer(__file__, deprecated_lookups=DEPRECATED_LOOKUP)


def __getattr__(name: str) -> Any:
    """Look up attributes dynamically."""
    return _import_attribute(name)


__all__ = [
    "import_aim",
    "BaseMetadataCallbackHandler",
    "AimCallbackHandler",
]
