"""Helper functions for managing the Aibaba AI API.

This module is only relevant for Aibaba AI developers, not for users.

.. warning::

    This module and its submodules are for internal use only.  Do not use them
    in your own code.  We may change the API at any time with no warning.

"""

from .deprecation import (
    AibabaAIDeprecationWarning,
    deprecated,
    suppress_aibaba_ai_deprecation_warning,
    surface_aibaba_ai_deprecation_warnings,
    warn_deprecated,
)
from .module_import import create_importer

__all__ = [
    "deprecated",
    "AibabaAIDeprecationWarning",
    "suppress_aibaba_ai_deprecation_warning",
    "surface_aibaba_ai_deprecation_warnings",
    "warn_deprecated",
    "create_importer",
]
